/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.LogoList;
import org.nlogo.util.MersenneTwisterFast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class ArrayAgentSet
extends AgentSet {
    Agent[] agents;
    private int size = 0;
    private final int initialCapacity;
    private int capacity = 0;

    @Override
    public int count() {
        if (!(this.type != Turtle.class && this.type != Link.class || this.removableAgents)) {
            int result2 = 0;
            AgentSet.Iterator iter2 = this.iterator();
            while (iter2.hasNext()) {
                iter2.next();
                ++result2;
            }
            return result2;
        }
        return this.size;
    }

    @Override
    boolean equalAgentSetsHelper(org.nlogo.api.AgentSet otherSet) {
        HashSet<Agent> set2 = new HashSet<Agent>();
        AgentSet.Iterator iter2 = this.iterator();
        while (iter2.hasNext()) {
            set2.add(iter2.next());
        }
        for (org.nlogo.api.Agent a : otherSet.agents()) {
            if (set2.contains(a)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        if (!(this.type != Turtle.class && this.type != Link.class || this.removableAgents)) {
            return !this.iterator().hasNext();
        }
        return this.size == 0;
    }

    int capacity() {
        return this.capacity;
    }

    public ArrayAgentSet(Class<? extends Agent> type, int initialCapacity, boolean removableAgents, World world) {
        super(type, world, null, removableAgents);
        this.initialCapacity = initialCapacity;
        this.agents = new Agent[initialCapacity];
        this.capacity = initialCapacity;
    }

    public ArrayAgentSet(Class<? extends Agent> type, Agent[] agents, World world) {
        super(type, world, null, false);
        this.initialCapacity = agents.length;
        this.agents = agents;
        this.capacity = this.initialCapacity;
        this.size = this.initialCapacity;
    }

    public ArrayAgentSet(Class<? extends Agent> type, Agent[] agents, String printName, World world) {
        super(type, world, printName, false);
        this.initialCapacity = agents.length;
        this.agents = agents;
        this.capacity = this.initialCapacity;
        this.size = this.initialCapacity;
    }

    ArrayAgentSet(Class<? extends Agent> type, int initialCapacity, String printName, boolean removableAgents, World world) {
        super(type, world, printName, removableAgents);
        this.initialCapacity = initialCapacity;
        this.agents = new Agent[initialCapacity];
        this.capacity = initialCapacity;
    }

    @Override
    public Agent agent(long i) {
        return this.agents[(int)i];
    }

    @Override
    Agent getAgent(Object id) {
        return this.agents[((Double)id).intValue()];
    }

    @Override
    public void add(Agent agent) {
        if (this.size < this.capacity) {
            this.agents[this.size] = agent;
            ++this.size;
        } else {
            Agent[] newagents = new Agent[this.capacity * 2];
            System.arraycopy(this.agents, 0, newagents, 0, this.capacity);
            this.agents = newagents;
            this.capacity *= 2;
            this.add(agent);
        }
    }

    @Override
    void remove(Object id) {
        throw new IllegalStateException("Cannot call remove() from an  ArrayAgentSet");
    }

    @Override
    void clear() {
        if (!this.removableAgents) {
            throw new IllegalStateException("Cannot call remove() on an AgentSet with removableAgents set to false");
        }
        this.capacity = this.initialCapacity;
        this.agents = new Agent[this.capacity];
        this.size = 0;
    }

    @Override
    public boolean contains(Agent agent) {
        AgentSet.Iterator iter2 = this.iterator();
        while (iter2.hasNext()) {
            if (iter2.next() != agent) continue;
            return true;
        }
        return false;
    }

    @Override
    public Agent randomOne(int precomputedCount, int random) {
        if (this.size == this.capacity && (this.type != Turtle.class && this.type != Link.class || this.removableAgents)) {
            return this.agents[random];
        }
        AgentSet.Iterator iter2 = this.iterator();
        for (int i = 0; i < random; ++i) {
            iter2.next();
        }
        return iter2.next();
    }

    @Override
    Agent[] randomTwo(int precomputedCount, int random1, int random2) {
        Agent[] result2 = new Agent[2];
        if (random2 >= random1) {
            ++random2;
        } else {
            int tmp = random1;
            random1 = random2;
            random2 = tmp;
        }
        if (this.size == this.capacity && (this.type != Turtle.class && this.type != Link.class || this.removableAgents)) {
            result2[0] = this.agents[random1];
            result2[1] = this.agents[random2];
        } else {
            AgentSet.Iterator iter2 = this.iterator();
            int i = 0;
            while (i++ < random1) {
                iter2.next();
            }
            result2[0] = iter2.next();
            while (i++ < random2) {
                iter2.next();
            }
            result2[1] = iter2.next();
        }
        return result2;
    }

    @Override
    Agent[] randomSubsetGeneral(int resultSize, int precomputedCount, MersenneTwisterFast random) {
        Agent[] result2 = new Agent[resultSize];
        if (precomputedCount == this.capacity) {
            int i = 0;
            int j = 0;
            while (j < resultSize) {
                if (random.nextInt(precomputedCount - i) < resultSize - j) {
                    result2[j] = this.agents[i];
                    ++j;
                }
                ++i;
            }
        } else {
            AgentSet.Iterator iter2 = this.iterator();
            int i = 0;
            int j = 0;
            while (j < resultSize) {
                Agent next2 = iter2.next();
                if (random.nextInt(precomputedCount - i) < resultSize - j) {
                    result2[j] = next2;
                    ++j;
                }
                ++i;
            }
        }
        return result2;
    }

    @Override
    public LogoList toLogoList() {
        ArrayList<Agent> result2 = new ArrayList<Agent>();
        AgentSet.Iterator iter2 = this.iterator();
        while (iter2.hasNext()) {
            Agent agent = iter2.next();
            result2.add(agent);
        }
        Collections.sort(result2);
        return LogoList.fromJava(result2);
    }

    @Override
    public Agent[] toArray() {
        return this.agents;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("AgentSet");
        s = s.append("\n...... type: ");
        s = s.append(this.type == null ? "null" : this.type.toString());
        s = s.append("\n...... size: " + this.size);
        s = s.append("\n...... count(): " + this.count());
        s = s.append("\n...... capacity: " + this.capacity);
        s = s.append("\n...... agents: ");
        AgentSet.Iterator iter2 = this.iterator();
        while (iter2.hasNext()) {
            s = s.append("\n" + iter2.next().toString());
        }
        return s.toString();
    }

    @Override
    public AgentSet.Iterator iterator() {
        if (this.type == Patch.class) {
            return new Iterator();
        }
        return new IteratorWithDead();
    }

    @Override
    public AgentSet.Iterator shufflerator(MersenneTwisterFast random) {
        return new Shufflerator(random);
    }

    private strictfp class Shufflerator
    extends Iterator {
        private int i;
        private final Agent[] copy;
        private Agent next;
        private final MersenneTwisterFast random;

        Shufflerator(MersenneTwisterFast random) {
            this.i = 0;
            this.copy = new Agent[ArrayAgentSet.this.size];
            this.random = random;
            System.arraycopy(ArrayAgentSet.this.agents, 0, this.copy, 0, ArrayAgentSet.this.size);
            while (this.i < this.copy.length && this.copy[this.i] == null) {
                ++this.i;
            }
            this.fetch();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Agent next() {
            Agent result2 = this.next;
            this.fetch();
            return result2;
        }

        private void fetch() {
            if (this.i >= this.copy.length) {
                this.next = null;
            } else {
                if (this.i < this.copy.length - 1) {
                    int r = this.i + this.random.nextInt(this.copy.length - this.i);
                    this.next = this.copy[r];
                    this.copy[r] = this.copy[this.i];
                } else {
                    this.next = this.copy[this.i];
                }
                ++this.i;
                if (this.next == null || this.next.id == -1L) {
                    this.fetch();
                }
            }
        }
    }

    private strictfp class IteratorWithDead
    extends Iterator {
        IteratorWithDead() {
            while (this.index < ArrayAgentSet.this.size && ArrayAgentSet.this.agents[this.index].id == -1L) {
                ++this.index;
            }
        }

        public Agent next() {
            int resultIndex = this.index;
            do {
                ++this.index;
            } while (this.index < ArrayAgentSet.this.size && ArrayAgentSet.this.agents[this.index].id == -1L);
            return ArrayAgentSet.this.agents[resultIndex];
        }
    }

    public strictfp class Iterator
    implements AgentSet.Iterator {
        int index;

        public boolean hasNext() {
            return this.index < ArrayAgentSet.this.size;
        }

        public Agent next() {
            return ArrayAgentSet.this.agents[this.index++];
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }
}

