/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Topology;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.I18N;

strictfp final class Box
extends Topology {
    Box(World world) {
        super(world);
    }

    double wrapX(double x2) throws AgentException {
        double max2 = (double)this.world.maxPxcor() + 0.5;
        double min2 = (double)this.world.minPxcor() - 0.5;
        if (x2 >= max2 || x2 < min2) {
            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Box.cantMoveTurtleBeyondWorldEdge"));
        }
        return x2;
    }

    double wrapY(double y) throws AgentException {
        double max2 = (double)this.world.maxPycor() + 0.5;
        double min2 = (double)this.world.minPycor() - 0.5;
        if (y >= max2 || y < min2) {
            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Box.cantMoveTurtleBeyondWorldEdge"));
        }
        return y;
    }

    double distanceWrap(double dx, double dy, double x1, double y1, double x2, double y2) {
        return this.world.rootsTable.gridRoot(dx * dx + dy * dy);
    }

    double towardsWrap(double headingX, double headingY) {
        if (headingX == 0.0) {
            return headingY > 0.0 ? 0.0 : 180.0;
        }
        if (headingY == 0.0) {
            return headingX > 0.0 ? 90.0 : 270.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-headingY, headingX))) % 360.0;
    }

    Patch getPatchAt(double xc, double yc) throws AgentException {
        if (yc > (double)this.world.maxPycor() + 0.5 || yc < (double)this.world.minPycor() - 0.5) {
            return null;
        }
        if (xc > (double)this.world.maxPxcor() + 0.5 || xc < (double)this.world.minPxcor() - 0.5) {
            return null;
        }
        return this.world.getPatchAt(xc, yc);
    }

    double shortestPathX(double x1, double x2) {
        return x2;
    }

    double shortestPathY(double y1, double y2) {
        return y2;
    }

    void diffuse(double diffuseparam, int vn) throws AgentException, PatchException {
        int xx = this.world.worldWidth();
        int yy = this.world.worldHeight();
        double[][] scratch = this.world.getPatchScratch();
        double[][] scratch2 = new double[xx][yy];
        int x2 = 0;
        int y = 0;
        int minx = this.world.minPxcor();
        int miny = this.world.minPycor();
        try {
            for (y = 0; y < yy; ++y) {
                for (x2 = 0; x2 < xx; ++x2) {
                    scratch[x2][y] = (Double)this.world.fastGetPatchAt(x2 + minx, y + miny).getPatchVariable(vn);
                    scratch2[x2][y] = 0.0;
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(x2), (int)this.wrapY(y)));
        }
        for (y = 0; y < yy; ++y) {
            for (x2 = 0; x2 < xx; ++x2) {
                double diffuseVal = scratch[x2][y] / 8.0 * diffuseparam;
                if (y > 0 && y < yy - 1 && x2 > 0 && x2 < xx - 1) {
                    double[] dArray = scratch2[x2];
                    int n = y;
                    dArray[n] = dArray[n] + (scratch[x2][y] - 8.0 * diffuseVal);
                    double[] dArray2 = scratch2[x2 - 1];
                    int n2 = y - 1;
                    dArray2[n2] = dArray2[n2] + diffuseVal;
                    double[] dArray3 = scratch2[x2 - 1];
                    int n3 = y;
                    dArray3[n3] = dArray3[n3] + diffuseVal;
                    double[] dArray4 = scratch2[x2 - 1];
                    int n4 = y + 1;
                    dArray4[n4] = dArray4[n4] + diffuseVal;
                    double[] dArray5 = scratch2[x2];
                    int n5 = y + 1;
                    dArray5[n5] = dArray5[n5] + diffuseVal;
                    double[] dArray6 = scratch2[x2];
                    int n6 = y - 1;
                    dArray6[n6] = dArray6[n6] + diffuseVal;
                    double[] dArray7 = scratch2[x2 + 1];
                    int n7 = y - 1;
                    dArray7[n7] = dArray7[n7] + diffuseVal;
                    double[] dArray8 = scratch2[x2 + 1];
                    int n8 = y;
                    dArray8[n8] = dArray8[n8] + diffuseVal;
                    double[] dArray9 = scratch2[x2 + 1];
                    int n9 = y + 1;
                    dArray9[n9] = dArray9[n9] + diffuseVal;
                    continue;
                }
                if (y > 0 && y < yy - 1) {
                    if (x2 == 0) {
                        double[] dArray = scratch2[x2];
                        int n = y;
                        dArray[n] = dArray[n] + (scratch[x2][y] - 5.0 * diffuseVal);
                        double[] dArray10 = scratch2[x2];
                        int n10 = y + 1;
                        dArray10[n10] = dArray10[n10] + diffuseVal;
                        double[] dArray11 = scratch2[x2];
                        int n11 = y - 1;
                        dArray11[n11] = dArray11[n11] + diffuseVal;
                        double[] dArray12 = scratch2[x2 + 1];
                        int n12 = y - 1;
                        dArray12[n12] = dArray12[n12] + diffuseVal;
                        double[] dArray13 = scratch2[x2 + 1];
                        int n13 = y;
                        dArray13[n13] = dArray13[n13] + diffuseVal;
                        double[] dArray14 = scratch2[x2 + 1];
                        int n14 = y + 1;
                        dArray14[n14] = dArray14[n14] + diffuseVal;
                        continue;
                    }
                    double[] dArray = scratch2[x2];
                    int n = y;
                    dArray[n] = dArray[n] + (scratch[x2][y] - 5.0 * diffuseVal);
                    double[] dArray15 = scratch2[x2];
                    int n15 = y + 1;
                    dArray15[n15] = dArray15[n15] + diffuseVal;
                    double[] dArray16 = scratch2[x2];
                    int n16 = y - 1;
                    dArray16[n16] = dArray16[n16] + diffuseVal;
                    double[] dArray17 = scratch2[x2 - 1];
                    int n17 = y - 1;
                    dArray17[n17] = dArray17[n17] + diffuseVal;
                    double[] dArray18 = scratch2[x2 - 1];
                    int n18 = y;
                    dArray18[n18] = dArray18[n18] + diffuseVal;
                    double[] dArray19 = scratch2[x2 - 1];
                    int n19 = y + 1;
                    dArray19[n19] = dArray19[n19] + diffuseVal;
                    continue;
                }
                if (x2 > 0 && x2 < xx - 1) {
                    if (y == 0) {
                        double[] dArray = scratch2[x2];
                        int n = y;
                        dArray[n] = dArray[n] + (scratch[x2][y] - 5.0 * diffuseVal);
                        double[] dArray20 = scratch2[x2 - 1];
                        int n20 = y;
                        dArray20[n20] = dArray20[n20] + diffuseVal;
                        double[] dArray21 = scratch2[x2 - 1];
                        int n21 = y + 1;
                        dArray21[n21] = dArray21[n21] + diffuseVal;
                        double[] dArray22 = scratch2[x2];
                        int n22 = y + 1;
                        dArray22[n22] = dArray22[n22] + diffuseVal;
                        double[] dArray23 = scratch2[x2 + 1];
                        int n23 = y;
                        dArray23[n23] = dArray23[n23] + diffuseVal;
                        double[] dArray24 = scratch2[x2 + 1];
                        int n24 = y + 1;
                        dArray24[n24] = dArray24[n24] + diffuseVal;
                        continue;
                    }
                    double[] dArray = scratch2[x2];
                    int n = y;
                    dArray[n] = dArray[n] + (scratch[x2][y] - 5.0 * diffuseVal);
                    double[] dArray25 = scratch2[x2 - 1];
                    int n25 = y;
                    dArray25[n25] = dArray25[n25] + diffuseVal;
                    double[] dArray26 = scratch2[x2 - 1];
                    int n26 = y - 1;
                    dArray26[n26] = dArray26[n26] + diffuseVal;
                    double[] dArray27 = scratch2[x2];
                    int n27 = y - 1;
                    dArray27[n27] = dArray27[n27] + diffuseVal;
                    double[] dArray28 = scratch2[x2 + 1];
                    int n28 = y;
                    dArray28[n28] = dArray28[n28] + diffuseVal;
                    double[] dArray29 = scratch2[x2 + 1];
                    int n29 = y - 1;
                    dArray29[n29] = dArray29[n29] + diffuseVal;
                    continue;
                }
                if (x2 == 0) {
                    if (y == 0) {
                        double[] dArray = scratch2[x2];
                        int n = y;
                        dArray[n] = dArray[n] + (scratch[x2][y] - 3.0 * diffuseVal);
                        double[] dArray30 = scratch2[x2];
                        int n30 = y + 1;
                        dArray30[n30] = dArray30[n30] + diffuseVal;
                        double[] dArray31 = scratch2[x2 + 1];
                        int n31 = y;
                        dArray31[n31] = dArray31[n31] + diffuseVal;
                        double[] dArray32 = scratch2[x2 + 1];
                        int n32 = y + 1;
                        dArray32[n32] = dArray32[n32] + diffuseVal;
                        continue;
                    }
                    double[] dArray = scratch2[x2];
                    int n = y;
                    dArray[n] = dArray[n] + (scratch[x2][y] - 3.0 * diffuseVal);
                    double[] dArray33 = scratch2[x2];
                    int n33 = y - 1;
                    dArray33[n33] = dArray33[n33] + diffuseVal;
                    double[] dArray34 = scratch2[x2 + 1];
                    int n34 = y;
                    dArray34[n34] = dArray34[n34] + diffuseVal;
                    double[] dArray35 = scratch2[x2 + 1];
                    int n35 = y - 1;
                    dArray35[n35] = dArray35[n35] + diffuseVal;
                    continue;
                }
                if (y == 0) {
                    double[] dArray = scratch2[x2];
                    int n = y;
                    dArray[n] = dArray[n] + (scratch[x2][y] - 3.0 * diffuseVal);
                    double[] dArray36 = scratch2[x2];
                    int n36 = y + 1;
                    dArray36[n36] = dArray36[n36] + diffuseVal;
                    double[] dArray37 = scratch2[x2 - 1];
                    int n37 = y;
                    dArray37[n37] = dArray37[n37] + diffuseVal;
                    double[] dArray38 = scratch2[x2 - 1];
                    int n38 = y + 1;
                    dArray38[n38] = dArray38[n38] + diffuseVal;
                    continue;
                }
                double[] dArray = scratch2[x2];
                int n = y;
                dArray[n] = dArray[n] + (scratch[x2][y] - 3.0 * diffuseVal);
                double[] dArray39 = scratch2[x2];
                int n39 = y - 1;
                dArray39[n39] = dArray39[n39] + diffuseVal;
                double[] dArray40 = scratch2[x2 - 1];
                int n40 = y;
                dArray40[n40] = dArray40[n40] + diffuseVal;
                double[] dArray41 = scratch2[x2 - 1];
                int n41 = y - 1;
                dArray41[n41] = dArray41[n41] + diffuseVal;
            }
        }
        for (y = 0; y < yy; ++y) {
            for (x2 = 0; x2 < xx; ++x2) {
                if (scratch2[x2][y] == scratch[x2][y]) continue;
                this.world.getPatchAtWrap(x2 + minx, y + miny).setPatchVariable(vn, (Object)scratch2[x2][y]);
            }
        }
    }

    void diffuse4(double diffuseparam, int vn) throws AgentException, PatchException {
        int xx = this.world.worldWidth();
        int yy = this.world.worldHeight();
        double[][] scratch = this.world.getPatchScratch();
        double[][] scratch2 = new double[xx][yy];
        int x2 = 0;
        int y = 0;
        int minx = this.world.minPxcor();
        int miny = this.world.minPycor();
        try {
            for (y = 0; y < yy; ++y) {
                for (x2 = 0; x2 < xx; ++x2) {
                    scratch[x2][y] = (Double)this.world.fastGetPatchAt(x2 + minx, y + miny).getPatchVariable(vn);
                    scratch2[x2][y] = 0.0;
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(x2), (int)this.wrapY(y)));
        }
        for (y = 0; y < yy; ++y) {
            for (x2 = 0; x2 < xx; ++x2) {
                double diffuseVal = scratch[x2][y] / 4.0 * diffuseparam;
                if (y > 0 && y < yy - 1 && x2 > 0 && x2 < xx - 1) {
                    double[] dArray = scratch2[x2];
                    int n = y;
                    dArray[n] = dArray[n] + (scratch[x2][y] - 4.0 * diffuseVal);
                    double[] dArray2 = scratch2[x2 - 1];
                    int n2 = y;
                    dArray2[n2] = dArray2[n2] + diffuseVal;
                    double[] dArray3 = scratch2[x2];
                    int n3 = y + 1;
                    dArray3[n3] = dArray3[n3] + diffuseVal;
                    double[] dArray4 = scratch2[x2];
                    int n4 = y - 1;
                    dArray4[n4] = dArray4[n4] + diffuseVal;
                    double[] dArray5 = scratch2[x2 + 1];
                    int n5 = y;
                    dArray5[n5] = dArray5[n5] + diffuseVal;
                    continue;
                }
                if (y > 0 && y < yy - 1) {
                    if (x2 == 0) {
                        double[] dArray = scratch2[x2];
                        int n = y;
                        dArray[n] = dArray[n] + (scratch[x2][y] - 3.0 * diffuseVal);
                        double[] dArray6 = scratch2[x2];
                        int n6 = y + 1;
                        dArray6[n6] = dArray6[n6] + diffuseVal;
                        double[] dArray7 = scratch2[x2];
                        int n7 = y - 1;
                        dArray7[n7] = dArray7[n7] + diffuseVal;
                        double[] dArray8 = scratch2[x2 + 1];
                        int n8 = y;
                        dArray8[n8] = dArray8[n8] + diffuseVal;
                        continue;
                    }
                    double[] dArray = scratch2[x2];
                    int n = y;
                    dArray[n] = dArray[n] + (scratch[x2][y] - 3.0 * diffuseVal);
                    double[] dArray9 = scratch2[x2];
                    int n9 = y + 1;
                    dArray9[n9] = dArray9[n9] + diffuseVal;
                    double[] dArray10 = scratch2[x2];
                    int n10 = y - 1;
                    dArray10[n10] = dArray10[n10] + diffuseVal;
                    double[] dArray11 = scratch2[x2 - 1];
                    int n11 = y;
                    dArray11[n11] = dArray11[n11] + diffuseVal;
                    continue;
                }
                if (x2 > 0 && x2 < xx - 1) {
                    if (y == 0) {
                        double[] dArray = scratch2[x2];
                        int n = y;
                        dArray[n] = dArray[n] + (scratch[x2][y] - 3.0 * diffuseVal);
                        double[] dArray12 = scratch2[x2 - 1];
                        int n12 = y;
                        dArray12[n12] = dArray12[n12] + diffuseVal;
                        double[] dArray13 = scratch2[x2];
                        int n13 = y + 1;
                        dArray13[n13] = dArray13[n13] + diffuseVal;
                        double[] dArray14 = scratch2[x2 + 1];
                        int n14 = y;
                        dArray14[n14] = dArray14[n14] + diffuseVal;
                        continue;
                    }
                    double[] dArray = scratch2[x2];
                    int n = y;
                    dArray[n] = dArray[n] + (scratch[x2][y] - 3.0 * diffuseVal);
                    double[] dArray15 = scratch2[x2 - 1];
                    int n15 = y;
                    dArray15[n15] = dArray15[n15] + diffuseVal;
                    double[] dArray16 = scratch2[x2];
                    int n16 = y - 1;
                    dArray16[n16] = dArray16[n16] + diffuseVal;
                    double[] dArray17 = scratch2[x2 + 1];
                    int n17 = y;
                    dArray17[n17] = dArray17[n17] + diffuseVal;
                    continue;
                }
                if (x2 == 0) {
                    if (y == 0) {
                        double[] dArray = scratch2[x2];
                        int n = y;
                        dArray[n] = dArray[n] + (scratch[x2][y] - 2.0 * diffuseVal);
                        double[] dArray18 = scratch2[x2];
                        int n18 = y + 1;
                        dArray18[n18] = dArray18[n18] + diffuseVal;
                        double[] dArray19 = scratch2[x2 + 1];
                        int n19 = y;
                        dArray19[n19] = dArray19[n19] + diffuseVal;
                        continue;
                    }
                    double[] dArray = scratch2[x2];
                    int n = y;
                    dArray[n] = dArray[n] + (scratch[x2][y] - 2.0 * diffuseVal);
                    double[] dArray20 = scratch2[x2];
                    int n20 = y - 1;
                    dArray20[n20] = dArray20[n20] + diffuseVal;
                    double[] dArray21 = scratch2[x2 + 1];
                    int n21 = y;
                    dArray21[n21] = dArray21[n21] + diffuseVal;
                    continue;
                }
                if (y == 0) {
                    double[] dArray = scratch2[x2];
                    int n = y;
                    dArray[n] = dArray[n] + (scratch[x2][y] - 2.0 * diffuseVal);
                    double[] dArray22 = scratch2[x2];
                    int n22 = y + 1;
                    dArray22[n22] = dArray22[n22] + diffuseVal;
                    double[] dArray23 = scratch2[x2 - 1];
                    int n23 = y;
                    dArray23[n23] = dArray23[n23] + diffuseVal;
                    continue;
                }
                double[] dArray = scratch2[x2];
                int n = y;
                dArray[n] = dArray[n] + (scratch[x2][y] - 2.0 * diffuseVal);
                double[] dArray24 = scratch2[x2];
                int n24 = y - 1;
                dArray24[n24] = dArray24[n24] + diffuseVal;
                double[] dArray25 = scratch2[x2 - 1];
                int n25 = y;
                dArray25[n25] = dArray25[n25] + diffuseVal;
            }
        }
        for (y = 0; y < yy; ++y) {
            for (x2 = 0; x2 < xx; ++x2) {
                if (scratch2[x2][y] == scratch[x2][y]) continue;
                this.world.getPatchAtWrap(x2 + minx, y + miny).setPatchVariable(vn, (Object)scratch2[x2][y]);
            }
        }
    }

    double observerX() {
        return 0.0;
    }

    double observerY() {
        return 0.0;
    }

    double followOffsetX() {
        return 0.0;
    }

    double followOffsetY() {
        return 0.0;
    }

    AgentSet getNeighbors(Patch source2) {
        double xLoc = source2.pxcor;
        double yLoc = source2.pycor;
        if (xLoc == (double)this.world._maxPxcor && xLoc == (double)this.world._minPxcor && yLoc == (double)this.world._maxPycor && yLoc == (double)this.world._minPycor) {
            return new ArrayAgentSet(Patch.class, 1, false, this.world);
        }
        if (xLoc == (double)this.world.maxPxcor()) {
            if (xLoc == (double)this.world.minPxcor()) {
                if (yLoc == (double)this.world.maxPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchSouth(source2)}, this.world);
                }
                if (yLoc == (double)this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2)}, this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchSouth(source2)}, this.world);
            }
            if (yLoc == (double)this.world.maxPycor()) {
                if (yLoc == (double)this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchWest(source2)}, this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchSouth(source2), this.getPatchWest(source2), this.getPatchSouthWest(source2)}, this.world);
            }
            if (yLoc == (double)this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchWest(source2), this.getPatchNorthWest(source2)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchSouth(source2), this.getPatchWest(source2), this.getPatchSouthWest(source2), this.getPatchNorthWest(source2)}, this.world);
        }
        if (xLoc == (double)this.world.minPxcor()) {
            if (yLoc == (double)this.world.maxPycor()) {
                if (yLoc == (double)this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2)}, this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchSouthEast(source2)}, this.world);
            }
            if (yLoc == (double)this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchNorthEast(source2)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchNorthEast(source2), this.getPatchSouthEast(source2)}, this.world);
        }
        if (yLoc == (double)this.world.maxPycor()) {
            if (yLoc == (double)this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2), this.getPatchWest(source2)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchWest(source2), this.getPatchSouthEast(source2), this.getPatchSouthWest(source2)}, this.world);
        }
        if (yLoc == (double)this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchWest(source2), this.getPatchNorthEast(source2), this.getPatchNorthWest(source2)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchWest(source2), this.getPatchNorthEast(source2), this.getPatchSouthEast(source2), this.getPatchSouthWest(source2), this.getPatchNorthWest(source2)}, this.world);
    }

    AgentSet getNeighbors4(Patch source2) {
        int xLoc = source2.pxcor;
        int yLoc = source2.pycor;
        if (xLoc == this.world.maxPxcor()) {
            if (xLoc == this.world.minPxcor()) {
                if (yLoc == this.world.maxPycor()) {
                    if (yLoc == this.world.minPycor()) {
                        return new ArrayAgentSet(Patch.class, 1, false, this.world);
                    }
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchSouth(source2)}, this.world);
                }
                if (yLoc == this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2)}, this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchSouth(source2)}, this.world);
            }
            if (yLoc == this.world.maxPycor()) {
                if (yLoc == this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchWest(source2)}, this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchSouth(source2), this.getPatchWest(source2)}, this.world);
            }
            if (yLoc == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchWest(source2)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchSouth(source2), this.getPatchWest(source2)}, this.world);
        }
        if (xLoc == this.world.minPxcor()) {
            if (yLoc == this.world.maxPycor()) {
                if (yLoc == this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2)}, this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2), this.getPatchSouth(source2)}, this.world);
            }
            if (yLoc == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchSouth(source2)}, this.world);
        }
        if (yLoc == this.world.maxPycor()) {
            if (yLoc == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2), this.getPatchWest(source2)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchWest(source2)}, this.world);
        }
        if (yLoc == this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchWest(source2)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchWest(source2)}, this.world);
    }

    Patch getPN(Patch source2) {
        if (source2.pycor == this.world.maxPycor()) {
            return null;
        }
        return this.getPatchNorth(source2);
    }

    Patch getPE(Patch source2) {
        if (source2.pxcor == this.world.maxPxcor()) {
            return null;
        }
        return this.getPatchEast(source2);
    }

    Patch getPS(Patch source2) {
        if (source2.pycor == this.world.minPycor()) {
            return null;
        }
        return this.getPatchSouth(source2);
    }

    Patch getPW(Patch source2) {
        if (source2.pxcor == this.world.minPxcor()) {
            return null;
        }
        return this.getPatchWest(source2);
    }

    Patch getPNE(Patch source2) {
        if (source2.pxcor == this.world.maxPxcor() || source2.pycor == this.world.maxPycor()) {
            return null;
        }
        return this.getPatchNorthEast(source2);
    }

    Patch getPSE(Patch source2) {
        if (source2.pxcor == this.world.maxPxcor() || source2.pycor == this.world.minPycor()) {
            return null;
        }
        return this.getPatchSouthEast(source2);
    }

    Patch getPSW(Patch source2) {
        if (source2.pxcor == this.world.minPxcor() || source2.pycor == this.world.minPycor()) {
            return null;
        }
        return this.getPatchSouthWest(source2);
    }

    Patch getPNW(Patch source2) {
        if (source2.pxcor == this.world.minPxcor() || source2.pycor == this.world.maxPycor()) {
            return null;
        }
        return this.getPatchNorthWest(source2);
    }
}

