/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class InRadiusOrCone {
    private final World world;

    InRadiusOrCone(World world) {
        this.world = world;
    }

    public List<Agent> inRadius(Agent agent, AgentSet sourceSet, double radius, boolean wrap2) {
        double startY;
        double startX;
        Patch startPatch;
        int worldWidth = this.world.worldWidth();
        int worldHeight = this.world.worldHeight();
        int maxPxcor = this.world.maxPxcor();
        int maxPycor = this.world.maxPycor();
        int minPxcor = this.world.minPxcor();
        int minPycor = this.world.minPycor();
        ArrayList<Agent> result2 = new ArrayList<Agent>();
        if (agent instanceof Turtle) {
            Turtle startTurtle = (Turtle)agent;
            startPatch = startTurtle.getPatchHere();
            startX = startTurtle.xcor();
            startY = startTurtle.ycor();
        } else {
            startPatch = (Patch)agent;
            startX = startPatch.pxcor;
            startY = startPatch.pycor;
        }
        int dxmin = 0;
        int dxmax = 0;
        int dymin = 0;
        int dymax = 0;
        int r = (int)StrictMath.ceil(radius);
        if (this.world.wrappingAllowedInX()) {
            double width = (double)worldWidth / 2.0;
            if ((double)r < width) {
                dxmax = r;
                dxmin = -r;
            } else {
                dxmax = (int)StrictMath.floor(width);
                dxmin = -((int)StrictMath.ceil(width - 1.0));
            }
        } else {
            int xdiff = minPxcor - startPatch.pxcor;
            dxmin = StrictMath.abs(xdiff) < r ? xdiff : -r;
            dxmax = StrictMath.min(maxPxcor - startPatch.pxcor, r);
        }
        if (this.world.wrappingAllowedInY()) {
            double height = (double)worldHeight / 2.0;
            if ((double)r < height) {
                dymax = r;
                dymin = -r;
            } else {
                dymax = (int)StrictMath.floor(height);
                dymin = -((int)StrictMath.ceil(height - 1.0));
            }
        } else {
            int ydiff = minPycor - startPatch.pycor;
            dymin = StrictMath.abs(ydiff) < r ? ydiff : -r;
            dymax = StrictMath.min(maxPycor - startPatch.pycor, r);
        }
        for (int dy = dymin; dy <= dymax; ++dy) {
            for (int dx = dxmin; dx <= dxmax; ++dx) {
                try {
                    Patch patch2 = startPatch.getPatchAtOffsets(dx, dy);
                    if (sourceSet.type() == Patch.class) {
                        if (!(this.world.protractor().distance(patch2.pxcor, patch2.pycor, startX, startY, wrap2) <= radius) || sourceSet != this.world.patches() && !sourceSet.contains(patch2)) continue;
                        result2.add(patch2);
                        continue;
                    }
                    if (sourceSet.type() != Turtle.class || this.world.rootsTable.gridRoot(dx * dx + dy * dy) > radius + 1.415) continue;
                    for (Turtle turtle2 : patch2.turtlesHere()) {
                        if (!(this.world.protractor().distance(turtle2.xcor(), turtle2.ycor(), startX, startY, wrap2) <= radius) || sourceSet != this.world.turtles() && (sourceSet.printName() == null || sourceSet != turtle2.getBreed()) && (sourceSet.printName() != null || !sourceSet.contains(turtle2))) continue;
                        result2.add(turtle2);
                    }
                    continue;
                }
                catch (AgentException e) {
                    Exceptions.ignore(e);
                }
            }
        }
        return result2;
    }

    public List<Agent> inCone(Turtle startTurtle, AgentSet sourceSet, double radius, double angle, boolean wrap2) {
        int n;
        int m;
        int worldWidth = this.world.worldWidth();
        int worldHeight = this.world.worldHeight();
        int maxPxcor = this.world.maxPxcor();
        int maxPycor = this.world.maxPycor();
        int minPxcor = this.world.minPxcor();
        int minPycor = this.world.minPycor();
        if (wrap2) {
            m = this.world.wrappingAllowedInX() ? (int)StrictMath.ceil(radius / (double)worldWidth) : 0;
            n = this.world.wrappingAllowedInY() ? (int)StrictMath.ceil(radius / (double)worldHeight) : 0;
        } else {
            m = 0;
            n = 0;
        }
        ArrayList<Agent> result2 = new ArrayList<Agent>();
        Patch startPatch = startTurtle.getPatchHere();
        double half = angle / 2.0;
        int dxmin = 0;
        int dymin = 0;
        int dxmax = 0;
        int dymax = 0;
        int r = (int)StrictMath.ceil(radius);
        if (this.world.wrappingAllowedInX()) {
            double width = (double)worldWidth / 2.0;
            if ((double)r < width) {
                dxmax = r;
                dxmin = -r;
            } else {
                dxmax = (int)StrictMath.floor(width);
                dxmin = -((int)StrictMath.ceil(width - 1.0));
            }
        } else {
            int xdiff = minPxcor - startPatch.pxcor;
            dxmin = StrictMath.abs(xdiff) < r ? xdiff : -r;
            dxmax = StrictMath.min(maxPxcor - startPatch.pxcor, r);
        }
        if (this.world.wrappingAllowedInY()) {
            double height = (double)worldHeight / 2.0;
            if ((double)r < height) {
                dymax = r;
                dymin = -r;
            } else {
                dymax = (int)StrictMath.floor(height);
                dymin = -((int)StrictMath.ceil(height - 1.0));
            }
        } else {
            int ydiff = minPycor - startPatch.pycor;
            dymin = StrictMath.abs(ydiff) < r ? ydiff : -r;
            dymax = StrictMath.min(maxPycor - startPatch.pycor, r);
        }
        for (int dy = dymin; dy <= dymax; ++dy) {
            block1: for (int dx = dxmin; dx <= dxmax; ++dx) {
                Patch patch2 = this.world.getPatchAtWrap(startPatch.pxcor + dx, startPatch.pycor + dy);
                if (patch2 == null) continue;
                if (sourceSet.type() == Patch.class) {
                    for (int worldOffsetX = -m; worldOffsetX <= m; ++worldOffsetX) {
                        for (int worldOffsetY = -n; worldOffsetY <= n; ++worldOffsetY) {
                            if (sourceSet != this.world.patches() && !sourceSet.contains(patch2) || !this.isInCone(patch2.pxcor + worldWidth * worldOffsetX, patch2.pycor + worldHeight * worldOffsetY, startTurtle.xcor(), startTurtle.ycor(), radius, half, startTurtle.heading())) continue;
                            result2.add(patch2);
                            continue block1;
                        }
                    }
                    continue;
                }
                if (!(this.world.rootsTable.gridRoot(dx * dx + dy * dy) <= radius + 1.415)) continue;
                block4: for (Turtle turtle2 : patch2.turtlesHere()) {
                    for (int worldOffsetX = -m; worldOffsetX <= m; ++worldOffsetX) {
                        for (int worldOffsetY = -n; worldOffsetY <= n; ++worldOffsetY) {
                            if (sourceSet != this.world.turtles() && (sourceSet.printName() == null || sourceSet != turtle2.getBreed()) && (sourceSet.printName() != null || !sourceSet.contains(turtle2)) || !this.isInCone(turtle2.xcor() + (double)(worldWidth * worldOffsetX), turtle2.ycor() + (double)(worldHeight * worldOffsetY), startTurtle.xcor(), startTurtle.ycor(), radius, half, startTurtle.heading())) continue;
                            result2.add(turtle2);
                            continue block4;
                        }
                    }
                }
            }
        }
        return result2;
    }

    private boolean isInCone(double x2, double y, double cx, double cy, double r, double half, double h) {
        double theta;
        if (x2 == cx && y == cy) {
            return true;
        }
        if (this.world.protractor().distance(cx, cy, x2, y, false) > r) {
            return false;
        }
        try {
            theta = this.world.protractor().towards(cx, cy, x2, y, false);
        }
        catch (AgentException e) {
            throw new IllegalStateException(e.toString());
        }
        double diff2 = StrictMath.abs(theta - h);
        return diff2 <= half || 360.0 - diff2 <= half;
    }
}

