/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.DummyLink;
import org.nlogo.agent.Link;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class LinkManager {
    private final World world;
    final Map<Turtle, List<Link>> srcMap = new LinkedHashMap<Turtle, List<Link>>();
    final Map<Turtle, List<Link>> destMap = new LinkedHashMap<Turtle, List<Link>>();
    private double countUnbreededLinks = 0.0;

    public LinkManager(World world) {
        this.world = world;
    }

    private void bless(Link link) {
        ArrayList<Link> recList;
        Turtle end1 = link.end1();
        Turtle end2 = link.end2();
        if (this.srcMap.containsKey(end1)) {
            this.srcMap.get(end1).add(link);
        } else {
            recList = new ArrayList<Link>();
            recList.add(link);
            this.srcMap.put(end1, recList);
        }
        if (this.destMap.containsKey(end2)) {
            this.destMap.get(end2).add(link);
        } else {
            recList = new ArrayList();
            recList.add(link);
            this.destMap.put(end2, recList);
        }
        if (link.getBreed() == this.world.links()) {
            this.countUnbreededLinks += 1.0;
        }
    }

    public void reset() {
        this.srcMap.clear();
        this.destMap.clear();
        this.world.tieManager.reset();
        this.countUnbreededLinks = 0.0;
        this.resetLinkDirectedness();
    }

    private void resetLinkDirectedness() {
        if (this.countUnbreededLinks == 0.0) {
            this.world.links().clearDirected();
        }
    }

    public Link createLink(Turtle src, Turtle dest, AgentSet breed) {
        Link link = this.newLink(this.world, src, dest, breed);
        link.colorDoubleUnchecked(Link.DEFAULT_COLOR);
        this.bless(link);
        return link;
    }

    Link newLink(World world, Turtle src, Turtle dest, AgentSet breed) {
        return new Link(world, src, dest, breed);
    }

    public Link findLink(Turtle src, Turtle dest, AgentSet breed, boolean includeAllLinks) {
        if (breed.isDirected()) {
            return this.findLinkFrom(src, dest, breed, includeAllLinks);
        }
        return this.findLinkEitherWay(src, dest, breed, includeAllLinks);
    }

    public Link findLinkFrom(Turtle src, Turtle dest, AgentSet breed, boolean includeAllLinks) {
        if (src == null || dest == null) {
            return null;
        }
        Link link = (Link)this.world.links().getAgent(new DummyLink(this.world, (Object)src, (Object)dest, breed));
        if (link == null && includeAllLinks && breed == this.world.links()) {
            Iterator<Object> iter2 = this.world.getLinkBreeds().values().iterator();
            while (iter2.hasNext()) {
                link = (Link)this.world.links().getAgent(new DummyLink(this.world, (Object)src, (Object)dest, (AgentSet)iter2.next()));
                if (link == null) continue;
                return link;
            }
        }
        return link;
    }

    public Link findLinkEitherWay(Turtle src, Turtle dest, AgentSet breed, boolean includeAllLinks) {
        Link link = this.findLinkFrom(src, dest, breed, includeAllLinks);
        if (link == null) {
            link = this.findLinkFrom(dest, src, breed, includeAllLinks);
        }
        return link;
    }

    public AgentSet findLinkedFrom(Turtle src, AgentSet sourceSet) {
        List<Link> fromList = this.srcMap.get(src);
        if (fromList != null) {
            ArrayAgentSet nodeset = new ArrayAgentSet(Turtle.class, fromList.size(), false, this.world);
            this.addLinkNeighborsFrom(nodeset, fromList, sourceSet, true);
            return nodeset;
        }
        return this.world.noTurtles();
    }

    public AgentSet findLinkedTo(Turtle target, AgentSet sourceSet) {
        List<Link> fromList = this.destMap.get(target);
        if (fromList != null) {
            ArrayAgentSet nodeset = new ArrayAgentSet(Turtle.class, fromList.size(), false, this.world);
            this.addLinkNeighborsTo(nodeset, fromList, sourceSet, true);
            return nodeset;
        }
        return this.world.noTurtles();
    }

    public AgentSet findLinkedWith(Turtle target, AgentSet sourceSet) {
        List<Link> toList2 = this.destMap.get(target);
        List<Link> fromList = this.srcMap.get(target);
        int size2 = (fromList == null ? 0 : fromList.size()) + (toList2 == null ? 0 : toList2.size());
        if (size2 == 0) {
            return this.world.noTurtles();
        }
        ArrayAgentSet nodeset = new ArrayAgentSet(Turtle.class, size2, false, this.world);
        if (toList2 != null) {
            this.addLinkNeighborsTo(nodeset, toList2, sourceSet, false);
        }
        if (fromList != null) {
            this.addLinkNeighborsFrom(nodeset, fromList, sourceSet, false);
        }
        return nodeset;
    }

    private void addLinkNeighborsFrom(AgentSet nodeset, List<Link> links, AgentSet sourceSet, boolean directed) {
        boolean isBreed = sourceSet.printName() != null;
        boolean isAllLinks = sourceSet == this.world.links();
        boolean unbreededLinks = this.checkBreededCompatibility(true);
        for (Link link : links) {
            if (!(!isBreed && sourceSet.contains(link) || isAllLinks && (unbreededLinks || directed == link.getBreed().isDirected() && !nodeset.contains(link.end1()))) && link.getBreed() != sourceSet) continue;
            nodeset.add(link.end2());
        }
    }

    private void addLinkNeighborsTo(AgentSet nodeset, List<Link> links, AgentSet sourceSet, boolean directed) {
        boolean isBreed = sourceSet.printName() != null;
        boolean isAllLinks = sourceSet == this.world.links();
        boolean unbreededLinks = this.checkBreededCompatibility(true);
        for (Link link : links) {
            if (!(!isBreed && sourceSet.contains(link) || isAllLinks && (unbreededLinks || directed == link.getBreed().isDirected() && !nodeset.contains(link.end1()))) && link.getBreed() != sourceSet) continue;
            nodeset.add(link.end1());
        }
    }

    public boolean checkBreededCompatibility(boolean unbreeded) {
        AgentSet.Iterator it = this.world.links().iterator();
        if (!it.hasNext()) {
            return true;
        }
        return ((Link)it.next()).getBreed() == this.world.links() == unbreeded;
    }

    public AgentSet findLinksFrom(Turtle src, AgentSet breed) {
        boolean isAllLinks;
        List<Link> fromList = this.srcMap.get(src);
        ArrayAgentSet linkset = new ArrayAgentSet(Link.class, 1, false, this.world);
        boolean bl = isAllLinks = breed == this.world.links();
        if (fromList != null) {
            for (Link link : fromList) {
                if (!isAllLinks && link.getBreed() != breed) continue;
                ((AgentSet)linkset).add(link);
            }
        }
        return linkset;
    }

    public AgentSet findLinksTo(Turtle target, AgentSet breed) {
        boolean isAllLinks;
        List<Link> fromList = this.destMap.get(target);
        ArrayAgentSet linkset = new ArrayAgentSet(Link.class, 1, false, this.world);
        boolean bl = isAllLinks = breed == this.world.links();
        if (fromList != null) {
            for (Link link : fromList) {
                if (!isAllLinks && link.getBreed() != breed) continue;
                ((AgentSet)linkset).add(link);
            }
        }
        return linkset;
    }

    public AgentSet findLinksWith(Turtle target, AgentSet breed) {
        List<Link> fromList = this.destMap.get(target);
        List<Link> toList2 = this.srcMap.get(target);
        ArrayList<Link> totalList = new ArrayList<Link>();
        if (fromList != null) {
            totalList.addAll(fromList);
        }
        if (toList2 != null) {
            totalList.addAll(toList2);
        }
        boolean isAllLinks = breed == this.world.links();
        ArrayAgentSet linkset = new ArrayAgentSet(Link.class, 1, false, this.world);
        for (Link link : totalList) {
            if (!isAllLinks && link.getBreed() != breed) continue;
            ((AgentSet)linkset).add(link);
        }
        return linkset;
    }

    void cleanup(Link link) {
        Turtle end2;
        link.untie();
        Turtle end1 = link.end1();
        List<Link> list2 = this.srcMap.get(end1);
        if (list2 != null) {
            list2.remove(link);
            if (list2.isEmpty()) {
                this.srcMap.remove(end1);
            }
        }
        if ((list2 = this.destMap.get(end2 = link.end2())) != null) {
            list2.remove(link);
            if (list2.isEmpty()) {
                this.destMap.remove(end2);
            }
        }
        if (link.getBreed() == this.world.links()) {
            this.countUnbreededLinks -= 1.0;
        }
        this.resetLinkDirectedness();
    }

    void cleanup(Turtle turtle2) {
        List<Link> links;
        if (this.srcMap.containsKey(turtle2)) {
            links = this.srcMap.get(turtle2);
            this.srcMap.remove(turtle2);
            for (Link link : links) {
                link.die();
            }
        }
        if (this.destMap.containsKey(turtle2)) {
            links = this.destMap.get(turtle2);
            this.destMap.remove(turtle2);
            for (Link link : links) {
                link.die();
            }
        }
    }
}

