/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.Agent3D;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.PerspectiveJ;
import org.nlogo.api.Vect;

public strictfp final class Observer3D
extends Observer
implements Agent3D {
    private Vect forward;
    private Vect right;

    public Observer3D(World world) {
        super(world);
    }

    public void home() {
        super.home();
        World3D w = (World3D)this.world;
        double zOff = (double)w.minPzcor() + (double)(w.maxPzcor() - w.minPzcor()) / 2.0;
        this.ozcor(zOff + (double)(StrictMath.max(this.world.worldWidth(), StrictMath.max(this.world.worldHeight(), w.worldDepth())) * 2));
        this.rotationPoint = new Vect(this.oxcor(), this.oycor(), zOff);
        this.right = new Vect(1.0, 0.0, 0.0);
        this.forward = new Vect(0.0, 0.0, 1.0);
    }

    public boolean updatePosition() {
        boolean changed2 = false;
        if (this.perspective == PerspectiveJ.OBSERVE()) {
            return false;
        }
        if (this.perspective == PerspectiveJ.WATCH()) {
            if (this.targetAgent.id() == -1L) {
                this.resetPerspective();
                return true;
            }
            this.face(this.targetAgent);
        } else {
            if (this.targetAgent.id() == -1L) {
                this.resetPerspective();
                return true;
            }
            Turtle3D turtle2 = (Turtle3D)this.targetAgent;
            this.oxyandzcor(turtle2.xcor(), turtle2.ycor(), turtle2.zcor());
            this.heading(turtle2.heading());
            this.pitch(turtle2.pitch());
            this.roll(turtle2.roll());
        }
        return changed2;
    }

    public double distance(Agent agent) {
        double z;
        double y;
        double x2;
        if (agent instanceof Turtle) {
            Turtle3D t = (Turtle3D)agent;
            x2 = t.xcor();
            y = t.ycor();
            z = t.zcor();
        } else {
            Patch3D p = (Patch3D)agent;
            x2 = p.pxcor;
            y = p.pycor;
            z = p.pzcor;
        }
        return this.distance(x2, y, z);
    }

    public double distance(org.nlogo.api.Turtle t) {
        return this.distance(t.xcor(), t.ycor(), ((org.nlogo.api.Turtle3D)t).zcor());
    }

    public double distance(double x2, double y, double z) {
        return StrictMath.sqrt((x2 - this.oxcor()) * (x2 - this.oxcor()) + (y - this.oycor()) * (y - this.oycor()) + (z - this.ozcor()) * (z - this.ozcor()));
    }

    public double followOffsetZ() {
        if (this.perspective == PerspectiveJ.FOLLOW() || this.perspective == PerspectiveJ.RIDE()) {
            World3D w = (World3D)this.world;
            return this.ozcor() - (double)(w.minPzcor() + w.maxPzcor()) / 2.0;
        }
        return 0.0;
    }

    public void face(double x2, double y, double z) {
        try {
            this.heading(this.world.protractor().towards(this, x2, y, false));
        }
        catch (AgentException ex) {
            this.heading(0.0);
        }
        try {
            this.pitch(-this.world.protractor().towardsPitch(this, x2, y, z, false));
        }
        catch (AgentException ex) {
            this.pitch(0.0);
        }
        this.setRotationPoint(x2, y, z);
        Vect[] v = Vect.toVectors(this.heading, this.pitch, this.roll);
        this.forward = v[0];
        this.right = v[1];
    }

    public void moveto(Agent otherAgent) {
        if (otherAgent instanceof Turtle) {
            Turtle3D t = (Turtle3D)otherAgent;
            this.oxyandzcor(t.xcor(), t.ycor(), t.zcor());
        } else {
            Patch3D p = (Patch3D)otherAgent;
            this.oxyandzcor(p.pxcor, p.pycor, p.pzcor);
        }
        this.face(this.rotationPoint.x(), this.rotationPoint.y(), this.rotationPoint.z());
    }

    public Patch3D getPatchAtOffsets(double dx, double dy, double dz) throws AgentException {
        return ((World3D)this.world).getPatchAt(dx, dy, dz);
    }

    public void setRotationPoint(org.nlogo.api.Agent agent) {
        if (agent instanceof Turtle) {
            Turtle3D t = (Turtle3D)agent;
            this.setRotationPoint(t.xcor(), t.ycor(), t.zcor());
        } else {
            Patch3D p = (Patch3D)agent;
            this.setRotationPoint(p.pxcor(), p.pycor(), p.pzcor());
        }
    }

    public void orbitRight(double delta) {
        this.right = this.right.correct();
        this.forward = this.forward.correct();
        Vect cors = new Vect(this.oxcor(), this.oycor(), this.ozcor());
        Vect up2 = this.forward.cross(this.right);
        Vect xaxis = new Vect(1.0, 0.0, 0.0);
        Vect upxy = new Vect(up2.x(), up2.y(), 0.0);
        upxy = upxy.normalize();
        if (up2.z() > 0.0) {
            delta = -delta;
        }
        cors = cors.subtract(this.rotationPoint);
        cors = cors.rotateZ(delta);
        this.right = this.right.rotateZ(delta);
        this.forward = this.forward.rotateZ(delta);
        cors = cors.add(this.rotationPoint);
        Vect rightxy = new Vect(this.right.x(), this.right.y(), 0.0);
        rightxy = rightxy.normalize();
        this.heading = StrictMath.toDegrees(rightxy.angleTo(xaxis));
        this.oxyandzcor(cors.x(), cors.y(), cors.z());
    }

    public void orbitUp(double delta) {
        Vect pos = new Vect(this.oxcor() - this.rotationPoint.x(), this.oycor() - this.rotationPoint.y(), this.ozcor() - this.rotationPoint.z());
        Vect rightxy = new Vect(this.right.x(), this.right.y(), 0.0).correct().normalize();
        Vect xaxis = new Vect(1.0, 0.0, 0.0);
        double angle = StrictMath.toDegrees(rightxy.angleTo(xaxis));
        pos = pos.rotateZ(angle).rotateX(-delta).rotateZ(-angle);
        this.pitch(this.pitch + delta);
        Vect[] v = Vect.toVectors(this.heading, this.pitch, this.roll);
        this.forward = v[0];
        this.right = v[1];
        this.oxyandzcor(pos.x() + this.rotationPoint.x(), pos.y() + this.rotationPoint.y(), pos.z() + this.rotationPoint.z());
    }

    public void translate(double thetaX, double thetaY) {
        Vect[] v = Vect.toVectors(this.heading, this.pitch, this.roll);
        Vect ortho = v[1].cross(v[0]);
        this.oxcor(this.oxcor() - v[1].x() * thetaX * 0.1);
        this.oycor(this.oycor() - v[1].y() * thetaX * 0.1);
        this.ozcor(this.ozcor() + v[1].z() * thetaX * 0.1);
        this.rotationPoint = new Vect(this.rotationPoint.x() - v[1].x() * thetaX * 0.1, this.rotationPoint.y() - v[1].y() * thetaX * 0.1, this.rotationPoint.z() + v[1].z() * thetaX * 0.1);
        this.oxcor(this.oxcor() + ortho.x() * thetaY * 0.1);
        this.oycor(this.oycor() + ortho.y() * thetaY * 0.1);
        this.ozcor(this.ozcor() - ortho.z() * thetaY * 0.1);
        this.rotationPoint = new Vect(this.rotationPoint.x() + ortho.x() * thetaY * 0.1, this.rotationPoint.y() + ortho.y() * thetaY * 0.1, this.rotationPoint.z() - ortho.z() * thetaY * 0.1);
    }
}

