/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.List;
import org.nlogo.agent.Agent3D;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.LogoList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class Patch3D
extends Patch
implements Agent3D,
org.nlogo.api.Patch3D {
    public static final int VAR_PXCOR3D = 0;
    public static final int VAR_PYCOR3D = 1;
    public static final int VAR_PZCOR3D = 2;
    public static final int VAR_PCOLOR3D = 3;
    public static final int VAR_PLABEL3D = 4;
    public static final int VAR_PLABELCOLOR3D = 5;
    public final int pzcor;
    public AgentSet patchNeighbors6;
    public static final int LAST_PREDEFINED_VAR_3D = 5;

    @Override
    public int pzcor() {
        return this.pzcor;
    }

    @Override
    void topologyChanged() {
        super.topologyChanged();
        this.patchNeighbors6 = null;
    }

    Patch3D(World world, int id, int pxcor, int pycor, int pzcor, int numVariables) {
        super(world, pxcor, pycor);
        this.id = id;
        this.pzcor = pzcor;
        this.variables = new Object[numVariables];
        block7: for (int i = 0; i < numVariables; ++i) {
            switch (i) {
                case 0: {
                    this.variables[i] = (double)pxcor;
                    continue block7;
                }
                case 1: {
                    this.variables[i] = (double)pycor;
                    continue block7;
                }
                case 2: {
                    this.variables[i] = (double)pzcor;
                    continue block7;
                }
                case 4: {
                    this.variables[i] = "";
                    continue block7;
                }
                case 5: {
                    this.variables[i] = Color.BoxedWhite();
                    continue block7;
                }
                default: {
                    this.variables[i] = World.ZERO;
                }
            }
        }
        this.NUMBER_PREDEFINED_VARS = 6;
    }

    @Override
    public void setPatchVariable(int vn, Object value2) throws AgentException {
        if (vn > 5) {
            this.variables[vn] = value2;
        } else {
            switch (vn) {
                case 3: {
                    if (value2 instanceof Double) {
                        this.pcolor((Double)value2);
                        break;
                    }
                    if (value2 instanceof LogoList) {
                        this.pcolor((LogoList)value2, 3, true);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(true)[vn], Double.class, value2);
                    break;
                }
                case 4: {
                    this.label(value2);
                    break;
                }
                case 5: {
                    if (value2 instanceof Double) {
                        this.labelColor((double)((Double)value2));
                        break;
                    }
                    if (value2 instanceof LogoList) {
                        this.labelColor((LogoList)value2, 5);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(true)[vn], Double.class, value2);
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    throw new AgentException("you can't change a patch's coordinates");
                }
                default: {
                    return;
                }
            }
        }
    }

    @Override
    public void setPatchVariable(int vn, double value2) throws AgentException {
        switch (vn) {
            case 0: {
                throw new AgentException("you can't change a patch's coordinates");
            }
            case 1: {
                throw new AgentException("you can't change a patch's coordinates");
            }
            case 2: {
                throw new AgentException("you can't change a patch's coordinates");
            }
        }
        throw new IllegalArgumentException(vn + " is not a double variable");
    }

    @Override
    public Object getPatchVariable(int vn) {
        if (vn == 3 && this.variables[3] == null) {
            this.variables[3] = this.pcolor;
        }
        return this.variables[vn];
    }

    @Override
    public double getPatchVariableDouble(int vn) {
        switch (vn) {
            case 0: {
                return this.pxcor;
            }
            case 1: {
                return this.pycor;
            }
            case 2: {
                return this.pzcor;
            }
        }
        throw new IllegalArgumentException(vn + " is not a double variable");
    }

    @Override
    public Patch getPatchAtOffsets(double dx, double dy) throws AgentException {
        Patch3D target = ((World3D)this.world).getPatchAt((double)this.pxcor + dx, (double)this.pycor + dy, this.pzcor);
        if (target == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return target;
    }

    @Override
    public Patch3D getPatchAtOffsets(double dx, double dy, double dz) throws AgentException {
        Patch3D target = ((World3D)this.world).getPatchAt((double)this.pxcor + dx, (double)this.pycor + dy, (double)this.pzcor + dz);
        if (target == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return target;
    }

    public Patch getPatchAtPoint(List<Double> point) throws AgentException {
        double dx = point.get(0);
        double dy = point.get(1);
        double dz = point.size() == 3 ? point.get(2) : 0.0;
        return this.getPatchAtOffsets(dx, dy, dz);
    }

    @Override
    public Patch fastGetPatchAt(int x2, int y) {
        return ((World3D)this.world).fastGetPatchAt(x2, y, this.pzcor);
    }

    @Override
    public Turtle sprout(int c, int heading, AgentSet breed) {
        Turtle3D child = new Turtle3D((World3D)this.world, breed, (Double)this.variables[0], (Double)this.variables[1], (Double)this.variables[2]);
        child.colorDouble(Double.valueOf(5 + 10 * c));
        child.heading(heading);
        return child;
    }

    @Override
    public Object pcolor() {
        if (this.variables[3] == null) {
            this.variables[3] = this.pcolor;
        }
        return this.variables[3];
    }

    @Override
    public void pcolor(double pcolor) {
        if (pcolor < 0.0 || pcolor >= (double)Color.MaxColor()) {
            pcolor = Color.modulateDouble(pcolor);
        }
        if (this.pcolor != pcolor) {
            this.pcolor = pcolor;
            this.variables[3] = null;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(pcolor);
            this.world.patchColorsDirty = true;
            if (pcolor != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    @Override
    public void pcolor(Double boxedColor) {
        double color = boxedColor;
        if (color < 0.0 || color >= (double)Color.MaxColor()) {
            if (this.pcolor != (color = Color.modulateDouble(color))) {
                this.pcolor = color;
                this.variables[3] = null;
                this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(this.pcolor);
                this.world.patchColorsDirty = true;
                if (this.pcolor != 0.0) {
                    this.world.patchesAllBlack = false;
                }
            }
        } else if (this.pcolor != color) {
            this.pcolor = color;
            this.variables[3] = boxedColor;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(this.pcolor);
            this.world.patchColorsDirty = true;
            if (this.pcolor != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    @Override
    public void pcolor(LogoList rgb) throws AgentException {
        this.pcolor(rgb, 3, true);
    }

    @Override
    public void pcolorDoubleUnchecked(Double boxedColor) {
        double color = boxedColor;
        if (color != this.pcolor) {
            this.pcolor = color;
            this.variables[3] = boxedColor;
            this.world.patchColors[(int)this.id] = Color.getARGBbyPremodulatedColorNumber(color);
            this.world.patchColorsDirty = true;
            if (color != 0.0) {
                this.world.patchesAllBlack = false;
            }
        }
    }

    @Override
    public Object label() {
        return this.variables[4];
    }

    @Override
    public String labelString() {
        return Dump.logoObject(this.variables[4]);
    }

    @Override
    public void label(Object label) {
        if (label instanceof String && ((String)label).length() == 0) {
            if (this.hasLabel()) {
                --this.world.patchesWithLabels;
            }
        } else if (!this.hasLabel()) {
            ++this.world.patchesWithLabels;
        }
        this.variables[4] = label;
    }

    @Override
    public Object labelColor() {
        return this.variables[5];
    }

    @Override
    public void labelColor(double labelColor) {
        this.variables[5] = Color.modulateDouble(labelColor);
    }

    @Override
    public void labelColor(Double labelColor) {
        this.variables[5] = labelColor;
    }

    @Override
    public AgentSet getNeighbors() {
        if (this.patchNeighbors == null) {
            this.patchNeighbors = ((Topology3D)((Object)this.world.getTopology())).getNeighbors3d(this);
        }
        return this.patchNeighbors;
    }

    public AgentSet getNeighbors6() {
        if (this.patchNeighbors6 == null) {
            this.patchNeighbors6 = ((Topology3D)((Object)this.world.getTopology())).getNeighbors6(this);
        }
        return this.patchNeighbors6;
    }

    @Override
    public String toString() {
        return "patch " + this.pxcor + " " + this.pycor + " " + this.pzcor;
    }

    @Override
    public int alpha() {
        return this.pcolor().equals(Color.BoxedBlack()) ? 0 : Color.getColor(this.pcolor()).getAlpha();
    }
}

