/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Box;
import org.nlogo.agent.HorizCylinder;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Torus;
import org.nlogo.agent.VertCylinder;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;

strictfp abstract class Topology {
    World world;

    Topology(World world) {
        this.world = world;
    }

    abstract double wrapX(double var1) throws AgentException;

    abstract double wrapY(double var1) throws AgentException;

    abstract double distanceWrap(double var1, double var3, double var5, double var7, double var9, double var11);

    abstract double towardsWrap(double var1, double var3);

    abstract Patch getPatchAt(double var1, double var3) throws AgentException;

    abstract AgentSet getNeighbors(Patch var1);

    abstract AgentSet getNeighbors4(Patch var1);

    abstract Patch getPN(Patch var1);

    abstract Patch getPE(Patch var1);

    abstract Patch getPS(Patch var1);

    abstract Patch getPW(Patch var1);

    abstract Patch getPNE(Patch var1);

    abstract Patch getPSE(Patch var1);

    abstract Patch getPSW(Patch var1);

    abstract Patch getPNW(Patch var1);

    abstract double shortestPathX(double var1, double var3);

    abstract double shortestPathY(double var1, double var3);

    public static Topology getTopology(World world, boolean xWrapping, boolean yWrapping) {
        if (xWrapping) {
            if (yWrapping) {
                return new Torus(world);
            }
            return new VertCylinder(world);
        }
        if (yWrapping) {
            return new HorizCylinder(world);
        }
        return new Box(world);
    }

    static double wrap(double pos, double min2, double max2) {
        if (pos >= max2) {
            return min2 + (pos - max2) % (max2 - min2);
        }
        if (pos < min2) {
            double result2 = max2 - (min2 - pos) % (max2 - min2);
            return result2 < max2 ? result2 : min2;
        }
        return pos;
    }

    double observerX() {
        return this.world.observer().oxcor();
    }

    double observerY() {
        return this.world.observer().oycor();
    }

    double followOffsetX() {
        return this.world.observer().followOffsetX();
    }

    double followOffsetY() {
        return this.world.observer().followOffsetY();
    }

    void diffuse(double diffuseparam, int vn) throws AgentException, PatchException {
        int minx = this.world.minPxcor();
        int maxx = this.world.maxPxcor();
        int miny = this.world.minPycor();
        int maxy = this.world.maxPycor();
        double[][] scratchOld = this.world.getPatchScratch();
        double[][] scratchNew = new double[maxx - minx + 1][maxy - miny + 1];
        int x2 = minx;
        int y = miny;
        try {
            for (x2 = minx; x2 <= maxx; ++x2) {
                for (y = miny; y <= maxy; ++y) {
                    Patch patch2 = this.world.fastGetPatchAt(x2, y);
                    double oldval = (Double)patch2.getPatchVariable(vn);
                    AgentSet neighbors = patch2.getNeighbors();
                    int neighborCount = neighbors.count();
                    double sum2 = 0.0;
                    for (int a = 0; a < neighborCount; ++a) {
                        Patch p = (Patch)neighbors.agent(a);
                        sum2 += (Double)p.getPatchVariable(vn) / (double)p.getNeighbors().count();
                    }
                    scratchOld[x2 - minx][y - miny] = oldval;
                    scratchNew[x2 - minx][y - miny] = oldval * (1.0 - diffuseparam) + sum2 * diffuseparam;
                }
            }
            for (x2 = minx; x2 <= maxx; ++x2) {
                for (y = miny; y <= maxy; ++y) {
                    double newval = scratchNew[x2 - minx][y - miny];
                    if (newval == scratchOld[x2 - minx][y - miny]) continue;
                    this.world.fastGetPatchAt(x2, y).setPatchVariable(vn, (Object)newval);
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(this.world.fastGetPatchAt(x2, y));
        }
    }

    void diffuse4(double diffuseparam, int vn) throws AgentException, PatchException {
        int minx = this.world.minPxcor();
        int maxx = this.world.maxPxcor();
        int miny = this.world.minPycor();
        int maxy = this.world.maxPycor();
        double[][] scratchOld = this.world.getPatchScratch();
        double[][] scratchNew = new double[maxx - minx + 1][maxy - miny + 1];
        int x2 = minx;
        int y = miny;
        try {
            for (x2 = minx; x2 <= maxx; ++x2) {
                for (y = miny; y <= maxy; ++y) {
                    Patch patch2 = this.world.fastGetPatchAt(x2, y);
                    double oldval = (Double)patch2.getPatchVariable(vn);
                    AgentSet neighbors = patch2.getNeighbors4();
                    int neighborCount = neighbors.count();
                    double sum2 = 0.0;
                    for (int a = 0; a < neighborCount; ++a) {
                        sum2 += ((Double)((Patch)neighbors.agent(a)).getPatchVariable(vn)).doubleValue();
                    }
                    scratchOld[x2 - minx][y - miny] = oldval;
                    scratchNew[x2 - minx][y - miny] = oldval * (1.0 - diffuseparam) + sum2 * diffuseparam / (double)neighborCount;
                }
            }
            for (x2 = minx; x2 <= maxx; ++x2) {
                for (y = miny; y <= maxy; ++y) {
                    double newval = scratchNew[x2 - minx][y - miny];
                    if (newval == scratchOld[x2 - minx][y - miny]) continue;
                    this.world.fastGetPatchAt(x2, y).setPatchVariable(vn, (Object)newval);
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(this.world.fastGetPatchAt(x2, y));
        }
    }

    Patch getPatchNorth(Patch source2) {
        if (source2.pycor == this.world.maxPycor()) {
            return source2.fastGetPatchAt(source2.pxcor, this.world.minPycor());
        }
        return source2.fastGetPatchAt(source2.pxcor, source2.pycor + 1);
    }

    Patch getPatchSouth(Patch source2) {
        if (source2.pycor == this.world.minPycor()) {
            return source2.fastGetPatchAt(source2.pxcor, this.world.maxPycor());
        }
        return source2.fastGetPatchAt(source2.pxcor, source2.pycor - 1);
    }

    Patch getPatchEast(Patch source2) {
        if (source2.pxcor == this.world.maxPxcor()) {
            return source2.fastGetPatchAt(this.world.minPxcor(), source2.pycor);
        }
        return source2.fastGetPatchAt(source2.pxcor + 1, source2.pycor);
    }

    Patch getPatchWest(Patch source2) {
        if (source2.pxcor == this.world.minPxcor()) {
            return source2.fastGetPatchAt(this.world.maxPxcor(), source2.pycor);
        }
        return source2.fastGetPatchAt(source2.pxcor - 1, source2.pycor);
    }

    Patch getPatchNorthWest(Patch source2) {
        if (source2.pycor == this.world.maxPycor()) {
            if (source2.pxcor == this.world.minPxcor()) {
                return source2.fastGetPatchAt(this.world.maxPxcor(), this.world.minPycor());
            }
            return source2.fastGetPatchAt(source2.pxcor - 1, this.world.minPycor());
        }
        if (source2.pxcor == this.world.minPxcor()) {
            return source2.fastGetPatchAt(this.world.maxPxcor(), source2.pycor + 1);
        }
        return source2.fastGetPatchAt(source2.pxcor - 1, source2.pycor + 1);
    }

    Patch getPatchSouthWest(Patch source2) {
        if (source2.pycor == this.world.minPycor()) {
            if (source2.pxcor == this.world.minPxcor()) {
                return source2.fastGetPatchAt(this.world.maxPxcor(), this.world.maxPycor());
            }
            return source2.fastGetPatchAt(source2.pxcor - 1, this.world.maxPycor());
        }
        if (source2.pxcor == this.world.minPxcor()) {
            return source2.fastGetPatchAt(this.world.maxPxcor(), source2.pycor - 1);
        }
        return source2.fastGetPatchAt(source2.pxcor - 1, source2.pycor - 1);
    }

    Patch getPatchSouthEast(Patch source2) {
        if (source2.pycor == this.world.minPycor()) {
            if (source2.pxcor == this.world.maxPxcor()) {
                return source2.fastGetPatchAt(this.world.minPxcor(), this.world.maxPycor());
            }
            return source2.fastGetPatchAt(source2.pxcor + 1, this.world.maxPycor());
        }
        if (source2.pxcor == this.world.maxPxcor()) {
            return source2.fastGetPatchAt(this.world.minPxcor(), source2.pycor - 1);
        }
        return source2.fastGetPatchAt(source2.pxcor + 1, source2.pycor - 1);
    }

    Patch getPatchNorthEast(Patch source2) {
        if (source2.pycor == this.world.maxPycor()) {
            if (source2.pxcor == this.world.maxPxcor()) {
                return source2.fastGetPatchAt(this.world.minPxcor(), this.world.minPycor());
            }
            return source2.fastGetPatchAt(source2.pxcor + 1, this.world.minPycor());
        }
        if (source2.pxcor == this.world.maxPxcor()) {
            return source2.fastGetPatchAt(this.world.minPxcor(), source2.pycor + 1);
        }
        return source2.fastGetPatchAt(source2.pxcor + 1, source2.pycor + 1);
    }
}

