/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Topology;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;

strictfp class Torus
extends Topology {
    Torus(World world) {
        super(world);
    }

    double wrapX(double x2) {
        return Torus.wrap(x2, (double)this.world.minPxcor() - 0.5, (double)this.world.maxPxcor() + 0.5);
    }

    double wrapY(double y) {
        return Torus.wrap(y, (double)this.world.minPycor() - 0.5, (double)this.world.maxPycor() + 0.5);
    }

    double distanceWrap(double dx, double dy, double x1, double y1, double x2, double y2) {
        double dx2 = x1 > x2 ? x2 + (double)this.world.worldWidth() - x1 : x2 - (double)this.world.worldWidth() - x1;
        dx = StrictMath.abs(dx2) < StrictMath.abs(dx) ? dx2 : dx;
        double dy2 = y1 > y2 ? y2 + (double)this.world.worldHeight() - y1 : y2 - (double)this.world.worldHeight() - y1;
        dy = StrictMath.abs(dy2) < StrictMath.abs(dy) ? dy2 : dy;
        return this.world.rootsTable.gridRoot(dx * dx + dy * dy);
    }

    double towardsWrap(double headingX, double headingY) {
        headingX = Torus.wrap(headingX, -((double)this.world.worldWidth()) / 2.0, (double)this.world.worldWidth() / 2.0);
        if ((headingY = Torus.wrap(headingY, -((double)this.world.worldHeight()) / 2.0, (double)this.world.worldHeight() / 2.0)) == 0.0) {
            return headingX > 0.0 ? 90.0 : 270.0;
        }
        if (headingX == 0.0) {
            return headingY > 0.0 ? 0.0 : 180.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-headingY, headingX))) % 360.0;
    }

    Patch getPatchAt(double xc, double yc) throws AgentException {
        return this.world.getPatchAt(xc, yc);
    }

    AgentSet getNeighbors(Patch source2) {
        if (source2.pxcor == this.world.maxPxcor() && source2.pxcor == this.world.minPxcor()) {
            if (source2.pycor == this.world.maxPycor() && source2.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[0], this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchSouth(source2)}, this.world);
        }
        if (source2.pycor == this.world.maxPycor() && source2.pycor == this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2), this.getPatchWest(source2)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchWest(source2), this.getPatchNorthEast(source2), this.getPatchSouthEast(source2), this.getPatchSouthWest(source2), this.getPatchNorthWest(source2)}, this.world);
    }

    AgentSet getNeighbors4(Patch source2) {
        if (source2.pxcor == this.world.maxPxcor() && source2.pxcor == this.world.minPxcor()) {
            if (source2.pycor == this.world.maxPycor() && source2.pycor == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[0], this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchSouth(source2)}, this.world);
        }
        if (source2.pycor == this.world.maxPycor() && source2.pycor == this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(source2), this.getPatchWest(source2)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(source2), this.getPatchEast(source2), this.getPatchSouth(source2), this.getPatchWest(source2)}, this.world);
    }

    double shortestPathX(double x1, double x2) {
        double xprime = x1 > x2 ? x2 + (double)this.world.worldWidth() : x2 - (double)this.world.worldWidth();
        if (StrictMath.abs(x2 - x1) > StrictMath.abs(xprime - x1)) {
            x2 = xprime;
        }
        return x2;
    }

    double shortestPathY(double y1, double y2) {
        double yprime = y1 > y2 ? y2 + (double)this.world.worldHeight() : y2 - (double)this.world.worldHeight();
        if (StrictMath.abs(y2 - y1) > StrictMath.abs(yprime - y1)) {
            y2 = yprime;
        }
        return y2;
    }

    void diffuse(double diffuseparam, int vn) throws AgentException, PatchException {
        int xx = this.world.worldWidth();
        int xx2 = xx * 2;
        int yy = this.world.worldHeight();
        int yy2 = yy * 2;
        double[][] scratch = this.world.getPatchScratch();
        int x2 = 0;
        int y = 0;
        try {
            for (y = 0; y < yy; ++y) {
                for (x2 = 0; x2 < xx; ++x2) {
                    scratch[x2][y] = (Double)this.world.fastGetPatchAt((int)this.wrapX(x2), (int)this.wrapY(y)).getPatchVariable(vn);
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(x2), (int)this.wrapY(y)));
        }
        for (y = yy; y < yy2; ++y) {
            for (x2 = xx; x2 < xx2; ++x2) {
                double sum2 = scratch[(x2 - 1) % xx][(y - 1) % yy];
                sum2 += scratch[(x2 - 1) % xx][y % yy];
                sum2 += scratch[(x2 - 1) % xx][(y + 1) % yy];
                sum2 += scratch[x2 % xx][(y - 1) % yy];
                sum2 += scratch[x2 % xx][(y + 1) % yy];
                sum2 += scratch[(x2 + 1) % xx][(y - 1) % yy];
                sum2 += scratch[(x2 + 1) % xx][y % yy];
                double oldval = scratch[x2 - xx][y - yy];
                double newval = oldval * (1.0 - diffuseparam) + (sum2 += scratch[(x2 + 1) % xx][(y + 1) % yy]) / 8.0 * diffuseparam;
                if (newval == oldval) continue;
                this.world.getPatchAt(x2 - xx, y - yy).setPatchVariable(vn, (Object)newval);
            }
        }
    }

    void diffuse4(double diffuseparam, int vn) throws AgentException, PatchException {
        int xx = this.world.worldWidth();
        int yy = this.world.worldHeight();
        double[][] scratch = this.world.getPatchScratch();
        int x2 = 0;
        int y = 0;
        try {
            for (y = 0; y < yy; ++y) {
                for (x2 = 0; x2 < xx; ++x2) {
                    scratch[x2][y] = (Double)this.world.fastGetPatchAt((int)this.wrapX(x2), (int)this.wrapY(y)).getPatchVariable(vn);
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(x2), (int)this.wrapY(y)));
        }
        for (y = 0; y < yy; ++y) {
            for (x2 = 0; x2 < xx; ++x2) {
                double sum2 = 0.0;
                sum2 += scratch[(x2 + xx - 1) % xx][(y + yy) % yy];
                sum2 += scratch[(x2 + xx) % xx][(y + yy + 1) % yy];
                sum2 += scratch[(x2 + xx + 1) % xx][(y + yy) % yy];
                double newval = scratch[x2][y] * (1.0 - diffuseparam) + (sum2 += scratch[(x2 + xx) % xx][(y + yy - 1) % yy]) * diffuseparam / 4.0;
                if (newval == scratch[x2][y]) continue;
                this.world.getPatchAt(x2, y).setPatchVariable(vn, (Object)newval);
            }
        }
    }

    Patch getPN(Patch source2) {
        return this.getPatchNorth(source2);
    }

    Patch getPE(Patch source2) {
        return this.getPatchEast(source2);
    }

    Patch getPS(Patch source2) {
        return this.getPatchSouth(source2);
    }

    Patch getPW(Patch source2) {
        return this.getPatchWest(source2);
    }

    Patch getPNE(Patch source2) {
        return this.getPatchNorthEast(source2);
    }

    Patch getPSE(Patch source2) {
        return this.getPatchSouthEast(source2);
    }

    Patch getPSW(Patch source2) {
        return this.getPatchSouthWest(source2);
    }

    Patch getPNW(Patch source2) {
        return this.getPatchNorthWest(source2);
    }
}

