/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.AllStoredValues;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.BreedShapes;
import org.nlogo.agent.DummyLink;
import org.nlogo.agent.Exporter;
import org.nlogo.agent.HorizCylinder;
import org.nlogo.agent.Importer;
import org.nlogo.agent.InRadiusOrCone;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Protractor;
import org.nlogo.agent.RootsTable;
import org.nlogo.agent.TickCounter;
import org.nlogo.agent.TieManager;
import org.nlogo.agent.Timer;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Torus;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.VertCylinder;
import org.nlogo.api.AgentException;
import org.nlogo.api.Color;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.LogoException;
import org.nlogo.api.Nobody$;
import org.nlogo.api.Program;
import org.nlogo.api.RandomSeedGenerator$;
import org.nlogo.api.Shape;
import org.nlogo.api.ShapeList;
import org.nlogo.api.TrailDrawerInterface;
import org.nlogo.api.ValueConstraint;
import org.nlogo.api.WorldDimensionException;
import org.nlogo.api.WorldDimensions;
import org.nlogo.util.Exceptions;
import org.nlogo.util.MersenneTwisterFast;
import scala.collection.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class World
implements org.nlogo.api.World {
    public static final Double ZERO = 0.0;
    public static final Double ONE = 1.0;
    public final TickCounter tickCounter = new TickCounter();
    public final Timer timer = new Timer();
    private final ShapeList _turtleShapeList;
    private final ShapeList _linkShapeList;
    private double patchSize = 12.0;
    TrailDrawerInterface trailDrawer;
    private final Map<Agent, Double> lineThicknesses = new HashMap<Agent, Double>();
    Topology topology;
    RootsTable rootsTable;
    protected Protractor _protractor;
    public LinkManager linkManager;
    public TieManager tieManager;
    public InRadiusOrCone inRadiusOrCone;
    public volatile boolean comeUpForAir = false;
    private final AgentSet _noTurtles = new ArrayAgentSet(Turtle.class, 0, false, this);
    private final AgentSet _noPatches = new ArrayAgentSet(Patch.class, 0, false, this);
    private final AgentSet _noLinks = new ArrayAgentSet(Link.class, 0, false, this);
    public final MersenneTwisterFast mainRNG = new MersenneTwisterFast();
    public final MersenneTwisterFast auxRNG = new MersenneTwisterFast();
    Double _worldWidthBoxed;
    Double _worldHeightBoxed;
    Double _minPxcorBoxed;
    Double _minPycorBoxed;
    Double _maxPxcorBoxed;
    Double _maxPycorBoxed;
    int _worldWidth;
    int _worldHeight;
    int _minPxcor;
    int _minPycor;
    int _maxPxcor;
    int _maxPycor;
    final AgentSet _observers;
    final Observer _observer;
    AgentSet _patches = null;
    AgentSet _turtles = null;
    AgentSet _links = null;
    private long nextTurtleIndex = 0L;
    private long nextLinkIndex = 0L;
    int[] patchColors;
    boolean patchColorsDirty = true;
    boolean patchesAllBlack = true;
    boolean mayHavePartiallyTransparentObjects = false;
    int patchesWithLabels = 0;
    double[][] patchScratch;
    public final BreedShapes linkBreedShapes = new BreedShapes("LINKS");
    public final BreedShapes turtleBreedShapes = new BreedShapes("TURTLES");
    private Program _program = this.newProgram();
    List<String> oldTurtlesOwn = new ArrayList<String>();
    List<String> oldPatchesOwn = new ArrayList<String>();
    List<String> oldLinksOwn = new ArrayList<String>();
    List<String> oldGlobals = new ArrayList<String>();
    Map<String, Object> oldBreeds = new LinkedHashMap<String, Object>();
    Map<String, Object> oldLinkBreeds = new LinkedHashMap<String, Object>();
    Map<String, List<String>> oldBreedsOwn = new HashMap<String, List<String>>();
    Map<String, List<String>> oldLinkBreedsOwn = new HashMap<String, List<String>>();
    private boolean displayOn = true;
    private CompilerServices _compiler;
    private Map<String, List<VariableWatcher>> variableWatchers = null;

    @Override
    public double ticks() {
        return this.tickCounter.ticks();
    }

    @Override
    public ShapeList turtleShapeList() {
        return this._turtleShapeList;
    }

    @Override
    public ShapeList linkShapeList() {
        return this._linkShapeList;
    }

    @Override
    public Protractor protractor() {
        return this._protractor;
    }

    public World() {
        this._turtleShapeList = new ShapeList();
        this._linkShapeList = new ShapeList();
        this._observer = this.createObserver();
        this._observers = new ArrayAgentSet(Observer.class, 1, "observers", false, this);
        this.linkManager = new LinkManager(this);
        this.tieManager = new TieManager(this, this.linkManager);
        this.inRadiusOrCone = new InRadiusOrCone(this);
        this._protractor = new Protractor(this);
        this._observers.add(this._observer);
        this.changeTopology(true, true);
        this.createPatches(this._minPxcor, this._maxPxcor, this._minPycor, this._maxPycor);
    }

    Observer createObserver() {
        return new Observer(this);
    }

    public AgentSet noTurtles() {
        return this._noTurtles;
    }

    public AgentSet noPatches() {
        return this._noPatches;
    }

    public AgentSet noLinks() {
        return this._noLinks;
    }

    public void trailDrawer(TrailDrawerInterface trailDrawer) {
        this.trailDrawer = trailDrawer;
    }

    Topology getTopology() {
        return this.topology;
    }

    public void changeTopology(boolean xWrapping, boolean yWrapping) {
        this.topology = Topology.getTopology(this, xWrapping, yWrapping);
        if (this._patches != null) {
            AgentSet.Iterator it = this._patches.iterator();
            while (it.hasNext()) {
                ((Patch)it.next()).topologyChanged();
            }
        }
    }

    @Override
    public double wrappedObserverX(double x2) {
        try {
            x2 = this.topology.wrapX(x2 - this.topology.followOffsetX());
        }
        catch (AgentException e) {
            Exceptions.ignore(e);
        }
        return x2;
    }

    @Override
    public double wrappedObserverY(double y) {
        try {
            y = this.topology.wrapY(y - this.topology.followOffsetY());
        }
        catch (AgentException e) {
            Exceptions.ignore(e);
        }
        return y;
    }

    @Override
    public double followOffsetX() {
        return this._observer.followOffsetX();
    }

    @Override
    public double followOffsetY() {
        return this._observer.followOffsetY();
    }

    @Override
    public boolean wrappingAllowedInX() {
        return this.topology instanceof Torus || this.topology instanceof VertCylinder;
    }

    @Override
    public boolean wrappingAllowedInY() {
        return this.topology instanceof Torus || this.topology instanceof HorizCylinder;
    }

    public void exportWorld(PrintWriter writer, boolean full) {
        new Exporter(this, writer).exportWorld(full);
    }

    public void importWorld(Importer.ErrorHandler errorHandler, ImporterUser importerUser, Importer.StringReader stringReader, BufferedReader reader) throws IOException {
        new Importer(errorHandler, this, importerUser, stringReader).importWorld(reader);
    }

    public double generateSeed() {
        return RandomSeedGenerator$.MODULE$.generateSeed();
    }

    public void setLineThickness(Agent agent, double size2) {
        this.lineThicknesses.put(agent, size2);
    }

    public double lineThickness(Agent agent) {
        Double size2 = this.lineThicknesses.get(agent);
        if (size2 != null) {
            return size2;
        }
        return 0.0;
    }

    public void removeLineThickness(Agent agent) {
        this.lineThicknesses.remove(agent);
    }

    void drawLine(double x0, double y0, double x1, double y1, Object color, double size2, String mode) {
        this.trailDrawer.drawLine(x0, y0, x1, y1, color, size2, mode);
    }

    public Double worldWidthBoxed() {
        return this._worldWidthBoxed;
    }

    public Double worldHeightBoxed() {
        return this._worldHeightBoxed;
    }

    public Double minPxcorBoxed() {
        return this._minPxcorBoxed;
    }

    public Double minPycorBoxed() {
        return this._minPycorBoxed;
    }

    public Double maxPxcorBoxed() {
        return this._maxPxcorBoxed;
    }

    public Double maxPycorBoxed() {
        return this._maxPycorBoxed;
    }

    @Override
    public int worldWidth() {
        return this._worldWidth;
    }

    @Override
    public int worldHeight() {
        return this._worldHeight;
    }

    @Override
    public int minPxcor() {
        return this._minPxcor;
    }

    @Override
    public int minPycor() {
        return this._minPycor;
    }

    @Override
    public int maxPxcor() {
        return this._maxPxcor;
    }

    @Override
    public int maxPycor() {
        return this._maxPycor;
    }

    @Override
    public double wrapX(double x2) throws AgentException {
        return this.topology.wrapX(x2);
    }

    @Override
    public double wrapY(double y) throws AgentException {
        return this.topology.wrapY(y);
    }

    @Override
    public double wrap(double pos, double min2, double max2) {
        return Topology.wrap(pos, min2, max2);
    }

    public void diffuse(double param2, int vn) throws AgentException, PatchException {
        this.topology.diffuse(param2, vn);
    }

    public void diffuse4(double param2, int vn) throws AgentException, PatchException {
        this.topology.diffuse4(param2, vn);
    }

    public int roundX(double x2) throws AgentException {
        try {
            x2 = this.topology.wrapX(x2);
        }
        catch (AgentException ex) {
            throw new AgentException("Cannot access patches beyond the limits of current world.");
        }
        if (x2 > 0.0) {
            return (int)(x2 + 0.5);
        }
        int intPart2 = (int)x2;
        double fractPart = (double)intPart2 - x2;
        return fractPart > 0.5 ? intPart2 - 1 : intPart2;
    }

    public int roundY(double y) throws AgentException {
        try {
            y = this.topology.wrapY(y);
        }
        catch (AgentException ex) {
            throw new AgentException("Cannot access patches beyond the limits of current world.");
        }
        if (y > 0.0) {
            return (int)(y + 0.5);
        }
        int intPart2 = (int)y;
        double fractPart = (double)intPart2 - y;
        return fractPart > 0.5 ? intPart2 - 1 : intPart2;
    }

    public Turtle createTurtle(AgentSet breed) {
        return new Turtle(this, breed, ZERO, ZERO);
    }

    public Turtle createTurtle(AgentSet breed, int c, int h) {
        Turtle baby = new Turtle(this, breed, ZERO, ZERO);
        baby.colorDoubleUnchecked(Double.valueOf(5 + 10 * c));
        baby.heading(h);
        return baby;
    }

    public AgentSet observers() {
        return this._observers;
    }

    @Override
    public Observer observer() {
        return this._observer;
    }

    @Override
    public AgentSet patches() {
        return this._patches;
    }

    @Override
    public AgentSet turtles() {
        return this._turtles;
    }

    @Override
    public AgentSet links() {
        return this._links;
    }

    public AgentSet agentClassToAgentSet(Class<? extends Agent> agentClass) {
        if (agentClass == Turtle.class) {
            return this._turtles;
        }
        if (agentClass == Patch.class) {
            return this._patches;
        }
        if (agentClass == Observer.class) {
            return this._observers;
        }
        if (agentClass == Link.class) {
            return this._links;
        }
        throw new IllegalArgumentException("agentClass = " + agentClass);
    }

    public WorldDimensions getDimensions() {
        return new WorldDimensions(this._minPxcor, this._maxPxcor, this._minPycor, this._maxPycor);
    }

    public boolean isDimensionVariable(String variableName) {
        return variableName.equalsIgnoreCase("MIN-PXCOR") || variableName.equalsIgnoreCase("MAX-PXCOR") || variableName.equalsIgnoreCase("MIN-PYCOR") || variableName.equalsIgnoreCase("MAX-PYCOR") || variableName.equalsIgnoreCase("WORLD-WIDTH") || variableName.equalsIgnoreCase("WORLD-HEIGHT");
    }

    public WorldDimensions setDimensionVariable(String variableName, int value2, WorldDimensions d) throws WorldDimensionException {
        if (variableName.equalsIgnoreCase("MIN-PXCOR")) {
            d.minPxcor_$eq(value2);
        } else if (variableName.equalsIgnoreCase("MAX-PXCOR")) {
            d.maxPxcor_$eq(value2);
        } else if (variableName.equalsIgnoreCase("MIN-PYCOR")) {
            d.minPycor_$eq(value2);
        } else if (variableName.equalsIgnoreCase("MAX-PYCOR")) {
            d.maxPycor_$eq(value2);
        } else if (variableName.equalsIgnoreCase("WORLD-WIDTH")) {
            d.minPxcor_$eq(this.growMin(this._minPxcor, this._maxPxcor, value2, d.minPxcor()));
            d.maxPxcor_$eq(this.growMax(this._minPxcor, this._maxPxcor, value2, d.maxPxcor()));
        } else if (variableName.equalsIgnoreCase("WORLD-HEIGHT")) {
            d.minPycor_$eq(this.growMin(this._minPycor, this._maxPycor, value2, d.minPycor()));
            d.maxPycor_$eq(this.growMax(this._minPycor, this._maxPycor, value2, d.maxPycor()));
        }
        return d;
    }

    public int growMin(int min2, int max2, int value2, int d) throws WorldDimensionException {
        if (value2 < 1) {
            throw new WorldDimensionException();
        }
        if (max2 == -min2) {
            if (value2 % 2 != 1) {
                throw new WorldDimensionException();
            }
            return -(value2 - 1) / 2;
        }
        if (max2 == 0) {
            return -(value2 - 1);
        }
        return d;
    }

    public int growMax(int min2, int max2, int value2, int d) throws WorldDimensionException {
        if (value2 < 1) {
            throw new WorldDimensionException();
        }
        if (max2 == -min2) {
            if (value2 % 2 != 1) {
                throw new WorldDimensionException();
            }
            return (value2 - 1) / 2;
        }
        if (min2 == 0) {
            return value2 - 1;
        }
        return d;
    }

    public boolean equalDimensions(WorldDimensions d) {
        return d.minPxcor() == this._minPxcor && d.maxPxcor() == this._maxPxcor && d.minPycor() == this._minPycor && d.maxPycor() == this._maxPycor;
    }

    @Override
    public Patch getPatch(int id) {
        return (Patch)this._patches.toArray()[id];
    }

    @Override
    public Patch getPatchAt(double x2, double y) throws AgentException {
        int xc = this.roundX(x2);
        int yc = this.roundY(y);
        int id = this._worldWidth * (this._maxPycor - yc) + xc - this._minPxcor;
        return (Patch)this._patches.toArray()[id];
    }

    public Patch getPatchAtWrap(double x2, double y) {
        double fractPart;
        int intPart2;
        int xc;
        x2 = Topology.wrap(x2, (double)this._minPxcor - 0.5, (double)this._maxPxcor + 0.5);
        y = Topology.wrap(y, (double)this._minPycor - 0.5, (double)this._maxPycor + 0.5);
        if (x2 > 0.0) {
            xc = (int)(x2 + 0.5);
        } else {
            intPart2 = (int)x2;
            fractPart = (double)intPart2 - x2;
            int n = xc = fractPart > 0.5 ? intPart2 - 1 : intPart2;
        }
        int yc = y > 0.0 ? (int)(y + 0.5) : ((fractPart = (double)(intPart2 = (int)y) - y) > 0.5 ? intPart2 - 1 : intPart2);
        int patchid = this._worldWidth * (this._maxPycor - yc) + xc - this._minPxcor;
        return (Patch)this._patches.toArray()[patchid];
    }

    public boolean validPatchCoordinates(int xc, int yc) {
        return xc >= this._minPxcor && xc <= this._maxPxcor && yc >= this._minPycor && yc <= this._maxPycor;
    }

    @Override
    public Patch fastGetPatchAt(int xc, int yc) {
        return (Patch)this._patches.toArray()[this._worldWidth * (this._maxPycor - yc) + xc - this._minPxcor];
    }

    public Turtle getTurtle(long id) {
        return (Turtle)this._turtles.getAgent(id);
    }

    public Link getLink(Object end1, Object end2, AgentSet breed) {
        return this.linkManager.findLink((Turtle)this._turtles.getAgent(end1), (Turtle)this._turtles.getAgent(end2), breed, false);
    }

    void nextTurtleIndex(long nextTurtleIndex) {
        this.nextTurtleIndex = nextTurtleIndex;
    }

    long nextTurtleIndex() {
        return this.nextTurtleIndex;
    }

    long newTurtleId() {
        return this.nextTurtleIndex++;
    }

    long newLinkId() {
        return this.nextLinkIndex++;
    }

    public Turtle getOrCreateTurtle(long id) {
        Turtle turtle2 = this.getTurtle(id);
        if (turtle2 == null) {
            turtle2 = new Turtle(this, id);
            this.nextTurtleIndex = StrictMath.max(this.nextTurtleIndex, id + 1L);
        }
        return turtle2;
    }

    public Link getOrCreateLink(Double end1, Double end2, AgentSet breed) {
        return this.getOrCreateLink(this.getOrCreateTurtle(end1.longValue()), this.getOrCreateTurtle(end2.longValue()), breed);
    }

    public Link getOrCreateLink(Turtle end1, Turtle end2, AgentSet breed) {
        Link link = this.getLink(end1.agentKey(), end2.agentKey(), breed);
        if (link == null) {
            link = this.linkManager.createLink(end1, end2, breed);
        }
        return link;
    }

    public Link getOrCreateDummyLink(Object end1, Object end2, AgentSet breed) {
        Link link;
        Link link2 = link = end1 == Nobody$.MODULE$ || end2 == Nobody$.MODULE$ ? null : this.getLink(((Turtle)end1).agentKey(), ((Turtle)end2).agentKey(), breed);
        if (link == null) {
            link = new DummyLink(this, end1, end2, breed);
        }
        return link;
    }

    @Override
    public boolean patchColorsDirty() {
        return this.patchColorsDirty;
    }

    @Override
    public void markPatchColorsDirty() {
        this.patchColorsDirty = true;
    }

    @Override
    public void markPatchColorsClean() {
        this.patchColorsDirty = false;
    }

    @Override
    public boolean patchesAllBlack() {
        return this.patchesAllBlack;
    }

    @Override
    public boolean mayHavePartiallyTransparentObjects() {
        return this.mayHavePartiallyTransparentObjects;
    }

    @Override
    public int[] patchColors() {
        return this.patchColors;
    }

    @Override
    public int patchesWithLabels() {
        return this.patchesWithLabels;
    }

    public void createPatches(WorldDimensions dim) {
        this.createPatches(dim.minPxcor(), dim.maxPxcor(), dim.minPycor(), dim.maxPycor());
    }

    public void createPatches(int minPxcor, int maxPxcor, int minPycor, int maxPycor) {
        java.util.Iterator<Object> iter2;
        this.patchScratch = null;
        this._minPxcor = minPxcor;
        this._maxPxcor = maxPxcor;
        this._minPycor = minPycor;
        this._maxPycor = maxPycor;
        this._worldWidth = maxPxcor - minPxcor + 1;
        this._worldHeight = maxPycor - minPycor + 1;
        this.rootsTable = new RootsTable(this._worldWidth, this._worldHeight);
        this._worldWidthBoxed = this._worldWidth;
        this._worldHeightBoxed = this._worldHeight;
        this._minPxcorBoxed = this._minPxcor;
        this._minPycorBoxed = this._minPycor;
        this._maxPxcorBoxed = this._maxPxcor;
        this._maxPycorBoxed = this._maxPycor;
        if (this._program.breeds() != null) {
            iter2 = this._program.breeds().values().iterator();
            while (iter2.hasNext()) {
                ((AgentSet)iter2.next()).clear();
            }
        }
        if (this._program.linkBreeds() != null) {
            iter2 = this._program.linkBreeds().values().iterator();
            while (iter2.hasNext()) {
                ((AgentSet)iter2.next()).clear();
            }
        }
        if (this._turtles != null) {
            this._turtles.clear();
        }
        this._turtles = new TreeAgentSet(Turtle.class, "TURTLES", this);
        if (this._links != null) {
            this._links.clear();
        }
        this._links = new TreeAgentSet(Link.class, "LINKS", this);
        int x2 = minPxcor;
        int y = maxPycor;
        Agent[] patchArray = new Agent[this._worldWidth * this._worldHeight];
        this.patchColors = new int[this._worldWidth * this._worldHeight];
        Arrays.fill(this.patchColors, Color.getARGBbyPremodulatedColorNumber(0.0));
        this.patchColorsDirty = true;
        int numVariables = this._program.patchesOwn().size();
        this._observer.resetPerspective();
        for (int i = 0; this._worldWidth * this._worldHeight != i; ++i) {
            Patch patch2 = new Patch(this, i, x2, y, numVariables);
            if (++x2 == maxPxcor + 1) {
                x2 = minPxcor;
                --y;
            }
            patchArray[i] = patch2;
        }
        this._patches = new ArrayAgentSet(Patch.class, patchArray, "patches", this);
        this.patchesWithLabels = 0;
        this.patchesAllBlack = true;
        this.mayHavePartiallyTransparentObjects = false;
    }

    public void clearAll() {
        this.tickCounter.clear();
        this.clearTurtles();
        this.clearPatches();
        this.clearGlobals();
        this.clearLinks();
        this._observer.resetPerspective();
        this.mayHavePartiallyTransparentObjects = false;
    }

    public void clearDrawing() {
    }

    public void stamp(Agent agent, boolean erase) {
        this.trailDrawer.stamp(agent, erase);
    }

    @Override
    public double patchSize() {
        return this.patchSize;
    }

    public boolean patchSize(double patchSize) {
        if (this.patchSize != patchSize) {
            this.patchSize = patchSize;
            return true;
        }
        return false;
    }

    @Override
    public Object getDrawing() {
        return this.trailDrawer.getDrawing();
    }

    @Override
    public boolean sendPixels() {
        return this.trailDrawer.sendPixels();
    }

    @Override
    public void markDrawingClean() {
        this.trailDrawer.sendPixels(false);
    }

    public void clearPatches() {
        AgentSet.Iterator iter2 = this._patches.iterator();
        while (iter2.hasNext()) {
            Patch patch2 = (Patch)iter2.next();
            patch2.pcolorDoubleUnchecked(Color.BoxedBlack());
            patch2.label("");
            patch2.labelColor(Color.BoxedWhite());
            try {
                for (int j = patch2.NUMBER_PREDEFINED_VARS; j < patch2.variables.length; ++j) {
                    patch2.setPatchVariable(j, ZERO);
                }
            }
            catch (AgentException ex) {
                throw new IllegalStateException(ex);
            }
        }
        this.patchesAllBlack = true;
    }

    public void clearTurtles() {
        Object iter2;
        if (this._program.breeds() != null) {
            iter2 = this._program.breeds().values().iterator();
            while (iter2.hasNext()) {
                ((AgentSet)iter2.next()).clear();
            }
        }
        iter2 = this._turtles.iterator();
        while (iter2.hasNext()) {
            Turtle turtle2 = (Turtle)iter2.next();
            this.lineThicknesses.remove(turtle2);
            this.linkManager.cleanup(turtle2);
            turtle2.id(-1L);
        }
        this._turtles.clear();
        iter2 = this._patches.iterator();
        while (iter2.hasNext()) {
            ((Patch)iter2.next()).clearTurtles();
        }
        this.nextTurtleIndex = 0L;
        this._observer.updatePosition();
    }

    public void clearLinks() {
        if (this._program.linkBreeds() != null) {
            for (AgentSet agentSet : this._program.linkBreeds().values()) {
                agentSet.clear();
            }
        }
        AgentSet.Iterator iter2 = this._links.iterator();
        while (iter2.hasNext()) {
            Link link = (Link)iter2.next();
            link.id = -1L;
        }
        this._links.clear();
        this.nextLinkIndex = 0L;
        this.linkManager.reset();
    }

    @Override
    public void clearGlobals() {
        for (int j = this._program.interfaceGlobals().size(); j < this._observer.variables.length; ++j) {
            try {
                ValueConstraint con = this._observer.variableConstraint(j);
                if (con != null) {
                    this._observer.setObserverVariable(j, con.defaultValue());
                    continue;
                }
                this._observer.setObserverVariable(j, ZERO);
                continue;
            }
            catch (AgentException ex) {
                throw new IllegalStateException(ex);
            }
            catch (LogoException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public void realloc() {
        java.util.Iterator i;
        AgentSet.Iterator iter2;
        for (String breedName : this._program.breeds().keySet()) {
            AgentSet breed = (AgentSet)this.oldBreeds.get(breedName);
            if (breed == null) {
                this._program.breeds().put(breedName, new TreeAgentSet(Turtle.class, breedName.toUpperCase(), this));
                continue;
            }
            this._program.breeds().put(breedName, breed);
        }
        for (String breedName : this._program.linkBreeds().keySet()) {
            boolean directed = this._program.linkBreeds().get(breedName).equals("DIRECTED-LINK-BREED");
            AgentSet breed = (AgentSet)this.oldLinkBreeds.get(breedName);
            if (breed == null) {
                breed = new TreeAgentSet(Link.class, breedName.toUpperCase(), this);
            } else {
                breed.clearDirected();
            }
            this._program.linkBreeds().put(breedName, breed);
            breed.setDirected(directed);
        }
        ArrayList<Agent> doomedAgents = new ArrayList<Agent>();
        try {
            if (this._turtles != null) {
                iter2 = this._turtles.iterator();
                while (iter2.hasNext()) {
                    Agent agt = iter2.next().realloc(true);
                    if (agt == null) continue;
                    doomedAgents.add(agt);
                }
                i = doomedAgents.iterator();
                while (i.hasNext()) {
                    ((Turtle)i.next()).die();
                }
                doomedAgents.clear();
            }
        }
        catch (AgentException ex) {
            throw new IllegalStateException(ex);
        }
        try {
            if (this._links != null) {
                iter2 = this._links.iterator();
                while (iter2.hasNext()) {
                    Agent agt = iter2.next().realloc(true);
                    if (agt == null) continue;
                    doomedAgents.add(agt);
                }
                i = doomedAgents.iterator();
                while (i.hasNext()) {
                    ((Link)i.next()).die();
                }
                doomedAgents.clear();
            }
        }
        catch (AgentException ex) {
            throw new IllegalStateException(ex);
        }
        try {
            if (this._patches != null && !((Object)this._program.patchesOwn()).equals(this.oldPatchesOwn)) {
                iter2 = this._patches.iterator();
                while (iter2.hasNext()) {
                    iter2.next().realloc(true);
                }
            }
        }
        catch (AgentException ex) {
            throw new IllegalStateException(ex);
        }
        this._observer.realloc(true);
        this.turtleBreedShapes.setUpBreedShapes(false, this._program.breeds());
        this.linkBreedShapes.setUpBreedShapes(false, this._program.linkBreeds());
    }

    public double[][] getPatchScratch() {
        if (this.patchScratch == null) {
            this.patchScratch = new double[this._worldWidth][this._worldHeight];
        }
        return this.patchScratch;
    }

    public int indexOfVariable(Class<? extends Agent> agentClass, String name) {
        if (agentClass == Observer.class) {
            return this.observerOwnsIndexOf(name);
        }
        if (agentClass == Turtle.class) {
            return this.turtlesOwnIndexOf(name);
        }
        if (agentClass == Link.class) {
            return this.linksOwnIndexOf(name);
        }
        return this.patchesOwnIndexOf(name);
    }

    public int indexOfVariable(Agent agent, String name) {
        if (agent instanceof Observer) {
            return this.observerOwnsIndexOf(name);
        }
        if (agent instanceof Turtle) {
            int result2;
            AgentSet breed = ((Turtle)agent).getBreed();
            if (breed != this._turtles && (result2 = this.breedsOwnIndexOf(breed, name)) != -1) {
                return result2;
            }
            return this.turtlesOwnIndexOf(name);
        }
        if (agent instanceof Link) {
            int result3;
            AgentSet breed = ((Link)agent).getBreed();
            if (breed != this._links && (result3 = this.linkBreedsOwnIndexOf(breed, name)) != -1) {
                return result3;
            }
            return this.linksOwnIndexOf(name);
        }
        return this.patchesOwnIndexOf(name);
    }

    @Override
    public String turtlesOwnNameAt(int index) {
        return this._program.turtlesOwn().get(index);
    }

    public int turtlesOwnIndexOf(String name) {
        return this._program.turtlesOwn().indexOf(name);
    }

    public int linksOwnIndexOf(String name) {
        return this._program.linksOwn().indexOf(name);
    }

    @Override
    public String linksOwnNameAt(int index) {
        return this._program.linksOwn().get(index);
    }

    int oldTurtlesOwnIndexOf(String name) {
        return this.oldTurtlesOwn.indexOf(name);
    }

    int oldLinksOwnIndexOf(String name) {
        return this.oldLinksOwn.indexOf(name);
    }

    @Override
    public String breedsOwnNameAt(org.nlogo.api.AgentSet breed, int index) {
        List<String> breedOwns = this._program.breedsOwn().get(breed.printName());
        return breedOwns.get(index - this._program.turtlesOwn().size());
    }

    public int breedsOwnIndexOf(AgentSet breed, String name) {
        List<String> breedOwns = this._program.breedsOwn().get(breed.printName());
        if (breedOwns == null) {
            return -1;
        }
        int result2 = breedOwns.indexOf(name);
        if (result2 == -1) {
            return -1;
        }
        return breed.type() == Turtle.class ? this._program.turtlesOwn().size() + result2 : this._program.linksOwn().size() + result2;
    }

    public String linkBreedsOwnNameAt(AgentSet breed, int index) {
        List<String> breedOwns = this._program.linkBreedsOwn().get(breed.printName());
        return breedOwns.get(index - this._program.linksOwn().size());
    }

    public int linkBreedsOwnIndexOf(AgentSet breed, String name) {
        List<String> breedOwns = this._program.linkBreedsOwn().get(breed.printName());
        if (breedOwns == null) {
            return -1;
        }
        int result2 = breedOwns.indexOf(name);
        if (result2 == -1) {
            return -1;
        }
        return this._program.linksOwn().size() + result2;
    }

    int oldBreedsOwnIndexOf(AgentSet breed, String name) {
        List<String> breedOwns = this.oldBreedsOwn.get(breed.printName());
        if (breedOwns == null) {
            return -1;
        }
        int result2 = breedOwns.indexOf(name);
        if (result2 == -1) {
            return -1;
        }
        return this.oldTurtlesOwn.size() + result2;
    }

    int oldLinkBreedsOwnIndexOf(AgentSet breed, String name) {
        List<String> breedOwns = this.oldLinkBreedsOwn.get(breed.printName());
        if (breedOwns == null) {
            return -1;
        }
        int result2 = breedOwns.indexOf(name);
        if (result2 == -1) {
            return -1;
        }
        return this.oldLinksOwn.size() + result2;
    }

    public String patchesOwnNameAt(int index) {
        return this._program.patchesOwn().get(index);
    }

    public int patchesOwnIndexOf(String name) {
        return this._program.patchesOwn().indexOf(name);
    }

    public String observerOwnsNameAt(int index) {
        return this._program.globals().get(index);
    }

    public int observerOwnsIndexOf(String name) {
        return this._program.globals().indexOf(name);
    }

    public boolean isBreed(AgentSet breed) {
        return this._program.breeds().containsValue(breed);
    }

    public boolean isLinkBreed(AgentSet breed) {
        return this._program.linkBreeds().containsValue(breed);
    }

    public AgentSet getBreed(String breedName) {
        return (AgentSet)this._program.breeds().get(breedName);
    }

    public AgentSet getLinkBreed(String breedName) {
        return (AgentSet)this._program.linkBreeds().get(breedName);
    }

    public String getBreedSingular(AgentSet breed) {
        if (breed == this._turtles) {
            return "TURTLE";
        }
        String breedName = breed.printName();
        for (Map.Entry<String, String> entry : this._program.breedsSingular().entrySet()) {
            if (!entry.getValue().equals(breedName)) continue;
            return entry.getKey();
        }
        return "TURTLE";
    }

    public String getLinkBreedSingular(AgentSet breed) {
        if (breed == this._links) {
            return "LINK";
        }
        String breedName = breed.printName();
        for (Map.Entry<String, String> entry : this._program.linkBreedsSingular().entrySet()) {
            if (!entry.getValue().equals(breedName)) continue;
            return entry.getKey();
        }
        return "LINK";
    }

    public int compareLinkBreeds(AgentSet breed1, AgentSet breed2) {
        for (AgentSet agentSet : this._program.linkBreeds().values()) {
            if (agentSet == breed1) {
                return -1;
            }
            if (agentSet != breed2) continue;
            return 1;
        }
        throw new IllegalStateException("neither of the breeds exist, that's bad");
    }

    public int getVariablesArraySize(Observer observer) {
        return this._program.globals().size();
    }

    public int getVariablesArraySize(Patch patch2) {
        return this._program.patchesOwn().size();
    }

    @Override
    public int getVariablesArraySize(org.nlogo.api.Turtle turtle2, org.nlogo.api.AgentSet breed) {
        if (breed == this._turtles) {
            return this._program.turtlesOwn().size();
        }
        List<String> breedOwns = this._program.breedsOwn().get(breed.printName());
        return this._program.turtlesOwn().size() + breedOwns.size();
    }

    @Override
    public int getVariablesArraySize(org.nlogo.api.Link link, org.nlogo.api.AgentSet breed) {
        if (breed == this._links) {
            return this._program.linksOwn().size();
        }
        List<String> breedOwns = this._program.linkBreedsOwn().get(breed.printName());
        return this._program.linksOwn().size() + breedOwns.size();
    }

    public int getLinkVariablesArraySize(AgentSet breed) {
        if (breed == this._links) {
            return this._program.linksOwn().size();
        }
        List<String> breedOwns = this._program.linkBreedsOwn().get(breed.printName());
        return this._program.linksOwn().size() + breedOwns.size();
    }

    public String checkTurtleShapeName(String name) {
        if (this._turtleShapeList.exists(name = name.toLowerCase())) {
            return name;
        }
        return null;
    }

    public String checkLinkShapeName(String name) {
        if (this._linkShapeList.exists(name = name.toLowerCase())) {
            return name;
        }
        return null;
    }

    public Shape getLinkShape(String name) {
        return this._linkShapeList.shape(name);
    }

    public Map<String, Object> getBreeds() {
        return this._program.breeds();
    }

    public boolean breedOwns(AgentSet breed, String name) {
        if (breed == this._turtles) {
            return false;
        }
        List<String> breedOwns = this._program.breedsOwn().get(breed.printName());
        return breedOwns.contains(name);
    }

    public Map<String, Object> getLinkBreeds() {
        return this._program.linkBreeds();
    }

    public boolean linkBreedOwns(AgentSet breed, String name) {
        if (breed == this._links) {
            return false;
        }
        List<String> breedOwns = this._program.linkBreedsOwn().get(breed.printName());
        return breedOwns.contains(name);
    }

    @Override
    public Program program() {
        return this._program;
    }

    public void program(Program program) {
        if (program == null) {
            throw new IllegalArgumentException("World.program cannot be set to null");
        }
        this._program = program;
    }

    public Program newProgram() {
        return new Program(false);
    }

    public Program newProgram(List<String> interfaceGlobals) {
        return new Program(interfaceGlobals, false);
    }

    public void rememberOldProgram() {
        this.oldTurtlesOwn = this._program.turtlesOwn();
        this.oldPatchesOwn = this._program.patchesOwn();
        this.oldLinksOwn = this._program.linksOwn();
        this.oldGlobals = this._program.globals();
        this.oldBreeds = this._program.breeds();
        this.oldLinkBreeds = this._program.linkBreeds();
        this.oldBreedsOwn = this._program.breedsOwn();
        this.oldLinkBreedsOwn = this._program.linkBreedsOwn();
    }

    public boolean displayOn() {
        return this.displayOn;
    }

    public void displayOn(boolean displayOn) {
        this.displayOn = displayOn;
    }

    public Object getObserverVariableByName(String var) {
        int index = this._program.globals().indexOf(var.toUpperCase());
        if (index >= 0 && index < this._observer.variables.length) {
            return this._observer.variables[index];
        }
        throw new IllegalArgumentException("\"" + var + "\" not found");
    }

    public void setObserverVariableByName(String var, Object value2) throws AgentException, LogoException {
        int index;
        var = var.toUpperCase();
        if (this._program.globals().contains(var) && -1 != (index = this._program.globals().indexOf(var)) && index < this._observer.variables.length) {
            this._observer.setObserverVariable(index, value2);
            return;
        }
        throw new IllegalArgumentException("\"" + var + "\" not found");
    }

    public void compiler_$eq(CompilerServices compiler) {
        this._compiler = compiler;
    }

    public CompilerServices compiler() {
        return this._compiler;
    }

    @Override
    public Iterator<Object> allStoredValues() {
        return AllStoredValues.apply(this);
    }

    public void addWatcher(String variableName, VariableWatcher watcher) {
        if (this.variableWatchers == null) {
            this.variableWatchers = new HashMap<String, List<VariableWatcher>>();
        }
        if (!this.variableWatchers.containsKey(variableName)) {
            this.variableWatchers.put(variableName, new CopyOnWriteArrayList());
        }
        this.variableWatchers.get(variableName).add(watcher);
    }

    public void deleteWatcher(String variableName, VariableWatcher watcher) {
        if (this.variableWatchers != null && this.variableWatchers.containsKey(variableName)) {
            List<VariableWatcher> watchers = this.variableWatchers.get(variableName);
            watchers.remove(watcher);
            if (watchers.isEmpty()) {
                this.variableWatchers.remove(variableName);
            }
            if (this.variableWatchers.isEmpty()) {
                this.variableWatchers = null;
            }
        }
    }

    void notifyWatchers(Agent agent, int vn, Object value2) {
        String variableName;
        List<VariableWatcher> watchers;
        if (this.variableWatchers != null && (watchers = this.variableWatchers.get(variableName = agent.variableName(vn))) != null) {
            for (VariableWatcher watcher : watchers) {
                watcher.update(agent, variableName, value2);
            }
        }
    }

    public static interface VariableWatcher {
        public void update(Agent var1, String var2, Object var3);
    }
}

