/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.OutputObject;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.api.CompilerException;
import org.nlogo.api.I18N;
import org.nlogo.api.TokenType;
import org.nlogo.awt.Fonts;
import org.nlogo.editor.EditorField;
import org.nlogo.nvm.Workspace;
import org.nlogo.window.CommandCenterInterface;
import org.nlogo.window.EditorColorizer;
import org.nlogo.window.Events;
import org.nlogo.window.JobWidget;
import org.nlogo.window.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp class CommandLine
extends JobWidget
implements ActionListener,
KeyListener,
Events.CompiledEvent.Handler {
    static final String PROMPT = ">";
    static final String OBSERVER_PROMPT = I18N.guiJ().get("common.observer") + ">";
    static final String TURTLE_PROMPT = I18N.guiJ().get("common.turtles") + ">";
    static final String PATCH_PROMPT = I18N.guiJ().get("common.patches") + ">";
    static final String LINK_PROMPT = I18N.guiJ().get("common.links") + ">";
    private final CommandCenterInterface commandCenter;
    private final boolean echoCommandsToOutput;
    public final EditorField<TokenType> textField;
    private final Workspace workspace;
    private Agent agent;
    private static final int MAX_HISTORY_SIZE = 40;
    private int historyPosition = -1;
    private String historyBase = "";
    private Class<? extends Agent> historyBaseClass = Observer.class;
    private final List<ExecutionString> history = new ArrayList<ExecutionString>(40);

    public void agent(Agent agent) {
        this.agent = agent;
    }

    public Agent agent() {
        return this.agent;
    }

    public CommandLine(CommandCenterInterface commandCenter, boolean echoCommandsToOutput, int fontSize, Workspace workspace) {
        super(workspace.world().mainRNG);
        this.commandCenter = commandCenter;
        this.echoCommandsToOutput = echoCommandsToOutput;
        this.workspace = workspace;
        this.agentClass(Observer.class);
        this.textField = new EditorField<TokenType>(30, new Font(Fonts.platformMonospacedFont(), 0, 12), true, new EditorColorizer(workspace), I18N.guiJ().fn());
        this.textField.setFont(this.textField.getFont().deriveFont((float)fontSize));
        this.textField.addKeyListener(this);
        this.setLayout(new BorderLayout());
        this.displayName(this.classDisplayName());
        this.add((Component)new JScrollPane(this.textField, 21, 31), "Center");
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(super.getMinimumSize().width, this.getPreferredSize().height);
    }

    @Override
    public String classDisplayName() {
        return "Command Center";
    }

    @Override
    public boolean isCommandCenter() {
        return true;
    }

    private String getText() {
        return this.textField.getText();
    }

    private void setText(String s) {
        this.textField.setText(s);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 10: {
                this.executeCurrentBuffer();
                e.consume();
                break;
            }
            case 9: {
                this.commandCenter.cycleAgentType(!e.isShiftDown());
                e.consume();
                break;
            }
            case 40: {
                this.cycleListForward();
                break;
            }
            case 38: {
                this.cycleListBack();
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.executeCurrentBuffer();
    }

    private void executeCurrentBuffer() {
        String inner2 = this.getText();
        if (inner2.trim().equals("")) {
            this.setText("");
            return;
        }
        if (this.workspace.isReporter(inner2)) {
            inner2 = "show " + inner2;
            this.setText(inner2);
        }
        String header2 = "to __commandline [] ";
        String footer = "__done end";
        if (this.agentClass() == Observer.class) {
            header2 = header2 + "__observercode ";
        } else if (this.agentClass() == Turtle.class) {
            header2 = header2 + "__turtlecode ";
        } else if (this.agentClass() == Patch.class) {
            header2 = header2 + "__patchcode ";
        } else if (this.agentClass() == Link.class) {
            header2 = header2 + "__linkcode ";
        }
        this.source(header2, inner2, "\n" + footer);
    }

    @Override
    public void handle(Events.CompiledEvent e) {
        super.handle(e);
        if (e.sourceOwner == this) {
            this.error(e.error);
            if (this.error() == null) {
                this.setText("");
                String outStr = this.innerSource();
                if (!outStr.trim().equals("")) {
                    this.addToHistory(outStr);
                    if (this.echoCommandsToOutput) {
                        outStr = this.agentClass() == Turtle.class ? TURTLE_PROMPT + " " + outStr : (this.agentClass() == Patch.class ? PATCH_PROMPT + " " + outStr : (this.agentClass() == Link.class ? LINK_PROMPT + " " + outStr : OBSERVER_PROMPT + " " + outStr));
                        new Events.OutputEvent(false, new OutputObject("", outStr, true, false), false, true).raise(this);
                    }
                    if (this.agent != null) {
                        ArrayAgentSet agentSet = new ArrayAgentSet(this.agentClass(), 1, false, this.agent.world());
                        ((AgentSet)agentSet).add(this.agent);
                        this.agents(agentSet);
                    }
                    new Events.AddJobEvent(this, this.agents(), this.procedure()).raise(this);
                }
            } else if (this.error() instanceof CompilerException) {
                int offset = this.headerSource.length();
                this.textField.select(((CompilerException)this.error()).startPos() - offset, ((CompilerException)this.error()).endPos() - offset);
                new Events.OutputEvent(false, new OutputObject("", "ERROR: " + this.error().getMessage(), true, true), true, true).raise(this);
            }
        }
    }

    private void addToHistory(String str) {
        ExecutionString executionString = new ExecutionString(this.agentClass(), str);
        if (this.history.isEmpty() || !executionString.equals(this.history.get(0))) {
            this.history.add(0, executionString);
            while (this.history.size() > 40) {
                this.history.remove(this.history.size() - 1);
            }
        }
        this.historyPosition = -1;
    }

    void cycleListBack() {
        if (!this.history.isEmpty()) {
            if (this.historyPosition == -1) {
                this.historyBase = this.getText();
                this.historyBaseClass = this.agentClass();
            }
            if (this.historyPosition + 1 < this.history.size()) {
                ++this.historyPosition;
                ExecutionString es = this.history.get(this.historyPosition);
                this.setText(es.string);
                this.agentClass(es.agentClass);
            }
        }
        this.commandCenter.repaintPrompt();
    }

    void cycleListForward() {
        if (this.historyPosition == 0) {
            this.setText(this.historyBase);
            this.agentClass(this.historyBaseClass);
            this.historyPosition = -1;
        } else if (this.historyPosition > 0 && !this.history.isEmpty()) {
            --this.historyPosition;
            ExecutionString es = this.history.get(this.historyPosition);
            this.setText(es.string);
            this.agentClass(es.agentClass);
        }
        this.commandCenter.repaintPrompt();
    }

    List<ExecutionString> getExecutionList() {
        return this.history;
    }

    void reset() {
        this.clearList();
        this.setText("");
        this.agentClass(Observer.class);
    }

    void clearList() {
        this.history.clear();
        this.historyPosition = 0;
    }

    void setExecutionString(ExecutionString es) {
        this.setText(es.string);
        this.agentClass(es.agentClass);
        this.textField.setCaretPosition(this.getText().length());
        this.commandCenter.repaintPrompt();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
    }

    @Override
    public String save() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object load(String[] strings, Widget.LoadHelper helper) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    strictfp static class ExecutionString {
        final Class<? extends Agent> agentClass;
        final String string;

        ExecutionString(Class<? extends Agent> agentClass, String string2) {
            this.agentClass = agentClass;
            this.string = string2;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ExecutionString && ((ExecutionString)obj).agentClass == this.agentClass && ((ExecutionString)obj).string.equals(this.string);
        }

        public int hashCode() {
            return this.agentClass.hashCode() + this.string.hashCode();
        }
    }
}

