/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.nlogo.agent.Observer;
import org.nlogo.api.Editable;
import org.nlogo.api.I18N;
import org.nlogo.api.ModelSectionJ;
import org.nlogo.api.Version;
import org.nlogo.api.VersionHistory;
import org.nlogo.app.WidgetPanel;
import org.nlogo.app.WidgetWrapper;
import org.nlogo.awt.Fonts;
import org.nlogo.awt.Hierarchy;
import org.nlogo.awt.Images;
import org.nlogo.awt.UserCancelException;
import org.nlogo.log.Logger;
import org.nlogo.swing.FileDialog;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.util.Exceptions;
import org.nlogo.window.ButtonWidget;
import org.nlogo.window.ChooserWidget;
import org.nlogo.window.CodeEditor;
import org.nlogo.window.EditorColorizer;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.InputBoxWidget;
import org.nlogo.window.InterfaceGlobalWidget;
import org.nlogo.window.JobWidget;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.OutputWidget;
import org.nlogo.window.PlotWidget;
import org.nlogo.window.SliderWidget;
import org.nlogo.window.ViewWidget;
import org.nlogo.window.ViewWidgetInterface;
import org.nlogo.window.Widget;
import org.nlogo.window.WidgetRegistry;
import org.nlogo.workspace.Evaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp class InterfacePanel
extends WidgetPanel
implements KeyListener,
Events.LoadSectionEvent.Handler,
Events.ExportInterfaceEvent.Handler {
    private final ViewWidgetInterface viewWidget;

    public ViewWidgetInterface viewWidget() {
        return this.viewWidget;
    }

    public InterfacePanel(ViewWidgetInterface viewWidget, GUIWorkspace workspace) {
        super(workspace);
        this.viewWidget = viewWidget;
        workspace.setWidgetContainer(this);
        if (!Version.is3D()) {
            this.addWidget((Widget)((Object)viewWidget), 0, 0, false, false);
        }
        ((Widget)((Object)viewWidget)).deleteable_$eq(false);
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        this.enableButtonKeys(true);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
        this.enableButtonKeys(false);
    }

    @Override
    protected void doPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.button"), "BUTTON", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.slider"), "SLIDER", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.switch"), "SWITCH", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.chooser"), "CHOOSER", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.input"), "INPUT", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.monitor"), "MONITOR", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.plot"), "PLOT", e.getX(), e.getY()));
        WidgetCreationMenuItem outputItem = new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.output"), "OUTPUT", e.getX(), e.getY());
        if (this.getOutputWidget() != null) {
            outputItem.setEnabled(false);
        }
        menu.add(outputItem);
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.note"), "NOTE", e.getX(), e.getY()));
        menu.add(new JPopupMenu.Separator());
        menu.add(this.exportItem());
        menu.show(this, e.getX(), e.getY());
    }

    private JMenuItem exportItem() {
        JMenuItem exportItem = new JMenuItem("Export Interface...");
        exportItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    InterfacePanel.this.exportInterface();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(InterfacePanel.this, ex.getMessage(), I18N.guiJ().get("common.messages.error"), 0);
                }
            }
        });
        return exportItem;
    }

    @Override
    public Widget makeWidget(String type, boolean loading) {
        Widget fromRegistry = WidgetRegistry.apply(type = type.toUpperCase());
        if (fromRegistry != null) {
            return fromRegistry;
        }
        if (type.equalsIgnoreCase("SLIDER")) {
            return new SliderWidget(this.workspace.world.auxRNG){

                public int sourceOffset() {
                    return Evaluator.sourceOffset(Observer.class, false);
                }
            };
        }
        if (type.equals("CHOOSER") || type.equals("CHOICE")) {
            return new ChooserWidget(this.workspace);
        }
        if (type.equals("BUTTON")) {
            return new ButtonWidget(this.workspace.world.mainRNG);
        }
        if (type.equals("PLOT")) {
            return PlotWidget.apply(this.workspace.plotManager());
        }
        if (type.equals("MONITOR")) {
            return new MonitorWidget(this.workspace.world.auxRNG);
        }
        if (type.equals("INPUT") || type.equals("INPUTBOX")) {
            Font font = new Font(Fonts.platformMonospacedFont(), 0, 12);
            return new InputBoxWidget(new CodeEditor(1, 20, font, false, null, new EditorColorizer(this.workspace), I18N.guiJ().fn()), new CodeEditor(5, 20, font, true, null, new EditorColorizer(this.workspace), I18N.guiJ().fn()), this.workspace, this);
        }
        if (type.equals("OUTPUT")) {
            return new OutputWidget();
        }
        if (type.equals("CC-WINDOW")) {
            return null;
        }
        throw new IllegalStateException("unknown widget type: " + type);
    }

    @Override
    protected void deleteWidgets(List<WidgetWrapper> hitList) {
        boolean needsRecompile = false;
        for (int i = 0; i < hitList.size(); ++i) {
            WidgetWrapper w = hitList.get(i);
            this.removeWidget(w);
            if (w.widget() instanceof JobWidget) {
                JobWidget jobWidget = (JobWidget)w.widget();
                jobWidget.innerSource("");
                new Events.CompileMoreSourceEvent(jobWidget).raise(this);
            }
            if (!(w.widget() instanceof InterfaceGlobalWidget)) continue;
            needsRecompile = true;
        }
        this.setForegroundWrapper();
        this.revalidate();
        this.repaint();
        if (needsRecompile) {
            new Events.CompileAllEvent().raise(this);
        }
        this.loseFocusIfAppropriate();
    }

    @Override
    protected void removeWidget(WidgetWrapper wrapper) {
        this.remove(wrapper);
        new Events.RemoveConstraintEvent(wrapper.widget().displayName()).raise(this);
        Logger.logWidgetRemoved(wrapper.widget().classDisplayName(), wrapper.widget().displayName());
    }

    @Override
    public Widget loadWidget(String[] strings, String modelVersion) {
        return this.loadWidget(strings, modelVersion, 0, 0);
    }

    private Widget loadWidget(String[] strings, final String modelVersion, int x2, int y) {
        Widget.LoadHelper helper = new Widget.LoadHelper(){

            public String version() {
                return modelVersion;
            }

            public String convert(String source2, boolean reporter) {
                return InterfacePanel.this.workspace.autoConvert(source2, true, reporter, modelVersion);
            }
        };
        String type = strings[0];
        if (x2 == 0) {
            x2 = Integer.parseInt(strings[1]);
        }
        if (y == 0) {
            y = Integer.parseInt(strings[2]);
        }
        if (this.viewWidget instanceof ViewWidget && !type.equals("GRAPHICS-WINDOW") && VersionHistory.olderThan13pre1(modelVersion)) {
            y += ((ViewWidget)this.viewWidget).getExtraHeight() + ((ViewWidget)this.viewWidget).controlStrip.getHeight();
        }
        if (type.equals("GRAPHICS-WINDOW")) {
            this.viewWidget.asWidget().load(strings, helper);
            Container parent = this.viewWidget.asWidget().getParent();
            if (parent != null) {
                parent.setSize(this.viewWidget.asWidget().getSize());
                this.enforceMinimumAndMaximumWidgetSizes(this.viewWidget.asWidget());
                parent.setLocation(x2, y);
                this.zoomer().zoomWidgetLocation(this.getWrapper(this.viewWidget.asWidget()), true, true, 1.0, this.zoomer().zoomFactor());
                this.zoomer().zoomWidgetSize(this.getWrapper(this.viewWidget.asWidget()), true, true, 1.0, this.zoomer().zoomFactor());
                this.zoomer().scaleComponentFont(((ViewWidget)this.viewWidget).view, this.zoomFactor(), 1.0, false);
            }
            return this.viewWidget.asWidget();
        }
        Widget newGuy = null;
        newGuy = this.makeWidget(type, true);
        if (newGuy != null) {
            newGuy.load(strings, helper);
            this.enforceMinimumAndMaximumWidgetSizes(newGuy);
            this.addWidget(newGuy, x2, y, false, true);
        }
        return newGuy;
    }

    @Override
    public List<Widget> getWidgetsForSaving() {
        ArrayList<Widget> result2 = new ArrayList<Widget>();
        Component[] comps = this.getComponents();
        result2.add((Widget)((Object)this.viewWidget));
        for (int i = comps.length - 1; i >= 0; --i) {
            WidgetWrapper wrapper;
            Widget widget;
            if (!(comps[i] instanceof WidgetWrapper) || result2.contains(widget = (wrapper = (WidgetWrapper)comps[i]).widget())) continue;
            result2.add(widget);
        }
        return result2;
    }

    @Override
    boolean contains(Editable w) {
        if (w == ((Widget)((Object)this.viewWidget)).getEditable()) {
            return true;
        }
        return super.contains(w);
    }

    @Override
    public void handle(Events.WidgetRemovedEvent e) {
    }

    @Override
    public void handle(Events.ExportInterfaceEvent e) {
        try {
            ImageIO.write((RenderedImage)Images.paintToImage(this), "png", e.stream);
        }
        catch (IOException ex) {
            e.exceptionBox[0] = ex;
        }
    }

    private void exportInterface() throws IOException {
        try {
            final String exportPath = FileDialog.show(this, "Export Interface", 1, this.workspace.guessExportName("interface.png"));
            final IOException[] exception = new IOException[]{null};
            ModalProgressTask.apply(Hierarchy.getFrame(this), "Exporting...", new Runnable(){

                public void run() {
                    try {
                        InterfacePanel.this.workspace.exportInterface(exportPath);
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        catch (UserCancelException ex) {
            Exceptions.ignore(ex);
        }
    }

    @Override
    public void handle(Events.LoadSectionEvent e) {
        if (e.section == ModelSectionJ.WIDGETS()) {
            this.loadWidgets(e.lines, e.version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllWidgets() {
        try {
            Component[] comps = this.getComponents();
            this.setVisible(false);
            for (int i = 0; comps.length != i; ++i) {
                WidgetWrapper wrapper;
                if (!(comps[i] instanceof WidgetWrapper) || (wrapper = (WidgetWrapper)comps[i]).widget() == this.viewWidget) continue;
                this.removeWidget(wrapper);
            }
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
        finally {
            this.setVisible(false);
        }
    }

    @Override
    public boolean isFocusable() {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            ButtonWidget button;
            if (!(comps[i] instanceof WidgetWrapper)) continue;
            Widget widget = ((WidgetWrapper)comps[i]).widget();
            if (widget instanceof InputBoxWidget) {
                return true;
            }
            if (!(widget instanceof ButtonWidget) || (button = (ButtonWidget)widget).actionKey() == '\u0000' || button.actionKey() == ' ') continue;
            return true;
        }
        return false;
    }

    private ButtonWidget findActionButton(char key) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            ButtonWidget button;
            Widget widget;
            if (!(comps[i] instanceof WidgetWrapper) || !((widget = ((WidgetWrapper)comps[i]).widget()) instanceof ButtonWidget) || Character.toUpperCase((button = (ButtonWidget)widget).actionKey()) != Character.toUpperCase(key)) continue;
            return button;
        }
        return null;
    }

    private void enableButtonKeys(boolean enabled) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Widget widget;
            if (!(comps[i] instanceof WidgetWrapper) || !((widget = ((WidgetWrapper)comps[i]).widget()) instanceof ButtonWidget)) continue;
            ButtonWidget button = (ButtonWidget)widget;
            button.keyEnabled(enabled);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        ButtonWidget button;
        if (e.getKeyChar() != '\uffff' && !e.isActionKey() && (e.getModifiers() & this.getToolkit().getMenuShortcutKeyMask()) == 0 && (button = this.findActionButton(e.getKeyChar())) != null) {
            button.keyTriggered();
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public boolean canAddWidget(String widget) {
        return !widget.equals("Output") || this.getOutputWidget() == null;
    }

    private strictfp class WidgetCreationMenuItem
    extends JMenuItem {
        WidgetCreationMenuItem(String displayName, final String widgetType, final int x2, final int y) {
            super(displayName);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Widget widget = InterfacePanel.this.makeWidget(widgetType, false);
                    WidgetWrapper wrapper = InterfacePanel.this.addWidget(widget, x2, y, true, false);
                    WidgetCreationMenuItem.this.revalidate();
                    wrapper.selected(true);
                    wrapper.foreground();
                    wrapper.isNew(true);
                    new Events.EditWidgetEvent(null).raise(InterfacePanel.this);
                    InterfacePanel.this.newWidget.setCursor(Cursor.getPredefinedCursor(0));
                    wrapper.isNew(false);
                    InterfacePanel.this.newWidget = null;
                }
            });
        }
    }
}

