/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.nlogo.api.FileIO;
import org.nlogo.api.I18N;
import org.nlogo.app.AboutWindow;
import org.nlogo.app.ModelsLibraryIndexReader;
import org.nlogo.awt.Images;
import org.nlogo.awt.Positioning;
import org.nlogo.awt.UserCancelException;
import org.nlogo.swing.BrowserLauncher;
import org.nlogo.swing.IconHolder;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.Utils;
import org.nlogo.workspace.ModelsLibrary;

strictfp class ModelsLibraryDialog
extends JDialog
implements TreeSelectionListener,
TreeExpansionListener {
    private static ModelsLibraryDialog me = null;
    private final JTree tree;
    private final ModelPreviewPanel modelPreviewPanel;
    private Node selected = null;
    private String source = null;
    private String path = null;
    private String searchText = null;
    private final List<TreePath> savedExpandedPaths = new LinkedList<TreePath>();
    Action openAction = new AbstractAction(I18N.guiJ().get("modelsLibrary.open")){

        public void actionPerformed(ActionEvent e) {
            ModelsLibraryDialog.this.path = ModelsLibraryDialog.this.selected.getFilePath();
            try {
                ModelsLibraryDialog.this.source = FileIO.file2String(ModelsLibraryDialog.this.path);
                ModelsLibraryDialog.this.setVisible(false);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    };
    Action toggleOrOpenAction = new AbstractAction("toggle-or-open"){

        public void actionPerformed(ActionEvent e) {
            if (ModelsLibraryDialog.this.selected.isFolder()) {
                int row = ModelsLibraryDialog.this.tree.getSelectionRows()[0];
                if (ModelsLibraryDialog.this.tree.isExpanded(row)) {
                    ModelsLibraryDialog.this.tree.collapseRow(row);
                } else {
                    ModelsLibraryDialog.this.tree.expandRow(row);
                }
            } else if (ModelsLibraryDialog.this.openAction.isEnabled()) {
                ModelsLibraryDialog.this.openAction.actionPerformed(null);
            }
        }
    };
    Action cancelAction = new AbstractAction(I18N.guiJ().get("common.buttons.cancel")){

        public void actionPerformed(ActionEvent e) {
            ModelsLibraryDialog.this.source = null;
            ModelsLibraryDialog.this.path = null;
            ModelsLibraryDialog.this.setVisible(false);
        }
    };
    Action communityAction = new AbstractAction(I18N.guiJ().get("modelsLibrary.community")){

        public void actionPerformed(ActionEvent e) {
            BrowserLauncher.openURL(me, "http://ccl.northwestern.edu/netlogo/models/community/", false);
        }
    };

    public static String open(Frame parent) throws UserCancelException {
        if (me == null) {
            me = new ModelsLibraryDialog(parent);
            ModelsLibraryDialog.me.tree.setSelectionRow(0);
        }
        me.setFocusable(false);
        me.setVisible(true);
        if (ModelsLibraryDialog.me.source == null) {
            throw new UserCancelException();
        }
        return ModelsLibraryDialog.me.source;
    }

    public static String getModelPath() {
        return ModelsLibraryDialog.me.path;
    }

    private ModelsLibraryDialog(Frame parent) {
        super(parent, I18N.guiJ().get("menu.file.modelsLibrary"), true);
        this.setResizable(true);
        this.openAction.setEnabled(false);
        this.toggleOrOpenAction.setEnabled(false);
        JButton communityButton = new JButton(this.communityAction);
        JButton selectButton = new JButton(this.openAction);
        JButton cancelButton = new JButton(this.cancelAction);
        this.getRootPane().setDefaultButton(selectButton);
        this.modelPreviewPanel = new ModelPreviewPanel();
        final SearchableModelTree[] smt = new SearchableModelTree[1];
        if (ModelsLibrary.needsModelScan() || smt[0] == null) {
            ModalProgressTask.apply(parent, I18N.guiJ().get("modelsLibrary.loading"), new Runnable(){

                public void run() {
                    ModelsLibrary.scanForModels(false);
                    smt[0] = new SearchableModelTree(new Node(ModelsLibrary.rootNode, ModelsLibraryIndexReader.readInfoMap()));
                }
            });
        }
        this.tree = new JTree(smt[0]);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setToggleClickCount(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        if (this.tree.getRowCount() > 1 && ((Node)this.tree.getPathForRow(1).getLastPathComponent()).getName().equals("Curricular Models")) {
            this.tree.expandRow(1);
        }
        if (this.tree.getRowCount() > 0 && ((Node)this.tree.getPathForRow(0).getLastPathComponent()).getName().equals("Sample Models")) {
            this.tree.expandRow(0);
        }
        if (this.tree.getRowCount() > 0 && ((Node)this.tree.getPathForRow(0).getLastPathComponent()).getName().equals("3D")) {
            this.tree.expandRow(0);
        }
        InputMap inputMap = new InputMap();
        inputMap.setParent(this.tree.getInputMap());
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "none");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle-or-open");
        this.tree.setInputMap(0, inputMap);
        this.tree.getActionMap().put("toggle-or-open", this.toggleOrOpenAction);
        Utils.addEscKeyAction(this.tree, inputMap, this.cancelAction);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeExpansionListener(this);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ModelsLibraryDialog.this.openAction.isEnabled()) {
                    ModelsLibraryDialog.this.openAction.actionPerformed(null);
                }
            }
        });
        Box topPanel = new Box(0);
        Box searchPanel = new Box(0);
        final JTextField searchField = new JTextField("");
        searchField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ModelsLibraryDialog.this.setSearchText(searchField.getText());
            }

            public void insertUpdate(DocumentEvent e) {
                ModelsLibraryDialog.this.setSearchText(searchField.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                ModelsLibraryDialog.this.setSearchText(searchField.getText());
            }
        });
        searchField.setMaximumSize(new Dimension(Short.MAX_VALUE, searchField.getMinimumSize().height));
        JButton clearSearchButton = new JButton(I18N.guiJ().get("modelsLibrary.clear"));
        clearSearchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                searchField.setText("");
            }
        });
        Font buttonFont = clearSearchButton.getFont();
        clearSearchButton.setFont(buttonFont.deriveFont(buttonFont.getSize2D() - 2.0f));
        searchPanel.add(new IconHolder(new ImageIcon(AboutWindow.class.getResource("/images/magnify.gif"))));
        searchPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        searchPanel.add(searchField);
        searchPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        searchPanel.add(clearSearchButton);
        searchPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        Box treePanel = new Box(1);
        treePanel.add(new JScrollPane(this.tree));
        treePanel.add(searchPanel);
        topPanel.add(treePanel);
        topPanel.add(new JScrollPane(this.modelPreviewPanel));
        Box buttonPanel = new Box(0);
        buttonPanel.add(Box.createRigidArea(new Dimension(40, 0)));
        buttonPanel.add(communityButton);
        buttonPanel.add(Box.createHorizontalGlue());
        if (System.getProperty("os.name").startsWith("Mac")) {
            buttonPanel.add(cancelButton);
            buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPanel.add(selectButton);
        } else {
            buttonPanel.add(selectButton);
            buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPanel.add(cancelButton);
        }
        buttonPanel.add(Box.createRigidArea(new Dimension(40, 0)));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(topPanel);
        contentPane.add(buttonPanel);
        this.setContentPane(contentPane);
        Utils.addEscKeyAction(this, this.cancelAction);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ModelsLibraryDialog.this.cancelAction.actionPerformed(null);
            }
        });
        this.setSize(740, 715);
        Positioning.center(this, parent);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ModelsLibraryDialog.this.modelPreviewPanel.showModel();
            }
        });
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String newText) {
        TreePath savedSelectionPath = this.tree.getSelectionPath();
        boolean wasNull = this.searchText == null;
        this.searchText = newText.length() == 0 ? null : newText.toUpperCase();
        boolean isNull = this.searchText == null;
        Node root2 = (Node)this.tree.getModel().getRoot();
        if (wasNull && !isNull) {
            this.savedExpandedPaths.clear();
            Enumeration<TreePath> e = this.tree.getExpandedDescendants(new TreePath(root2));
            while (e.hasMoreElements()) {
                this.savedExpandedPaths.add(e.nextElement());
            }
        }
        ((SearchableModelTree)this.tree.getModel()).reload(root2);
        if (!isNull) {
            Thread expander = new Thread(){
                String text;
                {
                    this.text = ModelsLibraryDialog.this.searchText;
                }

                public void run() {
                    for (int i = 0; i < ModelsLibraryDialog.this.tree.getRowCount(); ++i) {
                        if (!this.text.equals(ModelsLibraryDialog.this.searchText)) {
                            return;
                        }
                        final TreePath path = ModelsLibraryDialog.this.tree.getPathForRow(i);
                        Node node = (Node)path.getLastPathComponent();
                        if (!node.isFolder()) continue;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    ModelsLibraryDialog.this.tree.expandPath(path);
                                }
                            });
                            continue;
                        }
                        catch (InvocationTargetException ex) {
                            throw new IllegalStateException(ex);
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ModelsLibraryDialog.this.invalidate();
                            ModelsLibraryDialog.this.validate();
                        }
                    });
                }
            };
            expander.start();
        } else if (!wasNull) {
            Iterator<TreePath> i = this.savedExpandedPaths.iterator();
            while (i.hasNext()) {
                this.tree.expandPath(i.next());
            }
            this.savedExpandedPaths.clear();
            if (savedSelectionPath != null) {
                this.tree.expandPath(savedSelectionPath);
                this.tree.setSelectionPath(savedSelectionPath);
                this.tree.scrollPathToVisible(savedSelectionPath);
            }
        }
    }

    private int[] searchTextIndices(String text2) {
        if (this.searchText == null) {
            return null;
        }
        String ucText = text2.toUpperCase();
        LinkedList<Integer> indices = new LinkedList<Integer>();
        int index = 0;
        while ((index = ucText.indexOf(this.searchText, index + 1)) > -1) {
            indices.add(index);
        }
        int[] result2 = new int[indices.size()];
        int rIndex = 0;
        Iterator i = indices.iterator();
        while (i.hasNext()) {
            result2[rIndex++] = (Integer)i.next();
        }
        return result2;
    }

    public void treeExpanded(TreeExpansionEvent e) {
        if (this.searchText == null) {
            this.invalidate();
            this.validate();
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
        if (this.searchText == null) {
            this.invalidate();
            this.validate();
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (this.tree.getSelectionPath() == null) {
            this.selected = null;
            this.openAction.setEnabled(false);
            this.toggleOrOpenAction.setEnabled(false);
        } else {
            this.selected = (Node)this.tree.getSelectionPath().getLastPathComponent();
            this.openAction.setEnabled(!this.selected.isFolder());
            this.toggleOrOpenAction.setEnabled(true);
        }
        this.modelPreviewPanel.showModel();
        this.invalidate();
        if (this.tree.getSelectionPath() != null) {
            this.tree.scrollPathToVisible(this.tree.getSelectionPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    strictfp static class Node
    extends DefaultMutableTreeNode {
        private final String name;
        private final String path;
        private final String info;

        Node(ModelsLibrary.Node from2, Map<String, String> infoMap) {
            this.name = from2.getName();
            this.path = from2.getFilePath();
            this.allowsChildren = from2.getAllowsChildren();
            if (!this.allowsChildren) {
                String info = infoMap.get(this.path.substring(this.path.indexOf("models")).replace(System.getProperty("file.separator"), "/"));
                if (info == null) {
                    info = "";
                }
                while (info.length() > 0 && !Character.isLetterOrDigit(info.charAt(0))) {
                    info = info.substring(1);
                }
                StringBuilder sb = new StringBuilder(info.length());
                sb.append(info);
                this.info = info = sb.toString();
            } else {
                this.info = "";
            }
            Enumeration<TreeNode> children2 = from2.children();
            while (children2.hasMoreElements()) {
                this.add(new Node((ModelsLibrary.Node)children2.nextElement(), infoMap));
            }
        }

        public String getName() {
            return this.name;
        }

        public String getFilePath() {
            return this.path;
        }

        public String getInfo() {
            return this.info;
        }

        @Override
        public String toString() {
            return this.name;
        }

        public boolean isFolder() {
            return this.allowsChildren;
        }

        @Override
        public boolean isLeaf() {
            return !this.allowsChildren;
        }
    }

    private strictfp class SearchableModelTree
    extends DefaultTreeModel {
        public SearchableModelTree(Node node) {
            super(node);
        }

        public Object getChild(Object parent, int childIndex) {
            if (ModelsLibraryDialog.this.searchText == null) {
                return super.getChild(parent, childIndex);
            }
            Node node = (Node)parent;
            int index = -1;
            Enumeration<TreeNode> children2 = node.children();
            while (children2.hasMoreElements()) {
                Node child = (Node)children2.nextElement();
                if (child.isFolder()) {
                    if (this.hasChildren(child)) {
                        ++index;
                    }
                } else if (this.matchesSearchText(child)) {
                    ++index;
                }
                if (index != childIndex) continue;
                return child;
            }
            return null;
        }

        private boolean hasChildren(Object parent) {
            Node node = (Node)parent;
            if (node.isFolder()) {
                Enumeration<TreeNode> children2 = node.children();
                while (children2.hasMoreElements()) {
                    Node child = (Node)children2.nextElement();
                    if (!(child.isFolder() ? this.hasChildren(child) : this.matchesSearchText(child))) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public int getChildCount(Object parent) {
            if (ModelsLibraryDialog.this.searchText == null) {
                return super.getChildCount(parent);
            }
            Node node = (Node)parent;
            if (node.isFolder()) {
                int result2 = 0;
                Enumeration<TreeNode> children2 = node.children();
                while (children2.hasMoreElements()) {
                    Node child = (Node)children2.nextElement();
                    if (child.isFolder()) {
                        if (this.getChildCount(child) <= 0) continue;
                        ++result2;
                        continue;
                    }
                    if (!this.matchesSearchText(child)) continue;
                    ++result2;
                }
                return result2;
            }
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            if (ModelsLibraryDialog.this.searchText == null) {
                return super.getIndexOfChild(parent, child);
            }
            Node node = (Node)parent;
            int result2 = 0;
            Enumeration<TreeNode> children2 = node.children();
            while (children2.hasMoreElements()) {
                Node c = (Node)children2.nextElement();
                if (c.equals(child)) {
                    return result2;
                }
                if (c.isFolder()) {
                    if (this.getChildCount(c) <= 0) continue;
                    ++result2;
                    continue;
                }
                if (!this.matchesSearchText(c)) continue;
                ++result2;
            }
            return -1;
        }

        private boolean matchesSearchText(Node node) {
            return node.getName().toUpperCase().indexOf(ModelsLibraryDialog.this.searchText) > -1 || node.getInfo().toUpperCase().indexOf(ModelsLibraryDialog.this.searchText) > -1 || node.getFilePath().toUpperCase().indexOf(ModelsLibraryDialog.this.searchText) > -1;
        }
    }

    private strictfp class GraphicsPreview
    extends JPanel {
        private Image image = null;

        GraphicsPreview() {
            this.setBackground(Color.BLACK);
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(400, 400));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
        }

        void setImage(String imagePath) {
            this.image = null;
            if (imagePath != null) {
                this.image = Images.loadImageFile(imagePath, false);
            }
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            if (this.image == null) {
                super.paintComponent(g);
            } else {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                int width = this.image.getWidth(null);
                int height = this.image.getHeight(null);
                if (width == height) {
                    g.drawImage(this.image, 0, 0, 400, 400, this);
                } else if (width > height) {
                    g.drawImage(this.image, 0, 0, (int)((double)width * (400.0 / (double)height)), 400, this);
                } else {
                    g.drawImage(this.image, 0, 0, 400, (int)((double)height * (400.0 / (double)width)), this);
                }
            }
        }
    }

    private strictfp class ModelPreviewPanel
    extends JPanel
    implements HyperlinkListener {
        private final GraphicsPreview graphicsPreview;
        private final JEditorPane textArea;

        ModelPreviewPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.graphicsPreview = new GraphicsPreview();
            this.graphicsPreview.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 1));
            this.textArea = new JEditorPane();
            this.textArea.setContentType("text/html");
            this.textArea.setEditable(false);
            this.textArea.setOpaque(false);
            this.textArea.addHyperlinkListener(this);
            this.add(this.graphicsPreview);
            this.add(this.textArea);
            this.add(Box.createVerticalGlue());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }

        void showModel() {
            this.graphicsPreview.setImage(ModelsLibraryDialog.this.selected == null || ModelsLibraryDialog.this.selected.isFolder() ? null : ModelsLibrary.getImagePath(ModelsLibraryDialog.this.selected.getFilePath()));
            this.textArea.setPreferredSize(null);
            this.textArea.setMaximumSize(new Dimension(390, Short.MAX_VALUE));
            if (ModelsLibraryDialog.this.selected != null && !ModelsLibraryDialog.this.selected.isFolder()) {
                this.textArea.setVisible(true);
                this.graphicsPreview.setVisible(true);
                this.textArea.setText("<html>\n<head>\n<style>body {font-family: Dialog; font-size: 12pt; }</style></head><body>\n<h2>" + ModelsLibraryDialog.this.selected.getName() + "</h2>\n" + ModelsLibraryDialog.this.selected.getInfo() + "</body>" + "</html>");
                try {
                    String text2 = this.textArea.getDocument().getText(0, this.textArea.getDocument().getLength());
                    int[] indices = ModelsLibraryDialog.this.searchTextIndices(text2);
                    if (indices != null) {
                        for (int i = 0; i < indices.length; ++i) {
                            this.textArea.getHighlighter().addHighlight(indices[i], indices[i] + ModelsLibraryDialog.this.searchText.length(), DefaultHighlighter.DefaultPainter);
                        }
                    }
                }
                catch (BadLocationException ex) {
                    throw new IllegalStateException(ex);
                }
                this.textArea.setCaretPosition(0);
            } else {
                String text3 = org.nlogo.util.Utils.getResourceAsString("/system/library.html");
                this.textArea.setText(text3);
                this.textArea.setCaretPosition(0);
                this.graphicsPreview.setVisible(false);
            }
            this.textArea.setPreferredSize(new Dimension(390, this.textArea.getPreferredSize().height));
            this.invalidate();
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (e.getURL() == null) {
                    JOptionPane.showMessageDialog(this, "Invalid URL!", "Error", 0);
                } else {
                    BrowserLauncher.openURL(this, e.getURL().toString(), false);
                }
            }
        }
    }
}

