/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.api.Editable;
import org.nlogo.api.I18N;
import org.nlogo.api.ModelReader;
import org.nlogo.app.WidgetCreator;
import org.nlogo.app.WidgetWrapper;
import org.nlogo.awt.Fonts;
import org.nlogo.awt.Mouse;
import org.nlogo.editor.AbstractEditorArea;
import org.nlogo.log.Logger;
import org.nlogo.nvm.DefaultCompilerServices;
import org.nlogo.window.AbstractWidgetPanel;
import org.nlogo.window.ButtonWidget;
import org.nlogo.window.CodeEditor;
import org.nlogo.window.DummyButtonWidget;
import org.nlogo.window.DummyChooserWidget;
import org.nlogo.window.DummyInputBoxWidget;
import org.nlogo.window.DummyMonitorWidget;
import org.nlogo.window.DummyPlotWidget;
import org.nlogo.window.DummySliderWidget;
import org.nlogo.window.DummyViewWidget;
import org.nlogo.window.EditorColorizer;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.OutputWidget;
import org.nlogo.window.PlotWidget;
import org.nlogo.window.Widget;
import org.nlogo.window.WidgetContainer;
import org.nlogo.window.WidgetRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class WidgetPanel
extends AbstractWidgetPanel
implements WidgetContainer,
MouseListener,
MouseMotionListener,
FocusListener,
Events.WidgetEditedEvent.Handler,
Events.WidgetRemovedEvent.Handler,
Events.LoadBeginEvent.Handler {
    static final int GRID_SNAP = 5;
    protected Rectangle selectionRect;
    protected Point startDragPoint;
    protected WidgetWrapper newWidget;
    protected List<WidgetWrapper> widgetsBeingDragged;
    protected final GUIWorkspace workspace;
    protected final JComponent glassPane = new JComponent(){

        public void paintComponent(Graphics g) {
            if (WidgetPanel.this.selectionRect != null) {
                g.setColor(Color.WHITE);
                g.drawRect(WidgetPanel.this.selectionRect.x, WidgetPanel.this.selectionRect.y, WidgetPanel.this.selectionRect.width - 1, WidgetPanel.this.selectionRect.height - 1);
                g.setColor(new Color(180, 180, 180, 120));
                g.fillRect(WidgetPanel.this.selectionRect.x, WidgetPanel.this.selectionRect.y, WidgetPanel.this.selectionRect.width - 1, WidgetPanel.this.selectionRect.height - 1);
            }
        }
    };
    protected boolean hasFocus = false;
    WidgetCreator widgetCreator = null;
    protected boolean sliderEventOnReleaseOnly = false;
    private Widget view = null;

    public WidgetPanel(GUIWorkspace workspace) {
        this.workspace = workspace;
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
        this.setAutoscrolls(true);
        this.glassPane.setOpaque(false);
        this.glassPane.setVisible(false);
        this.add((Component)this.glassPane, DRAG_LAYER);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public void requestFocus() {
        this.requestFocusInWindow();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredSize(false);
    }

    GUIWorkspace workspace() {
        return this.workspace;
    }

    @Override
    public boolean empty() {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof WidgetWrapper)) continue;
            return false;
        }
        return true;
    }

    public Dimension getPreferredSize(boolean savingAsApplet) {
        int maxX = 0;
        int maxY = 0;
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] == this.glassPane) continue;
            Point location = comps[i].getLocation();
            Dimension size2 = comps[i].getSize();
            int x2 = location.x + size2.width;
            int y = location.y + size2.height;
            if (!savingAsApplet && comps[i] instanceof WidgetWrapper && !((WidgetWrapper)comps[i]).selected()) {
                x2 += 9;
                y += 9;
            }
            if (x2 > maxX) {
                maxX = x2;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        if (!savingAsApplet && System.getProperty("os.name").startsWith("Mac") && System.getProperty("os.version").startsWith("10.2")) {
            maxX += 8;
            maxY += 8;
        }
        return new Dimension(maxX, maxY);
    }

    OutputWidget getOutputWidget() {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            WidgetWrapper wrapper;
            if (!(comps[i] instanceof WidgetWrapper) || !((wrapper = (WidgetWrapper)comps[i]).widget() instanceof OutputWidget)) continue;
            return (OutputWidget)wrapper.widget();
        }
        return null;
    }

    public void setWidgetCreator(WidgetCreator widgetCreator) {
        this.widgetCreator = widgetCreator;
    }

    public WidgetWrapper getWrapper(Widget widget) {
        return (WidgetWrapper)widget.getParent();
    }

    protected List<WidgetWrapper> selectedWrappers() {
        ArrayList<WidgetWrapper> result2 = new ArrayList<WidgetWrapper>();
        Component[] comps = this.getComponents();
        for (int i = 0; comps.length != i; ++i) {
            WidgetWrapper wrapper;
            if (!(comps[i] instanceof WidgetWrapper) || !(wrapper = (WidgetWrapper)comps[i]).selected()) continue;
            result2.add(wrapper);
        }
        return result2;
    }

    void aboutToDragSelectedWidgets(int startPressX, int startPressY) {
        this.widgetsBeingDragged = new ArrayList<WidgetWrapper>();
        List<WidgetWrapper> selectedWrappers = this.selectedWrappers();
        for (int i = 0; i < selectedWrappers.size(); ++i) {
            WidgetWrapper w = selectedWrappers.get(i);
            w.startPressX = startPressX;
            w.startPressY = startPressY;
            w.aboutToDrag();
            this.widgetsBeingDragged.add(w);
        }
    }

    void dragSelectedWidgets(int x2, int y) {
        WidgetWrapper w;
        int i;
        Point p = new Point(x2, y);
        for (i = 0; i < this.widgetsBeingDragged.size(); ++i) {
            w = this.widgetsBeingDragged.get(i);
            p = this.restrictDrag(p, w);
        }
        for (i = 0; i < this.widgetsBeingDragged.size(); ++i) {
            w = this.widgetsBeingDragged.get(i);
            w.doDrag(p.x, p.y);
        }
    }

    protected Point restrictDrag(Point p, WidgetWrapper w) {
        int x2 = p.x;
        int y = p.y;
        Rectangle wb = w.originalBounds;
        Rectangle b = this.getBounds();
        Rectangle newWb = new Rectangle(wb.x + x2, wb.y + y, wb.width, wb.height);
        if (this.workspace.snapOn() && !this.isZoomed()) {
            int xGridSnap = newWb.x - newWb.x / 5 * 5;
            int yGridSnap = newWb.y - newWb.y / 5 * 5;
            x2 -= xGridSnap;
            y -= yGridSnap;
            newWb.x -= xGridSnap;
            newWb.y -= yGridSnap;
        }
        if (newWb.x + newWb.width < 18) {
            x2 += 18 - (newWb.x + newWb.width);
        }
        if (newWb.y < 10) {
            y += 10 - newWb.y;
        }
        if (newWb.x + 18 > b.width) {
            x2 -= newWb.x + 18 - b.width;
        }
        if (newWb.y + 10 > b.height) {
            y -= newWb.y + 10 - b.height;
        }
        return new Point(x2, y);
    }

    void dropSelectedWidgets() {
        for (int i = 0; i < this.widgetsBeingDragged.size(); ++i) {
            WidgetWrapper w = this.widgetsBeingDragged.get(i);
            w.doDrop();
        }
        this.widgetsBeingDragged = null;
        this.setForegroundWrapper();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!Mouse.hasButton1(e)) {
            return;
        }
        Point p = e.getPoint();
        Rectangle rect = this.getBounds();
        p.x += rect.x;
        p.y += rect.y;
        if (this.newWidget != null) {
            if (this.workspace.snapOn()) {
                this.startDragPoint.x = this.startDragPoint.x / 5 * 5;
                this.startDragPoint.y = this.startDragPoint.y / 5 * 5;
            }
            Point p2 = this.restrictDrag(new Point(e.getX() - this.startDragPoint.x, e.getY() - this.startDragPoint.y), this.newWidget);
            this.newWidget.setLocation(this.startDragPoint.x + p2.x, this.startDragPoint.y + p2.y);
        } else if (null != this.startDragPoint) {
            if (!this.glassPane.isVisible()) {
                this.glassPane.setBounds(0, 0, this.getWidth(), this.getHeight());
                this.glassPane.setVisible(true);
            }
            this.scrollRectToVisible(new Rectangle(e.getX() - 20, e.getY() - 20, 40, 40));
            Rectangle oldSelectionRect = this.selectionRect;
            int x2 = StrictMath.min(this.getWidth(), StrictMath.max(e.getX(), 0));
            int y = StrictMath.min(this.getHeight(), StrictMath.max(e.getY(), 0));
            this.selectionRect = new Rectangle(StrictMath.min(this.startDragPoint.x, x2), StrictMath.min(this.startDragPoint.y, y), StrictMath.abs(x2 - this.startDragPoint.x), StrictMath.abs(y - this.startDragPoint.y));
            this.selectWidgets(this.selectionRect);
            if (oldSelectionRect != null) {
                this.glassPane.repaint(oldSelectionRect);
            }
            this.glassPane.repaint(this.selectionRect);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopup(e);
            return;
        }
        if (!Mouse.hasButton1(e)) {
            return;
        }
        this.requestFocus();
        Point p = e.getPoint();
        Rectangle rect = this.getBounds();
        p.x += rect.x;
        p.y += rect.y;
        if (!rect.contains(p)) {
            return;
        }
        this.unselectWidgets();
        this.startDragPoint = e.getPoint();
        if (this.widgetCreator == null) {
            return;
        }
        Widget widget = this.widgetCreator.getWidget();
        if (widget == null) {
            return;
        }
        this.addWidget(widget, e.getX(), e.getY(), true, false);
        this.revalidate();
    }

    protected void doPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.button"), "BUTTON", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.slider"), "SLIDER", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.switch"), "SWITCH", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.chooser"), "CHOOSER", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.input"), "INPUT", e.getX(), e.getY()));
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.monitor"), "MONITOR", e.getX(), e.getY()));
        WidgetCreationMenuItem plot2 = new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.plot"), "PLOT", e.getX(), e.getY());
        if (this.workspace.plotManager().plots().size() == 0) {
            plot2.setEnabled(false);
        }
        menu.add(plot2);
        menu.add(new WidgetCreationMenuItem(I18N.guiJ().get("tabs.run.widgets.note"), "NOTE", e.getX(), e.getY()));
        menu.show(this, e.getX(), e.getY());
    }

    public void createWidget(String name, int x2, int y) {
        Widget widget = this.makeWidget(name, false);
        WidgetWrapper wrapper = this.addWidget(widget, x2, y, true, false);
        this.revalidate();
        wrapper.selected(true);
        wrapper.foreground();
        wrapper.isNew(true);
        new Events.EditWidgetEvent(null).raise(this);
        this.newWidget.setCursor(Cursor.getPredefinedCursor(0));
        wrapper.isNew(false);
        this.newWidget = null;
    }

    public Widget makeWidget(String type, boolean loading) {
        type = "DUMMY " + type.toUpperCase();
        Widget fromRegistry = WidgetRegistry.apply(type);
        if (fromRegistry != null) {
            return fromRegistry;
        }
        if (type.equals("DUMMY SLIDER")) {
            return new DummySliderWidget();
        }
        if (type.equals("DUMMY CHOOSER") || type.equals("DUMMY CHOICE")) {
            return new DummyChooserWidget(new DefaultCompilerServices(this.workspace.compiler()));
        }
        if (type.equals("DUMMY BUTTON")) {
            return new DummyButtonWidget();
        }
        if (type.equals("DUMMY PLOT")) {
            String[] names2 = this.workspace.plotManager().getPlotNames();
            if (names2.length > 0) {
                return DummyPlotWidget.apply(names2[0], this.workspace.plotManager());
            }
            return DummyPlotWidget.apply("plot 1", this.workspace.plotManager());
        }
        if (type.equals("DUMMY MONITOR")) {
            return new DummyMonitorWidget();
        }
        if (type.equals("DUMMY INPUT") || type.equals("DUMMY INPUTBOX")) {
            Font font = new Font(Fonts.platformMonospacedFont(), 0, 12);
            return new DummyInputBoxWidget((AbstractEditorArea)new CodeEditor(1, 20, font, false, null, new EditorColorizer(this.workspace), I18N.guiJ().fn()), (AbstractEditorArea)new CodeEditor(5, 20, font, true, null, new EditorColorizer(this.workspace), I18N.guiJ().fn()), this, new DefaultCompilerServices(this.workspace.compiler()));
        }
        if (type.equals("DUMMY OUTPUT")) {
            return new OutputWidget();
        }
        if (type.equals("DUMMY CC-WINDOW")) {
            return null;
        }
        if (type.equals("DUMMY GRAPHICS-WINDOW") || type.equals("DUMMY VIEW") || type.equals("VIEW")) {
            this.view = new DummyViewWidget(this.workspace.world);
            return this.view;
        }
        throw new IllegalStateException("unknown widget type: " + type);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopup(e);
            return;
        }
        if (Mouse.hasButton1(e)) {
            Point p = e.getPoint();
            Rectangle rect = this.getBounds();
            p.x += rect.x;
            p.y += rect.y;
            this.selectionRect = null;
            this.glassPane.setVisible(false);
            if (this.newWidget != null) {
                this.newWidget.selected(true);
                this.newWidget.foreground();
                this.newWidget.isNew(true);
                new Events.EditWidgetEvent(null).raise(this);
                this.newWidget.setCursor(Cursor.getPredefinedCursor(0));
                this.newWidget.isNew(false);
                this.newWidget = null;
            }
        }
    }

    void setForegroundWrapper() {
        Component[] comps = this.getComponents();
        for (int i = 0; comps.length != i; ++i) {
            if (!(comps[i] instanceof WidgetWrapper) || !((WidgetWrapper)comps[i]).selected()) continue;
            ((WidgetWrapper)comps[i]).foreground();
            return;
        }
    }

    protected void selectWidgets(Rectangle rect) {
        Component[] comps = this.getComponents();
        for (int i = 0; comps.length != i; ++i) {
            if (!(comps[i] instanceof WidgetWrapper)) continue;
            boolean selected = false;
            WidgetWrapper wrapper = (WidgetWrapper)comps[i];
            selected = wrapper.selected();
            Rectangle wrapperRect = wrapper.getUnselectedBounds();
            if (!selected) {
                if (!rect.intersects(wrapperRect)) continue;
                wrapper.selected(true);
                continue;
            }
            if (rect.intersects(wrapperRect) || !selected) continue;
            wrapper.selected(false);
        }
        this.setForegroundWrapper();
    }

    protected void unselectWidgets() {
        List<WidgetWrapper> selectedWrappers = this.selectedWrappers();
        for (int i = 0; i < selectedWrappers.size(); ++i) {
            WidgetWrapper wrapper = selectedWrappers.get(i);
            wrapper.selected(false);
        }
    }

    protected WidgetWrapper addWidget(Widget widget, int x2, int y, boolean select2, boolean loadingWidget) {
        Dimension size2 = widget.getSize();
        WidgetWrapper wrapper = new WidgetWrapper(widget, this);
        wrapper.setVisible(false);
        this.add((Component)wrapper, DEFAULT_LAYER);
        this.moveToFront(wrapper);
        if (select2 || !loadingWidget) {
            wrapper.setSize(wrapper.getPreferredSize());
        } else {
            wrapper.setSize(size2);
        }
        if (this.workspace.snapOn() && !loadingWidget) {
            int gridX = x2 / 5 * 5;
            int gridY = y / 5 * 5;
            wrapper.setLocation(gridX, gridY);
        } else {
            wrapper.setLocation(x2, y);
        }
        wrapper.validate();
        wrapper.setVisible(true);
        this.zoomer().zoomWidget(wrapper, true, loadingWidget, 1.0, this.zoomFactor());
        if (select2) {
            this.newWidget = wrapper;
            this.newWidget.originalBounds = this.newWidget.getBounds();
            this.newWidget.setCursor(Cursor.getPredefinedCursor(1));
        }
        Logger.logAddWidget(widget.classDisplayName(), widget.displayName());
        return wrapper;
    }

    public void editWidgetFinished(Editable target, boolean canceled) {
        if (target instanceof Component && ((Component)((Object)target)).getParent() instanceof WidgetWrapper) {
            ((WidgetWrapper)((Component)((Object)target)).getParent()).selected(false);
        }
        if (canceled && this.newWidget != null) {
            this.removeWidget(this.newWidget);
            this.revalidate();
        }
        this.setForegroundWrapper();
        this.loseFocusIfAppropriate();
    }

    public void deleteSelectedWidgets() {
        ArrayList<WidgetWrapper> hitList = new ArrayList<WidgetWrapper>();
        List<WidgetWrapper> selectedWrappers = this.selectedWrappers();
        for (WidgetWrapper w : selectedWrappers) {
            if (!w.selected() || !w.widget().deleteable()) continue;
            hitList.add(w);
        }
        this.deleteWidgets(hitList);
    }

    void deleteWidget(WidgetWrapper target) {
        ArrayList<WidgetWrapper> hitList = new ArrayList<WidgetWrapper>();
        hitList.add(target);
        this.deleteWidgets(hitList);
    }

    protected void deleteWidgets(List<WidgetWrapper> hitList) {
        for (int i = 0; i < hitList.size(); ++i) {
            WidgetWrapper w = hitList.get(i);
            this.removeWidget(w);
        }
        this.setForegroundWrapper();
        this.revalidate();
        this.repaint();
        this.loseFocusIfAppropriate();
    }

    protected void removeWidget(WidgetWrapper wrapper) {
        if (wrapper.widget() == this.view) {
            this.view = null;
        }
        this.remove(wrapper);
        Logger.logWidgetRemoved(wrapper.widget().classDisplayName(), wrapper.widget().displayName());
    }

    public boolean sliderEventOnReleaseOnly() {
        return this.sliderEventOnReleaseOnly;
    }

    public void sliderEventOnReleaseOnly(boolean sliderEventOnReleaseOnly) {
        this.sliderEventOnReleaseOnly = sliderEventOnReleaseOnly;
    }

    @Override
    public void handle(Events.ZoomedEvent e) {
        super.handle(e);
        this.unselectWidgets();
        this.zoomer().zoomWidgets(this.zoomFactor());
        this.revalidate();
    }

    @Override
    public Widget loadWidget(String[] strings, final String modelVersion) {
        Widget.LoadHelper helper = new Widget.LoadHelper(){

            public String version() {
                return modelVersion;
            }

            public String convert(String source2, boolean reporter) {
                return WidgetPanel.this.workspace.autoConvert(source2, true, reporter, modelVersion);
            }
        };
        String type = strings[0];
        int x2 = Integer.parseInt(strings[1]);
        int y = Integer.parseInt(strings[2]);
        Widget newGuy = this.makeWidget(type, true);
        if (newGuy != null) {
            newGuy.load(strings, helper);
            this.enforceMinimumAndMaximumWidgetSizes(newGuy);
            this.addWidget(newGuy, x2, y, false, true);
        }
        return newGuy;
    }

    @Override
    public void handle(Events.WidgetEditedEvent e) {
        new Events.DirtyEvent().raise(this);
        this.zoomer().updateZoomInfo(e.widget);
    }

    @Override
    public void handle(Events.WidgetRemovedEvent e) {
        if (e.widget instanceof PlotWidget) {
            Component[] comps = this.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                WidgetWrapper wrapper;
                Widget widget;
                if (!(comps[i] instanceof WidgetWrapper) || !((widget = (wrapper = (WidgetWrapper)comps[i]).widget()) instanceof DummyPlotWidget) || !e.widget.displayName().equals(widget.displayName())) continue;
                this.removeWidget(wrapper);
            }
            this.repaint();
        }
    }

    @Override
    public void handle(Events.LoadBeginEvent e) {
        this.unselectWidgets();
        this.removeAllWidgets();
        this.zoomer().forgetAllZoomInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadWidgets(String[] lines2, String version) {
        try {
            List<List<String>> v = ModelReader.parseWidgets(lines2);
            if (null != v) {
                this.setVisible(false);
                for (List<String> v2 : v) {
                    String[] strings = v2.toArray(new String[v2.size()]);
                    this.loadWidget(strings, version);
                }
            }
        }
        finally {
            this.setVisible(true);
            this.revalidate();
        }
    }

    @Override
    public List<Widget> getWidgetsForSaving() {
        ArrayList<Widget> result2 = new ArrayList<Widget>();
        Component[] comps = this.getComponents();
        for (int i = comps.length - 1; i >= 0; --i) {
            WidgetWrapper wrapper;
            Widget widget;
            if (!(comps[i] instanceof WidgetWrapper) || result2.contains(widget = (wrapper = (WidgetWrapper)comps[i]).widget())) continue;
            result2.add(widget);
        }
        return result2;
    }

    @Override
    public void removeAllWidgets() {
        Component[] comps = this.getComponents();
        this.setVisible(false);
        for (int i = 0; comps.length != i; ++i) {
            if (!(comps[i] instanceof WidgetWrapper)) continue;
            WidgetWrapper wrapper = (WidgetWrapper)comps[i];
            this.removeWidget(wrapper);
        }
    }

    @Override
    public boolean hasView() {
        return this.view != null;
    }

    boolean contains(Editable w) {
        Component[] comps = this.getComponents();
        for (int i = 0; comps.length != i; ++i) {
            WidgetWrapper wrapper;
            if (!(comps[i] instanceof WidgetWrapper) || (wrapper = (WidgetWrapper)comps[i]).widget().getEditable() != w) continue;
            return true;
        }
        return false;
    }

    protected void enforceMinimumAndMaximumWidgetSizes(Component component) {
        Dimension maximumSize;
        Dimension size2 = component.getSize();
        boolean changed2 = false;
        Dimension minimumSize = component.getMinimumSize();
        if (size2.width < minimumSize.width) {
            size2.width = minimumSize.width;
            changed2 = true;
        }
        if (size2.height < minimumSize.height) {
            size2.height = minimumSize.height;
            changed2 = true;
        }
        if ((maximumSize = component.getMaximumSize()) != null) {
            if (size2.width > maximumSize.width && maximumSize.width > 0) {
                size2.width = maximumSize.width;
                changed2 = true;
            }
            if (size2.height > maximumSize.height && maximumSize.height > 0) {
                size2.height = maximumSize.height;
                changed2 = true;
            }
        }
        if (changed2) {
            component.setSize(size2);
        }
    }

    protected void loseFocusIfAppropriate() {
        if (this.hasFocus && !this.isFocusable()) {
            this.transferFocus();
        }
    }

    @Override
    public boolean isFocusable() {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            ButtonWidget button;
            Widget widget;
            if (!(comps[i] instanceof WidgetWrapper) || !((widget = ((WidgetWrapper)comps[i]).widget()) instanceof ButtonWidget) || (button = (ButtonWidget)widget).actionKey() == '\u0000' || button.actionKey() == ' ') continue;
            return true;
        }
        return false;
    }

    @Override
    public String getBoundsString(Widget widget) {
        StringBuilder buf = new StringBuilder();
        Rectangle r = this.getUnzoomedBounds(widget);
        buf.append(r.x + "\n");
        buf.append(r.y + "\n");
        buf.append(r.x + r.width + "\n");
        buf.append(r.y + r.height + "\n");
        return buf.toString();
    }

    @Override
    public Rectangle getUnzoomedBounds(Component component) {
        return this.zoomer().getUnzoomedBounds(component);
    }

    @Override
    public void resetZoomInfo(Widget widget) {
        this.zoomer().updateZoomInfo(widget);
    }

    @Override
    public void resetSizeInfo(Widget widget) {
        this.getWrapper(widget).widgetResized();
    }

    @Override
    public boolean isZoomed() {
        return this.zoomer().zoomFactor() != 1.0;
    }

    public boolean canAddWidget(String widget) {
        if (widget.equals(I18N.guiJ().get("tabs.run.widgets.view"))) {
            return !this.hasView();
        }
        if (widget.equals(I18N.guiJ().get("tabs.run.widgets.plot"))) {
            return this.workspace.plotManager().getPlotNames().length > 0;
        }
        return true;
    }

    protected strictfp class WidgetCreationMenuItem
    extends JMenuItem {
        WidgetCreationMenuItem(String displayName, final String name, final int x2, final int y) {
            super(displayName);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WidgetPanel.this.createWidget(name, x2, y);
                }
            });
        }
    }
}

