/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.util.Map;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.Program;
import org.nlogo.api.Token;
import org.nlogo.api.TokenizerInterface;
import org.nlogo.api.Version$;
import org.nlogo.compiler.AgentTypeChecker;
import org.nlogo.compiler.ArgumentStuffer;
import org.nlogo.compiler.Assembler;
import org.nlogo.compiler.CarefullyVisitor;
import org.nlogo.compiler.Compiler$;
import org.nlogo.compiler.ConstantFolder;
import org.nlogo.compiler.ExpressionParser;
import org.nlogo.compiler.IdentifierParser;
import org.nlogo.compiler.LocalsVisitor;
import org.nlogo.compiler.Optimizer;
import org.nlogo.compiler.ProcedureDefinition;
import org.nlogo.compiler.ReferenceVisitor;
import org.nlogo.compiler.SetVisitor;
import org.nlogo.compiler.SimpleOfVisitor;
import org.nlogo.compiler.StructureParser;
import org.nlogo.compiler.TaskVisitor;
import org.nlogo.nvm.GeneratorInterface;
import org.nlogo.nvm.Procedure;
import org.nlogo.util.Femto$;
import scala.Option;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompilerMain$
implements ScalaObject {
    public static final CompilerMain$ MODULE$;

    static {
        new CompilerMain$();
    }

    public Seq<Procedure> compile(String source$1, Option<String> displayName, Program program$1, boolean subprogram$1, Map<String, Procedure> oldProcedures$1, ExtensionManager extensionManager$1) {
        TokenizerInterface tokenizer = program$1.is3D() ? Compiler$.MODULE$.Tokenizer3D() : Compiler$.MODULE$.Tokenizer2D();
        StructureParser.Results structureResults$1 = new StructureParser(tokenizer.tokenize(source$1), displayName, program$1, oldProcedures$1, extensionManager$1, tokenizer).parse(subprogram$1);
        ArrayBuffer<ProcedureDefinition> defs$1 = new ArrayBuffer<ProcedureDefinition>();
        Iterator<Object> taskNumbers$1 = package$.MODULE$.Iterator().from(1);
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(structureResults$1.procedures().values()).asScala()).foreach(new Serializable(program$1, subprogram$1, oldProcedures$1, structureResults$1, defs$1, taskNumbers$1){
            public static final long serialVersionUID;
            private final Program program$1;
            private final boolean subprogram$1;
            private final Map oldProcedures$1;
            private final StructureParser.Results structureResults$1;
            private final ArrayBuffer defs$1;
            private final Iterator taskNumbers$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ArrayBuffer<ProcedureDefinition> apply(Procedure procedure) {
                procedure.topLevel = this.subprogram$1;
                Seq<Token> tokens = new IdentifierParser(this.program$1, this.oldProcedures$1, this.structureResults$1.procedures(), false).process(((IterableLike)this.structureResults$1.tokens().apply(procedure)).iterator(), procedure);
                return this.defs$1.$plus$plus$eq((TraversableOnce)new ExpressionParser(procedure, this.taskNumbers$1).parse(tokens));
            }
            {
                this.program$1 = program;
                this.subprogram$1 = bl;
                this.oldProcedures$1 = map2;
                this.structureResults$1 = results;
                this.defs$1 = arrayBuffer;
                this.taskNumbers$1 = iterator2;
            }
        });
        defs$1.foreach(new Serializable(program$1){
            public static final long serialVersionUID;
            private final Program program$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ProcedureDefinition procdef) {
                procdef.accept(new ReferenceVisitor());
                procdef.accept(new ConstantFolder());
                procdef.accept(new SimpleOfVisitor());
                procdef.accept(new TaskVisitor());
                procdef.accept(new LocalsVisitor());
                procdef.accept(new SetVisitor());
                procdef.accept(new CarefullyVisitor());
                procdef.accept(new Optimizer(this.program$1.is3D()));
            }
            {
                this.program$1 = program;
            }
        });
        new AgentTypeChecker(defs$1).parse();
        defs$1.foreach(new Serializable(source$1, extensionManager$1){
            public static final long serialVersionUID;
            private final String source$1;
            private final ExtensionManager extensionManager$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ProcedureDefinition procdef) {
                procdef.accept(new ArgumentStuffer());
                new Assembler().assemble(procdef);
                if (Version$.MODULE$.useGenerator()) {
                    procdef.procedure().code = Femto$.MODULE$.get(GeneratorInterface.class, "org.nlogo.generator.Generator", new Object[]{this.source$1, procdef.procedure(), BoxesRunTime.boxToBoolean(this.extensionManager$1.profilingEnabled())}).generate();
                }
            }
            {
                this.source$1 = string2;
                this.extensionManager$1 = extensionManager;
            }
        });
        return (Seq)((TraversableLike)defs$1.map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Procedure apply(ProcedureDefinition procedureDefinition) {
                return procedureDefinition.procedure();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).filterNot(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Procedure procedure) {
                return procedure.isTask();
            }
        });
    }

    private CompilerMain$() {
        MODULE$ = this;
    }
}

