/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.event.TextListener;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.nlogo.editor.Colorizer;
import org.nlogo.editor.HighlightView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp class HighlightEditorKit<TokenType>
extends DefaultEditorKit
implements ViewFactory,
DocumentListener {
    private final TextListener listener;
    private JEditorPane pane;
    private final Colorizer<TokenType> colorizer;

    HighlightEditorKit(TextListener listener, Colorizer<TokenType> colorizer) {
        this.listener = listener;
        this.colorizer = colorizer;
    }

    @Override
    public void install(JEditorPane pane) {
        this.pane = pane;
    }

    @Override
    public ViewFactory getViewFactory() {
        return this;
    }

    @Override
    public View create(Element elem2) {
        return new HighlightView<TokenType>(this.pane, elem2, this.colorizer);
    }

    @Override
    public Document createDefaultDocument() {
        PlainDocument doc = new PlainDocument();
        doc.addDocumentListener(this);
        return doc;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.listener != null) {
            this.listener.textValueChanged(null);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.listener != null) {
            this.listener.textValueChanged(null);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.listener != null) {
            this.listener.textValueChanged(null);
        }
    }
}

