/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.nlogo.editor.Colorizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp class HighlightView<TokenType>
extends PlainView {
    private final JEditorPane pane;
    private final Colorizer<TokenType> colorizer;
    private int lineStart;
    private Color[] charColors;
    private static final boolean LEAVE_COLORS_ALONE = System.getProperty("os.name").startsWith("Mac");
    private static final Color SELECTED_BACKGROUND_COLOR = HighlightView.retrieveDefaultUIColor("textHighlight", Color.BLUE);
    private static final Color UNSELECTED_TEXT_COLOR = HighlightView.retrieveDefaultUIColor("textText", Color.BLACK);
    private static final Color SELECTED_TEXT_COLOR = HighlightView.retrieveDefaultUIColor("textHighlightText", Color.WHITE);

    HighlightView(JEditorPane pane, Element element, Colorizer<TokenType> colorizer) {
        super(element);
        this.pane = pane;
        this.colorizer = colorizer;
    }

    @Override
    protected void drawLine(int lineIndex, Graphics g, int x2, int y) {
        try {
            this.studyLine(lineIndex);
            super.drawLine(lineIndex, g, x2, y);
        }
        catch (BadLocationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void studyLine(int lineIndex) throws BadLocationException {
        Element element = this.getElement().getElement(lineIndex);
        PlainDocument doc = (PlainDocument)this.getDocument();
        Segment text2 = this.getLineBuffer();
        this.lineStart = element.getStartOffset();
        int lineEnd = element.getEndOffset();
        int length = lineEnd - this.lineStart;
        if (length < 0) {
            length = 0;
        }
        doc.getText(this.lineStart, length, text2);
        this.charColors = this.colorizer.getCharacterColors(text2.toString());
    }

    @Override
    protected int drawUnselectedText(Graphics g, int x2, int y, int p0, int p1) throws BadLocationException {
        return this.drawText(g, x2, y, p0, p1, false);
    }

    @Override
    protected int drawSelectedText(Graphics g, int x2, int y, int p0, int p1) throws BadLocationException {
        return this.drawText(g, x2, y, p0, p1, true);
    }

    private int drawText(Graphics g, int x2, int y, int p0, int p1, boolean isSelected) throws BadLocationException {
        PlainDocument doc = (PlainDocument)this.getDocument();
        Segment text2 = this.getLineBuffer();
        while (p0 < p1) {
            doc.getText(p0, 1, text2);
            Color color = this.charColors[p0 - this.lineStart];
            if (!this.pane.isEnabled()) {
                color = this.lightenColor(color, 0.5f);
            }
            g.setColor(isSelected && !LEAVE_COLORS_ALONE ? this.selectedColor(color) : color);
            x2 = Utilities.drawTabbedText(text2, x2, y, g, (TabExpander)this, p0);
            ++p0;
        }
        return x2;
    }

    private static Color retrieveDefaultUIColor(String propertyName, Color fallBack) {
        Color col = UIManager.getDefaults().getColor(propertyName);
        if (col == null) {
            return fallBack;
        }
        return col;
    }

    private Color selectedColor(Color color) {
        if (color.getRGB() == UNSELECTED_TEXT_COLOR.getRGB()) {
            return SELECTED_TEXT_COLOR;
        }
        if (this.isDarkSelectionColor()) {
            return this.lightenColor(color, 0.75f);
        }
        return this.darkenColor(color, 0.75f);
    }

    private boolean isDarkSelectionColor() {
        int blue;
        int green;
        int red = SELECTED_BACKGROUND_COLOR.getRed();
        return red + (green = SELECTED_BACKGROUND_COLOR.getGreen()) + (blue = SELECTED_BACKGROUND_COLOR.getBlue()) < 375;
    }

    private Color lightenColor(Color color, float amount) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return new Color((int)((float)red + (float)(255 - red) * amount), (int)((float)green + (float)(255 - green) * amount), (int)((float)blue + (float)(255 - blue) * amount));
    }

    private Color darkenColor(Color color, float amount) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return new Color((int)((float)red * amount), (int)((float)green * amount), (int)((float)blue * amount));
    }
}

