/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.client;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp class TimedSet
extends AbstractSet<Object> {
    private final List<Object> contents;
    private final Map<Object, TimeStamp> timestamps;
    private final long idleLifetime;

    public TimedSet(long idleLifetime) {
        this.idleLifetime = idleLifetime;
        this.contents = new ArrayList<Object>();
        this.timestamps = new HashMap<Object, TimeStamp>();
    }

    public TimedSet(long idleLifetime, int initialCapacity) {
        this.idleLifetime = idleLifetime;
        this.contents = new ArrayList<Object>(initialCapacity);
        this.timestamps = new HashMap<Object, TimeStamp>(initialCapacity);
    }

    @Override
    public synchronized boolean add(Object o) {
        if (!this.touch(o)) {
            this.contents.add(o);
            this.timestamps.put(o, new TimeStamp());
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean remove(Object o) {
        return this.timestamps.remove(o) != null && this.contents.remove(o);
    }

    public Object get(int index) {
        return this.contents.get(index);
    }

    @Override
    public synchronized void clear() {
        this.contents.clear();
        this.timestamps.clear();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.timestamps.containsKey(o);
    }

    @Override
    public synchronized int size() {
        return this.contents.size();
    }

    @Override
    public synchronized Iterator<Object> iterator() {
        return this.contents.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.contents.toArray();
    }

    public synchronized boolean touch(Object o) {
        TimeStamp ts = this.timestamps.get(o);
        if (ts != null) {
            ts.modified = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public synchronized int expire() {
        long now = System.currentTimeMillis();
        Iterator<Object> it = this.iterator();
        int expired = 0;
        while (it.hasNext()) {
            Object o = it.next();
            TimeStamp ts = this.timestamps.get(o);
            if (now - ts.modified <= this.idleLifetime) continue;
            this.timestamps.remove(o);
            it.remove();
            ++expired;
        }
        return expired;
    }

    public synchronized long getModifiedTime(Object o) {
        TimeStamp ts = this.timestamps.get(o);
        if (ts == null) {
            throw new NoSuchElementException("TimedSet does not contain " + o);
        }
        return ts.modified;
    }

    public synchronized long getAddedTime(Object o) {
        TimeStamp ts = this.timestamps.get(o);
        if (ts == null) {
            throw new NoSuchElementException("TimedSet does not contain " + o);
        }
        return ts.created;
    }

    private strictfp static class TimeStamp {
        public long created;
        public long modified;

        public TimeStamp() {
            this.modified = this.created = System.currentTimeMillis();
        }
    }
}

