/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.mirroring;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class Overridable {
    private final RollbackStack rollbackStack = new RollbackStack();

    abstract String getMethodName(int var1);

    public void set(int var, Object value2) {
        try {
            String methodName = this.getMethodName(var);
            Method getter2 = this.getClass().getMethod(methodName, new Class[0]);
            Method setter2 = this.getSetter(methodName, value2.getClass());
            Object oldValue = getter2.invoke((Object)this, new Object[0]);
            this.rollbackStack.push(this.getSetter(methodName, oldValue.getClass()), oldValue);
            setter2.invoke((Object)this, value2);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private Method getSetter(String methodName, Class<? extends Object> class1) throws NoSuchMethodException {
        try {
            return this.getClass().getMethod(methodName, class1);
        }
        catch (NoSuchMethodException ex) {
            return this.getClass().getMethod(methodName, Object.class);
        }
    }

    public static int getOverrideIndex(String[] variables, String varName) {
        for (int i = 0; i < variables.length; ++i) {
            if (!varName.equalsIgnoreCase(variables[i])) continue;
            return i;
        }
        return -1;
    }

    public void rollback() {
        this.rollbackStack.rollback(this);
    }

    private strictfp class RollbackStack {
        private final LinkedList<Method> methodStack = new LinkedList();
        private final LinkedList<Object> valueStack = new LinkedList();

        private RollbackStack() {
        }

        void push(Method setter2, Object value2) {
            this.methodStack.addLast(setter2);
            this.valueStack.addLast(value2);
        }

        void rollback(Object owner) {
            try {
                while (!this.methodStack.isEmpty()) {
                    this.methodStack.removeLast().invoke(owner, this.valueStack.removeLast());
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

