/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.server;

import java.util.concurrent.LinkedBlockingQueue;
import org.nlogo.agent.Link;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.Agent;
import org.nlogo.api.HubNetInterface;
import org.nlogo.api.Shape;
import org.nlogo.hubnet.connection.ConnectionInterface;
import org.nlogo.hubnet.connection.HubNetException;
import org.nlogo.hubnet.connection.MessageEnvelope;
import org.nlogo.hubnet.mirroring.Agent;
import org.nlogo.hubnet.mirroring.HubNetDrawingMessage;
import org.nlogo.hubnet.mirroring.HubNetLine;
import org.nlogo.hubnet.mirroring.HubNetLinkStamp;
import org.nlogo.hubnet.mirroring.HubNetTurtleStamp;
import org.nlogo.hubnet.mirroring.OverrideList;
import org.nlogo.hubnet.server.ConnectionManager;
import org.nlogo.hubnet.server.HubNetUtils$;
import org.nlogo.hubnet.server.ServerPlotManager;
import org.nlogo.util.Exceptions$;
import org.nlogo.workspace.AbstractWorkspaceScala;
import scala.Function0;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.Numeric$IntIsIntegral$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0011ea!B\u0001\u0003\u0003\u0003Y!!\u0004%vE:+G/T1oC\u001e,'O\u0003\u0002\u0004\t\u000511/\u001a:wKJT!!\u0002\u0004\u0002\r!,(M\\3u\u0015\t9\u0001\"A\u0003oY><wNC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0015\u0001A\u0002\u0006\u000e!!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\r\t\u0007/[\u0005\u00033Y\u0011q\u0002S;c\u001d\u0016$\u0018J\u001c;fe\u001a\f7-\u001a\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0011\t!bY8o]\u0016\u001cG/[8o\u0013\tyBDA\nD_:tWm\u0019;j_:Le\u000e^3sM\u0006\u001cW\r\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u0013]|'o[:qC\u000e,\u0007CA\u0015,\u001b\u0005Q#BA\u0014\u0007\u0013\ta#F\u0001\fBEN$(/Y2u/>\u00148n\u001d9bG\u0016\u001c6-\u00197b\u0011\u0015q\u0003\u0001\"\u00010\u0003\u0019a\u0014N\\5u}Q\u0011\u0001G\r\t\u0003c\u0001i\u0011A\u0001\u0005\u0006O5\u0002\r\u0001\u000b\u0005\bi\u0001\u0011\rQ\"\u00016\u0003E\u0019wN\u001c8fGRLwN\\'b]\u0006<WM]\u000b\u0002mA\u0011\u0011gN\u0005\u0003q\t\u0011\u0011cQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0011\u001dQ\u0004A1A\u0005\u0002m\nqBT(`\t\u0006#\u0016iX,B\u0013RKejR\u000b\u0002yA\u0011Q\"P\u0005\u0003}9\u0011aa\u0015;sS:<\u0007B\u0002!\u0001A\u0003%A(\u0001\tO\u001f~#\u0015\tV!`/\u0006KE+\u0013(HA!9!\t\u0001b\u0001\n\u0003Y\u0014a\u0004(P?\u0012\u000bE+Q0G\u000bR\u001b\u0005*\u0012#\t\r\u0011\u0003\u0001\u0015!\u0003=\u0003Aquj\u0018#B)\u0006{f)\u0012+D\u0011\u0016#\u0005\u0005C\u0004G\u0001\t\u0007I\u0011A\u001e\u0002\u001b9{Ek\u0018'P\u000f\u001e+EiX%O\u0011\u0019A\u0005\u0001)A\u0005y\u0005qaj\u0014+`\u0019>;u)\u0012#`\u0013:\u0003\u0003b\u0002&\u0001\u0005\u0004%\tbS\u0001\r[\u0016\u001c8/Y4fg2K7\u000f^\u000b\u0002\u0019B\u0019QJ\u0015+\u000e\u00039S!a\u0014)\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002R!\u0005!Q\u000f^5m\u0013\t\u0019fJA\nMS:\\W\r\u001a\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0002VG:\u0011a+\u0019\b\u0003/\u0002t!\u0001W0\u000f\u0005esfB\u0001.^\u001b\u0005Y&B\u0001/\u000b\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003;\u0011I!A\u0019\u000f\u0002\u001f5+7o]1hK\u0016sg/\u001a7pa\u0016L!\u0001Z3\u0003\u001f5+7o]1hK\u0016sg/\u001a7pa\u0016T!A\u0019\u000f\t\r\u001d\u0004\u0001\u0015!\u0003M\u00035iWm]:bO\u0016\u001cH*[:uA!9\u0011\u000e\u0001a\u0001\n\u0013Q\u0017aD7fgN\fw-Z#om\u0016dw\u000e]3\u0016\u0003QCq\u0001\u001c\u0001A\u0002\u0013%Q.A\nnKN\u001c\u0018mZ3F]Z,Gn\u001c9f?\u0012*\u0017\u000f\u0006\u0002ocB\u0011\u0011e\\\u0005\u0003a\n\u0012A!\u00168ji\"9!o[A\u0001\u0002\u0004!\u0016a\u0001=%c!1A\u000f\u0001Q!\nQ\u000b\u0001#\\3tg\u0006<W-\u00128wK2|\u0007/\u001a\u0011\t\u000bY\u0004A\u0011A<\u0002\u001d\u0015t\u0017/^3vK6+7o]1hKR\u0011a\u000e\u001f\u0005\u0006sV\u0004\r\u0001V\u0001\b[\u0016\u001c8/Y4f\u0011\u0015Y\b\u0001\"\u0001}\u00039iWm]:bO\u0016<\u0016-\u001b;j]\u001e,\u0012! \t\u0003CyL!a \u0012\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0011a\u00068v[\n,'o\u00144NKN\u001c\u0018mZ3t/\u0006LG/\u001b8h+\t\t9\u0001E\u0002\"\u0003\u0013I1!a\u0003#\u0005\rIe\u000e\u001e\u0005\u0007\u0003\u001f\u0001A\u0011\u0001?\u0002\u0019\u0015tG/\u001a:NKN\u001c\u0018mZ3)\r\u00055\u00111CA\r!\r\t\u0013QC\u0005\u0004\u0003/\u0011#A\u0002;ie><8o\t\u0002\u0002\u001cA\u00191$!\b\n\u0007\u0005}ADA\bIk\ntU\r^#yG\u0016\u0004H/[8o\u0011\u0019\t\u0019\u0003\u0001C\u0001y\u0006YQ\r_5u\u001b\u0016\u001c8/Y4fQ\u0019\t\t#a\u0005\u0002\u001a!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0012\u0001\u00044fi\u000eDW*Z:tC\u001e,G#\u00018)\r\u0005\u001d\u00121CA\r\u0011\u001d\t\t\u0004\u0001C\u0001\u0003g\t!bZ3u\u001b\u0016\u001c8/Y4f+\u0005a\u0001FBA\u0018\u0003'\tI\u0002C\u0004\u0002:\u0001!\t!a\u000f\u0002!\u001d,G/T3tg\u0006<WmU8ve\u000e,WCAA\u001f!\u0011\ty$!\u0012\u000f\u0007\u0005\n\t%C\u0002\u0002D\t\na\u0001\u0015:fI\u00164\u0017b\u0001 \u0002H)\u0019\u00111\t\u0012)\r\u0005]\u00121CA\r\u0011\u001d\ti\u0005\u0001C\u0001\u0003w\tQbZ3u\u001b\u0016\u001c8/Y4f)\u0006<\u0007FBA&\u0003'\tI\u0002\u0003\u0004\u0002T\u0001!IA[\u0001\u0013O\u0016$X*Z:tC\u001e,WI\u001c<fY>\u0004X\r\u000b\u0004\u0002R\u0005M\u0011\u0011\u0004\u0005\b\u00033\u0002A\u0011AA.\u0003\u0011\u0019XM\u001c3\u0015\u000f9\fi&a\u001d\u0002x!A\u0011qLA,\u0001\u0004\t\t'A\u0003o_\u0012,7\u000f\u0005\u0004\u0002d\u00055\u0014Q\b\b\u0005\u0003K\nIGD\u0002[\u0003OJ\u0011aI\u0005\u0004\u0003W\u0012\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003_\n\tHA\u0002TKFT1!a\u001b#\u0011!\t)(a\u0016A\u0002\u0005u\u0012a\u0001;bO\"9\u00110a\u0016A\u0002\u0005e\u0004cA\u0011\u0002|%\u0019\u0011Q\u0010\u0012\u0003\u0007\u0005s\u0017\u0010\u000b\u0004\u0002X\u0005M\u0011\u0011\u0004\u0005\b\u0003\u0007\u0003A\u0011BAC\u0003e\u0019\u0018.\\;mCR,g)Y5mK\u0012,\u00050\u001b;NKN\u001c\u0018mZ3\u0015\u00079\f9\t\u0003\u0005\u0002\n\u0006\u0005\u0005\u0019AA\u001f\u0003!\u0019G.[3oi&#\u0007bBA-\u0001\u0011\u0005\u0011Q\u0012\u000b\b{\u0006=\u00151SAK\u0011!\t\t*a#A\u0002\u0005u\u0012\u0001\u00028pI\u0016D\u0001\"!\u001e\u0002\f\u0002\u0007\u0011Q\b\u0005\bs\u0006-\u0005\u0019AA=Q\u0019\tY)a\u0005\u0002\u001a!9\u00111\u0014\u0001\u0005\u0002\u0005u\u0015aD:f]\u0012,6/\u001a:NKN\u001c\u0018mZ3\u0015\u000b9\fy*!)\t\u0011\u0005}\u0013\u0011\u0014a\u0001\u0003CB\u0001\"a)\u0002\u001a\u0002\u0007\u0011QH\u0001\u0005i\u0016DH\u000fC\u0004\u0002(\u0002!\t!!+\u0002)\t\u0014x.\u00193dCN$Xk]3s\u001b\u0016\u001c8/Y4f)\rq\u00171\u0016\u0005\t\u0003[\u000b)\u000b1\u0001\u0002>\u0005\u0019Qn]4\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\u0006A1/\u001a8e)\u0016DH\u000fF\u0003o\u0003k\u000b9\f\u0003\u0005\u0002`\u0005=\u0006\u0019AA1\u0011!\t\u0019+a,A\u0002\u0005u\u0002bBA^\u0001\u0011\u0005\u0011QX\u0001\nG2,\u0017M\u001d+fqR$2A\\A`\u0011!\ty&!/A\u0002\u0005\u0005\u0004bBAb\u0001\u0011\u0005\u0011QY\u0001\nEJ|\u0017\rZ2bgR$RA\\Ad\u0003\u0013D\u0001\"!\u001e\u0002B\u0002\u0007\u0011Q\b\u0005\bs\u0006\u0005\u0007\u0019AA=Q\u0019\t\t-a\u0005\u0002\u001a!9\u00111\u0019\u0001\u0005\u0002\u0005=Gc\u00018\u0002R\"A\u0011QVAg\u0001\u0004\tI\b\u000b\u0004\u0002N\u0006M\u0011\u0011\u0004\u0005\b\u0003/\u0004A\u0011AA\u0016\u0003I\u0011'o\\1eG\u0006\u001cHo\u00117fCJ$V\r\u001f;\t\u000f\u0005m\u0007\u0001\"\u0003\u0002,\u0005\u00112\r[3dWJ+hN\\5oON#\u0018\r^;tQ\u0019\tI.a\u0005\u0002\u001a!9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\u0018AE:fi\u000ec\u0017.\u001a8u\u0013:$XM\u001d4bG\u0016$RA\\As\u0003SD\u0001\"a:\u0002`\u0002\u0007\u0011QH\u0001\u000eS:$XM\u001d4bG\u0016$\u0016\u0010]3\t\u0011\u0005-\u0018q\u001ca\u0001\u0003[\fQ\"\u001b8uKJ4\u0017mY3J]\u001a|\u0007CBA2\u0003_\f\u00190\u0003\u0003\u0002r\u0006E$\u0001C%uKJ\f'\r\\3\u0011\u0007\u0005\n)0C\u0002\u0002x\n\u0012a!\u00118z%\u00164\u0007FBAp\u0003'\tI\u0002C\u0004\u0002~\u0002!\t!a@\u0002\u001b%\u001cxJ^3se&$\u0017M\u00197f)\u0015i(\u0011\u0001B\u0012\u0011!\u0011\u0019!a?A\u0002\t\u0015\u0011!C1hK:$H+\u001f9fa\u0011\u00119A!\u0005\u0011\r\u0005}\"\u0011\u0002B\u0007\u0013\u0011\u0011Y!a\u0012\u0003\u000b\rc\u0017m]:\u0011\t\t=!\u0011\u0003\u0007\u0001\t!\u0011\u0019\"a?\u0003\u0002\tU!aA0%cE!!q\u0003B\u000f!\r\t#\u0011D\u0005\u0004\u00057\u0011#a\u0002(pi\"Lgn\u001a\t\u0004+\t}\u0011b\u0001B\u0011-\t)\u0011iZ3oi\"A!QEA~\u0001\u0004\ti$A\u0004wCJt\u0015-\\3\t\u000f\t%\u0002\u0001\"\u0001\u0003,\u0005\u00012/\u001a8e\u001fZ,'O]5eK2K7\u000f\u001e\u000b\n]\n5\"\u0011\u0007B\u001f\u0005\u007fA\u0001Ba\f\u0003(\u0001\u0007\u0011QH\u0001\u0007G2LWM\u001c;\t\u0011\t\r!q\u0005a\u0001\u0005g\u0001DA!\u000e\u0003:A1\u0011q\bB\u0005\u0005o\u0001BAa\u0004\u0003:\u0011A!1\bB\u0014\u0005\u0003\u0011)BA\u0002`IIB\u0001B!\n\u0003(\u0001\u0007\u0011Q\b\u0005\t\u0005\u0003\u00129\u00031\u0001\u0003D\u0005IqN^3se&$Wm\u001d\t\t\u0003\u007f\u0011)E!\u0013\u0002t&!!qIA$\u0005\ri\u0015\r\u001d\t\u0004\u001b\t-\u0013b\u0001B'\u001d\t!Aj\u001c8h\u0011\u001d\u0011\t\u0006\u0001C\u0001\u0005'\nQb\u00197fCJ|e/\u001a:sS\u0012,G#\u00038\u0003V\t]#1\rB3\u0011!\u0011yCa\u0014A\u0002\u0005u\u0002\u0002\u0003B\u0002\u0005\u001f\u0002\rA!\u00171\t\tm#q\f\t\u0007\u0003\u007f\u0011IA!\u0018\u0011\t\t=!q\f\u0003\t\u0005C\u0012yE!\u0001\u0003\u0016\t\u0019q\fJ\u001a\t\u0011\t\u0015\"q\na\u0001\u0003{A\u0001B!\u0011\u0003P\u0001\u0007!q\r\t\u0007\u0003G\niG!\u0013\t\u000f\t-\u0004\u0001\"\u0001\u0003n\u0005\u00112\r\\3be>3XM\u001d:jI\u0016d\u0015n\u001d;t)\rq'q\u000e\u0005\t\u0005_\u0011I\u00071\u0001\u0002>!9!1\u000f\u0001\u0005\u0002\tU\u0014\u0001F:f]\u0012\fu-\u001a8u!\u0016\u00148\u000f]3di&4X\rF\u0007o\u0005o\u0012IH! \u0003\n\nE%1\u0014\u0005\t\u0005_\u0011\t\b1\u0001\u0002>!A!1\u0010B9\u0001\u0004\t9!A\u0006qKJ\u001c\b/Z2uSZ,\u0007\u0002\u0003B\u0002\u0005c\u0002\rAa 1\t\t\u0005%Q\u0011\t\u0007\u0003\u007f\u0011IAa!\u0011\t\t=!Q\u0011\u0003\t\u0005\u000f\u0013\tH!\u0001\u0003\u0016\t\u0019q\f\n\u001b\t\u0011\t-%\u0011\u000fa\u0001\u0005\u001b\u000b!!\u001b3\u0011\u0007\u0005\u0012y)C\u0002\u0003N\tB\u0001Ba%\u0003r\u0001\u0007!QS\u0001\u0007e\u0006$\u0017.^:\u0011\u0007\u0005\u00129*C\u0002\u0003\u001a\n\u0012a\u0001R8vE2,\u0007b\u0002BO\u0005c\u0002\r!`\u0001\u000bg\u0016\u0014h/\u001a:N_\u0012,\u0007B\u0002BQ\u0001\u0011EA0A\tt_6,gj\u001c3fg\"\u000bg/\u001a,jK^DqA!*\u0001\t\u0013\u00119+\u0001\u000bce>\fGmY1tiZKWm^'fgN\fw-\u001a\u000b\u0004]\n%\u0006\u0002\u0003BV\u0005G\u0003\r!!\u001f\u0002\u0007=\u0014'\u000eC\u0004\u00030\u0002!\tA!-\u0002\u0011M,g\u000e\u001a'j]\u0016$rB\u001cBZ\u0005o\u0013YLa0\u0003D\n\u001d'1\u001a\u0005\t\u0005k\u0013i\u000b1\u0001\u0003\u0016\u0006\u0011\u0001\u0010\r\u0005\t\u0005s\u0013i\u000b1\u0001\u0003\u0016\u0006\u0011\u0011\u0010\r\u0005\t\u0005{\u0013i\u000b1\u0001\u0003\u0016\u0006\u0011\u00010\r\u0005\t\u0005\u0003\u0014i\u000b1\u0001\u0003\u0016\u0006\u0011\u00110\r\u0005\t\u0005\u000b\u0014i\u000b1\u0001\u0002z\u0005)1m\u001c7pe\"A!\u0011\u001aBW\u0001\u0004\u0011)*\u0001\u0003tSj,\u0007\u0002\u0003Bg\u0005[\u0003\r!!\u0010\u0002\t5|G-\u001a\u0005\b\u0005#\u0004A\u0011\u0001Bj\u0003%\u0019XM\u001c3Ti\u0006l\u0007\u000fF\u0003o\u0005+\u0014I\u000e\u0003\u0005\u0003X\n=\u0007\u0019\u0001B\u000f\u0003\u0015\tw-\u001a8u\u0011\u001d\u0011YNa4A\u0002u\fQ!\u001a:bg\u0016DqAa8\u0001\t\u0003\tY#A\u0005tK:$7\t\\3be\"9!1\u001d\u0001\u0005\u0002\t\u0015\u0018aD4fi>+H/U;fk\u0016\u001c\u0016N_3\u0016\u0005\tU\u0005F\u0002Bq\u0003'\tI\u0002C\u0004\u0003l\u0002!\t!!\u0002\u0002\u001d\u001d,G/\u00138Rk\u0016,XmU5{K\"2!\u0011^A\n\u00033AqA!=\u0001\t\u0003\u0011\u00190A\u0004dY&,g\u000e^:\u0016\u0005\tU\bCBA2\u0003_\fi\u0004C\u0004\u0003z\u0002!\tAa?\u0002\t-L7m\u001b\u000b\u0004]\nu\b\u0002\u0003B\u0000\u0005o\u0004\r!!\u0010\u0002\rU\u001cXM]%e\u0011\u001d\u0019\u0019\u0001\u0001C\u0001\u0003W\tqa[5dW\u0006cG\u000eC\u0004\u0004\b\u0001!\ta!\u0003\u0002!M,GOV5fo6K'O]8sS:<Gc\u00018\u0004\f!91QBB\u0003\u0001\u0004i\u0018!B8o\u001f\u001a4\u0007bBB\t\u0001\u0011\u000511C\u0001\u0011g\u0016$\b\u000b\\8u\u001b&\u0014(o\u001c:j]\u001e$2A\\B\u000b\u0011\u001d\u0019iaa\u0004A\u0002uDqa!\u0007\u0001\t\u0003\u0019Y\"\u0001\bxC&$hi\u001c:DY&,g\u000e^:\u0015\r\ru11EB\u0014!\u0019\t3qD?\u0002\b%\u00191\u0011\u0005\u0012\u0003\rQ+\b\u000f\\33\u0011!\u0019)ca\u0006A\u0002\u0005\u001d\u0011a\u00058v[\u000ec\u0017.\u001a8ugR{w+Y5u\r>\u0014\b\u0002CB\u0015\u0007/\u0001\rA!$\u0002\u001bQLW.Z8vi6KG\u000e\\5t\u0011\u001d\u0019i\u0003\u0001C\u0001\u0007_\tqb^1ji\u001a{'/T3tg\u0006<Wm\u001d\u000b\u0007\u0007;\u0019\td!\u000e\t\u0011\rM21\u0006a\u0001\u0003\u000f\tAC\\;n\u001b\u0016\u001c8/Y4fgR{w+Y5u\r>\u0014\b\u0002CB\u0015\u0007W\u0001\rA!$\t\u000f\re\u0002\u0001\"\u0003\u0004<\u0005iq/Y5u\r>\u0014XI^3oiN$ba!\u0010\u0004J\r5C\u0003BB\u000f\u0007\u007fA\u0011b!\u0011\u00048\u0011\u0005\raa\u0011\u0002!\r,(O]3oi:+X.\u0012<f]R\u001c\b#B\u0011\u0004F\u0005\u001d\u0011bAB$E\tAAHY=oC6,g\b\u0003\u0005\u0004L\r]\u0002\u0019AA\u0004\u0003IqW/\\#wK:$8\u000fV8XC&$hi\u001c:\t\u0011\r%2q\u0007a\u0001\u0005\u001bCqa!\u0015\u0001\t\u0013\u0019\u0019&A\u0006qY>$X*\u00198bO\u0016\u0014XCAB+!\r\t4qK\u0005\u0004\u00073\u0012!!E*feZ,'\u000f\u00157pi6\u000bg.Y4fe\"91Q\f\u0001\u0005\n\u0005-\u0012\u0001\u0005:fg\u0016$\b\u000b\\8u\u001b\u0006t\u0017mZ3s\u0011\u001d\u0019\t\u0007\u0001C\u0001\u0007G\n\u0011#\u00193e\u001d\u0006\u0014(o\\<dCN$\b\u000b\\8u)\ri8Q\r\u0005\t\u0007O\u001ay\u00061\u0001\u0002>\u0005A\u0001\u000f\\8u\u001d\u0006lW\rC\u0004\u0004l\u0001!\ta!\u001c\u0002\tAdw\u000e\u001e\u000b\u0006]\u000e=4\u0011\u000f\u0005\t\u0003\u0013\u001bI\u00071\u0001\u0002>!A11OB5\u0001\u0004\u0011)*A\u0001z\u0011\u001d\u0019Y\u0007\u0001C\u0001\u0007o\"rA\\B=\u0007w\u001ay\b\u0003\u0005\u0002\n\u000eU\u0004\u0019AA\u001f\u0011!\u0019ih!\u001eA\u0002\tU\u0015!\u0001=\t\u0011\rM4Q\u000fa\u0001\u0005+Cqaa!\u0001\t\u0003\u0019))A\u0005dY\u0016\f'\u000f\u00157piR\u0019ana\"\t\u0011\u0005%5\u0011\u0011a\u0001\u0003{Aqaa#\u0001\t\u0003\u0019i)A\u0006qY>$\b+\u001a8E_^tG#\u00028\u0004\u0010\u000eE\u0005\u0002CAE\u0007\u0013\u0003\r!!\u0010\t\u000f\rM5\u0011\u0012a\u0001{\u00069\u0001/\u001a8E_^t\u0007bBBL\u0001\u0011\u00051\u0011T\u0001\u000fg\u0016$\b\u000b\\8u!\u0016tWj\u001c3f)\u0015q71TBO\u0011!\tIi!&A\u0002\u0005u\u0002\u0002CBP\u0007+\u0003\r!a\u0002\u0002\u0017Adw\u000e\u001e)f]6{G-\u001a\u0005\b\u0007G\u0003A\u0011ABS\u0003M\u0019X\r\u001e%jgR|wM]1n\u001dVl')\u0019:t)\u0015q7qUBU\u0011!\tIi!)A\u0002\u0005u\u0002\u0002CBV\u0007C\u0003\r!a\u0002\u0002\u00079,X\u000eC\u0004\u00040\u0002!\ta!-\u0002%M,G\u000f\u00157piB+g.\u00138uKJ4\u0018\r\u001c\u000b\u0006]\u000eM6Q\u0017\u0005\t\u0003\u0013\u001bi\u000b1\u0001\u0002>!A1qWBW\u0001\u0004\u0011)*\u0001\u0005j]R,'O^1m\u0011\u0019\u0019Y\f\u0001C\u0001y\u0006ia/[3x\u0013N4\u0016n]5cY\u0016D\u0001ba0\u0001\u0001\u0004%I\u0001`\u0001\u000f?\u001a\u0014\u0018-\\3t'.L\u0007\u000f]3e\u0011%\u0019\u0019\r\u0001a\u0001\n\u0013\u0019)-\u0001\n`MJ\fW.Z:TW&\u0004\b/\u001a3`I\u0015\fHc\u00018\u0004H\"A!o!1\u0002\u0002\u0003\u0007Q\u0010C\u0004\u0004L\u0002\u0001\u000b\u0015B?\u0002\u001f}3'/Y7fgN[\u0017\u000e\u001d9fI\u0002Bqaa4\u0001\t\u0003\tY#A\u0007ge\u0006lWm]*lSB\u0004X\r\u001a\u0005\u0007\u0007'\u0004A\u0011\u0001?\u0002\r%\u001cH)Z1e\u0011\u001d\u00199\u000e\u0001C\u0001\u00073\f\u0001\u0003]1j]RLU.\\3eS\u0006$X\r\\=\u0015\u00079\u001cY\u000eC\u0004\u0004^\u000eU\u0007\u0019A?\u0002\u000b\u0019|'oY3\t\u000f\r\u0005\b\u0001\"\u0001\u0002,\u0005\u0001\u0013N\\2sK6,g\u000e^1m+B$\u0017\r^3Ge>lWI^3oiRC'/Z1e\u0011\u001d\u0019)\u000f\u0001C\u0001\u0003W\tqA]3qC&tG\u000f\u0003\u0004\u0004j\u0002!\t\u0001`\u0001\f[>,8/Z%og&$W\rC\u0004\u0004n\u0002!\tA!:\u0002\u00135|Wo]3Y\u0007>\u0014\bbBBy\u0001\u0011\u0005!Q]\u0001\n[>,8/Z-D_JDaa!>\u0001\t\u0003a\u0018!C7pkN,Gi\\<o\u0011\u001d\u0019I\u0010\u0001C\u0001\u0003W\taB]3tKRlu.^:f\u0007>\u00148\u000fC\u0004\u0004~\u0002!\taa@\u0002\u0019MD\u0017\r]3DQ\u0006tw-\u001a3\u0015\u00079$\t\u0001\u0003\u0005\u0005\u0004\rm\b\u0019\u0001C\u0003\u0003\u0015\u0019\b.\u00199f!\r)BqA\u0005\u0004\t\u00131\"!B*iCB,\u0007b\u0002C\u0007\u0001\u0011\u0005AqB\u0001\u0011CB\u0004H.\u001f(fo\u001a{g\u000e^*ju\u0016$RA\u001cC\t\t+A\u0001\u0002b\u0005\u0005\f\u0001\u0007\u0011qA\u0001\tM>tGoU5{K\"AAq\u0003C\u0006\u0001\u0004\t9!\u0001\u0003{_>l\u0007")
public abstract class HubNetManager
implements HubNetInterface,
ConnectionInterface,
ScalaObject {
    public final AbstractWorkspaceScala org$nlogo$hubnet$server$HubNetManager$$workspace;
    private final String NO_DATA_WAITING;
    private final String NO_DATA_FETCHED;
    private final String NOT_LOGGED_IN;
    private final LinkedBlockingQueue<MessageEnvelope.MessageEnvelope> messagesList;
    private MessageEnvelope.MessageEnvelope messageEnvelope;
    private boolean _framesSkipped;
    private volatile int bitmap$init$0;

    public abstract ConnectionManager connectionManager();

    public String NO_DATA_WAITING() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.NO_DATA_WAITING;
        }
        throw new UninitializedFieldError("Uninitialized field: HubNetManager.scala: 20".toString());
    }

    public String NO_DATA_FETCHED() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.NO_DATA_FETCHED;
        }
        throw new UninitializedFieldError("Uninitialized field: HubNetManager.scala: 24".toString());
    }

    public String NOT_LOGGED_IN() {
        if ((this.bitmap$init$0 & 4) != 0) {
            return this.NOT_LOGGED_IN;
        }
        throw new UninitializedFieldError("Uninitialized field: HubNetManager.scala: 29".toString());
    }

    public LinkedBlockingQueue<MessageEnvelope.MessageEnvelope> messagesList() {
        if ((this.bitmap$init$0 & 8) != 0) {
            return this.messagesList;
        }
        throw new UninitializedFieldError("Uninitialized field: HubNetManager.scala: 31".toString());
    }

    private MessageEnvelope.MessageEnvelope messageEnvelope() {
        if ((this.bitmap$init$0 & 0x10) != 0) {
            return this.messageEnvelope;
        }
        throw new UninitializedFieldError("Uninitialized field: HubNetManager.scala: 32".toString());
    }

    private void messageEnvelope_$eq(MessageEnvelope.MessageEnvelope messageEnvelope) {
        this.messageEnvelope = messageEnvelope;
        this.bitmap$init$0 |= 0x10;
    }

    @Override
    public void enqueueMessage(MessageEnvelope.MessageEnvelope message) {
        this.messagesList().put(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean messageWaiting() {
        if (!this.messagesList().isEmpty()) return true;
        BoxedUnit exceptionResult1 = null;
        try {
            LinkedBlockingQueue<MessageEnvelope.MessageEnvelope> linkedBlockingQueue = this.messagesList();
            synchronized (linkedBlockingQueue) {
                this.messagesList().wait(50L);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_2
                exceptionResult1 = boxedUnit;
            }
        }
        catch (InterruptedException interruptedException) {
            Exceptions$.MODULE$.ignore(interruptedException);
            exceptionResult1 = BoxedUnit.UNIT;
        }
        if (!this.messagesList().isEmpty()) return true;
        return false;
    }

    @Override
    public int numberOfMessagesWaiting() {
        return this.messagesList().size();
    }

    @Override
    public boolean enterMessage() throws HubNetException {
        this.checkRunningStatus();
        return this.getMessageEnvelope().isEnterMessage();
    }

    @Override
    public boolean exitMessage() throws HubNetException {
        this.checkRunningStatus();
        return this.getMessageEnvelope().isExitMessage();
    }

    @Override
    public void fetchMessage() throws HubNetException {
        this.checkRunningStatus();
        this.messageEnvelope_$eq(null);
        if (this.messagesList().isEmpty()) {
            throw new HubNetException(this.NO_DATA_WAITING());
        }
        this.messageEnvelope_$eq(this.messagesList().take());
    }

    @Override
    public Object getMessage() throws HubNetException {
        return this.getMessageEnvelope().getMessage();
    }

    @Override
    public String getMessageSource() throws HubNetException {
        return this.getMessageEnvelope().getSource();
    }

    @Override
    public String getMessageTag() throws HubNetException {
        return this.getMessageEnvelope().getTag();
    }

    private MessageEnvelope.MessageEnvelope getMessageEnvelope() throws HubNetException {
        this.checkRunningStatus();
        if (this.messageEnvelope() == null) {
            throw new HubNetException(this.NO_DATA_FETCHED());
        }
        return this.messageEnvelope();
    }

    @Override
    public void send(Seq<String> nodes, String tag$1, Object message$1) throws HubNetException {
        this.checkRunningStatus();
        nodes.foreach(new Serializable(this, tag$1, message$1){
            public static final long serialVersionUID;
            private final HubNetManager $outer;
            private final String tag$1;
            private final Object message$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String node) {
                if (!this.$outer.send(node, this.tag$1, this.message$1)) {
                    this.$outer.org$nlogo$hubnet$server$HubNetManager$$simulateFailedExitMessage(node);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.tag$1 = string2;
                this.message$1 = object;
            }
        });
    }

    public final void org$nlogo$hubnet$server$HubNetManager$$simulateFailedExitMessage(String clientId) {
        this.enqueueMessage(new MessageEnvelope.ExitMessageEnvelope(clientId));
    }

    @Override
    public boolean send(String node, String tag, Object message) throws HubNetException {
        return this.connectionManager().send(node, tag, message);
    }

    @Override
    public void sendUserMessage(Seq<String> nodes, String text$1) {
        nodes.foreach(new Serializable(this, text$1){
            public static final long serialVersionUID;
            private final HubNetManager $outer;
            private final String text$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String node) {
                if (!this.$outer.connectionManager().sendUserMessage(node, this.text$1)) {
                    this.$outer.org$nlogo$hubnet$server$HubNetManager$$simulateFailedExitMessage(node);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.text$1 = string2;
            }
        });
    }

    @Override
    public void broadcastUserMessage(String msg) {
        if (this.connectionManager().isRunning()) {
            this.connectionManager().broadcastUserMessage(msg);
        }
    }

    @Override
    public void sendText(Seq<String> nodes, String text$2) {
        nodes.foreach(new Serializable(this, text$2){
            public static final long serialVersionUID;
            private final HubNetManager $outer;
            private final String text$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String node) {
                if (!this.$outer.connectionManager().sendTextMessage(node, this.text$2)) {
                    this.$outer.org$nlogo$hubnet$server$HubNetManager$$simulateFailedExitMessage(node);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.text$2 = string2;
            }
        });
    }

    @Override
    public void clearText(Seq<String> nodes) {
        nodes.foreach(new Serializable(this){
            public static final long serialVersionUID;
            private final HubNetManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String node) {
                if (!this.$outer.connectionManager().sendClearTextMessage(node)) {
                    this.$outer.org$nlogo$hubnet$server$HubNetManager$$simulateFailedExitMessage(node);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void broadcast(String tag, Object message) throws HubNetException {
        if (this.connectionManager().isRunning()) {
            this.connectionManager().broadcast(tag, message);
        }
    }

    @Override
    public void broadcast(Object msg) throws HubNetException {
        if (this.connectionManager().isRunning()) {
            this.connectionManager().broadcast(msg);
        }
    }

    @Override
    public void broadcastClearText() {
        if (this.connectionManager().isRunning()) {
            this.connectionManager().broadcastClearTextMessage();
        }
    }

    private void checkRunningStatus() throws HubNetException {
        if (this.connectionManager().isRunning()) {
            return;
        }
        throw new HubNetException(this.NOT_LOGGED_IN());
    }

    @Override
    public void setClientInterface(String interfaceType, Iterable<Object> interfaceInfo) throws HubNetException {
        this.connectionManager().setClientInterface(interfaceType, interfaceInfo);
        this.resetPlotManager();
    }

    @Override
    public boolean isOverridable(Class<? extends Agent> agentType, String varName) {
        return OverrideList.getOverrideIndex(Agent.AgentType.fromAgentClass(agentType), varName) != -1;
    }

    @Override
    public void sendOverrideList(String client, Class<? extends Agent> agentType, String varName, Map<Long, Object> overrides) {
        this.connectionManager().sendOverrideList(client, agentType, varName, overrides);
    }

    @Override
    public void clearOverride(String client, Class<? extends Agent> agentType, String varName, Seq<Long> overrides) {
        this.connectionManager().clearOverride(client, agentType, varName, overrides);
    }

    @Override
    public void clearOverrideLists(String client) {
        this.connectionManager().clearOverrideLists(client);
    }

    @Override
    public void sendAgentPerspective(String client, int perspective, Class<? extends Agent> agentType, long id, double radius, boolean serverMode) {
        this.connectionManager().sendAgentPerspective(client, perspective, agentType, id, radius, serverMode);
    }

    public boolean someNodesHaveView() {
        return this.connectionManager().nodesHaveView() && HubNetUtils$.MODULE$.viewMirroring();
    }

    private void broadcastViewMessage(Object obj) {
        if (this.connectionManager().isRunning() && this.someNodesHaveView()) {
            this.broadcast("VIEW", obj);
        }
    }

    @Override
    public void sendLine(double x0, double y0, double x1, double y1, Object color, double size2, String mode) {
        this.broadcastViewMessage(new HubNetLine(x0, y0, x1, y1, color, size2, mode));
    }

    @Override
    public void sendStamp(Agent agent, boolean erase) {
        Agent agent2 = agent;
        if (agent2 instanceof Turtle) {
            this.broadcastViewMessage(new HubNetTurtleStamp((Turtle)agent2, erase));
        } else if (agent2 instanceof Link) {
            this.broadcastViewMessage(new HubNetLinkStamp((Link)agent2, erase));
        }
    }

    @Override
    public void sendClear() {
        this.broadcastViewMessage(new HubNetDrawingMessage(HubNetDrawingMessage.Type.CLEAR));
    }

    @Override
    public double getOutQueueSize() throws HubNetException {
        this.checkRunningStatus();
        Iterable<Object> queueSizes = this.connectionManager().clientSendQueueSizes();
        int totalClients = queueSizes.size();
        int totalQueueSize = BoxesRunTime.unboxToInt(queueSizes.sum(Numeric$IntIsIntegral$.MODULE$));
        return totalClients == 0 ? 0.0 : (double)(totalQueueSize / totalClients);
    }

    @Override
    public int getInQueueSize() throws HubNetException {
        this.checkRunningStatus();
        return this.messagesList().size();
    }

    @Override
    public Iterable<String> clients() {
        return this.connectionManager().clients().keys();
    }

    @Override
    public void kick(String userId) {
        this.connectionManager().removeClient(userId, true, "Kicked out.");
    }

    @Override
    public void kickAll() {
        this.connectionManager().removeAllClients();
    }

    @Override
    public void setViewMirroring(boolean onOff) {
        HubNetUtils$.MODULE$.viewMirroring_$eq(onOff);
    }

    @Override
    public void setPlotMirroring(boolean onOff) {
        HubNetUtils$.MODULE$.plotMirroring_$eq(onOff);
    }

    @Override
    public Tuple2<Object, Object> waitForClients(int numClientsToWaitFor, long timeoutMillis) {
        return this.waitForEvents(numClientsToWaitFor, timeoutMillis, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final HubNetManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.org$nlogo$hubnet$server$HubNetManager$$workspace.getHubNetManager().clients().size();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    @Override
    public Tuple2<Object, Object> waitForMessages(int numMessagesToWaitFor, long timeoutMillis) {
        return this.waitForEvents(numMessagesToWaitFor, timeoutMillis, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final HubNetManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.org$nlogo$hubnet$server$HubNetManager$$workspace.getHubNetManager().getInQueueSize();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    private Tuple2<Object, Object> waitForEvents(int numEventsToWaitFor, long timeoutMillis$1, Function0<Object> currentNumEvents) {
        long start$1 = System.currentTimeMillis();
        World world = this.org$nlogo$hubnet$server$HubNetManager$$workspace.world;
        synchronized (world) {
            while (true) {
                int numNow;
                if ((numNow = currentNumEvents.apply$mcI$sp()) >= numEventsToWaitFor) {
                    return new Tuple2<Object, Object>(BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToInteger(numNow));
                }
                if (this.timedOut$1(timeoutMillis$1, start$1)) {
                    return new Tuple2<Object, Object>(BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToInteger(numNow));
                }
                this.org$nlogo$hubnet$server$HubNetManager$$workspace.world.wait(25L);
            }
        }
    }

    private ServerPlotManager plotManager() {
        return this.connectionManager().plotManager();
    }

    private void resetPlotManager() {
        this.plotManager().initPlotListeners();
    }

    @Override
    public boolean addNarrowcastPlot(String plotName) {
        return this.plotManager().addNarrowcastPlot(plotName);
    }

    @Override
    public void plot(String clientId, double y) {
        this.plotManager().narrowcastPlot(clientId, y);
    }

    @Override
    public void plot(String clientId, double x2, double y) {
        this.plotManager().narrowcastPlot(clientId, x2, y);
    }

    @Override
    public void clearPlot(String clientId) {
        this.plotManager().narrowcastClear(clientId);
    }

    @Override
    public void plotPenDown(String clientId, boolean penDown) {
        this.plotManager().narrowcastPenDown(clientId, penDown);
    }

    @Override
    public void setPlotPenMode(String clientId, int plotPenMode) {
        this.plotManager().narrowcastPlotPenMode(clientId, plotPenMode);
    }

    @Override
    public void setHistogramNumBars(String clientId, int num) {
        this.plotManager().narrowcastSetHistogramNumBars(clientId, num);
    }

    @Override
    public void setPlotPenInterval(String clientId, double interval) {
        this.plotManager().narrowcastSetInterval(clientId, interval);
    }

    @Override
    public boolean viewIsVisible() {
        return this.someNodesHaveView();
    }

    private boolean _framesSkipped() {
        if ((this.bitmap$init$0 & 0x20) != 0) {
            return this._framesSkipped;
        }
        throw new UninitializedFieldError("Uninitialized field: HubNetManager.scala: 282".toString());
    }

    private void _framesSkipped_$eq(boolean bl) {
        this._framesSkipped = bl;
        this.bitmap$init$0 |= 0x20;
    }

    @Override
    public void framesSkipped() {
        this._framesSkipped_$eq(true);
    }

    @Override
    public boolean isDead() {
        return false;
    }

    @Override
    public void paintImmediately(boolean force2) {
        if (force2 || this._framesSkipped()) {
            this.incrementalUpdateFromEventThread();
        }
    }

    @Override
    public void incrementalUpdateFromEventThread() {
        if (this.someNodesHaveView() && this.connectionManager().isRunning()) {
            this.connectionManager().incrementalViewUpdate();
        }
        this._framesSkipped_$eq(false);
    }

    @Override
    public void repaint() {
    }

    @Override
    public boolean mouseInside() {
        return false;
    }

    @Override
    public double mouseXCor() {
        return 0.0;
    }

    @Override
    public double mouseYCor() {
        return 0.0;
    }

    @Override
    public boolean mouseDown() {
        return false;
    }

    @Override
    public void resetMouseCors() {
    }

    @Override
    public void shapeChanged(Shape shape2) {
    }

    @Override
    public void applyNewFontSize(int fontSize, int zoom) {
    }

    private final boolean timedOut$1(long l, long l2) {
        return System.currentTimeMillis() - l2 > l;
    }

    public HubNetManager(AbstractWorkspaceScala workspace) {
        this.org$nlogo$hubnet$server$HubNetManager$$workspace = workspace;
        this.NO_DATA_WAITING = "There is no data waiting.  Always check for data using HUBNET-MESSAGE-WAITING? before fetching data with HUBNET-FETCH-MESSAGE.";
        this.bitmap$init$0 |= 1;
        this.NO_DATA_FETCHED = "The data has not been fetched.  Always fetch the data with HUBNET-FETCH-MESSAGE before you try to access the data with HUBNET-MESSAGE or HUBNET-MESSAGE-SOURCE or HUBNET-MESSAGE-TAG";
        this.bitmap$init$0 |= 2;
        this.NOT_LOGGED_IN = "Not logged in.  Please use the hubnet-reset command.";
        this.bitmap$init$0 |= 4;
        this.messagesList = new LinkedBlockingQueue();
        this.bitmap$init$0 |= 8;
        this.messageEnvelope = null;
        this.bitmap$init$0 |= 0x10;
        this._framesSkipped = true;
        this.bitmap$init$0 |= 0x20;
    }
}

