/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import org.apache.http.client.HttpClient;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.nlogo.mc.Image;
import org.nlogo.mc.ImageException;
import org.nlogo.mc.LoadingDialog;
import org.nlogo.mc.Month;
import org.nlogo.mc.MultiPartPostRequest;
import org.nlogo.mc.Person;
import org.nlogo.mc.SexOfPerson;

public strictfp abstract class CreateUserRequest
extends MultiPartPostRequest {
    private JDialog loadingDialog;
    private String invalid;
    private Frame frame;

    public CreateUserRequest(HttpClient http, Frame frame, String firstName, String lastName, String emailAddress, SexOfPerson sexOfPerson, String country, Integer birthdayYear, Month birthdayMonth, Integer birthdayDay, String password, Image profilePicture) {
        super(http, "http://modelingcommons.org/account/create");
        this.frame = frame;
        this.addStringParam("new_person[first_name]", firstName);
        this.addStringParam("new_person[last_name]", lastName);
        this.addStringParam("new_person[email_address]", emailAddress);
        this.addStringParam("new_person[sex]", sexOfPerson.toString());
        this.addStringParam("new_person[country_name]", country);
        String birthdayYearString = "";
        if (birthdayYear != null) {
            birthdayYearString = birthdayYear.toString();
        }
        String birthdayMonthString = "";
        if (birthdayMonth != null) {
            birthdayMonthString = "" + birthdayMonth.getMonthNum();
        }
        String birthdayDayString = "";
        if (birthdayDay != null) {
            birthdayDayString = birthdayDay.toString();
        }
        this.addStringParam("new_person[birthdate(1i)]", birthdayYearString);
        this.addStringParam("new_person[birthdate(2i)]", birthdayMonthString);
        this.addStringParam("new_person[birthdate(3i)]", birthdayDayString);
        this.addStringParam("new_person[password]", password);
        this.addStringParam("new_person[registration_consent]", "1");
        if (profilePicture != null) {
            try {
                ByteArrayOutputStream profilePictureStream = new ByteArrayOutputStream();
                BufferedImage image = profilePicture.getImage();
                if (image == null) {
                    this.invalid = "INVALID_PROFILE_PICTURE";
                } else {
                    ImageIO.write((RenderedImage)image, "png", profilePictureStream);
                    this.addFileParam("new_person[avatar]", profilePictureStream.toByteArray(), firstName + "_" + lastName + ".png");
                }
            }
            catch (ImageException e) {
                this.invalid = "INVALID_PROFILE_PICTURE";
            }
            catch (IOException e) {
                this.invalid = "INVALID_PROFILE_PICTURE";
            }
        }
    }

    protected void onReturn(String response) {
        this.loadingDialog.dispose();
        if (response == null) {
            this.onCreateUser("CONNECTION_ERROR", null);
            return;
        }
        JSONParser json = new JSONParser();
        try {
            JSONObject obj = (JSONObject)json.parse(response);
            String status = (String)obj.get((Object)"status");
            Person person = null;
            if (status.equals("SUCCESS")) {
                JSONObject personObj = (JSONObject)obj.get((Object)"person");
                person = new Person((String)personObj.get((Object)"first_name"), (String)personObj.get((Object)"last_name"), ((Number)personObj.get((Object)"id")).intValue(), (String)personObj.get((Object)"avatar"), (String)personObj.get((Object)"email_address"));
            }
            this.onCreateUser(status, person);
        }
        catch (ParseException e) {
            this.onCreateUser("INVALID_RESPONSE_FROM_SERVER", null);
        }
    }

    public void execute() {
        if (this.invalid != null) {
            this.onCreateUser(this.invalid, null);
            return;
        }
        this.loadingDialog = new LoadingDialog(this.frame, "Creating account on Modeling Commons");
        super.execute();
        this.loadingDialog.setVisible(true);
    }

    protected abstract void onCreateUser(String var1, Person var2);
}

