/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.awt.Frame;
import javax.swing.JDialog;
import org.apache.http.client.HttpClient;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.nlogo.mc.LoadingDialog;
import org.nlogo.mc.PostRequest;

public strictfp abstract class LogoutRequest
extends PostRequest {
    private JDialog loadingDialog;
    private Frame frame;

    public LogoutRequest(HttpClient http, Frame frame) {
        super(http, "http://modelingcommons.org/account/logout");
        this.frame = frame;
    }

    protected void onReturn(String response) {
        this.loadingDialog.dispose();
        if (response == null) {
            this.onLogout("CONNECTION_ERROR", false);
            return;
        }
        JSONParser json = new JSONParser();
        try {
            JSONObject obj = (JSONObject)json.parse(response);
            String status = (String)obj.get((Object)"status");
            if (status.equals("SUCCESS") || status.equals("NOT_LOGGED_IN")) {
                this.onLogout("SUCCESS", true);
            } else {
                this.onLogout(status, false);
            }
        }
        catch (ParseException e) {
            this.onLogout("INVALID_RESPONSE_FROM_SERVER", false);
        }
    }

    public void execute() {
        this.loadingDialog = new LoadingDialog(this.frame, "Logging out of Modeling Commons");
        super.execute();
        this.loadingDialog.setVisible(true);
    }

    protected abstract void onLogout(String var1, boolean var2);
}

