/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.awt.Frame;
import javax.swing.JDialog;
import org.apache.http.client.HttpClient;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.nlogo.mc.LoadingDialog;
import org.nlogo.mc.MultiPartPostRequest;
import org.nlogo.mc.NewModelType;

public strictfp abstract class UpdateModelRequest
extends MultiPartPostRequest {
    private JDialog loadingDialog;
    private String invalid;
    private Frame frame;

    public UpdateModelRequest(HttpClient http, Frame frame, int existingModelId, String newModelName, String modelBody, String description, NewModelType newModelType) {
        super(http, "http://modelingcommons.org/upload/update_model");
        this.frame = frame;
        if (newModelType != NewModelType.NEW_VERSION && newModelType != NewModelType.CHILD) {
            throw new IllegalArgumentException("Invalid upload type - must be child or new version");
        }
        this.addStringParam("new_version[name]", newModelName);
        this.addStringParam("new_version[description]", description);
        this.addStringParam("new_version[node_id]", "" + existingModelId);
        this.addStringParam("fork", newModelType.toString());
        String modelName = newModelType == NewModelType.NEW_VERSION ? "" + existingModelId + "_new" : newModelName;
        this.addFileParam("new_version[uploaded_body]", modelBody, modelName + ".nlogo");
    }

    protected void onReturn(String response) {
        this.loadingDialog.dispose();
        if (response == null) {
            this.onUploaded("CONNECTION_ERROR", null, null);
            return;
        }
        JSONParser json = new JSONParser();
        try {
            JSONObject obj = (JSONObject)json.parse(response);
            String status = (String)obj.get((Object)"status");
            String uploadedModelURL = null;
            String uploadedModelName = null;
            if (status.equals("SUCCESS")) {
                JSONObject model = (JSONObject)obj.get((Object)"model");
                uploadedModelURL = (String)model.get((Object)"url");
                uploadedModelName = (String)model.get((Object)"name");
            }
            this.onUploaded(status, uploadedModelURL, uploadedModelName);
        }
        catch (ParseException e) {
            this.onUploaded("INVALID_RESPONSE_FROM_SERVER", null, null);
        }
    }

    public void execute() {
        if (this.invalid != null) {
            this.onUploaded(this.invalid, null, null);
            return;
        }
        this.loadingDialog = new LoadingDialog(this.frame, "Uploading model to Modeling Commons");
        super.execute();
        this.loadingDialog.setVisible(true);
    }

    protected abstract void onUploaded(String var1, String var2, String var3);
}

