/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nlogo.api.Let;
import org.nlogo.api.SourceOwner;
import org.nlogo.api.Syntax;
import org.nlogo.api.Token;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.Workspace;
import scala.Option;
import scala.collection.JavaConversions;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Procedure {
    public final Type tyype;
    public final Token nameToken;
    public final String fileName;
    public final String name;
    public final String displayName;
    public int pos;
    public int endPos;
    public List<String> args = new ArrayList<String>();
    public String usableBy = "OTPL";
    public int localsCount = 0;
    public boolean topLevel = false;
    private SourceOwner owner;
    public final Procedure parent;
    public final ArrayBuffer<Procedure> children = new ArrayBuffer();
    public int size;
    public final ArrayBuffer<Let> taskFormals = new ArrayBuffer();
    public final List<Let> lets = new ArrayList<Let>();
    public final HashMap<Let, Integer> alteredLets = new HashMap();
    public Command[] code = new Command[0];

    public boolean isTask() {
        return this.parent != null;
    }

    public Let getTaskFormal(int n, Token token2) {
        while (this.taskFormals.size() < n) {
            this.taskFormals.$plus$eq((Object)new Let("?" + n, token2.startPos(), token2.endPos(), Collections.<Let>emptyList()));
        }
        return this.taskFormals.apply(n - 1);
    }

    public Procedure(Type tyype, Token nameToken, String name, Option<String> displayName, Procedure parent) {
        this.tyype = tyype;
        this.nameToken = nameToken;
        this.name = name;
        this.fileName = nameToken.fileName();
        this.parent = parent;
        this.displayName = this.buildDisplayName(displayName);
    }

    private String buildDisplayName(Option<String> displayName) {
        return this.isTask() ? "(command task from: " + this.parent.displayName + ")" : (displayName.isDefined() ? displayName.get() : "procedure " + this.getNameAndFile());
    }

    private String getNameAndFile() {
        if (this.fileName == null || this.fileName.length() == 0) {
            return this.name;
        }
        return this.name + " (" + this.fileName + ")";
    }

    public Syntax syntax() {
        int[] right = new int[this.args.size() - this.localsCount];
        for (int i = 0; i < right.length; ++i) {
            right[i] = Syntax.WildcardType();
        }
        switch (this.tyype) {
            case COMMAND: {
                return Syntax.commandSyntax(right);
            }
            case REPORTER: {
                return Syntax.reporterSyntax(right, Syntax.WildcardType());
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append("[");
        buf.append(this.name);
        buf.append(":");
        boolean first = true;
        for (String a : this.args) {
            buf.append(first ? "[" : " ");
            buf.append(a);
            first = false;
        }
        buf.append("]");
        buf.append(":");
        buf.append(this.usableBy);
        buf.append("]");
        return buf.toString();
    }

    public String dump() {
        StringBuilder buf = new StringBuilder();
        boolean indent2 = this.isTask();
        if (indent2) {
            buf.append("   ");
        }
        buf.append(this.displayName);
        if (this.parent != null) {
            buf.append(":" + this.parent.displayName);
        }
        buf.append(":");
        boolean first = true;
        buf.append("[");
        for (String a : this.args) {
            if (!first) {
                buf.append(" ");
            }
            buf.append(a);
            first = false;
        }
        buf.append("]{" + this.usableBy + "}:\n");
        for (int i = 0; i < this.code.length; ++i) {
            if (indent2) {
                buf.append("   ");
            }
            Command command = this.code[i];
            buf.append("[" + i + "]");
            buf.append(command.dump(indent2 ? 6 : 3));
            buf.append("\n");
        }
        for (Procedure p : JavaConversions.asJavaIterable(this.children)) {
            buf.append("\n");
            buf.append(p.dump());
        }
        return buf.toString();
    }

    public void init(Workspace workspace) {
        this.size = this.args.size();
        for (int i = 0; i < this.code.length; ++i) {
            this.code[i].init(workspace);
        }
        for (Procedure p : JavaConversions.asJavaIterable(this.children)) {
            p.init(workspace);
        }
    }

    public SourceOwner getOwner() {
        return this.owner;
    }

    public void setOwner(SourceOwner owner) {
        this.owner = owner;
        for (Procedure p : JavaConversions.asJavaIterable(this.children)) {
            p.setOwner(owner);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static enum Type {
        COMMAND,
        REPORTER;

    }
}

