/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import org.nlogo.api.Constants;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.api.World;
import org.nlogo.render.AbstractTopologyRenderer;
import org.nlogo.render.Drawable;
import org.nlogo.render.LinkDrawer;

public strictfp class BoxRenderer
extends AbstractTopologyRenderer {
    public BoxRenderer(World world) {
        super(world);
    }

    public void wrapDrawable(Drawable obj, GraphicsInterface g, double xcor, double ycor, double turtleSize, double cellSize) {
        double size2 = turtleSize * cellSize + obj.adjustSize(turtleSize, cellSize);
        double offset = size2 / 2.0;
        double x2 = this.graphicsX(xcor, cellSize) - offset;
        double y = this.graphicsY(ycor, cellSize) - offset;
        g.push();
        g.translate(x2, y);
        this.draw(obj, g, x2, y, 0.0, 0.0, size2);
        g.pop();
    }

    public void drawLabelHelper(GraphicsInterface g, double xcor, double ycor, String label, Object color, double patchSize, double size2) {
        g.push();
        double x2 = this.graphicsX(xcor + 0.5 * size2, patchSize);
        double y = this.graphicsY(ycor - 0.5 * size2, patchSize);
        g.setColor(org.nlogo.api.Color.getColor(color));
        g.drawLabel(label, x2, y, patchSize);
        g.pop();
    }

    public void fillBackground(GraphicsInterface g) {
        if (this.viewOffsetX != 0.0 || this.viewOffsetY != 0.0) {
            this.fillWith(g, Constants.ViewBackground());
        }
    }

    public void paintAllPatchesBlack(GraphicsInterface g) {
        g.setColor(Color.BLACK);
        g.fillRect(this.worldAndViewPreMultipliedX, this.worldAndViewPreMultipliedY, this.width, this.height);
    }

    public void drawLink(GraphicsInterface g, Link link, LinkDrawer.LinkDrawable drawable, double patchSize, Color color, double lineThickness) {
        int lineWidth = (int)StrictMath.max(1.0, lineThickness * patchSize);
        g.setStroke(lineWidth);
        g.setColor(color);
        drawable.draw(g, link, color, this.graphicsX(link.x1(), patchSize), this.graphicsY(link.y1(), patchSize), this.graphicsX(link.x2(), patchSize), this.graphicsY(link.y2(), patchSize), patchSize, lineThickness);
    }

    public void drawLine(GraphicsInterface g, double startX, double startY, double endX, double endY, double penSize) {
        g.drawLine(this.graphicsXNoOffset(startX, this.world.patchSize()), this.graphicsYNoOffset(startY, this.world.patchSize()), this.graphicsXNoOffset(endX, this.world.patchSize()), this.graphicsYNoOffset(endY, this.world.patchSize()));
    }
}

