/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.ShapeList;
import org.nlogo.api.Turtle;
import org.nlogo.render.Drawable;
import org.nlogo.render.TopologyRenderer;
import org.nlogo.render.TurtleShapeManager;
import org.nlogo.render.VectorShapeDrawable;
import org.nlogo.shape.VectorShape;

public strictfp class TurtleDrawer {
    private static final double MIN_PATCH_SIZE_FOR_TURTLE_SHAPES = 3.0;
    final TurtleShapeManager shapes;

    public TurtleDrawer(ShapeList shapeList) {
        this.shapes = new TurtleShapeManager(shapeList);
    }

    public void drawTurtle(GraphicsInterface g, TopologyRenderer topology, Turtle turtle2, double patchSize) {
        if (!turtle2.hidden()) {
            if (turtle2.size() * patchSize >= 3.0) {
                this.drawTurtleShape(g, topology, turtle2, patchSize);
            } else {
                topology.drawWrappedRect(g, org.nlogo.api.Color.getColor(turtle2.color()), 0.0f, turtle2.xcor(), turtle2.ycor(), turtle2.size(), patchSize, true);
            }
            if (turtle2.hasLabel()) {
                this.drawTurtleLabel(g, topology, turtle2, patchSize);
            }
        }
    }

    void drawTurtleShape(GraphicsInterface g, TopologyRenderer topology, Turtle turtle2, double patchSize) {
        Drawable d = this.getShapeFromCacheOrCreateDrawable(turtle2, patchSize, this.shapes.getShape(turtle2));
        topology.wrapDrawable(d, g, turtle2.xcor(), turtle2.ycor(), turtle2.size(), patchSize);
    }

    private Drawable getShapeFromCacheOrCreateDrawable(Turtle turtle2, double patchSize, VectorShape shape2) {
        if (this.shapes.useCache(turtle2, patchSize) && !shape2.isTooSimpleToCache()) {
            Color turtleColor = org.nlogo.api.Color.getColor(turtle2.color());
            Color fgColor = shape2.fgRecolorable() ? turtleColor : new Color(255, 255, 255, turtleColor.getAlpha());
            return this.shapes.getCachedShape(shape2, fgColor, turtle2.heading(), turtle2.size());
        }
        return new VectorShapeDrawable(shape2, org.nlogo.api.Color.getColor(turtle2.color()), patchSize, (int)turtle2.heading(), turtle2.lineThickness(), turtle2.size());
    }

    void drawTurtleWithOutline(GraphicsInterface g, TopologyRenderer topology, Turtle turtle2, double patchSize) {
        if (!turtle2.hidden()) {
            if (turtle2.size() * patchSize >= 3.0) {
                this.drawTurtleShapeWithOutline(g, topology, turtle2, patchSize);
            } else {
                this.drawWrappedRectWithOutline(g, topology, turtle2, patchSize);
            }
            if (turtle2.hasLabel()) {
                this.drawTurtleLabel(g, topology, turtle2, patchSize);
            }
        }
    }

    private void drawTurtleShapeWithOutline(GraphicsInterface g, TopologyRenderer topology, Turtle turtle2, double patchSize) {
        double turtleSize = turtle2.size();
        double xcor = turtle2.xcor();
        double ycor = turtle2.ycor();
        VectorShape shape2 = this.shapes.getShape(turtle2);
        VectorShape outline = (VectorShape)shape2.clone();
        outline.setOutline();
        double thickness = StrictMath.min(turtleSize / 5.0, 0.5);
        Color color = org.nlogo.api.Color.getColor(turtle2.color());
        int heading = (int)turtle2.heading();
        topology.wrapDrawable(new VectorShapeDrawable(outline, color, patchSize, heading, thickness, turtleSize), g, turtle2.xcor(), turtle2.ycor(), turtleSize, patchSize);
        topology.wrapDrawable(new VectorShapeDrawable(outline, org.nlogo.api.Color.getComplement(color), patchSize, heading, thickness / 2.0, turtleSize), g, xcor, ycor, turtleSize, patchSize);
        topology.wrapDrawable(new VectorShapeDrawable(shape2, color, patchSize, heading, turtle2.lineThickness(), turtleSize), g, xcor, ycor, turtleSize, patchSize);
    }

    private void drawWrappedRectWithOutline(GraphicsInterface g, TopologyRenderer topology, Turtle turtle2, double patchSize) {
        double xcor = turtle2.xcor();
        double ycor = turtle2.ycor();
        double turtleSize = turtle2.size();
        Color color = org.nlogo.api.Color.getColor(turtle2.color());
        topology.drawWrappedRect(g, color, 4.0f, xcor, ycor, turtleSize, patchSize, false);
        topology.drawWrappedRect(g, org.nlogo.api.Color.getComplement(color), 2.0f, xcor, ycor, turtleSize, patchSize, false);
        topology.drawWrappedRect(g, color, (float)turtleSize, xcor, ycor, turtleSize, patchSize, true);
    }

    private void drawTurtleLabel(GraphicsInterface g, TopologyRenderer topology, Turtle turtle2, double patchSize) {
        topology.drawLabelHelper(g, turtle2.xcor(), turtle2.ycor(), turtle2.labelString(), turtle2.labelColor(), patchSize, turtle2.size());
    }
}

