/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.framework.ViewChangeListener;
import org.jhotdraw.util.Command;
import org.jhotdraw.util.CommandMenu;
import org.jhotdraw.util.RedoCommand;
import org.jhotdraw.util.UndoCommand;
import org.jhotdraw.util.UndoManager;
import org.nlogo.api.CompilerException;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.Editable;
import org.nlogo.api.I18N;
import org.nlogo.api.SourceOwner;
import org.nlogo.api.TokenType;
import org.nlogo.awt.EventQueue;
import org.nlogo.editor.Colorizer;
import org.nlogo.sdm.Model;
import org.nlogo.sdm.Translator;
import org.nlogo.sdm.gui.AggregateDrawing;
import org.nlogo.sdm.gui.AggregateDrawingView;
import org.nlogo.sdm.gui.AggregateEditorTab;
import org.nlogo.sdm.gui.AggregateModelEditorToolBar;
import org.nlogo.sdm.gui.AggregateTabs;
import org.nlogo.sdm.gui.InspectionTool;
import org.nlogo.sdm.gui.ModelElementFigure;
import org.nlogo.sdm.gui.Wrapper;
import org.nlogo.swing.TabsMenu;
import org.nlogo.util.Exceptions;
import org.nlogo.window.EditDialogFactoryInterface;
import org.nlogo.window.ErrorLabel;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.MenuBarFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp class AggregateModelEditor
extends JFrame
implements DrawingEditor,
Event.LinkChild {
    private static final Dimension WINDOW_SIZE = new Dimension(700, 550);
    private static final Dimension VIEW_SIZE = new Dimension(800, 1000);
    private final Colorizer<TokenType> colorizer;
    private final Component linkParent;
    private final MenuBarFactory menuBarFactory;
    private final CompilerServices compiler;
    private AggregateModelEditorToolBar toolbar;
    private final UndoManager undoManager = new UndoManager();
    private Tool currentTool;
    private Tool selectionTool;
    private DrawingView view;
    private AggregateTabs tabs;
    private ErrorLabel errorLabel;
    private final EditDialogFactoryInterface dialogFactory;

    AggregateModelEditor(Component linkParent, Colorizer<TokenType> colorizer, MenuBarFactory menuBarFactory, CompilerServices compiler, EditDialogFactoryInterface dialogFactory) {
        this(linkParent, colorizer, menuBarFactory, null, compiler, dialogFactory);
    }

    AggregateModelEditor(Component linkParent, Colorizer<TokenType> colorizer, MenuBarFactory menuBarFactory, AggregateDrawing drawing, CompilerServices compiler, EditDialogFactoryInterface dialogFactory) {
        super(I18N.guiJ().get("menu.tools.systemDynamicsModeler"), linkParent.getGraphicsConfiguration());
        this.linkParent = linkParent;
        this.colorizer = colorizer;
        this.menuBarFactory = menuBarFactory;
        this.compiler = compiler;
        this.dialogFactory = dialogFactory;
        Wrapper.reset();
        this.setDefaultCloseOperation(1);
        if (drawing == null) {
            drawing = new AggregateDrawing();
        } else {
            FigureEnumeration figs = drawing.figures();
            while (figs.hasNextFigure()) {
                Figure fig = figs.nextFigure();
                if (!(fig instanceof ModelElementFigure) || ((ModelElementFigure)fig).getModelElement() == null) continue;
                drawing.getModel().addElement(((ModelElementFigure)fig).getModelElement());
            }
        }
        AggregateDrawingView drawingView = new AggregateDrawingView(this, AggregateModelEditor.VIEW_SIZE.width, AggregateModelEditor.VIEW_SIZE.height);
        drawingView.setDrawing((Drawing)drawing);
        this.open((DrawingView)drawingView);
        this.pack();
        this.setVisible(true);
    }

    void setError(SourceOwner owner, CompilerException e) {
        this.errorLabel.setError(e, owner.headerSource().length());
        this.tabs.setError(e);
    }

    Model getModel() {
        return ((AggregateDrawing)this.view().drawing()).getModel();
    }

    @Override
    public Object getLinkParent() {
        return this.linkParent;
    }

    void setToolbar(AggregateModelEditorToolBar toolbar) {
        this.toolbar = toolbar;
    }

    void inspectFigure(Figure f2) {
        try {
            Editable target = (Editable)f2;
            this.dialogFactory.canceled(this, target);
            if (f2 instanceof ModelElementFigure && ((ModelElementFigure)f2).dirty()) {
                new Events.CompileAllEvent().raise(this);
                new Events.DirtyEvent().raise(this);
            }
            f2.invalidate();
        }
        catch (ClassCastException ex) {
            Exceptions.ignore(ex);
        }
    }

    public String toNetLogoCode() {
        String src = "";
        if (this.view() != null && this.view().drawing() != null) {
            Translator translator = new Translator(this.getModel(), this.compiler);
            src = translator.source();
        }
        return src;
    }

    public void setTool(Tool t) {
        this.currentTool = t;
        if (this.tool() != null) {
            this.tool().activate();
        }
    }

    public void setSelectionTool() {
        if (this.selectionTool != null) {
            this.setTool(this.selectionTool);
        }
    }

    private void open(DrawingView view) {
        this.getContentPane().setLayout(new BorderLayout());
        this.view = view;
        this.errorLabel = new ErrorLabel();
        this.getContentPane().add((Component)this.errorLabel, "North");
        AggregateEditorTab editorTab = new AggregateEditorTab(this, (Component)view);
        this.tabs = new AggregateTabs(editorTab, this, this.colorizer);
        this.getContentPane().add((Component)this.tabs, "Center");
        JMenuBar menuBar = new JMenuBar();
        boolean isOSX = System.getProperty("os.name").startsWith("Mac");
        if (isOSX) {
            menuBar.add(this.menuBarFactory.createFileMenu());
        }
        CommandMenu editMenu = new CommandMenu(I18N.guiJ().get("menu.edit"));
        editMenu.add((Command)new UndoCommand(I18N.guiJ().get("menu.edit.undo"), (DrawingEditor)this));
        editMenu.add((Command)new RedoCommand(I18N.guiJ().get("menu.edit.redo"), (DrawingEditor)this));
        menuBar.add((JMenu)editMenu);
        if (isOSX) {
            menuBar.add(this.menuBarFactory.createToolsMenu());
            JMenu zoomMenu = menuBar.add(this.menuBarFactory.createZoomMenu());
            zoomMenu.setEnabled(false);
            menuBar.add((Component)zoomMenu);
        }
        menuBar.add(new TabsMenu(I18N.guiJ().get("menu.tabs"), this.tabs));
        if (isOSX) {
            this.menuBarFactory.addHelpMenu(menuBar);
        }
        this.setJMenuBar(menuBar);
        this.setSize(WINDOW_SIZE);
        this.setVisible(true);
        this.selectionTool = new InspectionTool(this);
        this.setTool(this.selectionTool);
        this.setVisible(true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AggregateModelEditor.this.toFront();
            }
        });
    }

    public DrawingView view() {
        return this.view;
    }

    public DrawingView[] views() {
        return new DrawingView[]{this.view()};
    }

    public Tool tool() {
        return this.currentTool;
    }

    public void toolDone() {
        this.setSelectionTool();
        this.toolbar.popButtons();
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void figureSelectionChanged(DrawingView view) {
    }

    public void showStatus(String str) {
    }

    public void addViewChangeListener(ViewChangeListener vcl) {
    }

    public void removeViewChangeListener(ViewChangeListener vcl) {
    }
}

