/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.util.StringTokenizer;
import org.nlogo.api.Constants;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.shape.Element;

public strictfp class Circle
extends Element
implements Cloneable {
    static final long serialVersionUID = 0L;
    private int x;
    private int y;
    private int xDiameter;
    private int yDiameter;

    public Circle(Point center, Point circum, Color color) {
        super(color);
        double radius = this.distance(center, circum);
        this.x = center.x - Circle.round(radius);
        this.y = center.y - Circle.round(radius);
        this.yDiameter = this.xDiameter = Circle.round(2.0 * radius);
    }

    public Circle(int x2, int y, int xDiameter, Color color) {
        super(color);
        this.x = x2;
        this.y = y;
        this.xDiameter = xDiameter;
        this.yDiameter = xDiameter;
    }

    public Point getOrigin() {
        return new Point(this.x + Circle.round(this.xDiameter / 2), this.y + Circle.round(this.yDiameter / 2));
    }

    public void setFilled(boolean fill2) {
        this.filled = fill2;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.xDiameter, this.yDiameter);
    }

    public void modify(Point center, Point circum) {
        double radius = this.distance(center, circum);
        this.x = center.x - Circle.round(radius);
        this.y = center.y - Circle.round(radius);
        this.yDiameter = this.xDiameter = Circle.round(2.0 * radius);
    }

    public void reshapeElement(Point oldPoint, Point newPoint) {
        double change = this.distance(this.getOrigin(), newPoint);
        this.x = this.getOrigin().x - (int)change;
        this.y = this.getOrigin().y - (int)change;
        this.xDiameter = (int)change * 2;
        this.yDiameter = (int)change * 2;
    }

    public void moveElement(int xOffset, int yOffset) {
        this.x += xOffset;
        this.y += yOffset;
    }

    public Point[] getHandles() {
        Point top = new Point(this.x + this.xDiameter / 2, this.y);
        Point left = new Point(this.x, this.y + this.yDiameter / 2);
        Point right = new Point(this.x + this.xDiameter, this.y + this.yDiameter / 2);
        Point bottom = new Point(this.x + this.xDiameter / 2, this.y + this.yDiameter);
        return new Point[]{top, left, right, bottom};
    }

    public boolean contains(Point p) {
        Ellipse2D.Double check2 = new Ellipse2D.Double(this.x, this.y, this.xDiameter, this.yDiameter);
        return check2.contains(p.x, p.y);
    }

    public void draw(GraphicsInterface g, Color turtleColor, double scale, double angle) {
        g.setColor(this.getColor(turtleColor));
        if (this.filled) {
            g.fillCircle(this.x, this.y, this.xDiameter, this.yDiameter, scale, angle);
        } else {
            g.drawCircle(this.x, this.y, this.xDiameter, this.yDiameter, scale, angle);
        }
    }

    public void rotateLeft() {
        int oldX = this.x;
        this.x = this.y;
        this.y = Constants.ShapeWidth() - oldX - this.yDiameter;
        int oldXDiameter = this.xDiameter;
        this.xDiameter = this.yDiameter;
        this.yDiameter = oldXDiameter;
    }

    public void rotateRight() {
        int oldX = this.x;
        this.x = Constants.ShapeWidth() - this.y - this.xDiameter;
        this.y = oldX;
        int oldXDiameter = this.xDiameter;
        this.xDiameter = this.yDiameter;
        this.yDiameter = oldXDiameter;
    }

    public void flipHorizontal() {
        this.x = Constants.ShapeWidth() - this.x - this.xDiameter;
    }

    public void flipVertical() {
        this.y = Constants.ShapeWidth() - this.y - this.yDiameter;
    }

    public String toReadableString() {
        return "Type: Circle, color: " + this.c + ",\n bounds: " + this.getBounds();
    }

    public String toString() {
        return "Circle " + this.c.getRGB() + " " + this.filled + " " + this.marked + " " + this.x + " " + this.y + " " + this.xDiameter;
    }

    public static Circle parseCircle(String text2) {
        StringTokenizer tokenizer = new StringTokenizer(text2);
        tokenizer.nextToken();
        String color = tokenizer.nextToken();
        boolean b1 = tokenizer.nextToken().equals("true");
        boolean b2 = tokenizer.nextToken().equals("true");
        int x1 = Integer.valueOf(tokenizer.nextToken());
        int y1 = Integer.valueOf(tokenizer.nextToken());
        int diam = Integer.valueOf(tokenizer.nextToken());
        if (diam == 0) {
            return null;
        }
        Circle circle = new Circle(x1, y1, diam, Color.decode(color));
        circle.setFilled(b1);
        circle.setMarked(b2);
        return circle;
    }

    public void setModifiedPoint(Point modified) {
    }
}

