/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.api.Constants;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.shape.Element;

public strictfp abstract class Curve
extends Element
implements Cloneable {
    static final long serialVersionUID = 0L;
    protected List<Integer> xcoords = new ArrayList<Integer>();
    protected List<Integer> ycoords = new ArrayList<Integer>();
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;

    public Curve(Color c) {
        super(c);
    }

    public void setFilled(boolean fill2) {
    }

    public Curve(Point start2, Point next2, Color color) {
        super(color);
        this.xcoords.add(start2.x);
        this.ycoords.add(start2.y);
        this.xcoords.add(next2.x);
        this.ycoords.add(next2.y);
        this.xmin = start2.x;
        this.xmax = start2.x;
        this.ymin = start2.y;
        this.ymax = start2.y;
        this.updateBounds(next2);
    }

    public Rectangle getBounds() {
        return this.createRect(new Point(this.xmin, this.ymin), new Point(this.xmax, this.ymax));
    }

    public void modify(Point start2, Point next2) {
        this.xcoords.add(next2.x);
        this.ycoords.add(next2.y);
        this.updateBounds(next2);
    }

    public void draw(GraphicsInterface g, Color turtleColor, double scale, double angle) {
        int[] xArray = new int[this.xcoords.size()];
        int[] yArray = new int[this.xcoords.size()];
        for (int i = 0; i < this.xcoords.size(); ++i) {
            xArray[i] = this.getElt(i, this.xcoords);
            yArray[i] = this.getElt(i, this.ycoords);
        }
        g.setColor(this.getColor());
        g.drawPolyline(xArray, yArray, this.xcoords.size());
    }

    public void rotateLeft() {
        for (int i = 0; i < this.xcoords.size(); ++i) {
            int temp = this.getElt(i, this.xcoords);
            this.xcoords.set(i, this.getElt(i, this.ycoords));
            this.ycoords.set(i, Constants.ShapeWidth() - temp);
        }
    }

    public void rotateRight() {
        for (int i = 0; i < this.xcoords.size(); ++i) {
            int temp = this.getElt(i, this.xcoords);
            this.xcoords.set(i, Constants.ShapeWidth() - this.getElt(i, this.ycoords));
            this.ycoords.set(i, temp);
        }
    }

    public void flipHorizontal() {
        for (int i = 0; i < this.xcoords.size(); ++i) {
            this.xcoords.set(i, Constants.ShapeWidth() - this.getElt(i, this.xcoords));
        }
    }

    public void flipVertical() {
        for (int i = 0; i < this.ycoords.size(); ++i) {
            this.ycoords.set(i, Constants.ShapeWidth() - this.getElt(i, this.ycoords));
        }
    }

    private void updateBounds(Point newPoint) {
        this.xmin = StrictMath.min(this.xmin, newPoint.x);
        this.xmax = StrictMath.max(this.xmax, newPoint.x);
        this.ymin = StrictMath.min(this.ymin, newPoint.y);
        this.ymax = StrictMath.max(this.ymax, newPoint.y);
    }

    public String toReadableString() {
        return "Type: Curve, color: " + this.c + ",\n bounds: " + this.getBounds();
    }
}

