/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.shape.DrawableShape;
import org.nlogo.shape.LinkLine;
import org.nlogo.shape.VectorShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class LinkShape
implements org.nlogo.api.Shape,
Cloneable,
Serializable,
DrawableShape {
    static final long serialVersionUID = 0L;
    private VectorShape directionIndicator;
    private double curviness;
    private String name = "";
    private LinkLine[] lines = new LinkLine[3];

    public LinkShape() {
        this.directionIndicator = LinkShape.getDefaultLinkDirectionShape();
        this.lines[0] = new LinkLine(-0.2, false);
        this.lines[1] = new LinkLine(0.0, true);
        this.lines[2] = new LinkLine(0.2, false);
    }

    public LinkLine getLine(int i) {
        return this.lines[i];
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setLineVisible(int index, boolean visible) {
        this.lines[index].setVisible(visible);
    }

    public void add(int index, LinkLine line) {
        this.lines[index] = line;
    }

    public void setDashiness(int index, float[] dashes) {
        this.lines[index].setDashiness(dashes);
    }

    public float[] getDashes(int index) {
        return this.lines[index].getDashes();
    }

    public double curviness() {
        return this.curviness;
    }

    public void curviness(double curviness) {
        this.curviness = curviness;
    }

    public String dashinessString(int index) {
        return this.lines[index].dashinessString();
    }

    public void setDashes(int index, String str) {
        this.lines[index].setDashes(str);
    }

    public boolean isTooSimpleToPaint() {
        return !this.lines[0].isVisible() && !this.lines[2].isVisible() && this.curviness == 0.0 && this.lines[1].isStraightPlainLine();
    }

    public org.nlogo.api.Shape getDirectionIndicator() {
        return this.directionIndicator;
    }

    public void setDirectionIndicator(VectorShape shape2) {
        this.directionIndicator = shape2;
    }

    @Override
    public void paint(GraphicsInterface g, Color color, int x2, int y, double cellSize, int angle) {
        this.paint(g, color, x2, y, cellSize / 2.0, 2.0, angle, 0.0, 0.0, true);
    }

    public void paint(GraphicsInterface g, Color color, double x2, double y, double cellSize, double size2, int angle, double lineThickness, double destSize, boolean isDirected) {
        double aR = StrictMath.toRadians(angle);
        double aSin = StrictMath.sin(aR) * size2 * cellSize;
        double aCos = StrictMath.cos(aR) * size2 * cellSize;
        this.paint(g, color, x2 + aSin + cellSize * size2 / 2.0, y + aCos, x2 + cellSize * size2 / 2.0, y, cellSize, size2, lineThickness, destSize, isDirected);
    }

    public void paint(GraphicsInterface g, Color color, double x1, double y1, double x2, double y2, double cellSize, double size2, double lineThickness, double destSize, boolean isDirected) {
        for (int i = 0; i < this.lines.length; ++i) {
            if (!this.lines[i].isVisible()) continue;
            float lt = (float)StrictMath.max(1.0, cellSize * lineThickness);
            Shape shape2 = this.lines[i].getShape(x1, y1, x2, y2, this.curviness, size2, cellSize, lt);
            this.lines[i].paint(g, color, cellSize, lt, shape2);
        }
        if (isDirected) {
            Shape arc = this.lines[1].getShape(x2, y2, x1, y1, -this.curviness, size2, cellSize, 1.0f);
            this.paintDirectionIndicator(g, color, arc, cellSize, lineThickness, size2, destSize + 1.0);
        }
    }

    public double[] getDirectionIndicatorTransform(double x1, double y1, double x2, double y2, double linkLength, double destSize, Link link, double cellSize, double size2) {
        if (this.curviness == 0.0) {
            double[] comps = new double[]{link.heading(), x2 + (x1 - x2) / linkLength * destSize * 2.0 / 3.0, y2 - (y2 - y1) / linkLength * destSize * 2.0 / 3.0};
            return comps;
        }
        Shape arc = this.lines[1].getShape(x2, y2, x1, y1, this.curviness * 3.0, linkLength, cellSize, 1.0f);
        double[] trans = this.getDirectionIndicatorTransform(arc, this.getDestShape(arc, destSize, cellSize));
        trans[0] = -trans[0] + 180.0;
        return trans;
    }

    public void paintDirectionIndicator(GraphicsInterface g, Color color, double x1, double y1, double x2, double y2, double heading, double cellSize, double lineThickness, double destSize, double linkLength) {
        double xcomp = (x1 - x2) / linkLength * destSize * 2.0 / 3.0;
        double ycomp = (y2 - y1) / linkLength * destSize * 2.0 / 3.0;
        double xmid = (x1 - x2) / 2.0;
        double ymid = (y2 - y1) / 2.0;
        if (StrictMath.abs(xmid) < StrictMath.abs(xcomp) && StrictMath.abs(ymid) < StrictMath.abs(ycomp)) {
            xcomp = xmid;
            ycomp = ymid;
        }
        double scaleFactor = this.directionIndicatorScale(lineThickness, cellSize);
        this.directionIndicator.paint(g, color, x2 + xcomp - cellSize * scaleFactor / 2.0, y2 - ycomp - cellSize * scaleFactor / 2.0, scaleFactor, cellSize, (int)heading, lineThickness);
    }

    public int numLines() {
        int numLines = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            if (!this.lines[i].isVisible()) continue;
            ++numLines;
        }
        return numLines;
    }

    public void paintDirectionIndicator(GraphicsInterface g, Color color, Shape arc, double cellSize, double lineThickness, double size2, double destSize) {
        double[] trans = this.getDirectionIndicatorTransform(arc, this.getDestShape(arc, destSize, cellSize));
        double scale = this.directionIndicatorScale(lineThickness, cellSize);
        this.directionIndicator.paint(g, color, trans[1] - cellSize * scale / 2.0, trans[2] - cellSize * scale / 2.0, scale, cellSize, (int)trans[0], lineThickness);
    }

    private double directionIndicatorScale(double lineThickness, double cellSize) {
        return (lineThickness * StrictMath.sqrt(cellSize / 2.0) + 2.0) * StrictMath.max(1.0, (double)this.numLines() / 1.5);
    }

    public Shape getDestShape(Shape arc, double size2, double cellSize) {
        PathIterator i = arc.getPathIterator(null, 1.0);
        double[] p = new double[6];
        i.currentSegment(p);
        AffineTransform trans = AffineTransform.getTranslateInstance(p[0], p[1]);
        trans.scale(cellSize, cellSize);
        trans.scale(size2, size2);
        return trans.createTransformedShape(new Ellipse2D.Double(-0.5, -0.5, 1.0, 1.0));
    }

    public double[] getDirectionIndicatorTransform(Shape arc, Shape dest) {
        double[] pts = new double[6];
        Point2D.Double p1 = null;
        Point2D.Double p2 = null;
        double[] trans = new double[3];
        PathIterator i = arc.getPathIterator(null, 1.0);
        while (!i.isDone()) {
            int ret = i.currentSegment(pts);
            if (ret == 0) {
                p2 = new Point2D.Double(pts[0], pts[1]);
            } else if (ret == 1) {
                p1 = p2;
                p2 = new Point2D.Double(pts[0], pts[1]);
                if (dest.contains(p1) && !dest.contains(p2)) {
                    trans = this.getDirectionIndicatorTransform(new Line2D.Double(p1, p2), dest);
                    break;
                }
            }
            i.next();
        }
        return trans;
    }

    public double[] getDirectionIndicatorTransform(Line2D line, Shape dest) {
        double dx = line.getX1() - line.getX2();
        double dy = line.getY1() - line.getY2();
        while (dx * dx + dy * dy > 1.0) {
            line = this.getLastOutsideSegment(line, dest);
            dx = line.getX1() - line.getX2();
            dy = line.getY1() - line.getY2();
        }
        double angle = (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(dy, dx))) % 360.0;
        return new double[]{angle, line.getX1(), line.getY1()};
    }

    protected Line2D getLastOutsideSegment(Line2D line, Shape dest) {
        Line2D.Double left = new Line2D.Double();
        Line2D.Double right = new Line2D.Double();
        do {
            this.split(line, left, right);
        } while (!dest.contains((line = left).getP2()));
        return right;
    }

    protected void split(Line2D src, Line2D left, Line2D right) {
        double x1 = src.getX1();
        double y1 = src.getY1();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double mx = x1 + (x2 - x1) / 2.0;
        double my = y1 + (y2 - y1) / 2.0;
        left.setLine(x1, y1, mx, my);
        right.setLine(mx, my, x2, y2);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public int getEditableColorIndex() {
        return 0;
    }

    public Object clone() {
        LinkShape newShape;
        try {
            newShape = (LinkShape)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
        newShape.directionIndicator = (VectorShape)this.directionIndicator.clone();
        newShape.lines = new LinkLine[this.lines.length];
        for (int i = 0; i < this.lines.length; ++i) {
            newShape.lines[i] = (LinkLine)this.lines[i].clone();
        }
        return newShape;
    }

    public String toString() {
        String str = this.name + "\n" + this.curviness + "\n";
        for (int i = 0; i < this.lines.length; ++i) {
            str = str + this.lines[i].toString() + "\n";
        }
        str = str + this.directionIndicator.toString();
        return str;
    }

    public static List<org.nlogo.api.Shape> parseShapes(String[] shapes, String version) {
        int index;
        ArrayList<org.nlogo.api.Shape> ret = new ArrayList<org.nlogo.api.Shape>();
        for (index = 0; shapes.length > index && 0 == VectorShape.getString(shapes, index).length(); ++index) {
        }
        while (shapes.length > index) {
            LinkShape shape2 = new LinkShape();
            index = LinkShape.parseShape(shapes, version, shape2, index);
            ret.add(shape2);
            ++index;
        }
        return ret;
    }

    public static int parseShape(String[] shapes, String version, LinkShape shape2, int index) {
        shape2.setName(VectorShape.getString(shapes, index++));
        shape2.curviness = Double.parseDouble(VectorShape.getString(shapes, index++));
        for (int i = 0; i < 3; ++i) {
            LinkLine line = new LinkLine();
            index = LinkLine.parseLine(shapes, version, line, index);
            shape2.add(i, line);
        }
        VectorShape indicator = new VectorShape();
        index = VectorShape.parseShape(shapes, version, indicator, index);
        shape2.setDirectionIndicator(indicator);
        return index;
    }

    public static LinkShape getDefaultLinkShape() {
        LinkShape result2 = new LinkShape();
        result2.setName("default");
        result2.setDirectionIndicator(LinkShape.getDefaultLinkDirectionShape());
        return result2;
    }

    public static VectorShape getDefaultLinkDirectionShape() {
        VectorShape result2 = new VectorShape();
        result2.setName("link direction");
        result2.setRotatable(true);
        result2.setEditableColorIndex(0);
        result2.addElement("Line -7500403 true 150 150 90 180");
        result2.addElement("Line -7500403 true 150 150 210 180");
        return result2;
    }
}

