/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape.editor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import org.nlogo.api.Shape;
import org.nlogo.api.ShapeList;
import org.nlogo.shape.ShapeChangeListener;
import org.nlogo.shape.editor.EditorDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class DrawableList
extends JList
implements EditorDialog.VectorShapeContainer {
    DefaultListModel listModel;
    final ShapeList shapeList;
    List<Shape> shapes;
    private final ShapeChangeListener shapeChangeListener;
    private Component parent;

    public DrawableList(ShapeList shapeList, ShapeChangeListener listener, int rows, int height) {
        this.shapeChangeListener = listener;
        this.shapeList = shapeList;
        this.putClientProperty("Quaqua.List.style", "striped");
        this.setVisibleRowCount(rows);
        this.listModel = new DefaultListModel();
        this.setModel(this.listModel);
        this.setFixedCellHeight(height);
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    public void update() {
        this.listModel.clear();
        this.shapes = this.shapeList.getShapes();
        for (Shape shape2 : this.shapes) {
            this.listModel.addElement(shape2.getName());
        }
    }

    @Override
    public void update(Shape originalShape, Shape newShape) {
        if (!originalShape.getName().equals(newShape.getName()) && !ShapeList.isDefaultShapeName(originalShape.getName())) {
            this.removeShape(originalShape);
        }
        this.addShape(newShape);
        this.update();
        this.selectShapeName(newShape.getName());
    }

    public void selectShapeName(String name) {
        int index = -1;
        while (++index < this.listModel.size() && !((String)this.listModel.elementAt(index)).equals(name)) {
        }
        this.addSelectionInterval(index, index);
        this.ensureIndexIsVisible(index);
    }

    public Object elementAt(int index) {
        return this.listModel.elementAt(index);
    }

    public Shape getOneSelected() {
        int[] selected = this.getSelectedIndices();
        if (selected.length == 1) {
            return this.shapes.get(selected[0]);
        }
        return null;
    }

    public Shape getShape(int index) {
        return this.shapes.get(index);
    }

    public Set<String> getShapeNames() {
        return this.shapeList.getNames();
    }

    @Override
    public boolean exists(String name) {
        return this.shapeList.exists(name);
    }

    void selectShapeIndex(int index) {
        this.addSelectionInterval(index, index);
        this.ensureIndexIsVisible(index);
    }

    List<Shape> deleteShapes() {
        int i;
        int delete2;
        int[] selected = this.getSelectedIndices();
        ArrayList<Shape> deletedShapes = new ArrayList<Shape>();
        if (selected.length > 1) {
            delete2 = JOptionPane.showConfirmDialog(this.parent, "Are you sure you want to delete these " + selected.length + " shapes?", "Delete", 0);
        } else if (selected.length == 1) {
            delete2 = JOptionPane.showConfirmDialog(this.parent, "Are you sure you want to delete this shape?", "Delete", 0);
        } else {
            return deletedShapes;
        }
        if (delete2 != 0) {
            return deletedShapes;
        }
        for (i = 0; i < selected.length; ++i) {
            if (ShapeList.isDefaultShapeName(this.shapes.get(selected[i]).getName())) continue;
            Shape shape2 = this.shapes.get(selected[i]);
            deletedShapes.add(shape2);
            this.removeShape(shape2);
        }
        for (i = selected.length - 1; i >= 0; --i) {
            if (ShapeList.isDefaultShapeName(this.shapes.get(selected[i]).getName())) continue;
            this.shapes.remove(selected[i]);
            this.listModel.remove(selected[i]);
        }
        this.selectShapeIndex(selected[0] >= this.shapes.size() ? selected[0] - 1 : selected[0]);
        return deletedShapes;
    }

    void addShape(Shape shape2) {
        if (shape2 != null) {
            Shape replacedShape = this.shapeList.add(shape2);
            if (this.shapeChangeListener != null) {
                this.shapeChangeListener.shapeChanged(replacedShape == null ? shape2 : replacedShape);
            }
        }
    }

    void removeShape(Shape shape2) {
        Shape removedShape = this.shapeList.removeShape(shape2);
        if (removedShape != null && this.shapeChangeListener != null) {
            this.shapeChangeListener.shapeRemoved(shape2);
            this.shapeChangeListener.shapeChanged(removedShape);
        }
    }
}

