/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import org.nlogo.api.I18N;
import org.nlogo.api.Shape;
import org.nlogo.api.ShapeList;
import org.nlogo.shape.editor.DrawableList;
import org.nlogo.shape.editor.ManagerDialog;
import org.nlogo.shape.editor.ShapeCellRenderer;
import org.nlogo.swing.ButtonPanel;
import org.nlogo.swing.Utils;

public strictfp class ImportDialog
extends JDialog
implements ListSelectionListener {
    final ManagerDialog manager;
    final DrawableList list;

    public ImportDialog(Frame frame, ManagerDialog manager, String[] shapes, String version, ShapeParser shapeParser) {
        super(frame, "Library", true);
        this.manager = manager;
        List<Shape> importedShapes = shapeParser.parseShapes(shapes, version);
        if (importedShapes == null) {
            this.list = null;
            this.dispose();
            return;
        }
        List<Shape> foreignShapes = ShapeList.sortShapes(importedShapes);
        if (foreignShapes == null) {
            this.list = null;
            this.dispose();
            return;
        }
        ShapeList shapeList = new ShapeList();
        shapeList.replaceShapes(foreignShapes);
        this.list = new DrawableList(shapeList, null, 10, 34);
        this.list.setParent(this);
        this.list.setCellRenderer(new ShapeCellRenderer(this.list));
        this.list.update();
        JButton importButton = new JButton("Import");
        importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.importSelectedShapes();
            }
        });
        AbstractAction cancelAction = new AbstractAction(I18N.guiJ().get("common.buttons.cancel")){

            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.dispose();
            }
        };
        JButton cancelButton = new JButton(cancelAction);
        Utils.addEscKeyAction(this, (Action)cancelAction);
        this.list.addMouseListener(new MouseInputAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ImportDialog.this.importSelectedShapes();
                }
            }
        });
        ButtonPanel panel = new ButtonPanel(new JButton[]{importButton, cancelButton});
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.getContentPane().setLayout(new BorderLayout(0, 10));
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)panel, "South");
        this.pack();
        this.setLocation(manager.getLocation().x + 10, manager.getLocation().y + 10);
        this.getRootPane().setDefaultButton(importButton);
        this.setVisible(true);
    }

    public void valueChanged(ListSelectionEvent e) {
        int[] selected = this.list.getSelectedIndices();
        if (selected.length == 1) {
            this.list.ensureIndexIsVisible(selected[0]);
        }
    }

    private void importSelectedShapes() {
        int i;
        Object[] choices = new Object[]{"Replace", "Rename", I18N.guiJ().get("common.buttons.cancel")};
        int[] selected = this.list.getSelectedIndices();
        ArrayList<Shape> shapesToAdd = new ArrayList<Shape>();
        for (i = 0; i < selected.length; ++i) {
            Shape shape2 = this.list.getShape(selected[i]);
            while (this.manager.shapesList().exists(shape2.getName())) {
                int choice = JOptionPane.showOptionDialog(this, "A shape with the name \"" + shape2.getName() + "\" already exists in this model.\n" + "Do you want to replace the existing shape or rename the imported one?", "Import", 1, 2, null, choices, choices[0]);
                if (choice == 0) {
                    shapesToAdd.add(shape2);
                    break;
                }
                if (choice == 1) {
                    String name = JOptionPane.showInputDialog(this, "Import shape as:", "Import Shapes", -1);
                    if (name == null) continue;
                    shape2.setName(name);
                    continue;
                }
                return;
            }
            shapesToAdd.add(shape2);
        }
        for (i = 0; i < shapesToAdd.size(); ++i) {
            this.manager.shapesList().addShape((Shape)shapesToAdd.get(i));
        }
        this.manager.shapesList().update();
        this.manager.shapesList().selectShapeName("default");
        this.dispose();
    }

    void sendImportWarning(String message) {
        JOptionPane.showMessageDialog(this, message, "Import", 2);
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = StrictMath.max(d.width, 260);
        return d;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ShapeParser {
        public List<Shape> parseShapes(String[] var1, String var2);
    }
}

