/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.shape.DrawableShape;
import org.nlogo.shape.editor.DrawableList;
import org.nlogo.shape.editor.EditorDialog;

public strictfp class ShapeCellRenderer
extends JPanel
implements ListCellRenderer {
    protected Object theShape;
    protected final Component shapeComponent;
    protected final Dimension dimension = new Dimension(90, 34);
    protected final JLabel shapeName = new JLabel("blah", 2);
    final DrawableList list;

    public ShapeCellRenderer(DrawableList list2) {
        this.list = list2;
        this.shapeComponent = this.getShapeComponent();
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.shapeComponent);
        this.add(Box.createHorizontalStrut(20));
        this.add(this.shapeName);
        this.add(Box.createHorizontalGlue());
    }

    public Component getShapeComponent() {
        return new Component(){

            public Dimension getMinimumSize() {
                return ShapeCellRenderer.this.dimension;
            }

            public Dimension getPreferredSize() {
                return ShapeCellRenderer.this.dimension;
            }

            public Dimension getMaximumSize() {
                return ShapeCellRenderer.this.dimension;
            }

            private void preview(Graphics2D g, Shape clip, int left, int top, int size2) {
                g.setColor(this.getForeground());
                if (((DrawableShape)ShapeCellRenderer.this.theShape).isRotatable()) {
                    g.fillOval(left - 1, top - 1, size2 + 1, size2 + 1);
                } else {
                    g.fillRect(left - 1, top - 1, size2 + 2, size2 + 2);
                }
                g.clipRect(left, top, size2, size2);
                ((DrawableShape)ShapeCellRenderer.this.theShape).paint(new Graphics2DWrapper(g), EditorDialog.getColor(((DrawableShape)ShapeCellRenderer.this.theShape).getEditableColorIndex()), left, top, size2, 0);
                g.setClip(clip);
            }

            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g.setColor(this.getBackground());
                g.fillRect(1, 1, ShapeCellRenderer.this.dimension.width - 2, ShapeCellRenderer.this.dimension.height - 2);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Shape clip = g.getClip();
                this.preview(g2, clip, 2, 12, 9);
                this.preview(g2, clip, 16, 11, 12);
                this.preview(g2, clip, 33, 7, 20);
                this.preview(g2, clip, 58, 2, 30);
            }
        };
    }

    public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
        this.theShape = this.list.getShape(index);
        this.shapeName.setText(value2.toString());
        if (isSelected) {
            this.setOpaque(true);
            this.shapeName.setForeground(list2.getSelectionForeground());
            this.setBackground(list2.getSelectionBackground());
            this.shapeComponent.setForeground(list2.getSelectionBackground());
            this.shapeComponent.setBackground(list2.getSelectionBackground());
        } else {
            this.setOpaque(false);
            this.shapeName.setForeground(list2.getForeground());
            this.setBackground(null);
            this.shapeComponent.setForeground(Color.BLACK);
            this.shapeComponent.setBackground(null);
        }
        return this;
    }
}

