/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JOptionPane;

public strictfp class BrowserLauncher {
    private BrowserLauncher() {
        throw new IllegalStateException();
    }

    public static void openURL(Component comp, String urlString, boolean local) {
        BrowserLauncher.openURL(comp, urlString, "", local);
    }

    public static void openURL(Component comp, String urlString, String anchor, boolean local) {
        try {
            if (local) {
                urlString = BrowserLauncher.makeURLFromFile(new File(urlString));
            }
            BrowserLauncher.openURL(urlString + anchor);
        }
        catch (BrowserNotFoundException ex) {
            JOptionPane.showMessageDialog(comp, ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String makeURLFromFile(File file) {
        return BrowserLauncher.makeURLFromFilePath(file.getAbsolutePath());
    }

    private static String makeURLFromFilePath(String filePath) {
        try {
            return new URI("file", filePath, null).toURL().toString();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static void openURL(String url) throws BrowserNotFoundException, IOException {
        String osName = System.getProperty("os.name");
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object result2 = desktopClass.getMethod("isDesktopSupported", new Class[0]).invoke(null, new Object[0]);
            if (result2 instanceof Boolean && ((Boolean)result2).booleanValue()) {
                Object desktop = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                desktopClass.getMethod("browse", URI.class).invoke(desktop, new URI(url));
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (osName.startsWith("Windows")) {
            Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "start", "\"\"", '\"' + url + '\"'});
        } else {
            if (osName.startsWith("Mac")) {
                throw new BrowserNotFoundException("We were unable to open a browser on your system.\nThis error can be reported to ccl-bugs@ccl.northwestern.edu");
            }
            try {
                Process process2 = Runtime.getRuntime().exec(new String[]{"firefox", "-remote", "'openURL(", url + ")'"});
                int exitCode = process2.waitFor();
                if (exitCode != 0) {
                    Runtime.getRuntime().exec(new String[]{"firefox", url});
                }
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
            catch (IOException ex) {
                throw new BrowserNotFoundException("NetLogo could not find and execute a web browser named 'firefox'.Please install Firefox and ensure that the 'firefox' command is in your executable PATH.  Firefox is available here:\n http://www.mozilla.com/firefox/\n\nThe full error message was:\n " + ex.getLocalizedMessage());
            }
        }
    }

    strictfp static class BrowserNotFoundException
    extends Exception {
        BrowserNotFoundException(String message) {
            super(message);
        }
    }
}

