/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import org.nlogo.awt.Hierarchy;
import org.nlogo.awt.UserCancelException;

public strictfp final class FileDialog {
    private static String currentDirectory = System.getProperty("user.home");
    private static final boolean MAC = System.getProperty("os.name").startsWith("Mac");
    private static final boolean LINUX = System.getProperty("os.name").startsWith("Linux");

    private FileDialog() {
        throw new IllegalStateException();
    }

    public static void setDirectory(String directory) {
        currentDirectory = directory;
    }

    public static String show(Component component, String title, int mode, String file) throws UserCancelException {
        return FileDialog.show(Hierarchy.getFrame(component), title, mode, false, file);
    }

    public static String show(Frame parentFrame, String title, int mode) throws UserCancelException {
        return FileDialog.show(parentFrame, title, mode, false);
    }

    public static String show(Frame parentFrame, String title, int mode, boolean directoriesOnly) throws UserCancelException {
        return FileDialog.show(parentFrame, title, mode, directoriesOnly, null);
    }

    private static String show(Frame parentFrame, String title, int mode, boolean directoriesOnly, String file) throws UserCancelException {
        if (LINUX) {
            int result2;
            JFileChooser chooser = new JFileChooser(currentDirectory);
            chooser.setDialogTitle(title);
            if (file != null && file.length() > 0) {
                chooser.setSelectedFile(new File(file));
            }
            if (directoriesOnly) {
                chooser.setFileSelectionMode(1);
            }
            if ((result2 = mode == 0 ? chooser.showOpenDialog(parentFrame) : chooser.showSaveDialog(parentFrame)) != 0) {
                throw new UserCancelException();
            }
            currentDirectory = FileDialog.selectedDirectory(chooser);
            return chooser.getSelectedFile().getAbsolutePath();
        }
        if (directoriesOnly) {
            JFileChooser chooser = new JFileChooser(currentDirectory);
            chooser.setFileSelectionMode(1);
            if (chooser.showOpenDialog(parentFrame) != 0) {
                throw new UserCancelException();
            }
            currentDirectory = FileDialog.selectedDirectory(chooser);
            return chooser.getSelectedFile().getAbsolutePath();
        }
        java.awt.FileDialog dialog = new java.awt.FileDialog(parentFrame, title, mode);
        if (!directoriesOnly) {
            dialog.setDirectory(currentDirectory);
            if (file != null) {
                dialog.setFile(file);
            }
        }
        dialog.setVisible(true);
        if (!directoriesOnly && dialog.getFile() == null || directoriesOnly && dialog.getDirectory() == null) {
            throw new UserCancelException();
        }
        currentDirectory = dialog.getDirectory();
        if (directoriesOnly) {
            return currentDirectory;
        }
        if (dialog.getDirectory() == null) {
            return dialog.getFile();
        }
        return dialog.getDirectory() + dialog.getFile();
    }

    private static String selectedDirectory(JFileChooser chooser) {
        File file = chooser.getSelectedFile();
        File dir = file.isDirectory() ? file : chooser.getCurrentDirectory();
        return dir.getAbsolutePath();
    }
}

