/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.nlogo.awt.Coordinates;
import org.nlogo.awt.RowLayout;
import org.nlogo.swing.WindowCloseBox;

public strictfp class WindowDragger
extends JPanel
implements MouseListener,
MouseMotionListener {
    private final JWindow window;
    private final JLabel titleLabel = new JLabel();
    private Point mousePressLoc;
    private Point mousePressAbsLoc;
    private Point locationWhenPressed;
    private final WindowCloseBox closeBox;
    private static final boolean IS_MAC = System.getProperty("os.name").startsWith("Mac");

    public void setTitle(String title) {
        this.titleLabel.setText(title);
        this.revalidate();
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public WindowDragger(JWindow window) {
        this.window = window;
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.titleLabel.setOpaque(true);
        this.titleLabel.setBackground(Color.WHITE);
        this.closeBox = new WindowCloseBox();
        if (!IS_MAC) {
            GridBagLayout gridBag = new GridBagLayout();
            this.setLayout(gridBag);
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = -1;
            gridBag.setConstraints(this.titleLabel, c);
            this.add(this.titleLabel);
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.anchor = 13;
            gridBag.setConstraints(this.closeBox, c);
            this.add(this.closeBox);
        } else {
            this.setLayout(new RowLayout(3, 0.0f, 0.5f));
            this.add(this.closeBox);
            this.add(this.titleLabel);
        }
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.titleLabel.addMouseListener(this);
        this.titleLabel.addMouseMotionListener(this);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.mousePressLoc = e.getPoint();
        this.mousePressAbsLoc = Coordinates.convertPointToScreen(this.mousePressLoc, this);
        this.locationWhenPressed = this.window.getLocationOnScreen();
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.inCloseBox(this.mousePressLoc)) {
            Point dragAbsLoc = Coordinates.convertPointToScreen(e.getPoint(), this);
            GraphicsConfiguration gc = this.getGraphicsConfiguration();
            Rectangle bounds = gc.getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width = bounds.width - insets.left - insets.right;
            bounds.height = bounds.height - insets.top - insets.bottom;
            int x2 = this.locationWhenPressed.x + (dragAbsLoc.x - this.mousePressAbsLoc.x);
            int y = this.locationWhenPressed.y + (dragAbsLoc.y - this.mousePressAbsLoc.y);
            x2 = StrictMath.max(bounds.x, StrictMath.min(x2, bounds.width + bounds.x));
            y = StrictMath.max(bounds.y, StrictMath.min(y, bounds.height + bounds.y));
            this.window.setLocation(x2, y);
        }
    }

    private boolean inCloseBox(Point p) {
        return p != null && p.x >= 7 && p.x <= 13 && p.y >= 2 && p.y <= 8;
    }

    public JButton getCloseBox() {
        return this.closeBox;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.BLACK);
        for (int x2 = 1; x2 < this.getWidth(); x2 += 2) {
            for (int y = 1; y < this.getHeight(); y += 2) {
                g.fillRect(x2, y, 1, 1);
            }
        }
    }
}

