/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import org.nlogo.api.Editable;
import org.nlogo.api.I18N;
import org.nlogo.api.Property;
import org.nlogo.awt.Fonts;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.Properties;
import org.nlogo.window.SingleErrorWidget;
import org.nlogo.window.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class DummyButtonWidget
extends SingleErrorWidget
implements Editable {
    private char actionKey = '\u0000';
    private boolean keyEnabled = false;
    private String name = "";

    public DummyButtonWidget() {
        this.setBackground(InterfaceColors.BUTTON_BACKGROUND);
        this.setBorder(this.widgetBorder());
        Fonts.adjustDefaultFont(this);
    }

    @Override
    public List<Property> propertySet() {
        return Properties.dummyButton();
    }

    public char actionKey() {
        return this.actionKey;
    }

    public void actionKey(char actionKey2) {
        this.actionKey = actionKey2;
    }

    private String actionKeyString() {
        return this.actionKey == '\u0000' ? "" : Character.toString(this.actionKey);
    }

    public boolean keyEnabled() {
        return this.keyEnabled;
    }

    public void keyEnabled(boolean keyEnabled) {
        if (this.keyEnabled != keyEnabled) {
            this.keyEnabled = keyEnabled;
            this.repaint();
        }
    }

    @Override
    public String classDisplayName() {
        return I18N.guiJ().get("tabs.run.widgets.button");
    }

    public void name(String name) {
        this.name = name;
        this.displayName(name);
    }

    public String name() {
        return this.name;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(55, 33);
    }

    @Override
    public Dimension getPreferredSize(Font font) {
        Dimension size2 = this.getMinimumSize();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        size2.width = StrictMath.max(size2.width, fontMetrics.stringWidth(this.displayName()) + 28);
        size2.height = StrictMath.max(size2.height, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 12);
        return size2;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Dimension size2 = this.getSize();
        FontMetrics fontMetrics = g.getFontMetrics();
        int labelHeight = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
        String displayName = this.displayName();
        int availableWidth = size2.width - 8;
        int stringWidth = fontMetrics.stringWidth(displayName);
        g.setColor(this.getForeground());
        String shortString = Fonts.shortenStringToFit(displayName, availableWidth, fontMetrics);
        int nx = stringWidth > availableWidth ? 4 : size2.width / 2 - stringWidth / 2;
        int ny = size2.height / 2 + labelHeight / 2;
        g.drawString(shortString, nx, ny);
        if (!this.actionKeyString().equals("")) {
            int ax = size2.width - 4 - fontMetrics.stringWidth(this.actionKeyString());
            int ay = fontMetrics.getMaxAscent() + 2;
            g.setColor(this.keyEnabled ? Color.BLACK : Color.GRAY);
            g.drawString(this.actionKeyString(), ax - 1, ay);
        }
    }

    @Override
    public String save() {
        StringBuilder s = new StringBuilder();
        s.append("BUTTON\n");
        s.append(this.getBoundsString());
        if (!this.name().trim().equals("")) {
            s.append(this.name() + "\n");
        } else {
            s.append("NIL\n");
        }
        s.append("NIL\n");
        s.append("NIL\n");
        s.append("1\n");
        s.append("T\n");
        String temp = "OBSERVER\n";
        s.append(temp);
        s.append("NIL\n");
        if (this.actionKey == '\u0000' || this.actionKey == ' ') {
            s.append("NIL\n");
        } else {
            s.append(this.actionKey + "\n");
        }
        return s.toString();
    }

    @Override
    public Object load(String[] strings, Widget.LoadHelper helper) {
        if (strings.length > 12 && !strings[12].equals("NIL")) {
            this.actionKey(strings[12].charAt(0));
        }
        this.name("");
        String dName = strings[5];
        if (!dName.equals("NIL")) {
            this.name(dName);
        } else {
            dName = strings[6];
            if (!dName.equals("NIL")) {
                this.name(dName);
            }
        }
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        this.setSize(x2 - x1, y2 - y1);
        return this;
    }
}

