/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.BorderFactory;
import org.nlogo.agent.World;
import org.nlogo.api.Editable;
import org.nlogo.api.I18N;
import org.nlogo.api.Property;
import org.nlogo.window.MouseMode;
import org.nlogo.window.Properties;
import org.nlogo.window.SingleErrorWidget;
import org.nlogo.window.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class DummyViewWidget
extends SingleErrorWidget
implements Editable {
    private final World world;
    private int newWidth;
    private int newHeight;

    @Override
    public String classDisplayName() {
        return I18N.guiJ().get("tabs.run.widgets.view");
    }

    public DummyViewWidget(World world) {
        this.world = world;
        this.setBackground(Color.black);
        this.setBorder(BorderFactory.createCompoundBorder(this.widgetBorder(), BorderFactory.createMatteBorder(1, 3, 4, 2, Color.black)));
        this.newWidth = (int)StrictMath.round((double)world.worldWidth() * world.patchSize());
        this.newHeight = (int)StrictMath.round((double)world.worldHeight() * world.patchSize());
        this.setSize(this.newWidth, this.newHeight);
    }

    public int width() {
        return this.newWidth;
    }

    public void width(int width) {
        this.newWidth = width;
    }

    public int height() {
        return this.newHeight;
    }

    public void height(int height) {
        this.newHeight = height;
    }

    @Override
    public List<Property> propertySet() {
        return Properties.dummyView();
    }

    @Override
    public boolean editFinished() {
        if (this.newWidth != this.getWidth() || this.newHeight != this.getHeight()) {
            this.setSize(new Dimension(this.newWidth, this.newHeight));
            this.resetSizeInfo();
        }
        return true;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.world.worldWidth(), this.world.worldHeight());
    }

    @Override
    public boolean needsPreferredWidthFudgeFactor() {
        return false;
    }

    @Override
    public Rectangle constrainDrag(Rectangle newBounds, Rectangle originalBounds, MouseMode mouseMode) {
        this.newWidth = newBounds.width;
        this.newHeight = newBounds.height;
        return newBounds;
    }

    @Override
    public boolean hasContextMenu() {
        return false;
    }

    @Override
    public String save() {
        return "VIEW\n" + this.getBoundsString() + "0\n0\n" + "0\n" + "1\n1\n" + "1\n1\n1\n" + "0\n" + "1\n1\n" + "1\n" + this.world.minPxcor() + "\n" + this.world.maxPxcor() + "\n" + this.world.minPycor() + "\n" + this.world.maxPycor() + "\n";
    }

    @Override
    public Object load(String[] strings, Widget.LoadHelper helper) {
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        double patchSize = Double.parseDouble(strings[7]);
        if (patchSize > 0.0) {
            this.setBounds(x1, y1, (int)(patchSize * (double)this.world.worldWidth()), (int)(patchSize * (double)this.world.worldHeight()));
        } else {
            this.setBounds(x1, y1, x2 - x1, y2 - y1);
        }
        this.newWidth = this.getWidth();
        this.newHeight = this.getHeight();
        return this;
    }
}

