/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.EventQueue;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.api.JobOwner;
import org.nlogo.nvm.Procedure;
import org.nlogo.util.MersenneTwisterFast;
import org.nlogo.window.Events;
import org.nlogo.window.SingleErrorWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class JobWidget
extends SingleErrorWidget
implements JobOwner,
Events.CompiledEvent.Handler {
    protected Class<? extends Agent> agentClass = null;
    public final MersenneTwisterFast random;
    protected AgentSet agents = null;
    private Procedure procedure = null;
    protected String innerSource = "";
    protected String headerSource = "";
    protected String footerSource = "";
    private boolean suppressRecompiles;
    protected boolean recompilePending;

    public JobWidget(MersenneTwisterFast random) {
        this.random = random;
    }

    public Class<? extends Agent> agentClass() {
        return this.agentClass;
    }

    public void agentClass(Class<? extends Agent> agentClass) {
        this.agentClass = agentClass;
    }

    @Override
    public MersenneTwisterFast random() {
        return this.random;
    }

    public boolean useAgentClass() {
        return true;
    }

    public AgentSet agents() {
        return this.agents;
    }

    public void agents(AgentSet agents) {
        this.agents = agents;
    }

    public Procedure procedure() {
        return this.procedure;
    }

    public void procedure(Procedure procedure) {
        this.procedure = procedure;
    }

    @Override
    public boolean ownsPrimaryJobs() {
        return true;
    }

    @Override
    public boolean isCommandCenter() {
        return false;
    }

    @Override
    public void handle(Events.CompiledEvent e) {
        if (e.sourceOwner == this) {
            this.procedure(e.procedure);
            this.error(e.error);
        }
        if (this.error() == null) {
            this.setForeground(Color.BLACK);
        } else {
            this.setForeground(Color.RED);
        }
    }

    @Override
    public void removeNotify() {
        if (EventQueue.isDispatchThread()) {
            new Events.RemoveJobEvent(this).raise(this);
        }
        super.removeNotify();
    }

    @Override
    public int sourceOffset() {
        String source2 = this.headerSource();
        return source2 == null ? 0 : source2.length();
    }

    @Override
    public String innerSource() {
        return this.innerSource;
    }

    @Override
    public void innerSource(String innerSource2) {
        this.innerSource = innerSource2;
    }

    @Override
    public String headerSource() {
        return this.headerSource;
    }

    public void headerSource(String headerSource) {
        this.headerSource = headerSource;
    }

    public String footerSource() {
        return this.footerSource;
    }

    public void footerSource(String footerSource) {
        this.footerSource = footerSource;
    }

    public void suppressRecompiles(boolean suppressRecompiles) {
        this.suppressRecompiles = suppressRecompiles;
        if (!suppressRecompiles && this.recompilePending) {
            this.recompilePending = false;
            new Events.CompileMoreSourceEvent(this).raise(this);
        }
    }

    public void source(String headerSource, String innerSource2, String footerSource) {
        this.headerSource = headerSource;
        this.innerSource = innerSource2;
        this.footerSource = footerSource;
        if (this.suppressRecompiles) {
            this.recompilePending = true;
        } else {
            new Events.CompileMoreSourceEvent(this).raise(this);
        }
    }

    @Override
    public String source() {
        StringBuilder b = new StringBuilder();
        b.append(this.headerSource());
        b.append(this.innerSource());
        b.append(this.footerSource());
        return b.toString();
    }
}

