/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.nlogo.api.Version;
import org.nlogo.swing.BrowserLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp final class QuickHelp<TokenType> {
    private static boolean quickHelpLoaded = false;
    private static final String QUICKHELPWORDS_PATH = "/system/dict.txt";
    private static final String QUICKHELPWORDS_PATH3D = "/system/dict3d.txt";
    private static Map<String, String> quickHelpWords;
    private static Map<String, String> quickHelpWords3d;

    private QuickHelp() {
        throw new IllegalStateException();
    }

    private static Map<String, String> loadHelp(String path) {
        String[] lines2 = QuickHelp.getResourceAsStringArray(path);
        HashMap<String, String> words = new HashMap<String, String>();
        for (int i = 0; i < lines2.length; ++i) {
            String anchor = lines2[i].substring(0, lines2[i].indexOf(32));
            String file = lines2[i].substring(lines2[i].indexOf(32) + 1);
            words.put(anchor, file);
        }
        return words;
    }

    private static String docPath(String docName) {
        return System.getProperty("netlogo.docs.dir", "docs") + "/" + docName;
    }

    private static void openDictionary(Component comp, String theWord, Map<String, String> words) {
        String theFile = words.get(theWord);
        BrowserLauncher.openURL(comp, QuickHelp.docPath("dict/" + theFile), true);
    }

    public static void doHelp(Component comp, String token2) {
        if (!quickHelpLoaded) {
            quickHelpWords = QuickHelp.loadHelp(QUICKHELPWORDS_PATH);
            quickHelpWords3d = Version.is3D() ? QuickHelp.loadHelp(QUICKHELPWORDS_PATH3D) : new HashMap<String, String>();
            quickHelpLoaded = true;
        }
        if (token2 == null) {
            return;
        }
        if (quickHelpWords3d.containsKey(token2 = token2.toLowerCase())) {
            QuickHelp.openDictionary(comp, token2, quickHelpWords3d);
        } else if (quickHelpWords.containsKey(token2)) {
            QuickHelp.openDictionary(comp, token2, quickHelpWords);
        } else if (0 == JOptionPane.showConfirmDialog(comp, token2.toUpperCase() + " could not be found in the NetLogo Dictionary.\n" + "Would you like to open the full NetLogo Dictionary?", "NetLogo", 0)) {
            BrowserLauncher.openURL(comp, QuickHelp.docPath("index2.html"), true);
        }
    }

    public static String[] getResourceAsStringArray(String path) {
        try {
            String line;
            ArrayList<String> result2 = new ArrayList<String>();
            InputStream stream = QuickHelp.class.getResourceAsStream(path);
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            while ((line = in.readLine()) != null) {
                result2.add(line);
            }
            return result2.toArray(new String[0]);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

