/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import org.nlogo.api.Approximate;
import org.nlogo.api.Dump;
import org.nlogo.api.Version;
import org.nlogo.awt.Fonts;
import org.nlogo.window.DisplaySwitch;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.MouseMode;
import org.nlogo.window.View;
import org.nlogo.window.ViewControlStrip;
import org.nlogo.window.ViewWidgetInterface;
import org.nlogo.window.Widget;
import org.nlogo.window.WorldViewSettings;
import org.nlogo.window.WorldViewSettings2D;
import org.nlogo.window.WorldViewSettings3D;

public strictfp class ViewWidget
extends Widget
implements ViewWidgetInterface,
Events.PeriodicUpdateEvent.Handler,
Events.LoadBeginEvent.Handler,
Events.LoadEndEvent.Handler {
    private final GUIWorkspace workspace;
    public final View view;
    public final ViewControlStrip controlStrip;
    public final JLabel tickCounter = new TickCounterLabel();
    public final DisplaySwitch displaySwitch;
    private static final int INSIDE_BORDER_HEIGHT = 1;
    private final WorldViewSettings settings;
    private String tickCounterLabel;

    public String classDisplayName() {
        return "World & View";
    }

    public final int getExtraHeight() {
        return this.getInsets().top + this.getInsets().bottom + 1;
    }

    public int getAdditionalHeight() {
        return this.getExtraHeight() + this.controlStrip.getHeight();
    }

    ViewWidget(GUIWorkspace workspace) {
        this.workspace = workspace;
        this.displaySwitch = new DisplaySwitch(workspace);
        Fonts.adjustDefaultFont(this.tickCounter);
        this.view = new View(workspace);
        this.controlStrip = new ViewControlStrip(workspace, this);
        this.setBackground(InterfaceColors.GRAPHICS_BACKGROUND);
        this.setBorder(BorderFactory.createCompoundBorder(this.widgetBorder(), BorderFactory.createMatteBorder(1, 3, 4, 2, InterfaceColors.GRAPHICS_BACKGROUND)));
        this.setLayout(null);
        this.add(this.view);
        this.add(this.controlStrip);
        this.settings = Version.is3D() ? new WorldViewSettings3D(workspace, this) : new WorldViewSettings2D(workspace, this);
    }

    public WorldViewSettings settings() {
        return this.settings;
    }

    public void doLayout() {
        int availableWidth = this.getWidth() - this.getInsets().left - this.getInsets().right;
        double patchSize = this.computePatchSize(availableWidth, this.workspace.world.worldWidth());
        int graphicsHeight = (int)StrictMath.round(patchSize * (double)this.workspace.world.worldHeight());
        int stripHeight = this.getHeight() - graphicsHeight - this.getInsets().top - this.getInsets().bottom;
        this.view.visualPatchSize(patchSize);
        this.view.setBounds(this.getInsets().left, this.getInsets().top + 1 + stripHeight, availableWidth, graphicsHeight);
        this.controlStrip.setBounds(this.getInsets().left, this.getInsets().top, availableWidth, stripHeight);
    }

    public Object getEditable() {
        return this.settings;
    }

    public double computePatchSize(int width, int numPatches) {
        double exactPatchSize = (double)width / (double)numPatches;
        for (int precision = 0; precision < 15; ++precision) {
            double roundedPatchSize = Approximate.approximate(exactPatchSize, precision);
            if ((int)((double)numPatches * roundedPatchSize) != width) continue;
            return roundedPatchSize;
        }
        return exactPatchSize;
    }

    public Dimension getPreferredSize(Font font) {
        return new Dimension(0, 0);
    }

    public boolean needsPreferredWidthFudgeFactor() {
        return false;
    }

    public Dimension getMinimumSize() {
        Dimension gSize = this.view.getMinimumSize();
        Dimension stripSize = this.controlStrip.getMinimumSize();
        if (gSize.width > stripSize.width) {
            return new Dimension(gSize.width + this.getInsets().left + this.getInsets().right, gSize.height + this.getExtraHeight() + stripSize.height);
        }
        int ssx = this.workspace.world.worldWidth();
        int ssy = this.workspace.world.worldHeight();
        double minPatchSize = this.computePatchSize(stripSize.width, ssx);
        return new Dimension(stripSize.width + this.getInsets().left + this.getInsets().right, stripSize.height + this.getExtraHeight() + (int)(minPatchSize * (double)ssy));
    }

    public int insetWidth() {
        return this.getInsets().left + this.getInsets().right;
    }

    public int calculateWidth(int worldWidth, double patchSize) {
        return (int)((double)worldWidth * patchSize) + this.getInsets().right + this.getInsets().left;
    }

    public int calculateHeight(int worldHeight, double patchSize) {
        Dimension stripSize = this.controlStrip.getMinimumSize();
        return stripSize.height + this.getExtraHeight() + (int)(patchSize * (double)worldHeight);
    }

    public int getMinimumWidth() {
        return this.controlStrip.getMinimumSize().width + this.insetWidth();
    }

    void resetSize() {
        this.view.setSize(this.workspace.world.worldWidth(), this.workspace.world.worldHeight(), this.workspace.world.patchSize());
        Dimension dim = this.view.getPreferredSize();
        this.setSize(dim.width + this.getInsets().left + this.getInsets().right, dim.height + this.getExtraHeight() + this.controlStrip.getPreferredSize().height);
        this.doLayout();
        this.resetZoomInfo();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        new Events.ResizeViewEvent(this.workspace.world.worldWidth(), this.workspace.world.worldHeight()).raise(this);
    }

    public void setBounds(int x2, int y, int width, int height) {
        Rectangle bounds = this.getBounds();
        if (width != bounds.width || height != bounds.height || x2 != bounds.x || y != bounds.y) {
            super.setBounds(x2, y, width, height);
            this.resetSizeInfo();
        }
    }

    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public String getBoundsString() {
        Rectangle r = this.findWidgetContainer() == null ? this.getBounds() : this.findWidgetContainer().getUnzoomedBounds(this);
        int width = StrictMath.max(245, r.width);
        StringBuilder buf = new StringBuilder();
        buf.append(r.x + "\n");
        buf.append(r.y + "\n");
        buf.append(r.x + width + "\n");
        buf.append(r.y + r.height + "\n");
        return buf.toString();
    }

    public Rectangle constrainDrag(Rectangle newBounds, Rectangle originalBounds, MouseMode mouseMode) {
        int stripHeight = this.controlStrip.getMinimumSize().height;
        double patchSizeBasedOnNewWidth = this.computePatchSize(newBounds.width - this.getInsets().left + this.getInsets().right, this.workspace.world.worldWidth());
        double patchSizeBasedOnNewHeight = this.computePatchSize(newBounds.height - stripHeight - this.getExtraHeight(), this.workspace.world.worldHeight());
        double newPatchSize = newBounds.height == originalBounds.height ? patchSizeBasedOnNewWidth : (newBounds.width == originalBounds.width ? patchSizeBasedOnNewHeight : StrictMath.max(patchSizeBasedOnNewWidth, patchSizeBasedOnNewHeight));
        this.workspace.world.patchSize(newPatchSize);
        this.view.setSize(this.workspace.world.worldWidth(), this.workspace.world.worldHeight(), newPatchSize);
        this.view.renderer.trailDrawer().rescaleDrawing();
        int newWidth = (int)(newPatchSize * (double)this.workspace.world.worldWidth()) + this.getInsets().left + this.getInsets().right;
        int newHeight = (int)(newPatchSize * (double)this.workspace.world.worldHeight()) + this.getExtraHeight() + stripHeight;
        int widthAdjust = newBounds.width - newWidth;
        int heightAdjust = newBounds.height - newHeight;
        int newX = newBounds.x;
        int newY = newBounds.y;
        switch (mouseMode) {
            case NE: {
                newY += heightAdjust;
                break;
            }
            case NW: {
                newX += widthAdjust;
                newY += heightAdjust;
                break;
            }
            case SE: {
                break;
            }
            case SW: {
                newX += widthAdjust;
                break;
            }
            case S: {
                break;
            }
            case W: {
                newX += widthAdjust;
                break;
            }
            case E: {
                break;
            }
            case N: {
                newY += heightAdjust;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (mouseMode) {
            case S: 
            case N: {
                int midpointX = originalBounds.x + originalBounds.width / 2;
                newX = midpointX - newWidth / 2;
                break;
            }
            case W: 
            case E: {
                int midpointY = originalBounds.y + originalBounds.height / 2;
                newY = midpointY - newHeight / 2;
                break;
            }
        }
        return new Rectangle(newX, newY, newWidth, newHeight);
    }

    void applyNewFontSize(int newFontSize) {
        Font font = this.view.getFont();
        int zoomDiff = font.getSize() - this.view.fontSize();
        this.view.applyNewFontSize(newFontSize, zoomDiff);
    }

    public boolean zoomSubcomponents() {
        return true;
    }

    public Widget asWidget() {
        return this;
    }

    public void handle(Events.LoadBeginEvent e) {
        this.tickCounter.setText("");
        this.tickCounterLabel = "ticks";
        this.tickCounter.setVisible(true);
    }

    public void handle(Events.LoadEndEvent e) {
        this.controlStrip.reset();
    }

    public void handle(Events.PeriodicUpdateEvent e) {
        double ticks = this.workspace.world.tickCounter.ticks();
        String tickText = ticks == -1.0 ? "" : Dump.number(StrictMath.floor(ticks));
        this.tickCounter.setText("     " + this.tickCounterLabel + ": " + tickText);
    }

    public void showTickCounter(boolean visible) {
        this.tickCounter.setVisible(visible);
    }

    public boolean showTickCounter() {
        return this.tickCounter.isVisible();
    }

    public void tickCounterLabel(String label) {
        this.tickCounterLabel = label;
        this.handle((Events.PeriodicUpdateEvent)null);
    }

    public String tickCounterLabel() {
        return this.tickCounterLabel;
    }

    public boolean hasContextMenu() {
        return true;
    }

    public Point populateContextMenu(JPopupMenu menu, Point p, Component source2) {
        return this.view.populateContextMenu(menu, p, source2);
    }

    void displaySwitchOn(boolean on) {
        this.displaySwitch.actionPerformed(null);
    }

    public String save() {
        return this.settings.save();
    }

    public Object load(String[] strings, Widget.LoadHelper helper) {
        return this.settings.load(strings, helper.version());
    }

    public boolean copyable() {
        return false;
    }

    private strictfp class TickCounterLabel
    extends JLabel {
        private TickCounterLabel() {
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            d.width = StrictMath.max(d.width, fontMetrics.stringWidth(ViewWidget.this.tickCounterLabel + ": 00000000"));
            return d;
        }
    }
}

