/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import org.nlogo.agent.World;
import org.nlogo.awt.Hierarchy;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.OptionDialog;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.Properties;
import org.nlogo.window.ViewWidget;
import org.nlogo.window.WorldViewSettings;

public strictfp class WorldViewSettings2D
extends WorldViewSettings {
    protected final World world;

    WorldViewSettings2D(GUIWorkspace workspace, ViewWidget gw) {
        super(workspace, gw);
        this.world = workspace.world;
    }

    public void addDimensionProperties() {
        this.dimensionProperties.addAll(Properties.dims2D());
    }

    public void addWrappingProperties() {
        this.wrappingProperties.addAll(Properties.wrap2D());
    }

    public boolean editFinished() {
        this.gWidget.editFinished();
        if (this.wrappingChanged) {
            this.workspace.changeTopology(this.newWrapX, this.newWrapY);
            this.wrappingChanged = false;
        }
        if (this.edgesChanged || this.patchSizeChanged) {
            this.resizeWithProgress(true);
            this.edgesChanged = false;
            this.patchSizeChanged = false;
        }
        if (this.fontSizeChanged) {
            this.gWidget.applyNewFontSize(this.newFontSize);
            this.fontSizeChanged = false;
        }
        this.gWidget.view.dirty();
        this.gWidget.view.repaint();
        this.workspace.glView.editFinished();
        return true;
    }

    public void resizeWithProgress(boolean showProgress) {
        boolean oldGraphicsOn = this.world.displayOn();
        if (oldGraphicsOn) {
            this.world.displayOn(false);
        }
        Runnable runnable = new Runnable(){
            static final int KICK = 0;
            static final int IGNORE = 1;

            public void run() {
                if (WorldViewSettings2D.this.edgesChanged) {
                    new Events.RemoveAllJobsEvent().raise(WorldViewSettings2D.this.gWidget);
                    if (this.hubnetDecision() == 0) {
                        WorldViewSettings2D.this.workspace.hubnetManager().reset();
                    }
                    WorldViewSettings2D.this.world.clearTurtles();
                    WorldViewSettings2D.this.world.clearLinks();
                    WorldViewSettings2D.this.world.createPatches(WorldViewSettings2D.this.newMinX, WorldViewSettings2D.this.newMaxX, WorldViewSettings2D.this.newMinY, WorldViewSettings2D.this.newMaxY);
                    WorldViewSettings2D.this.workspace.patchesCreatedNotify();
                    WorldViewSettings2D.this.gWidget.resetSize();
                }
                if (WorldViewSettings2D.this.patchSizeChanged) {
                    WorldViewSettings2D.this.world.patchSize(WorldViewSettings2D.this.newPatchSize);
                    WorldViewSettings2D.this.gWidget.resetSize();
                }
                if (WorldViewSettings2D.this.edgesChanged) {
                    WorldViewSettings2D.this.gWidget.view.renderer.trailDrawer().clearDrawing();
                } else {
                    WorldViewSettings2D.this.gWidget.view.renderer.trailDrawer().rescaleDrawing();
                }
            }

            private int hubnetDecision() {
                if (WorldViewSettings2D.this.workspace.hubNetRunning()) {
                    String message = "Resizing the world kills all turtles. This may cause HubNet clients to be unresponsive. Consider kicking out all clients before proceeding.";
                    return OptionDialog.show(WorldViewSettings2D.this.workspace.getFrame(), "Kick clients?", message, new String[]{"Kick clients", "Don't kick"});
                }
                return 1;
            }
        };
        if (showProgress) {
            ModalProgressTask.apply(Hierarchy.getFrame(this.gWidget), "Resizing...", runnable);
        } else {
            runnable.run();
        }
        this.gWidget.displaySwitchOn(true);
        if (oldGraphicsOn) {
            this.world.displayOn(true);
            this.gWidget.view.dirty();
            this.gWidget.view.repaint();
        }
    }

    public String save() {
        return "GRAPHICS-WINDOW\n" + this.gWidget.getBoundsString() + (-this.world.minPxcor() == this.world.maxPxcor() ? this.world.maxPxcor() : -1) + "\n" + (-this.world.minPycor() == this.world.maxPycor() ? this.world.maxPycor() : -1) + "\n" + this.world.patchSize() + "\n" + "1\n" + this.gWidget.view.fontSize() + "\n" + "1\n1\n1\n0\n" + (this.world.wrappingAllowedInX() ? "1" : "0") + "\n" + (this.world.wrappingAllowedInY() ? "1" : "0") + "\n" + "1\n" + this.world.minPxcor() + "\n" + this.world.maxPxcor() + "\n" + this.world.minPycor() + "\n" + this.world.maxPycor() + "\n" + this.workspace.updateMode().save() + "\n" + this.workspace.updateMode().save() + "\n" + (this.showTickCounter() ? "1" : "0") + "\n" + (this.tickCounterLabel().trim().equals("") ? "NIL" : this.tickCounterLabel()) + "\n" + this.frameRate() + "\n";
    }
}

