/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.nlogo.window.View;
import org.nlogo.window.ViewWidget;
import org.nlogo.window.ViewWidgetInterface;
import org.nlogo.window.Widget;
import org.nlogo.window.WidgetWrapperInterface;

public strictfp class Zoomer {
    private final Container container;
    private double zoomFactor = 1.0;
    private final Map<Component, Dimension> sizes = new HashMap<Component, Dimension>();
    private final Map<Component, Double> sizeZooms = new HashMap<Component, Double>();
    private final Map<Component, Point> locations = new HashMap<Component, Point>();
    private final Map<Component, Double> locationZooms = new HashMap<Component, Double>();
    private final Map<Component, Font> fonts = new HashMap<Component, Font>();
    private final Map<Component, Double> fontZooms = new HashMap<Component, Double>();

    public double zoomFactor() {
        return this.zoomFactor;
    }

    public Zoomer(Container container) {
        this.container = container;
    }

    public void zoomWidgets(double newZoom) {
        this.container.setVisible(false);
        double oldZoom = this.zoomFactor;
        this.zoomFactor = newZoom;
        Component[] comps = this.container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof WidgetWrapperInterface)) continue;
            WidgetWrapperInterface wrapper = (WidgetWrapperInterface)((Object)comps[i]);
            this.zoomWidget(wrapper, false, false, oldZoom, this.zoomFactor);
        }
        this.container.setVisible(true);
    }

    public void zoomWidget(WidgetWrapperInterface wrapper, boolean newWidget, boolean loadingWidget, double oldZoom, double newZoom) {
        if (oldZoom == newZoom) {
            return;
        }
        this.zoomWidgetSize(wrapper, newWidget, loadingWidget, oldZoom, newZoom);
        this.zoomWidgetLocation(wrapper, newWidget, loadingWidget, oldZoom, newZoom);
        this.zoomWidgetFont(wrapper, wrapper.widget(), newWidget, loadingWidget, oldZoom, newZoom);
    }

    public void zoomWidgetSize(WidgetWrapperInterface wrapper, boolean newWidget, boolean loadingWidget, double oldZoom, double newZoom) {
        Widget component = wrapper.widget();
        Dimension originalSize = this.sizes.get(component);
        Double originalZoom = this.sizeZooms.get(component);
        if (originalSize == null) {
            originalSize = component.getSize();
            originalZoom = oldZoom;
            if (!newWidget || loadingWidget) {
                this.sizes.put(component, originalSize);
                this.sizeZooms.put(component, originalZoom);
            }
        }
        if (!newWidget || loadingWidget) {
            wrapper.setSize(this.zoomSize(originalSize, originalZoom, newZoom));
        }
    }

    public Dimension zoomSize(Dimension originalSize, double oldZoom, double newZoom) {
        return new Dimension((int)StrictMath.ceil((double)originalSize.width * newZoom / oldZoom), (int)StrictMath.ceil((double)originalSize.height * newZoom / oldZoom));
    }

    public Dimension zoomSize(Dimension originalSize) {
        return this.zoomSize(originalSize, 1.0, this.zoomFactor);
    }

    public void zoomWidgetLocation(WidgetWrapperInterface wrapper, boolean newWidget, boolean loadingWidget, double oldZoom, double newZoom) {
        Widget component = wrapper.widget();
        Point originalLocation = this.locations.get(component);
        Double originalZoom = this.locationZooms.get(component);
        if (originalLocation == null) {
            originalLocation = wrapper.getUnselectedLocation();
            originalZoom = oldZoom;
            if (!newWidget || loadingWidget) {
                this.locations.put(component, originalLocation);
                this.locationZooms.put(component, originalZoom);
            }
        }
        if (!newWidget || loadingWidget) {
            wrapper.setLocation(this.zoomLocation(originalLocation, originalZoom, newZoom));
        }
    }

    private Point zoomLocation(Point originalLocation, double oldZoom, double newZoom) {
        return new Point((int)StrictMath.ceil((double)originalLocation.x * newZoom / oldZoom), (int)StrictMath.ceil((double)originalLocation.y * newZoom / oldZoom));
    }

    public void zoomWidgetFont(WidgetWrapperInterface wrapper, Widget widget, boolean newWidget, boolean loadingWidget, double oldZoom, double newZoom) {
        boolean recursive = widget.zoomSubcomponents();
        if (this.fonts.get(widget) == null) {
            this.storeComponentFont(widget, recursive, newWidget, loadingWidget, oldZoom);
        }
        this.scaleComponentFont(widget, newZoom, oldZoom, recursive);
        if (wrapper != null && recursive) {
            wrapper.validate();
        }
    }

    private void storeComponentFont(Component component, boolean recursive, boolean newWidget, boolean loadingWidget, double oldZoom) {
        if (!(component instanceof ViewWidgetInterface && newWidget && !loadingWidget || this.fonts.get(component) != null)) {
            this.fonts.put(component, component.getFont());
            this.fontZooms.put(component, oldZoom);
        }
        if (recursive && component instanceof Container) {
            Component[] comps = ((Container)component).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.storeComponentFont(comps[i], true, newWidget, loadingWidget, oldZoom);
            }
        }
    }

    public void scaleComponentFont(Component component, double newZoom, double oldZoom, boolean recursive) {
        if (this.fonts.get(component) == null) {
            this.storeComponentFont(component, recursive, false, false, oldZoom);
        }
        Font originalFont = this.fonts.get(component);
        double originalZoom = this.fontZooms.get(component);
        component.invalidate();
        component.setFont(component.getFont().deriveFont((float)StrictMath.ceil((double)originalFont.getSize() * newZoom / originalZoom)));
        if (recursive && component instanceof Container) {
            Component[] comps = ((Container)component).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.scaleComponentFont(comps[i], newZoom, oldZoom, true);
            }
        }
    }

    public void forgetAllZoomInfo() {
        this.sizes.clear();
        this.sizeZooms.clear();
        this.locations.clear();
        this.locationZooms.clear();
        Iterator<Component> comps = this.fonts.keySet().iterator();
        while (comps.hasNext()) {
            Component comp = comps.next();
            if (comp instanceof View) continue;
            comps.remove();
            this.fontZooms.remove(comp);
        }
    }

    public void updateZoomInfo(Component component) {
        Container parent = component.getParent();
        if (parent instanceof WidgetWrapperInterface) {
            Point storedLocation;
            WidgetWrapperInterface wrapper = (WidgetWrapperInterface)((Object)parent);
            Dimension storedSize = this.sizes.get(component);
            if (storedSize != null && !component.getSize().equals(this.zoomSize(storedSize, this.sizeZooms.get(component), this.zoomFactor))) {
                this.sizes.remove(component);
                this.sizeZooms.remove(component);
            }
            if ((storedLocation = this.locations.get(component)) != null && !wrapper.getUnselectedLocation().equals(this.zoomLocation(storedLocation, this.locationZooms.get(component), this.zoomFactor))) {
                this.locations.remove(component);
                this.locationZooms.remove(component);
            }
            if (component instanceof ViewWidget) {
                this.fonts.remove(((ViewWidget)component).view);
                this.fontZooms.remove(((ViewWidget)component).view);
            }
        }
    }

    public Rectangle getUnzoomedBounds(Component comp) {
        Point originalLocation;
        Rectangle r = comp.getBounds();
        Container parent = comp.getParent();
        if (parent != null) {
            r.x += comp.getParent().getLocation().x;
            r.y += comp.getParent().getLocation().y;
        }
        Point unzoomedLocation = (originalLocation = this.locations.get(comp)) == null ? this.zoomLocation(r.getLocation(), this.zoomFactor, 1.0) : this.zoomLocation(originalLocation, this.locationZooms.get(comp), 1.0);
        Dimension originalSize = this.sizes.get(comp);
        Dimension unzoomedSize = originalSize == null ? this.zoomSize(r.getSize(), this.zoomFactor, 1.0) : this.zoomSize(originalSize, this.sizeZooms.get(comp), 1.0);
        return new Rectangle(unzoomedLocation, unzoomedSize);
    }

    int getFontForSave(Component comp) {
        int size2 = comp.getFont().getSize();
        Font originalFont = this.fonts.get(comp);
        Double originalZoom = this.fontZooms.get(comp);
        size2 = originalFont != null ? (int)StrictMath.ceil((double)originalFont.getSize() / originalZoom) : (int)StrictMath.ceil((double)size2 / this.zoomFactor);
        return size2;
    }
}

