/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.nlogo.agent.AbstractExporter;
import org.nlogo.agent.Agent;
import org.nlogo.agent.Importer;
import org.nlogo.agent.OutputObject;
import org.nlogo.agent.World;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Dump;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.File;
import org.nlogo.api.FileModeJ;
import org.nlogo.api.HubNetInterface;
import org.nlogo.api.HubNetWorkspaceInterface;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.LocalFile;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoThunkFactory;
import org.nlogo.api.ModelType;
import org.nlogo.api.ModelTypeJ;
import org.nlogo.api.RemoteFile;
import org.nlogo.api.Token;
import org.nlogo.api.Version;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.CompilerInterface;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.FileManager;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.JobManagerInterface;
import org.nlogo.nvm.MutableLong;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Tracer;
import org.nlogo.nvm.Workspace;
import org.nlogo.util.Exceptions;
import org.nlogo.util.Femto;
import org.nlogo.util.MersenneTwisterFast;
import org.nlogo.workspace.BufferedReaderImporter;
import org.nlogo.workspace.DefaultFileManager;
import org.nlogo.workspace.Evaluator;
import org.nlogo.workspace.ExtensionManager;
import org.nlogo.workspace.WorldLoader;
import org.nlogo.workspace.WorldLoader3D;
import org.nlogo.workspace.WorldLoaderInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class AbstractWorkspace
implements Workspace,
LogoThunkFactory,
HubNetWorkspaceInterface {
    public final World world;
    protected final DefaultFileManager fileManager;
    private Tracer tracer = null;
    public final JobManagerInterface jobManager;
    private final HubNetManagerFactory hubNetManagerFactory;
    protected HubNetInterface hubNetManager;
    protected final Evaluator evaluator;
    protected final ExtensionManager extensionManager;
    private final WeakHashMap<Job, WeakHashMap<Agent, WeakHashMap<Command, MutableLong>>> lastRunTimes = new WeakHashMap();
    private final WeakHashMap<Activation, Boolean> completedActivations = new WeakHashMap();
    protected String modelFileName;
    private String modelDir;
    private ModelType modelType;
    private static boolean isApp = false;
    private static boolean isApplet = true;
    protected boolean hubNetRunning = false;
    private Map<String, Procedure> procedures = new HashMap<String, Procedure>();
    public WeakHashMap<String, Procedure> codeBits = new WeakHashMap();
    private Workspace.UpdateMode updateMode = Workspace.UpdateMode.CONTINUOUS;
    private int _behaviorSpaceRunNumber = 0;
    private String _behaviorSpaceExperimentName = "";

    @Override
    public World world() {
        return this.world;
    }

    @Override
    public FileManager fileManager() {
        return this.fileManager;
    }

    @Override
    public Tracer profilingTracer() {
        return this.tracer;
    }

    @Override
    public boolean profilingEnabled() {
        return this.tracer != null;
    }

    public void setProfilingTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public WeakHashMap<Job, WeakHashMap<Agent, WeakHashMap<Command, MutableLong>>> lastRunTimes() {
        return this.lastRunTimes;
    }

    @Override
    public WeakHashMap<Activation, Boolean> completedActivations() {
        return this.completedActivations;
    }

    protected AbstractWorkspace(World world, HubNetManagerFactory hubNetManagerFactory) {
        this.world = world;
        this.hubNetManagerFactory = hubNetManagerFactory;
        this.modelType = ModelTypeJ.NEW();
        this.evaluator = new Evaluator(this);
        world.compiler_$eq(this);
        this.jobManager = Femto.get(JobManagerInterface.class, "org.nlogo.job.JobManager", new Object[]{this, world, world});
        this.fileManager = new DefaultFileManager(this);
        this.extensionManager = new ExtensionManager(this);
    }

    @Override
    public org.nlogo.api.ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Override
    public boolean isExtensionName(String name) {
        return this.extensionManager.isExtensionName(name);
    }

    @Override
    public void importExtensionData(String name, List<String[]> data2, ImportErrorHandler handler) throws ExtensionException {
        this.extensionManager.importExtensionData(name, data2, handler);
    }

    public abstract boolean compilerTestingMode();

    @Override
    public void dispose() throws InterruptedException {
        this.jobManager.die();
        this.getExtensionManager().reset();
        if (this.hubNetManager != null) {
            this.hubNetManager.disconnect();
        }
    }

    @Override
    public abstract boolean isHeadless();

    public boolean warningMessage(String message) {
        System.err.println();
        System.err.println("WARNING: " + message);
        System.err.println();
        return true;
    }

    public static boolean isApp() {
        return isApp;
    }

    public static void isApp(boolean isApp) {
        AbstractWorkspace.isApp = isApp;
    }

    public static boolean isApplet() {
        return isApplet;
    }

    public static void isApplet(boolean isApplet) {
        AbstractWorkspace.isApplet = isApplet;
    }

    @Override
    public boolean getIsApplet() {
        return isApplet;
    }

    @Override
    public HubNetInterface getHubNetManager() {
        if (this.hubNetManager == null && this.hubNetManagerFactory != null) {
            this.hubNetManager = this.hubNetManagerFactory.newInstance(this);
        }
        return this.hubNetManager;
    }

    public HubNetInterface hubnetManager() {
        return this.hubNetManager;
    }

    public boolean hubNetRunning() {
        return this.hubNetRunning;
    }

    @Override
    public void hubNetRunning(boolean hubNetRunning) {
        this.hubNetRunning = hubNetRunning;
    }

    @Override
    public WorldPropertiesInterface getPropertiesInterface() {
        return null;
    }

    @Override
    public void setModelPath(String modelPath) {
        if (modelPath == null) {
            this.modelFileName = null;
            this.modelDir = null;
        } else {
            java.io.File file = new java.io.File(modelPath).getAbsoluteFile();
            this.modelFileName = file.getName();
            this.modelDir = file.getParent();
            if (this.modelDir.equals("")) {
                this.modelDir = null;
            }
            if (this.modelDir != null) {
                this.fileManager.setPrefix(this.modelDir);
            }
        }
    }

    @Override
    public String attachModelDir(String filePath) throws MalformedURLException {
        if (AbstractWorkspace.isApplet() || new java.io.File(filePath).isAbsolute()) {
            return filePath;
        }
        String path = this.getModelPath();
        if (path == null) {
            path = System.getProperty("user.home") + java.io.File.separatorChar + "dummy.txt";
        }
        URL urlForm = new URL(AbstractWorkspace.toURL(new java.io.File(path)), filePath);
        return new java.io.File(urlForm.getFile()).getAbsolutePath();
    }

    public static URL toURL(java.io.File file) throws MalformedURLException {
        return file.toURL();
    }

    @Override
    public String convertToNormal() throws IOException {
        java.io.File git = new java.io.File(".git");
        if (!git.exists() || !git.isDirectory()) {
            throw new IOException("no .git directory found");
        }
        this.modelType = ModelTypeJ.NORMAL();
        return this.getModelPath();
    }

    protected void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    @Override
    public String getModelPath() {
        if (this.modelDir == null || this.modelFileName == null) {
            return null;
        }
        return this.modelDir + java.io.File.separatorChar + this.modelFileName;
    }

    @Override
    public String getModelFileName() {
        return this.modelFileName;
    }

    @Override
    public String getModelDir() {
        return this.modelDir;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public boolean forceSaveAs() {
        return this.modelType == ModelTypeJ.NEW() || this.modelType == ModelTypeJ.LIBRARY();
    }

    @Override
    public String modelNameForDisplay() {
        return AbstractWorkspace.makeModelNameForDisplay(this.modelFileName);
    }

    static String makeModelNameForDisplay(String str) {
        if (str == null) {
            return "Untitled";
        }
        int suffixIndex = str.lastIndexOf(".nlogo");
        if (suffixIndex > 0 && suffixIndex == str.length() - 6) {
            str = str.substring(0, str.length() - 6);
        }
        if ((suffixIndex = str.lastIndexOf(".nlogo3d")) > 0 && suffixIndex == str.length() - 8) {
            str = str.substring(0, str.length() - 8);
        }
        return str;
    }

    @Override
    public Map<String, Procedure> getProcedures() {
        return this.procedures;
    }

    @Override
    public void setProcedures(Map<String, Procedure> procedures) {
        this.procedures = procedures;
    }

    public void init() {
        for (Procedure procedure : this.procedures.values()) {
            procedure.init(this);
        }
    }

    @Override
    public void joinForeverButtons(Agent agent) {
        this.jobManager.joinForeverButtons(agent);
    }

    @Override
    public void addJobFromJobThread(Job job) {
        this.jobManager.addJobFromJobThread(job);
    }

    @Override
    public abstract void magicOpen(String var1);

    @Override
    public abstract void changeLanguage();

    @Override
    public Procedure compileForRun(String source2, Context context, boolean reporter) throws CompilerException {
        String key = source2 + "@" + context.activation.procedure.args.size() + "@" + context.agentBit;
        Procedure proc = this.codeBits.get(key);
        if (proc == null) {
            proc = this.evaluator.compileForRun(source2, context, reporter);
            this.codeBits.put(key, proc);
        }
        return proc;
    }

    public Workspace.UpdateMode updateMode() {
        return this.updateMode;
    }

    public void updateMode(Workspace.UpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    @Override
    public abstract void open(String var1) throws IOException, CompilerException, LogoException;

    @Override
    public abstract void openString(String var1) throws CompilerException, LogoException;

    public void halt() {
        this.jobManager.haltPrimary();
        this.world.displayOn(true);
    }

    @Override
    public abstract void requestDisplayUpdate(boolean var1);

    @Override
    public abstract void breathe();

    @Override
    public void outputObject(Object object, Object owner, boolean addNewline, boolean readable, Workspace.OutputDestination destination) throws LogoException {
        OutputObject oo = new OutputObject(owner instanceof Agent ? Dump.logoObject(owner) : "", (readable && !(owner instanceof Agent) ? " " : "") + Dump.logoObject(object, readable, false), addNewline, false);
        if (destination == Workspace.OutputDestination.FILE) {
            this.fileManager.writeOutputObject(oo);
        } else {
            this.sendOutput(oo, destination == Workspace.OutputDestination.OUTPUT_AREA);
        }
    }

    protected abstract void sendOutput(OutputObject var1, boolean var2) throws LogoException;

    @Override
    public void setOutputAreaContents(String text2) {
        try {
            this.clearOutput();
            if (text2.length() > 0) {
                this.sendOutput(new OutputObject("", text2, false, false), true);
            }
        }
        catch (LogoException e) {
            Exceptions.handle(e);
        }
    }

    @Override
    public abstract void clearDrawing();

    protected void exportInterfaceGlobals(PrintWriter writer) {
        writer.println(Dump.csv().header("MODEL SETTINGS"));
        List<String> globals = this.world.program().interfaceGlobals();
        writer.println(Dump.csv().variableNameRow(globals));
        Object[] values2 = new Object[globals.size()];
        int i = 0;
        Iterator<String> iter2 = globals.iterator();
        while (iter2.hasNext()) {
            values2[i] = this.world.getObserverVariableByName(iter2.next());
            ++i;
        }
        writer.println(Dump.csv().dataRow(values2));
        writer.println();
    }

    @Override
    public abstract void clearAll();

    protected abstract Importer.ErrorHandler importerErrorHandler();

    @Override
    public void importWorld(String filename) throws IOException {
        this.clearAll();
        this.doImport(new BufferedReaderImporter(filename){

            public void doImport(BufferedReader reader) throws IOException {
                AbstractWorkspace.this.world.importWorld(AbstractWorkspace.this.importerErrorHandler(), AbstractWorkspace.this, AbstractWorkspace.this.stringReader(), reader);
            }
        });
    }

    @Override
    public void importWorld(Reader reader) throws IOException {
        this.clearAll();
        this.world.importWorld(this.importerErrorHandler(), this, this.stringReader(), new BufferedReader(reader));
    }

    private final Importer.StringReader stringReader() {
        return new Importer.StringReader(){

            public Object readFromString(String s) throws Importer.StringReaderException {
                try {
                    return AbstractWorkspace.this.compiler().readFromString(s, AbstractWorkspace.this.world, AbstractWorkspace.this.extensionManager, AbstractWorkspace.this.world.program().is3D());
                }
                catch (CompilerException ex) {
                    throw new Importer.StringReaderException(ex.getMessage());
                }
            }
        };
    }

    @Override
    public void importDrawing(String filename) throws IOException {
        this.doImport(new FileImporter(filename){

            public void doImport(File file) throws IOException {
                AbstractWorkspace.this.importDrawing(file);
            }
        });
    }

    protected abstract void importDrawing(File var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(BufferedReaderImporter importer) throws IOException {
        LocalFile file = new LocalFile(importer.filename());
        try {
            ((File)file).open(FileModeJ.READ());
            importer.doImport(file.reader());
        }
        finally {
            try {
                ((File)file).close(false);
            }
            catch (IOException ex2) {
                Exceptions.ignore(ex2);
            }
        }
    }

    protected void doImport(FileImporter importer) throws IOException {
        File newFile = AbstractWorkspace.isApplet() ? new RemoteFile(importer.filename) : new LocalFile(importer.filename);
        importer.doImport(newFile);
    }

    public String guessExportName(String defaultName) {
        String modelName = this.getModelFileName();
        if (modelName == null) {
            return defaultName;
        }
        int index = modelName.lastIndexOf(".nlogo");
        if (index > -1) {
            modelName = modelName.substring(0, index);
        }
        return modelName + " " + defaultName;
    }

    public File exportBehaviors(String filename, String experimentName, boolean includeHeader) throws IOException {
        LocalFile file = new LocalFile(filename);
        ((File)file).open(FileModeJ.WRITE());
        if (includeHeader) {
            AbstractExporter.exportHeader(((File)file).getPrintWriter(), "BehaviorSpace", this.modelFileName, experimentName);
            ((File)file).getPrintWriter().flush();
        }
        return file;
    }

    @Override
    public int behaviorSpaceRunNumber() {
        return this._behaviorSpaceRunNumber;
    }

    @Override
    public void behaviorSpaceRunNumber(int n) {
        this._behaviorSpaceRunNumber = n;
    }

    @Override
    public String behaviorSpaceExperimentName() {
        return this._behaviorSpaceExperimentName;
    }

    @Override
    public void behaviorSpaceExperimentName(String name) {
        this._behaviorSpaceExperimentName = name;
    }

    public String getSource(String filename) throws IOException {
        File sourceFile;
        if (filename.equals("aggregate")) {
            return this.aggregateManager().innerSource();
        }
        if (AbstractWorkspace.isApplet()) {
            String url = this.fileManager().attachPrefix(filename);
            sourceFile = new RemoteFile(url);
        } else {
            sourceFile = new LocalFile(filename);
        }
        String source2 = sourceFile.readFile();
        return source2.replaceAll("\r\n", "\n");
    }

    @Override
    public String autoConvert(String source2, boolean subprogram, boolean reporter, String modelVersion) {
        return this.compiler().autoConvert(source2, subprogram, reporter, modelVersion, this, true, this.world().program().is3D());
    }

    public void loadWorld(String[] strings, String version, WorldLoaderInterface worldInterface) {
        WorldLoader loader = Version.is3D(version) ? new WorldLoader3D() : new WorldLoader();
        loader.load(strings, version, worldInterface);
    }

    @Override
    public MersenneTwisterFast auxRNG() {
        return this.world.auxRNG;
    }

    @Override
    public MersenneTwisterFast mainRNG() {
        return this.world.mainRNG;
    }

    @Override
    public Object readNumberFromString(String source2) throws CompilerException {
        return this.compiler().readNumberFromString(source2, this.world, this.getExtensionManager(), this.world.program().is3D());
    }

    @Override
    public void checkReporterSyntax(String source2) throws CompilerException {
        this.compiler().checkReporterSyntax(source2, this.world.program(), this.getProcedures(), this.getExtensionManager(), false);
    }

    @Override
    public void checkCommandSyntax(String source2) throws CompilerException {
        this.compiler().checkCommandSyntax(source2, this.world.program(), this.getProcedures(), this.getExtensionManager(), false);
    }

    @Override
    public boolean isConstant(String s) {
        try {
            this.compiler().readFromString(s, this.world.program().is3D());
            return true;
        }
        catch (CompilerException e) {
            return false;
        }
    }

    @Override
    public boolean isValidIdentifier(String s) {
        return this.compiler().isValidIdentifier(s, this.world.program().is3D());
    }

    @Override
    public boolean isReporter(String s) {
        return this.compiler().isReporter(s, this.world.program(), this.getProcedures(), this.getExtensionManager());
    }

    @Override
    public Token[] tokenizeForColorization(String s) {
        return this.compiler().tokenizeForColorization(s, this.getExtensionManager(), this.world.program().is3D());
    }

    @Override
    public Token getTokenAtPosition(String s, int pos) {
        return this.compiler().getTokenAtPosition(s, pos);
    }

    @Override
    public Map<String, List<Object>> findProcedurePositions(String source2) {
        return this.compiler().findProcedurePositions(source2, this.world.program().is3D());
    }

    @Override
    public abstract CompilerInterface compiler();

    @Override
    public LogoException lastLogoException() {
        return null;
    }

    @Override
    public void clearLastLogoException() {
    }

    public void lastLogoException_$eq(LogoException e) {
    }

    protected strictfp abstract class FileImporter {
        public String filename;

        FileImporter(String filename) {
            this.filename = filename;
        }

        public abstract void doImport(File var1) throws IOException;
    }

    public static interface HubNetManagerFactory {
        public HubNetInterface newInstance(AbstractWorkspace var1);
    }
}

