/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.CheckMethodAdapter;

public class CheckAnnotationAdapter
implements AnnotationVisitor {
    private final AnnotationVisitor av;
    private final boolean named;
    private boolean end;

    public CheckAnnotationAdapter(AnnotationVisitor annotationVisitor) {
        this(annotationVisitor, true);
    }

    CheckAnnotationAdapter(AnnotationVisitor annotationVisitor, boolean bl) {
        this.av = annotationVisitor;
        this.named = bl;
    }

    public void visit(String string2, Object object) {
        this.checkEnd();
        this.checkName(string2);
        if (!(object instanceof Byte || object instanceof Boolean || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String || object instanceof Type || object instanceof byte[] || object instanceof boolean[] || object instanceof char[] || object instanceof short[] || object instanceof int[] || object instanceof long[] || object instanceof float[] || object instanceof double[])) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        if (this.av != null) {
            this.av.visit(string2, object);
        }
    }

    public void visitEnum(String string2, String string3, String string4) {
        this.checkEnd();
        this.checkName(string2);
        CheckMethodAdapter.checkDesc(string3, false);
        if (string4 == null) {
            throw new IllegalArgumentException("Invalid enum value");
        }
        if (this.av != null) {
            this.av.visitEnum(string2, string3, string4);
        }
    }

    public AnnotationVisitor visitAnnotation(String string2, String string3) {
        this.checkEnd();
        this.checkName(string2);
        CheckMethodAdapter.checkDesc(string3, false);
        return new CheckAnnotationAdapter(this.av == null ? null : this.av.visitAnnotation(string2, string3));
    }

    public AnnotationVisitor visitArray(String string2) {
        this.checkEnd();
        this.checkName(string2);
        return new CheckAnnotationAdapter(this.av == null ? null : this.av.visitArray(string2), false);
    }

    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        if (this.av != null) {
            this.av.visitEnd();
        }
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }

    private void checkName(String string2) {
        if (this.named && string2 == null) {
            throw new IllegalArgumentException("Annotation value name must not be null");
        }
    }
}

