/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Injector;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.injectors.AbstractInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeInjector<T>
extends AbstractInjector<T> {
    private final Injector<T>[] injectors;

    public CompositeInjector(Object componentKey, Class<?> componentImplementation, Parameter[] parameters, ComponentMonitor monitor, boolean useNames, Injector ... injectors) {
        super(componentKey, componentImplementation, parameters, monitor, useNames);
        this.injectors = injectors;
    }

    @Override
    public T getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return this.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class));
    }

    @Override
    public T getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        Object instance = null;
        for (Injector<T> injector : this.injectors) {
            if (instance == null) {
                instance = injector.getComponentInstance(container, (Type)((Object)ComponentAdapter.NOTHING.class));
                continue;
            }
            injector.decorateComponentInstance(container, into, instance);
        }
        return instance;
    }

    @Override
    public Object decorateComponentInstance(PicoContainer container, Type into, T instance) {
        Object result2 = null;
        for (Injector<T> injector : this.injectors) {
            result2 = injector.decorateComponentInstance(container, into, instance);
        }
        return result2;
    }

    @Override
    public void verify(PicoContainer container) throws PicoCompositionException {
        for (Injector<T> injector : this.injectors) {
            injector.verify(container);
        }
    }

    @Override
    public final void accept(PicoVisitor visitor) {
        super.accept(visitor);
        for (Injector<T> injector : this.injectors) {
            injector.accept(visitor);
        }
    }

    @Override
    public String getDescriptor() {
        StringBuilder sb = new StringBuilder("CompositeInjector(");
        for (Injector<T> injector : this.injectors) {
            sb.append(injector.getDescriptor());
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString().replace("-", "+") + ")-";
    }
}

