/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.PicoLifecycleException;
import org.picocontainer.lifecycle.AbstractMonitoringLifecycleStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaEE5LifecycleStrategy
extends AbstractMonitoringLifecycleStrategy {
    public JavaEE5LifecycleStrategy(ComponentMonitor monitor) {
        super(monitor);
    }

    @Override
    public void start(Object component) {
        this.doLifecycleMethod(component, PostConstruct.class, true);
    }

    @Override
    public void stop(Object component) {
    }

    @Override
    public void dispose(Object component) {
        this.doLifecycleMethod(component, PreDestroy.class, false);
    }

    private void doLifecycleMethod(Object component, Class<? extends Annotation> annotation, boolean superFirst) {
        this.doLifecycleMethod(component, annotation, component.getClass(), superFirst, new HashSet<String>());
    }

    private void doLifecycleMethod(Object component, Class<? extends Annotation> annotation, Class<? extends Object> clazz, boolean superFirst, Set<String> doneAlready) {
        Method[] methods2;
        Class<? extends Object> parent = clazz.getSuperclass();
        if (superFirst && parent != Object.class) {
            this.doLifecycleMethod(component, annotation, parent, superFirst, doneAlready);
        }
        for (Method method : methods2 = clazz.getDeclaredMethods()) {
            String signature = JavaEE5LifecycleStrategy.signature(method);
            if (!method.isAnnotationPresent(annotation) || doneAlready.contains(signature)) continue;
            try {
                long str = System.currentTimeMillis();
                this.currentMonitor().invoking(null, null, method, component, new Object[0]);
                method.invoke(component, new Object[0]);
                doneAlready.add(signature);
                this.currentMonitor().invoked(null, null, method, component, System.currentTimeMillis() - str, new Object[0], null);
            }
            catch (IllegalAccessException e) {
                throw new PicoLifecycleException(method, component, e);
            }
            catch (InvocationTargetException e) {
                throw new PicoLifecycleException(method, component, e);
            }
        }
        if (!superFirst && parent != Object.class) {
            this.doLifecycleMethod(component, annotation, parent, superFirst, doneAlready);
        }
    }

    private static String signature(Method method) {
        Class<?>[] pt;
        StringBuilder sb = new StringBuilder(method.getName());
        for (Class<?> objectClass : pt = method.getParameterTypes()) {
            sb.append(objectClass.getName());
        }
        return sb.toString();
    }

    @Override
    public boolean hasLifecycle(Class<?> type) {
        Method[] methods2 = type.getDeclaredMethods();
        for (int i = 0; i < methods2.length; ++i) {
            Method method = methods2[i];
            if (!method.isAnnotationPresent(PreDestroy.class) && !method.isAnnotationPresent(PostConstruct.class)) continue;
            return true;
        }
        return false;
    }
}

