/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ScopedName;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Sets;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticRef;
import com.google.javascript.rhino.StaticSlot;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;

public class AbstractVar<S extends AbstractScope<S, V>, V extends AbstractVar<S, V>>
extends ScopedName
implements StaticSlot,
StaticRef {
    private final String name;
    private final Node nameNode;
    private StaticSourceFile.SourceKind implicitGoogNamespaceStrength;
    private final CompilerInput input;
    private final int index;
    private final S scope;
    private static final ImmutableSet<Token> DECLARATION_TYPES = Sets.immutableEnumSet((Enum)Token.VAR, (Enum[])new Token[]{Token.LET, Token.CONST, Token.FUNCTION, Token.CLASS, Token.CATCH, Token.IMPORT, Token.PARAM_LIST});

    AbstractVar(String name, @Nullable Node nameNode, @Nullable S scope, int index, @Nullable CompilerInput input, @Nullable Node implicitGoogNamespaceDefinition) {
        Preconditions.checkArgument(index >= -1, index);
        this.name = Preconditions.checkNotNull(name);
        if (implicitGoogNamespaceDefinition != null) {
            this.nameNode = null;
            this.implicitGoogNamespaceStrength = AbstractVar.strengthOf(implicitGoogNamespaceDefinition);
        } else {
            this.nameNode = nameNode;
            this.implicitGoogNamespaceStrength = null;
        }
        this.scope = scope;
        this.index = index;
        this.input = input;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Node getScopeRoot() {
        return ((AbstractScope)this.scope).getRootNode();
    }

    @Override
    public final Node getNode() {
        return this.nameNode;
    }

    final CompilerInput getInput() {
        return this.input;
    }

    @Override
    public final StaticSourceFile getSourceFile() {
        return (this.getNode() != null ? this.getNode() : ((AbstractScope)this.scope).getRootNode()).getStaticSourceFile();
    }

    public final V getSymbol() {
        return this.thisVar();
    }

    public final V getDeclaration() {
        return this.getNode() == null ? null : (V)this.thisVar();
    }

    public final Node getParentNode() {
        return this.getNode() == null ? null : this.getNode().getParent();
    }

    public boolean isBleedingFunction() {
        Node parent = this.getParentNode();
        return parent != null && NodeUtil.isFunctionExpression(parent);
    }

    public final S getScope() {
        return this.scope;
    }

    int getIndex() {
        return this.index;
    }

    public final boolean isGlobal() {
        return ((AbstractScope)this.scope).isGlobal();
    }

    public final boolean isLocal() {
        return ((AbstractScope)this.scope).isLocal();
    }

    final boolean isExtern() {
        return this.input == null || this.input.isExtern();
    }

    public final boolean isDeclaredOrInferredConst() {
        Node declarationNode = this.getNode();
        if (declarationNode == null) {
            return false;
        }
        return declarationNode.isDeclaredConstantVar() || declarationNode.isInferredConstantVar() || declarationNode.getBooleanProp(Node.IS_CONSTANT_NAME);
    }

    public final boolean isDefine() {
        JSDocInfo info = this.getJSDocInfo();
        return info != null && info.isDefine();
    }

    public final Node getInitialValue() {
        return NodeUtil.getRValueOfLValue(this.getNode());
    }

    public final Node getNameNode() {
        return this.getNode();
    }

    @Override
    public final JSDocInfo getJSDocInfo() {
        return this.getNode() == null ? null : NodeUtil.getBestJSDocInfo(this.getNode());
    }

    final boolean isVar() {
        return this.declarationType() == Token.VAR;
    }

    final boolean isCatch() {
        return this.declarationType() == Token.CATCH;
    }

    final boolean isLet() {
        return this.declarationType() == Token.LET;
    }

    final boolean isConst() {
        return this.declarationType() == Token.CONST;
    }

    final boolean isClass() {
        return this.declarationType() == Token.CLASS;
    }

    final boolean isParam() {
        return this.declarationType() == Token.PARAM_LIST;
    }

    public final boolean isDefaultParam() {
        Node parent = this.getNode().getParent();
        return parent.getParent().isParamList() && parent.isDefaultValue() && parent.getFirstChild() == this.nameNode;
    }

    final boolean isImport() {
        return this.declarationType() == Token.IMPORT;
    }

    public final boolean isArguments() {
        return "arguments".equals(this.name) && ((AbstractScope)this.scope).isFunctionScope();
    }

    final boolean isGoogModuleExports() {
        return ((AbstractScope)this.scope).isModuleScope() && "exports".equals(this.name) && this.isImplicit();
    }

    public final boolean isThis() {
        return "this".equals(this.name) && ((AbstractScope)this.scope).isFunctionScope();
    }

    private boolean isImplicit() {
        if (this.isImplicitGoogNamespace()) {
            return true;
        }
        AbstractScope.ImplicitVar var = AbstractScope.ImplicitVar.of(this.name);
        return var != null && var.isMadeByScope((AbstractScope<?, ?>)this.scope);
    }

    final Token declarationType() {
        if (this.isImplicitGoogNamespace()) {
            return null;
        }
        for (Node current = this.getNode(); current != null; current = current.getParent()) {
            if (!DECLARATION_TYPES.contains((Object)current.getToken())) continue;
            return current.getToken();
        }
        Preconditions.checkState(this.isImplicit(), "The nameNode for %s must be a descendant of one of: %s", (Object)this, DECLARATION_TYPES);
        return null;
    }

    private V thisVar() {
        return (V)this;
    }

    final boolean isImplicitGoogNamespace() {
        return this.implicitGoogNamespaceStrength != null;
    }

    final void addImplicitGoogNamespaceDefinition(Node definition) {
        Preconditions.checkState(this.isImplicitGoogNamespace(), this);
        this.implicitGoogNamespaceStrength = AbstractVar.strongerOf(this.implicitGoogNamespaceStrength, AbstractVar.strengthOf(definition));
    }

    final StaticSourceFile.SourceKind getImplicitGoogNamespaceStrength() {
        Preconditions.checkState(this.isImplicitGoogNamespace(), this);
        return this.implicitGoogNamespaceStrength;
    }

    private static final StaticSourceFile.SourceKind strengthOf(Node n) {
        StaticSourceFile source = n.getStaticSourceFile();
        if (source == null) {
            return StaticSourceFile.SourceKind.EXTERN;
        }
        return source.getKind();
    }

    private static StaticSourceFile.SourceKind strongerOf(StaticSourceFile.SourceKind left, StaticSourceFile.SourceKind right) {
        if (left.equals((Object)StaticSourceFile.SourceKind.STRONG) || right.equals((Object)StaticSourceFile.SourceKind.STRONG)) {
            return StaticSourceFile.SourceKind.STRONG;
        }
        if (left.equals((Object)StaticSourceFile.SourceKind.EXTERN) || right.equals((Object)StaticSourceFile.SourceKind.EXTERN)) {
            return StaticSourceFile.SourceKind.EXTERN;
        }
        return StaticSourceFile.SourceKind.WEAK;
    }
}

