/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AccessorSummary;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;

public class AstAnalyzer {
    private static final ImmutableSet<String> CONSTRUCTORS_WITHOUT_SIDE_EFFECTS = ImmutableSet.of("Array", "Date", "Error", "Object", "RegExp", "XMLHttpRequest", new String[0]);
    private static final ImmutableSet<String> BUILTIN_FUNCTIONS_WITHOUT_SIDEEFFECTS = ImmutableSet.of("Object", "Array", "String", "Number", "BigInt", "Boolean", new String[]{"RegExp", "Error"});
    private static final ImmutableSet<String> OBJECT_METHODS_WITHOUT_SIDEEFFECTS = ImmutableSet.of("toString", "valueOf");
    private static final ImmutableSet<String> REGEXP_METHODS = ImmutableSet.of("test", "exec");
    private static final ImmutableSet<String> STRING_REGEXP_METHODS = ImmutableSet.of("match", "replace", "search", "split");
    private final AbstractCompiler compiler;
    private final boolean assumeGettersArePure;

    AstAnalyzer(AbstractCompiler compiler, boolean assumeGettersArePure) {
        this.compiler = Preconditions.checkNotNull(compiler);
        this.assumeGettersArePure = assumeGettersArePure;
    }

    boolean mayEffectMutableState(Node n) {
        return this.checkForStateChangeHelper(n, true);
    }

    public boolean mayHaveSideEffects(Node n) {
        return this.checkForStateChangeHelper(n, false);
    }

    boolean functionCallHasSideEffects(Node callNode) {
        Preconditions.checkState(callNode.isCall() || callNode.isTaggedTemplateLit() || callNode.isOptChainCall(), callNode);
        if (callNode.isNoSideEffectsCall()) {
            return false;
        }
        if (callNode.isOnlyModifiesArgumentsCall() && NodeUtil.allArgsUnescapedLocal(callNode)) {
            return false;
        }
        Node callee = callNode.getFirstChild();
        if (callee.isName()) {
            String name = callee.getString();
            if (BUILTIN_FUNCTIONS_WITHOUT_SIDEEFFECTS.contains(name)) {
                return false;
            }
        } else if (callee.isGetProp() || callee.isOptChainGetProp()) {
            if (callNode.hasOneChild() && OBJECT_METHODS_WITHOUT_SIDEEFFECTS.contains(callee.getString())) {
                return false;
            }
            if (callNode.isOnlyModifiesThisCall() && NodeUtil.evaluatesToLocalValue(callee.getFirstChild())) {
                return false;
            }
            if (callee.getFirstChild().isName() && callee.isQualifiedName() && callee.getFirstChild().getString().equals("Math")) {
                switch (callee.getString()) {
                    case "abs": 
                    case "acos": 
                    case "acosh": 
                    case "asin": 
                    case "asinh": 
                    case "atan": 
                    case "atanh": 
                    case "atan2": 
                    case "cbrt": 
                    case "ceil": 
                    case "cos": 
                    case "cosh": 
                    case "exp": 
                    case "expm1": 
                    case "floor": 
                    case "hypot": 
                    case "log": 
                    case "log10": 
                    case "log1p": 
                    case "log2": 
                    case "max": 
                    case "min": 
                    case "pow": 
                    case "round": 
                    case "sign": 
                    case "sin": 
                    case "sinh": 
                    case "sqrt": 
                    case "tan": 
                    case "tanh": 
                    case "trunc": {
                        return false;
                    }
                    case "random": {
                        return !callNode.hasOneChild();
                    }
                }
            }
            if (!this.compiler.hasRegExpGlobalReferences()) {
                if (callee.getFirstChild().isRegExp() && REGEXP_METHODS.contains(callee.getString())) {
                    return false;
                }
                if (this.isTypedAsString(callee.getFirstChild())) {
                    String method = callee.getString();
                    Node param = callee.getNext();
                    if (param != null) {
                        if (param.isStringLit()) {
                            if (STRING_REGEXP_METHODS.contains(method)) {
                                return false;
                            }
                        } else if (param.isRegExp()) {
                            if ("replace".equals(method)) {
                                return !param.getNext().isStringLit();
                            }
                            if (STRING_REGEXP_METHODS.contains(method)) {
                                return false;
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    private boolean isTypedAsString(Node n) {
        if (n.isStringLit()) {
            return true;
        }
        if (this.compiler.getOptions().useTypesForLocalOptimization) {
            JSType nativeStringType;
            Color color = n.getColor();
            if (color != null) {
                return color.equals(StandardColors.STRING);
            }
            JSType type = n.getJSType();
            if (type != null && type.equals(nativeStringType = this.compiler.getTypeRegistry().getNativeType(JSTypeNative.STRING_TYPE))) {
                return true;
            }
        }
        return false;
    }

    private boolean checkForStateChangeHelper(Node n, boolean checkForNewObjects) {
        Node parent = n.getParent();
        switch (n.getToken()) {
            case THROW: 
            case YIELD: 
            case AWAIT: 
            case FOR_AWAIT_OF: 
            case FOR_OF: 
            case FOR_IN: 
            case VAR: 
            case LET: 
            case CONST: 
            case EXPORT: {
                return true;
            }
            case DYNAMIC_IMPORT: {
                return true;
            }
            case SUPER: {
                return false;
            }
            case OBJECTLIT: 
            case ARRAYLIT: 
            case REGEXP: {
                if (!checkForNewObjects) break;
                return true;
            }
            case OBJECT_REST: 
            case OBJECT_SPREAD: {
                if (this.assumeGettersArePure) break;
                return true;
            }
            case ITER_REST: 
            case ITER_SPREAD: {
                if (!NodeUtil.iteratesImpureIterable(n)) break;
                return true;
            }
            case NAME: {
                if (!n.hasChildren()) break;
                return true;
            }
            case FUNCTION: {
                return checkForNewObjects || NodeUtil.isFunctionDeclaration(n);
            }
            case GETTER_DEF: 
            case SETTER_DEF: 
            case MEMBER_FUNCTION_DEF: {
                return false;
            }
            case COMPUTED_PROP: {
                if (!n.getParent().isClassMembers()) break;
                return this.checkForStateChangeHelper(n.getFirstChild(), checkForNewObjects);
            }
            case MEMBER_FIELD_DEF: {
                return n.isStaticMember() && n.hasChildren() && this.checkForStateChangeHelper(n.getFirstChild(), checkForNewObjects);
            }
            case COMPUTED_FIELD_DEF: {
                return this.checkForStateChangeHelper(n.getFirstChild(), checkForNewObjects) || n.isStaticMember() && n.getSecondChild() != null && this.checkForStateChangeHelper(n.getSecondChild(), checkForNewObjects);
            }
            case CLASS: {
                return checkForNewObjects || NodeUtil.isClassDeclaration(n) || this.checkForStateChangeHelper(n.getSecondChild(), checkForNewObjects) || this.checkForStateChangeHelper(n.getLastChild(), checkForNewObjects);
            }
            case CLASS_MEMBERS: {
                for (Node member = n.getFirstChild(); member != null; member = member.getNext()) {
                    if (!this.checkForStateChangeHelper(member, checkForNewObjects)) continue;
                    return true;
                }
                return false;
            }
            case NEW: {
                if (checkForNewObjects) {
                    return true;
                }
                if (!this.constructorCallHasSideEffects(n)) break;
                return true;
            }
            case CALL: 
            case OPTCHAIN_CALL: {
                if (!this.functionCallHasSideEffects(n)) break;
                return true;
            }
            case TAGGED_TEMPLATELIT: {
                return this.functionCallHasSideEffects(n);
            }
            case CAST: 
            case AND: 
            case BLOCK: 
            case ROOT: 
            case EXPR_RESULT: 
            case HOOK: 
            case IF: 
            case PARAM_LIST: 
            case DEFAULT_VALUE: 
            case NUMBER: 
            case BIGINT: 
            case OR: 
            case COALESCE: 
            case THIS: 
            case TRUE: 
            case FALSE: 
            case NULL: 
            case STRINGLIT: 
            case SWITCH: 
            case TEMPLATELIT_SUB: 
            case TRY: 
            case EMPTY: 
            case TEMPLATELIT: 
            case TEMPLATELIT_STRING: {
                break;
            }
            case STRING_KEY: {
                if (!parent.isObjectPattern()) break;
                if (this.getPropertyKind(n.getString()).hasGetter()) {
                    return true;
                }
                if (!parent.getLastChild().isObjectRest()) break;
                return true;
            }
            case GETELEM: 
            case OPTCHAIN_GETELEM: {
                break;
            }
            case GETPROP: 
            case OPTCHAIN_GETPROP: {
                if (!this.getPropertyKind(n.getString()).hasGetterOrSetter()) break;
                return true;
            }
            default: {
                if (NodeUtil.isSimpleOperator(n)) break;
                if (NodeUtil.isAssignmentOp(n)) {
                    Node assignTarget = n.getFirstChild();
                    if (assignTarget.isName()) {
                        return true;
                    }
                    if (this.checkForStateChangeHelper(n.getFirstChild(), checkForNewObjects) || this.checkForStateChangeHelper(n.getLastChild(), checkForNewObjects)) {
                        return true;
                    }
                    if (NodeUtil.isNormalGet(assignTarget)) {
                        Node current = assignTarget.getFirstChild();
                        if (NodeUtil.evaluatesToLocalValue(current)) {
                            return false;
                        }
                        while (NodeUtil.isNormalGet(current)) {
                            current = current.getFirstChild();
                        }
                        return !NodeUtil.isLiteralValue(current, true);
                    }
                    return !NodeUtil.isLiteralValue(assignTarget, true);
                }
                return true;
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (!this.checkForStateChangeHelper(c, checkForNewObjects)) continue;
            return true;
        }
        return false;
    }

    boolean constructorCallHasSideEffects(Node newNode) {
        Preconditions.checkArgument(newNode.isNew(), "Expected NEW node, got %s", (Object)newNode.getToken());
        if (newNode.isNoSideEffectsCall()) {
            return false;
        }
        if (newNode.isOnlyModifiesArgumentsCall() && NodeUtil.allArgsUnescapedLocal(newNode)) {
            return false;
        }
        Node nameNode = newNode.getFirstChild();
        return !nameNode.isName() || !CONSTRUCTORS_WITHOUT_SIDE_EFFECTS.contains(nameNode.getString());
    }

    boolean nodeTypeMayHaveSideEffects(Node n) {
        Preconditions.checkNotNull(this.compiler);
        if (NodeUtil.isAssignmentOp(n)) {
            return true;
        }
        switch (n.getToken()) {
            case THROW: 
            case YIELD: 
            case AWAIT: 
            case FOR_AWAIT_OF: 
            case FOR_OF: 
            case FOR_IN: 
            case DYNAMIC_IMPORT: 
            case DELPROP: 
            case DEC: 
            case INC: {
                return true;
            }
            case CALL: 
            case OPTCHAIN_CALL: 
            case TAGGED_TEMPLATELIT: {
                return this.functionCallHasSideEffects(n);
            }
            case NEW: {
                return this.constructorCallHasSideEffects(n);
            }
            case NAME: {
                return n.hasChildren();
            }
            case DESTRUCTURING_LHS: {
                return true;
            }
            case OBJECT_REST: 
            case OBJECT_SPREAD: {
                return !this.assumeGettersArePure;
            }
            case ITER_REST: 
            case ITER_SPREAD: {
                return NodeUtil.iteratesImpureIterable(n);
            }
            case STRING_KEY: {
                if (!n.getParent().isObjectPattern()) break;
                return this.getPropertyKind(n.getString()).hasGetter();
            }
            case GETPROP: 
            case OPTCHAIN_GETPROP: {
                return this.getPropertyKind(n.getString()).hasGetterOrSetter();
            }
        }
        return false;
    }

    private AccessorSummary.PropertyAccessKind getPropertyKind(String name) {
        return this.assumeGettersArePure ? AccessorSummary.PropertyAccessKind.NORMAL : this.compiler.getAccessorSummary().getKind(name);
    }
}

