/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.JsIterables;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorId;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Splitter;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Suppliers;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticRef;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.StaticSlot;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeReplacer;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

final class AstFactory {
    private static final Splitter DOT_SPLITTER = Splitter.on(".");
    @Nullable
    private final ColorRegistry colorRegistry;
    @Nullable
    private final JSTypeRegistry registry;
    private final JSType unknownType;
    private static final Supplier<Color> bigintNumberStringColor = Suppliers.memoize(() -> Color.createUnion(ImmutableSet.of(StandardColors.BIGINT, StandardColors.STRING, StandardColors.NUMBER)));
    private final TypeMode typeMode;

    private AstFactory(JSTypeRegistry registry) {
        this.registry = registry;
        this.colorRegistry = null;
        this.unknownType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        this.typeMode = TypeMode.JSTYPE;
    }

    private AstFactory() {
        this.registry = null;
        this.colorRegistry = null;
        this.unknownType = null;
        this.typeMode = TypeMode.NONE;
    }

    private AstFactory(ColorRegistry colorRegistry) {
        this.registry = null;
        this.colorRegistry = colorRegistry;
        this.unknownType = null;
        this.typeMode = TypeMode.COLOR;
    }

    static AstFactory createFactoryWithoutTypes() {
        return new AstFactory();
    }

    static AstFactory createFactoryWithTypes(JSTypeRegistry registry) {
        return new AstFactory(registry);
    }

    static AstFactory createFactoryWithColors(ColorRegistry colorRegistry) {
        return new AstFactory(colorRegistry);
    }

    boolean isAddingTypes() {
        return TypeMode.JSTYPE.equals((Object)this.typeMode);
    }

    boolean isAddingColors() {
        return TypeMode.COLOR.equals((Object)this.typeMode);
    }

    private void assertNotAddingColors() {
        Preconditions.checkState(!this.isAddingColors(), "method not supported for colors");
    }

    Node exprResult(Node expr) {
        return IR.exprResult(expr).srcref(expr);
    }

    Node createEmpty() {
        return IR.empty();
    }

    Node createBlock(Node ... statements) {
        return IR.block(statements);
    }

    Node createIf(Node cond, Node then) {
        return IR.ifNode(cond, then);
    }

    Node createIf(Node cond, Node then, Node elseNode) {
        return IR.ifNode(cond, then, elseNode);
    }

    Node createFor(Node init, Node cond, Node incr, Node body) {
        return IR.forNode(init, cond, incr, body);
    }

    Node createBreak() {
        return IR.breakNode();
    }

    Node createReturn(Node value) {
        return IR.returnNode(value);
    }

    Node createYield(Type type, Node value) {
        Node result = IR.yield(value);
        this.setJSTypeOrColor(type, result);
        return result;
    }

    Node createAwait(Type type, Node value) {
        Node result = IR.await(value);
        this.setJSTypeOrColor(type, result);
        return result;
    }

    Node createString(String value) {
        Node result = IR.string(value);
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.STRING_TYPE, StandardColors.STRING), result);
        return result;
    }

    Node createNumber(double value) {
        Node result = IR.number(value);
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.NUMBER_TYPE, StandardColors.NUMBER), result);
        return result;
    }

    Node createBoolean(boolean value) {
        Node result = value ? IR.trueNode() : IR.falseNode();
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.BOOLEAN_TYPE, StandardColors.BOOLEAN), result);
        return result;
    }

    Node createNull() {
        Node result = IR.nullNode();
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.NULL_TYPE, StandardColors.NULL_OR_VOID), result);
        return result;
    }

    Node createVoid(Node child) {
        Node result = IR.voidNode(child);
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.VOID_TYPE, StandardColors.NULL_OR_VOID), result);
        return result;
    }

    public Node createUndefinedValue() {
        return this.createVoid(this.createNumber(0.0));
    }

    Node createNot(Node child) {
        Node result = IR.not(child);
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.BOOLEAN_TYPE, StandardColors.BOOLEAN), result);
        return result;
    }

    Node createThis(Type thisType) {
        Node result = IR.thisNode();
        this.setJSTypeOrColor(thisType, result);
        return result;
    }

    Node createSuper(Type superType) {
        Node result = IR.superNode();
        this.setJSTypeOrColor(superType, result);
        return result;
    }

    Node createThisForEs6Class(Node functionNode) {
        Preconditions.checkState(functionNode.isClass(), functionNode);
        Node result = IR.thisNode();
        this.setJSTypeOrColor(this.getTypeOfThisForEs6Class(functionNode), result);
        return result;
    }

    Node createThisForEs6ClassMember(Node functionNode) {
        Preconditions.checkState(functionNode.isMemberFunctionDef() && functionNode.getParent().isClassMembers(), functionNode);
        Node classNode = functionNode.getGrandparent();
        if (functionNode.isStaticMember()) {
            Node result = IR.thisNode();
            this.setJSTypeOrColor(AstFactory.type(classNode), result);
            return result;
        }
        return this.createThisForEs6Class(classNode);
    }

    @Nullable
    private JSType getTypeOfThisForFunctionNode(Node functionNode) {
        this.assertNotAddingColors();
        if (this.isAddingTypes()) {
            FunctionType functionType = this.getFunctionType(functionNode);
            return Preconditions.checkNotNull(functionType.getTypeOfThis(), functionType);
        }
        return null;
    }

    @Nullable
    private Type getTypeOfThisForEs6Class(Node functionNode) {
        Preconditions.checkArgument(functionNode.isClass(), functionNode);
        switch (this.typeMode) {
            case JSTYPE: {
                return AstFactory.type(this.getTypeOfThisForFunctionNode(functionNode));
            }
            case COLOR: {
                return AstFactory.type(this.getInstanceOfColor(functionNode.getColor()));
            }
            case NONE: {
                return AstFactory.noTypeInformation();
            }
        }
        throw new AssertionError();
    }

    private FunctionType getFunctionType(Node functionNode) {
        Preconditions.checkState(functionNode.isFunction() || functionNode.isClass(), "not a function or class: %s", (Object)functionNode);
        this.assertNotAddingColors();
        JSType typeBeforeCast = functionNode.getJSTypeBeforeCast();
        FunctionType functionType = typeBeforeCast != null ? typeBeforeCast.assertFunctionType() : functionNode.getJSTypeRequired().assertFunctionType();
        return functionType;
    }

    Node createThisAliasReferenceForEs6Class(String aliasName, Node functionNode) {
        Node result = IR.name(aliasName);
        this.setJSTypeOrColor(this.getTypeOfThisForEs6Class(functionNode), result);
        return result;
    }

    Node createSingleLetNameDeclaration(String variableName) {
        return IR.let(this.createName(variableName, AstFactory.type(JSTypeNative.VOID_TYPE, StandardColors.NULL_OR_VOID)));
    }

    Node createSingleLetNameDeclaration(String variableName, Node value) {
        return IR.let(this.createName(variableName, AstFactory.type(value)), value);
    }

    Node createSingleVarNameDeclaration(String variableName) {
        return IR.var(this.createName(variableName, AstFactory.type(JSTypeNative.VOID_TYPE, StandardColors.NULL_OR_VOID)));
    }

    Node createSingleVarNameDeclaration(String variableName, Node value) {
        return IR.var(this.createName(variableName, AstFactory.type(value)), value);
    }

    Node createSingleConstNameDeclaration(String variableName, Node value) {
        return IR.constNode(this.createName(variableName, AstFactory.type(value.getJSType(), value.getColor())), value);
    }

    Node createArgumentsReference() {
        Node result = IR.name("arguments");
        switch (this.typeMode) {
            case JSTYPE: {
                result.setJSType(this.registry.getNativeType(JSTypeNative.ARGUMENTS_TYPE));
                break;
            }
            case COLOR: {
                result.setColor(this.colorRegistry.get(StandardColors.ARGUMENTS_ID));
                break;
            }
        }
        return result;
    }

    Node createArgumentsAliasDeclaration(String aliasName) {
        return this.createSingleConstNameDeclaration(aliasName, this.createArgumentsReference());
    }

    Node createName(String name, Type type) {
        Node result = IR.name(name);
        this.setJSTypeOrColor(type, result);
        return result;
    }

    Node createName(StaticScope scope, String name) {
        Node result = IR.name(name);
        switch (this.typeMode) {
            case JSTYPE: {
                JSType definitionType = this.getVarDefinitionNode(scope, name).getJSType();
                result.setJSType(definitionType != null ? definitionType : this.unknownType);
                break;
            }
            case COLOR: {
                Color definitionColor = this.getVarDefinitionNode(scope, name).getColor();
                result.setColor(definitionColor != null ? definitionColor : StandardColors.UNKNOWN);
                break;
            }
        }
        return result;
    }

    Node createNameWithUnknownType(String name) {
        return this.createName(name, AstFactory.type(this.unknownType, StandardColors.UNKNOWN));
    }

    Node createQName(StaticScope scope, String qname) {
        return this.createQName(scope, DOT_SPLITTER.split(qname));
    }

    @Deprecated
    Node createQNameFromTypedScope(TypedScope globalTypedScope, String qname) {
        Preconditions.checkArgument(globalTypedScope == null || globalTypedScope.isGlobal(), globalTypedScope);
        this.assertNotAddingColors();
        List<String> nameParts = DOT_SPLITTER.splitToList(qname);
        Preconditions.checkState(!nameParts.isEmpty());
        String receiverPart = nameParts.get(0);
        Node receiver = IR.name(receiverPart);
        if (this.isAddingTypes()) {
            TypedVar var = Preconditions.checkNotNull(globalTypedScope.getVar(receiverPart), receiverPart);
            receiver.setJSType(Preconditions.checkNotNull(var.getType(), var));
        }
        List<String> otherParts = nameParts.subList(1, nameParts.size());
        return this.createGetPropsWithoutColors(receiver, otherParts);
    }

    Node createQName(StaticScope scope, Iterable<String> names) {
        String baseName = Preconditions.checkNotNull(Iterables.getFirst(names, null));
        Iterable<String> propertyNames = Iterables.skip(names, 1);
        return this.createQName(scope, baseName, propertyNames);
    }

    Node createQName(StaticScope scope, String baseName, String ... propertyNames) {
        Preconditions.checkNotNull(baseName);
        return this.createQName(scope, baseName, Arrays.asList(propertyNames));
    }

    Node createQName(StaticScope scope, String baseName, Iterable<String> propertyNames) {
        Node baseNameNode;
        Node qname = baseNameNode = this.createName(scope, baseName);
        String name = baseName;
        for (String propertyName : propertyNames) {
            name = name + "." + propertyName;
            Type type = null;
            if (this.isAddingTypes() || this.isAddingColors()) {
                Node def = Preconditions.checkNotNull(scope.getSlot(name), "Cannot find name %s in StaticScope.", (Object)name).getDeclaration().getNode();
                type = AstFactory.type(def);
            }
            qname = this.createGetProp(qname, propertyName, type);
        }
        return qname;
    }

    Node createQNameWithUnknownType(String qname) {
        return this.createQNameWithUnknownType(DOT_SPLITTER.split(qname));
    }

    private Node createQNameWithUnknownType(Iterable<String> names) {
        String baseName = Preconditions.checkNotNull(Iterables.getFirst(names, null));
        Iterable<String> propertyNames = Iterables.skip(names, 1);
        return this.createQNameWithUnknownType(baseName, propertyNames);
    }

    Node createQNameWithUnknownType(String baseName, Iterable<String> propertyNames) {
        Node baseNameNode = this.createNameWithUnknownType(baseName);
        return this.createGetPropsWithUnknownType(baseNameNode, propertyNames);
    }

    Node createPrototypeAccess(Node receiver) {
        Node result = IR.getprop(receiver, "prototype");
        switch (this.typeMode) {
            case JSTYPE: {
                result.setJSType(this.getJsTypeForProperty(receiver, "prototype"));
                break;
            }
            case COLOR: {
                Preconditions.checkNotNull(receiver.getColor(), "Missing color on %s", (Object)receiver);
                ImmutableSet<Color> possiblePrototypes = receiver.getColor().getPrototypes();
                result.setColor(possiblePrototypes.isEmpty() ? StandardColors.UNKNOWN : Color.createUnion(possiblePrototypes));
                break;
            }
        }
        return result;
    }

    Node createJSCompDotGlobalAccess(StaticScope scope, String qname) {
        Node jscompDotGlobal = this.createQName(scope, "$jscomp.global");
        Node result = this.createQName(scope, qname);
        Node qnameRoot = NodeUtil.getRootOfQualifiedName(result);
        qnameRoot.replaceWith(this.createGetProp(jscompDotGlobal, qnameRoot.getString(), AstFactory.type(qnameRoot)));
        return result;
    }

    @Deprecated
    Node createGetPropWithoutColor(Node receiver, String propertyName) {
        this.assertNotAddingColors();
        Node result = IR.getprop(receiver, propertyName);
        if (this.isAddingTypes()) {
            result.setJSType(this.getJsTypeForProperty(receiver, propertyName));
        }
        return result;
    }

    Node createGetProp(Node receiver, String propertyName, Type type) {
        Node result = IR.getprop(receiver, propertyName);
        this.setJSTypeOrColor(type, result);
        return result;
    }

    @Deprecated
    Node createGetPropsWithoutColors(Node receiver, Iterable<String> propertyNames) {
        this.assertNotAddingColors();
        Node result = receiver;
        for (String propertyName : propertyNames) {
            result = this.createGetPropWithoutColor(result, propertyName);
        }
        return result;
    }

    Node createGetPropsWithUnknownType(Node receiver, Iterable<String> propertyNames) {
        Node result = receiver;
        for (String propertyName : propertyNames) {
            result = this.createGetPropWithUnknownType(result, propertyName);
        }
        return result;
    }

    Node createGetPropWithUnknownType(Node receiver, String propertyName) {
        Node result = IR.getprop(receiver, propertyName);
        this.setJSTypeOrColor(AstFactory.type(this.unknownType, StandardColors.UNKNOWN), result);
        return result;
    }

    Node createGetElem(Node receiver, Node key) {
        Node result = IR.getelem(receiver, key);
        this.setJSTypeOrColor(AstFactory.type(this.unknownType, StandardColors.UNKNOWN), result);
        return result;
    }

    Node createDelProp(Node target) {
        Node result = IR.delprop(target);
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.BOOLEAN_TYPE, StandardColors.BOOLEAN), result);
        return result;
    }

    Node createStringKey(String key, Node value) {
        Node result = IR.stringKey(key, value);
        this.setJSTypeOrColor(AstFactory.type(value.getJSType(), value.getColor()), result);
        return result;
    }

    Node createComputedProperty(Node key, Node value) {
        Node result = IR.computedProp(key, value);
        this.setJSTypeOrColor(AstFactory.type(value.getJSType(), value.getColor()), result);
        return result;
    }

    Node createGetterDef(String name, Node value) {
        JSType returnType = value.getJSType();
        Node functionNode = this.createZeroArgFunction("", IR.block(this.createReturn(value)), returnType);
        Node getterNode = Node.newString(Token.GETTER_DEF, name);
        getterNode.addChildToFront(functionNode);
        return getterNode;
    }

    Node createIn(Node left, Node right) {
        Node result = IR.in(left, right);
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.BOOLEAN_TYPE, StandardColors.BOOLEAN), result);
        return result;
    }

    Node createComma(Node left, Node right) {
        Node result = IR.comma(left, right);
        this.setJSTypeOrColor(AstFactory.type(right.getJSType(), right.getColor()), result);
        return result;
    }

    Node createCommas(Node first, Node second, Node ... rest) {
        Node result = this.createComma(first, second);
        for (Node next : rest) {
            result = this.createComma(result, next);
        }
        return result;
    }

    Node createAnd(Node left, Node right) {
        Node result = IR.and(left, right);
        switch (this.typeMode) {
            case JSTYPE: {
                JSType leftType = Preconditions.checkNotNull(left.getJSType(), left);
                JSType rightType = Preconditions.checkNotNull(right.getJSType(), right);
                result.setJSType(this.registry.createUnionType(leftType, rightType));
                break;
            }
            case COLOR: {
                Color leftColor = Preconditions.checkNotNull(left.getColor(), left);
                Color rightColor = Preconditions.checkNotNull(right.getColor(), right);
                result.setColor(Color.createUnion(ImmutableSet.of(leftColor, rightColor)));
                break;
            }
        }
        return result;
    }

    Node createOr(Node left, Node right) {
        Node result = IR.or(left, right);
        switch (this.typeMode) {
            case JSTYPE: {
                JSType leftType = Preconditions.checkNotNull(left.getJSType(), left);
                JSType rightType = Preconditions.checkNotNull(right.getJSType(), right);
                result.setJSType(this.registry.createUnionType(leftType, rightType));
                break;
            }
            case COLOR: {
                Color leftColor = Preconditions.checkNotNull(left.getColor(), left);
                Color rightColor = Preconditions.checkNotNull(right.getColor(), right);
                result.setColor(Color.createUnion(ImmutableSet.of(leftColor, rightColor)));
                break;
            }
        }
        return result;
    }

    Node createAdd(Node left, Node right) {
        Node result = IR.add(left, right);
        switch (this.typeMode) {
            case JSTYPE: {
                result.setJSType(this.getNativeType(JSTypeNative.BIGINT_NUMBER_STRING));
                break;
            }
            case COLOR: {
                result.setColor(bigintNumberStringColor.get());
                break;
            }
        }
        return result;
    }

    Node createSub(Node left, Node right) {
        Node result = IR.sub(left, right);
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.NUMBER_TYPE, StandardColors.NUMBER), result);
        return result;
    }

    Node createInc(Node operand, boolean isPost) {
        Node result = IR.inc(operand, isPost);
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.NUMBER_TYPE, StandardColors.NUMBER), result);
        return result;
    }

    Node createLessThan(Node left, Node right) {
        Node result = IR.lt(left, right);
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.BOOLEAN_TYPE, StandardColors.BOOLEAN), result);
        return result;
    }

    Node createCall(Node callee, Type resultType, Node ... args) {
        Node result = NodeUtil.newCallNode(callee, args);
        this.setJSTypeOrColor(resultType, result);
        return result;
    }

    Node createCallWithUnknownType(Node callee, Node ... args) {
        return this.createCall(callee, AstFactory.type(this.unknownType, StandardColors.UNKNOWN), args);
    }

    Node createObjectDotAssignCall(StaticScope scope, Type returnType, Node ... args) {
        Node objAssign = this.createQName(scope, "Object", "assign");
        Node result = this.createCall(objAssign, returnType, args);
        switch (this.typeMode) {
            case JSTYPE: {
                JSType returnJSType = returnType.getJSType(this.registry);
                FunctionType objAssignType = this.registry.createFunctionTypeWithVarArgs(returnJSType, this.registry.getNativeType(JSTypeNative.OBJECT_TYPE), this.registry.createUnionType(JSTypeNative.OBJECT_TYPE, JSTypeNative.NULL_TYPE));
                objAssign.setJSType(objAssignType);
                break;
            }
        }
        return result;
    }

    Node createNewNode(Node target, Node ... args) {
        Node result = IR.newNode(target, args);
        switch (this.typeMode) {
            case JSTYPE: {
                JSType instanceType = target.getJSType();
                instanceType = instanceType.isFunctionType() ? instanceType.toMaybeFunctionType().getInstanceType() : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                result.setJSType(instanceType);
                break;
            }
            case COLOR: {
                result.setColor(this.getInstanceOfColor(target.getColor()));
                break;
            }
        }
        return result;
    }

    private Color getInstanceOfColor(Color color) {
        ImmutableSet<Color> possibleInstanceColors = color.getInstanceColors();
        return possibleInstanceColors.isEmpty() ? StandardColors.UNKNOWN : Color.createUnion(possibleInstanceColors);
    }

    Node createConstructorCall(Type classType, Node callee, Node ... args) {
        Node result = NodeUtil.newCallNode(callee, args);
        switch (this.typeMode) {
            case JSTYPE: {
                JSType classJSType = classType.getJSType(this.registry);
                FunctionType constructorType = Preconditions.checkNotNull(classJSType.toMaybeFunctionType());
                ObjectType instanceType = Preconditions.checkNotNull(constructorType.getInstanceType());
                result.setJSType(instanceType);
                break;
            }
            case COLOR: {
                result.setColor(this.getInstanceOfColor(classType.getColor(this.colorRegistry)));
                break;
            }
        }
        return result;
    }

    Node createAssignStatement(Node lhs, Node rhs) {
        return this.exprResult(this.createAssign(lhs, rhs));
    }

    Node createAssign(Node lhs, Node rhs) {
        Node result = IR.assign(lhs, rhs);
        this.setJSTypeOrColor(AstFactory.type(rhs), result);
        return result;
    }

    Node createAssign(String lhsName, Node rhs) {
        Node name = this.createName(lhsName, AstFactory.type(rhs));
        return this.createAssign(name, rhs);
    }

    Node createObjectLit(Node ... elements) {
        Node result = IR.objectlit(elements);
        switch (this.typeMode) {
            case JSTYPE: {
                result.setJSType(this.registry.createAnonymousObjectType(null));
                break;
            }
            case COLOR: {
                result.setColor(StandardColors.TOP_OBJECT);
                break;
            }
        }
        return result;
    }

    Node createObjectLit(Type type, Node ... elements) {
        Node result = IR.objectlit(elements);
        this.setJSTypeOrColor(type, result);
        return result;
    }

    public Node createQuotedStringKey(String key, Node value) {
        Node result = IR.stringKey(key, value);
        result.setQuotedString();
        return result;
    }

    Node createEmptyFunction(Type type) {
        Node result = NodeUtil.emptyFunction();
        if (this.isAddingTypes()) {
            Preconditions.checkArgument(type.getJSType(this.registry).isFunctionType(), type);
        }
        this.setJSTypeOrColor(type, result);
        return result;
    }

    Node createEmptyGeneratorFunction(Type type) {
        Node result = this.createEmptyFunction(type);
        result.setIsGeneratorFunction(true);
        return result;
    }

    Node createFunction(String name, Node paramList, Node body, Type type) {
        Node nameNode = this.createName(name, type);
        Node result = IR.function(nameNode, paramList, body);
        if (this.isAddingTypes()) {
            Preconditions.checkArgument(type.getJSType(this.registry).isFunctionType(), type);
        }
        this.setJSTypeOrColor(type, result);
        return result;
    }

    Node createParamList(String ... parameterNames) {
        Node paramList = IR.paramList(new Node[0]);
        for (String parameterName : parameterNames) {
            paramList.addChildToBack(this.createNameWithUnknownType(parameterName));
        }
        return paramList;
    }

    Node createZeroArgFunction(String name, Node body, @Nullable JSType returnType) {
        FunctionType functionType = this.isAddingTypes() ? this.registry.createFunctionType(returnType, new JSType[0]).toMaybeFunctionType() : null;
        return this.createFunction(name, IR.paramList(new Node[0]), body, AstFactory.type(functionType, StandardColors.TOP_OBJECT));
    }

    Node createZeroArgGeneratorFunction(String name, Node body, @Nullable JSType returnType) {
        Node result = this.createZeroArgFunction(name, body, returnType);
        result.setIsGeneratorFunction(true);
        return result;
    }

    Node createZeroArgArrowFunctionForExpression(Node expression) {
        Node result = IR.arrowFunction(IR.name(""), IR.paramList(new Node[0]), expression);
        switch (this.typeMode) {
            case JSTYPE: {
                FunctionType functionType = FunctionType.builder(this.registry).withReturnType(expression.getJSTypeRequired()).withParameters().buildAndResolve();
                result.setJSType(functionType);
                break;
            }
            case COLOR: {
                result.setColor(StandardColors.TOP_OBJECT);
                break;
            }
        }
        return result;
    }

    Node createMemberFunctionDef(String name, Node function) {
        Preconditions.checkArgument(function.getFirstChild().getString().isEmpty(), function);
        Node result = IR.memberFunctionDef(name, function);
        this.setJSTypeOrColor(AstFactory.type(function), result);
        return result;
    }

    Node createSheq(Node expr1, Node expr2) {
        Node result = IR.sheq(expr1, expr2);
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.BOOLEAN_TYPE, StandardColors.BOOLEAN), result);
        return result;
    }

    Node createEq(Node expr1, Node expr2) {
        Node result = IR.eq(expr1, expr2);
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.BOOLEAN_TYPE, StandardColors.BOOLEAN), result);
        return result;
    }

    Node createNe(Node expr1, Node expr2) {
        Node result = IR.ne(expr1, expr2);
        this.setJSTypeOrColor(AstFactory.type(JSTypeNative.BOOLEAN_TYPE, StandardColors.BOOLEAN), result);
        return result;
    }

    Node createHook(Node condition, Node expr1, Node expr2) {
        Node result = IR.hook(condition, expr1, expr2);
        switch (this.typeMode) {
            case JSTYPE: {
                result.setJSType(this.registry.createUnionType(expr1.getJSType(), expr2.getJSType()));
                break;
            }
            case COLOR: {
                result.setColor(Color.createUnion(ImmutableSet.of(expr1.getColor(), expr2.getColor())));
                break;
            }
        }
        return result;
    }

    Node createArraylit(Node ... elements) {
        return this.createArraylit(Arrays.asList(elements));
    }

    Node createArraylit(Iterable<Node> elements) {
        Node result = IR.arraylit(elements);
        switch (this.typeMode) {
            case JSTYPE: {
                result.setJSType(this.registry.createTemplatizedType(this.registry.getNativeObjectType(JSTypeNative.ARRAY_TYPE), this.getNativeType(JSTypeNative.UNKNOWN_TYPE)));
                break;
            }
            case COLOR: {
                result.setColor(this.colorRegistry.get(StandardColors.ARRAY_ID));
                break;
            }
        }
        return result;
    }

    Node createJSCompMakeIteratorCall(Node iterable, StaticScope scope) {
        Type type;
        Node makeIteratorName = this.createQName(scope, "$jscomp.makeIterator");
        switch (this.typeMode) {
            case JSTYPE: {
                JSType iterableType = iterable.getJSType().getTemplateTypeMap().getResolvedTemplateType(this.registry.getIterableTemplate());
                JSType makeIteratorType = makeIteratorName.getJSType();
                makeIteratorName.setJSType(this.replaceTemplate(makeIteratorType, ImmutableList.of(iterableType)));
                type = AstFactory.type(makeIteratorName.getJSType().assertFunctionType().getReturnType());
                break;
            }
            case COLOR: {
                type = AstFactory.type(this.colorRegistry.get(StandardColors.ITERATOR_ID));
                break;
            }
            case NONE: {
                type = AstFactory.noTypeInformation();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return this.createCall(makeIteratorName, type, iterable);
    }

    Node createJscompArrayFromIteratorCall(Node iterator, StaticScope scope) {
        Type resultType;
        Node makeIteratorName = this.createQName(scope, "$jscomp.arrayFromIterator");
        switch (this.typeMode) {
            case JSTYPE: {
                JSType iterableType = iterator.getJSType().getTemplateTypeMap().getResolvedTemplateType(this.registry.getIteratorValueTemplate());
                JSType makeIteratorType = makeIteratorName.getJSType();
                makeIteratorName.setJSType(this.replaceTemplate(makeIteratorType, ImmutableList.of(iterableType)));
                resultType = AstFactory.type(makeIteratorName.getJSType().assertFunctionType().getReturnType());
                break;
            }
            case COLOR: {
                resultType = AstFactory.type(this.colorRegistry.get(StandardColors.ARRAY_ID));
                break;
            }
            case NONE: {
                resultType = AstFactory.noTypeInformation();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return this.createCall(makeIteratorName, resultType, iterator);
    }

    Node createJscompArrayFromIterableCall(Node iterable, StaticScope scope) {
        Type resultType;
        Node makeIterableName = this.createQName(scope, "$jscomp.arrayFromIterable");
        switch (this.typeMode) {
            case JSTYPE: {
                JSType iterableType = iterable.getJSType().getTemplateTypeMap().getResolvedTemplateType(this.registry.getIterableTemplate());
                JSType makeIterableType = makeIterableName.getJSType();
                makeIterableName.setJSType(this.replaceTemplate(makeIterableType, ImmutableList.of(iterableType)));
                resultType = AstFactory.type(makeIterableName.getJSType().assertFunctionType().getReturnType());
                break;
            }
            case COLOR: {
                resultType = AstFactory.type(this.colorRegistry.get(StandardColors.ARRAY_ID));
                break;
            }
            case NONE: {
                resultType = AstFactory.noTypeInformation();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return this.createCall(makeIterableName, resultType, iterable);
    }

    Node createJSCompMakeAsyncIteratorCall(Node iterable, StaticScope scope) {
        Type resultType;
        Node makeIteratorAsyncName = this.createQName(scope, "$jscomp.makeAsyncIterator");
        switch (this.typeMode) {
            case JSTYPE: {
                JSType asyncIterableType = JsIterables.maybeBoxIterableOrAsyncIterable(iterable.getJSType(), this.registry).orElse(this.unknownType);
                JSType makeAsyncIteratorType = makeIteratorAsyncName.getJSType();
                makeIteratorAsyncName.setJSType(this.replaceTemplate(makeAsyncIteratorType, ImmutableList.of(asyncIterableType)));
                resultType = AstFactory.type(makeIteratorAsyncName.getJSType().assertFunctionType().getReturnType());
                break;
            }
            case COLOR: {
                resultType = AstFactory.type(this.colorRegistry.get(StandardColors.ASYNC_ITERATOR_ITERABLE_ID));
                break;
            }
            case NONE: {
                resultType = AstFactory.noTypeInformation();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return this.createCall(makeIteratorAsyncName, resultType, iterable);
    }

    private JSType replaceTemplate(JSType templatedType, ImmutableList<JSType> templateTypes) {
        TemplateTypeMap typeMap = this.registry.getEmptyTemplateTypeMap().copyWithExtension(templatedType.getTemplateTypeMap().getTemplateKeys(), templateTypes);
        TemplateTypeReplacer replacer = TemplateTypeReplacer.forPartialReplacement(this.registry, typeMap);
        return templatedType.visit(replacer);
    }

    Node createEmptyAsyncGeneratorWrapperArgument(JSType asyncGeneratorWrapperType) {
        Type generatorType = AstFactory.noTypeInformation();
        if (this.isAddingTypes()) {
            if (asyncGeneratorWrapperType.isUnknownType()) {
                generatorType = AstFactory.type(this.registry.createFunctionType(this.replaceTemplate(this.getNativeType(JSTypeNative.GENERATOR_TYPE), ImmutableList.of(this.unknownType)), new JSType[0]));
            } else {
                JSType innerFunctionReturnType = Iterables.getOnlyElement(asyncGeneratorWrapperType.toMaybeFunctionType().getParameters()).getJSType();
                generatorType = AstFactory.type(this.registry.createFunctionType(innerFunctionReturnType, new JSType[0]));
            }
        } else if (this.isAddingColors()) {
            generatorType = AstFactory.type(StandardColors.TOP_OBJECT);
        }
        return this.createEmptyGeneratorFunction(generatorType);
    }

    Node createJscompAsyncExecutePromiseGeneratorFunctionCall(StaticScope scope, Node generatorFunction) {
        Node jscompDotAsyncExecutePromiseGeneratorFunction = this.createQName(scope, "$jscomp.asyncExecutePromiseGeneratorFunction");
        Type resultType = AstFactory.type(this.unknownType);
        if (this.isAddingTypes()) {
            resultType = AstFactory.type(jscompDotAsyncExecutePromiseGeneratorFunction.getJSType().assertFunctionType().getReturnType());
        } else if (this.isAddingColors()) {
            resultType = AstFactory.type(this.colorRegistry.get(StandardColors.PROMISE_ID));
        }
        return this.createCall(jscompDotAsyncExecutePromiseGeneratorFunction, resultType, generatorFunction);
    }

    private JSType getNativeType(JSTypeNative nativeType) {
        Preconditions.checkNotNull(this.registry, "registry is null");
        return Preconditions.checkNotNull(this.registry.getNativeType(nativeType), "native type not found: %s", (Object)nativeType);
    }

    private Node getVarDefinitionNode(StaticScope scope, String name) {
        StaticSlot var = Preconditions.checkNotNull(scope.getSlot(name), "Missing var %s in scope %s", (Object)name, (Object)scope);
        StaticRef declaration = Preconditions.checkNotNull(var.getDeclaration(), "Cannot find type for var with missing declaration %s", (Object)var);
        return Preconditions.checkNotNull(declaration.getNode(), "Missing node for declaration %s", (Object)declaration);
    }

    private JSType getJsTypeForProperty(Node receiver, String propertyName) {
        JSType getpropType = null;
        JSType receiverJSType = receiver.getJSType();
        if (receiverJSType != null && (getpropType = receiverJSType.findPropertyType(propertyName)) == null) {
            ObjectType receiverObjectType = ObjectType.cast(receiverJSType.autobox());
            JSType jSType = getpropType = receiverObjectType == null ? this.unknownType : receiverObjectType.getPropertyType(propertyName);
        }
        if (getpropType == null) {
            getpropType = this.unknownType;
        }
        if (getpropType.isUnknownType() && propertyName.equals("global") && receiver.matchesName("$jscomp")) {
            getpropType = this.getNativeType(JSTypeNative.GLOBAL_THIS);
        }
        return getpropType;
    }

    private void setJSTypeOrColor(Type type, Node result) {
        switch (this.typeMode) {
            case JSTYPE: {
                result.setJSType(type.getJSType(this.registry));
                break;
            }
            case COLOR: {
                result.setColor(type.getColor(this.colorRegistry));
                break;
            }
        }
    }

    static Type type(Node node) {
        return new TypeOnNode(node);
    }

    static Type type(JSType type) {
        return new JSTypeOrColor(type, null);
    }

    static Type type(JSTypeNative type) {
        return new JSTypeOrColor(type, (Color)null);
    }

    static Type type(Color type) {
        return new JSTypeOrColor((JSType)null, type);
    }

    static Type type(ColorId type) {
        return new JSTypeOrColor(null, type);
    }

    static Type type(JSType type, Color color) {
        return new JSTypeOrColor(type, color);
    }

    static Type type(JSTypeNative type, Color color) {
        return new JSTypeOrColor(type, color);
    }

    private static Type noTypeInformation() {
        return new JSTypeOrColor((JSType)null, null);
    }

    private static final class JSTypeOrColor
    implements Type {
        private final JSType jstype;
        private final JSTypeNative jstypeNative;
        private final Color color;
        private final ColorId colorId;

        JSTypeOrColor(JSTypeNative jstypeNative, ColorId colorId) {
            this.jstypeNative = jstypeNative;
            this.jstype = null;
            this.color = null;
            this.colorId = colorId;
        }

        JSTypeOrColor(JSTypeNative jstypeNative, Color color) {
            this.jstypeNative = jstypeNative;
            this.jstype = null;
            this.color = color;
            this.colorId = null;
        }

        JSTypeOrColor(JSType jstype, Color color) {
            this.jstype = jstype;
            this.jstypeNative = null;
            this.color = color;
            this.colorId = null;
        }

        @Override
        public JSType getJSType(JSTypeRegistry registry) {
            return this.jstype != null ? this.jstype : registry.getNativeType(this.jstypeNative);
        }

        @Override
        public Color getColor(ColorRegistry registry) {
            return this.color != null ? this.color : registry.get(Preconditions.checkNotNull(this.colorId));
        }
    }

    private static final class TypeOnNode
    implements Type {
        private final Node n;

        TypeOnNode(Node n) {
            this.n = n;
        }

        @Override
        public JSType getJSType(JSTypeRegistry registry) {
            return Preconditions.checkNotNull(this.n.getJSType(), this.n);
        }

        @Override
        public Color getColor(ColorRegistry registry) {
            return Preconditions.checkNotNull(this.n.getColor(), this.n);
        }
    }

    static interface Type {
        public JSType getJSType(JSTypeRegistry var1);

        public Color getColor(ColorRegistry var1);
    }

    static enum TypeMode {
        JSTYPE,
        COLOR,
        NONE;

    }
}

