/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSChunkGraph;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Ascii;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

final class CheckClosureImports
implements CompilerPass {
    static final DiagnosticType INVALID_CLOSURE_IMPORT_DESTRUCTURING = DiagnosticType.error("JSC_INVALID_CLOSURE_IMPORT_DESTRUCTURING", "Destructuring {0} must be a simple object pattern.");
    static final DiagnosticType ONE_CLOSURE_IMPORT_PER_DECLARATION = DiagnosticType.error("JSC_ONE_CLOSURE_IMPORT_PER_DECLARATION", "There may only be one {0} per var/let/const declaration.");
    static final DiagnosticType INVALID_CLOSURE_IMPORT_CALL = DiagnosticType.error("JSC_INVALID_CLOSURE_IMPORT_CALL", "{0} parameter must be a string literal.");
    static final DiagnosticType LATE_PROVIDE_ERROR = DiagnosticType.error("JSC_LATE_PROVIDE_ERROR", "Required namespace \"{0}\" not provided yet.");
    static final DiagnosticType LET_CLOSURE_IMPORT = DiagnosticType.disabled("JSC_LET_CLOSURE_IMPORT", "Module imports must be constant. Please use ''const'' instead of ''let''.");
    static final DiagnosticType NO_CLOSURE_IMPORT_DESTRUCTURING = DiagnosticType.error("JSC_NO_CLOSURE_IMPORT_DESTRUCTURING", "Cannot destructure the return value of {0}");
    static final DiagnosticType LHS_OF_CLOSURE_IMPORT_MUST_BE_CONST_IN_ES_MODULE = DiagnosticType.error("JSC_LHS_OF_CLOUSRE_IMPORT_MUST_BE_CONST_IN_ES_MODULE", "The left side of a {0} must use ''const'' (not ''let'' or ''var'') in an ES module.");
    static final DiagnosticType CROSS_CHUNK_REQUIRE_ERROR = DiagnosticType.warning("JSC_XMODULE_REQUIRE_ERROR", "namespace \"{0}\" is required in chunk {2} but provided in chunk {1}. Is chunk {2} missing a dependency on chunk {1}?");
    private static final Node GOOG_REQUIRE = IR.getprop(IR.name("goog"), "require");
    private static final Node GOOG_MODULE_GET = IR.getprop(IR.name("goog"), "module", "get");
    private static final Node GOOG_FORWARD_DECLARE = IR.getprop(IR.name("goog"), "forwardDeclare");
    private static final Node GOOG_REQUIRE_TYPE = IR.getprop(IR.name("goog"), "requireType");
    private final AbstractCompiler compiler;
    private final Checker checker;
    private final Set<String> namespacesSeen;
    private final JSChunkGraph chunkGraph;

    CheckClosureImports(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap) {
        this.compiler = compiler;
        this.checker = new Checker(compiler, moduleMetadataMap);
        this.namespacesSeen = new HashSet<String>();
        this.chunkGraph = compiler.getModuleGraph();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, this.checker);
        NodeTraversal.traverse(this.compiler, root, this.checker);
    }

    private void verifyRequireOrder(String namespace, Node call, NodeTraversal t, ModuleMetadataMap.ModuleMetadata requiredModule) {
        if (!this.namespacesSeen.contains(namespace)) {
            t.report(call, LATE_PROVIDE_ERROR, namespace);
            return;
        }
        if (requiredModule.rootNode() == null || requiredModule.rootNode().isFromExterns()) {
            return;
        }
        InputId requiredInputId = NodeUtil.getInputId(requiredModule.rootNode());
        CompilerInput requiredInput = Preconditions.checkNotNull(this.compiler.getInput(requiredInputId), "Cannot find CompilerInput for %s", (Object)requiredModule);
        JSChunk requiredChunk = requiredInput.getChunk();
        JSChunk currentChunk = t.getChunk();
        if (currentChunk != requiredChunk && !this.chunkGraph.dependsOn(currentChunk, requiredChunk)) {
            this.compiler.report(JSError.make(call, CROSS_CHUNK_REQUIRE_ERROR, namespace, requiredChunk.getName(), currentChunk.getName()));
        }
    }

    private class Checker
    extends NodeTraversal.AbstractModuleCallback {
        private final ModuleMetadataMap moduleMetadataMap;

        Checker(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap) {
            super(compiler, moduleMetadataMap);
            this.moduleMetadataMap = moduleMetadataMap;
        }

        @Override
        protected void enterModule(ModuleMetadataMap.ModuleMetadata currentModule, Node moduleScopeRoot) {
            CheckClosureImports.this.namespacesSeen.addAll(currentModule.googNamespaces().elementSet());
        }

        @Override
        public void visit(NodeTraversal t, Node n, @Nullable ModuleMetadataMap.ModuleMetadata currentModule, @Nullable Node moduleScopeRoot) {
            if (currentModule == null) {
                return;
            }
            Node parent = n.getParent();
            if (n.isCall()) {
                ClosureImport kindOfCall = this.kindOfCall(n);
                if (kindOfCall != null) {
                    this.checkImport(t, n, parent, currentModule, kindOfCall);
                } else if (n.getFirstChild().matchesQualifiedName(GOOG_MODULE_GET)) {
                    this.checkGoogModuleGet(t, n, currentModule);
                }
            } else if (n.isName()) {
                this.checkValidImportCodeReference(t, n);
            }
        }

        @Nullable
        private ClosureImport kindOfCall(Node callNode) {
            Preconditions.checkState(callNode.isCall());
            if (callNode.getFirstChild().matchesQualifiedName(GOOG_REQUIRE)) {
                return ClosureImport.REQUIRE;
            }
            if (callNode.getFirstChild().matchesQualifiedName(GOOG_FORWARD_DECLARE)) {
                return ClosureImport.FORWARD_DECLARE;
            }
            if (callNode.getFirstChild().matchesQualifiedName(GOOG_REQUIRE_TYPE)) {
                return ClosureImport.REQUIRE_TYPE;
            }
            return null;
        }

        private void checkValidImportCodeReference(NodeTraversal t, Node nameNode) {
            Node decl;
            Var var = (Var)t.getScope().getVar(nameNode.getString());
            if (var == null || var.getNameNode() == nameNode) {
                return;
            }
            Node declarationNameNode = var.getNameNode();
            if (declarationNameNode == null || !NodeUtil.isDeclarationLValue(declarationNameNode)) {
                return;
            }
            Node node = decl = declarationNameNode.getParent().isStringKey() ? declarationNameNode.getGrandparent().getGrandparent() : declarationNameNode.getParent();
            if (!(NodeUtil.isNameDeclaration(decl) && decl.hasOneChild() && decl.getFirstChild().hasChildren() && decl.getFirstChild().getLastChild().isCall())) {
                return;
            }
            ClosureImport kindOfCall = this.kindOfCall(decl.getFirstChild().getLastChild());
            if (kindOfCall == null) {
                return;
            }
        }

        private void checkGoogModuleGet(NodeTraversal t, Node call, ModuleMetadataMap.ModuleMetadata currentModule) {
            boolean isModule;
            if (t.inModuleHoistScope()) {
                t.report(call, ClosurePrimitiveErrors.MODULE_USES_GOOG_MODULE_GET, new String[0]);
                return;
            }
            if (!currentModule.isEs6Module() && !currentModule.isGoogModule() && t.inGlobalScope() && this.compiler.getOptions().moduleResolutionMode != ModuleLoader.ResolutionMode.WEBPACK) {
                t.report(call, ClosurePrimitiveErrors.INVALID_GET_CALL_SCOPE, new String[0]);
                return;
            }
            if (!call.hasTwoChildren() || !call.getSecondChild().isStringLit()) {
                t.report(call, INVALID_CLOSURE_IMPORT_CALL, "goog.module.get");
                return;
            }
            String namespace = call.getSecondChild().getString();
            ModuleMetadataMap.ModuleMetadata requiredModule = this.moduleMetadataMap.getModulesByGoogNamespace().get(namespace);
            if (requiredModule == null) {
                t.report(call, ClosurePrimitiveErrors.MISSING_MODULE_OR_PROVIDE, namespace);
                return;
            }
            Node maybeAssign = call.getParent();
            boolean isFillingAnAlias = maybeAssign.isAssign() && maybeAssign.getFirstChild().isName();
            boolean bl = isModule = currentModule.isGoogModule() || currentModule.isEs6Module();
            if (isFillingAnAlias && isModule) {
                String aliasName = call.getParent().getFirstChild().getString();
                Var aliasVar = (Var)t.getScope().getVar(aliasName);
                if (aliasVar == null) {
                    t.report(call, ClosureRewriteModule.INVALID_GET_ALIAS, new String[0]);
                    return;
                }
                Node aliasVarNodeRhs = NodeUtil.getRValueOfLValue(aliasVar.getNode());
                if (aliasVarNodeRhs == null || !NodeUtil.isCallTo(aliasVarNodeRhs, GOOG_FORWARD_DECLARE)) {
                    t.report(call, ClosureRewriteModule.INVALID_GET_ALIAS, new String[0]);
                    return;
                }
                if (!namespace.equals(aliasVarNodeRhs.getLastChild().getString())) {
                    t.report(call, ClosureRewriteModule.INVALID_GET_ALIAS, new String[0]);
                    return;
                }
            }
        }

        private boolean isValidDestructuringImport(Node destructuringLhs) {
            Preconditions.checkArgument(destructuringLhs.isDestructuringLhs());
            Node objectPattern = destructuringLhs.getFirstChild();
            if (!objectPattern.isObjectPattern()) {
                return false;
            }
            for (Node stringKey = objectPattern.getFirstChild(); stringKey != null; stringKey = stringKey.getNext()) {
                if (!stringKey.isStringKey()) {
                    return false;
                }
                if (stringKey.getFirstChild().isName()) continue;
                return false;
            }
            return true;
        }

        private void checkShortName(NodeTraversal t, Node shortNameNode, String namespace) {
            String lastSegment;
            String shortName = shortNameNode.getString();
            if (shortName.equals(lastSegment = namespace.substring(namespace.lastIndexOf(46) + 1)) || lastSegment.isEmpty()) {
                return;
            }
            if (Ascii.isUpperCase(shortName.charAt(0)) != Ascii.isUpperCase(lastSegment.charAt(0))) {
                char newStartChar = Ascii.isUpperCase(shortName.charAt(0)) ? Ascii.toLowerCase(shortName.charAt(0)) : Ascii.toUpperCase(shortName.charAt(0));
                String correctedName = newStartChar + shortName.substring(1);
                t.report(shortNameNode, ClosureCheckModule.INCORRECT_SHORTNAME_CAPITALIZATION, shortName, correctedName);
            }
        }

        private void checkImport(NodeTraversal t, Node call, Node parent, ModuleMetadataMap.ModuleMetadata currentModule, ClosureImport importType) {
            boolean atTopLevelScope = t.inGlobalHoistScope() || t.inModuleScope();
            boolean isModule = currentModule.isModule();
            boolean validAssignment = isModule || parent.isExprResult();
            boolean isAliased = NodeUtil.isNameDeclaration(parent.getParent());
            if (!atTopLevelScope || !validAssignment) {
                t.report(call, ClosurePrimitiveErrors.INVALID_CLOSURE_CALL_SCOPE_ERROR, new String[0]);
                return;
            }
            if (!call.hasTwoChildren() || !call.getSecondChild().isStringLit()) {
                t.report(call, INVALID_CLOSURE_IMPORT_CALL, importType.callName());
                return;
            }
            if (isModule && isAliased) {
                Node lhs;
                Node declaration = parent.getParent();
                if (!declaration.hasOneChild()) {
                    t.report(call, ONE_CLOSURE_IMPORT_PER_DECLARATION, importType.callName());
                    return;
                }
                if (importType.aliasMustBeConstant()) {
                    if (declaration.isLet()) {
                        t.report(call, LET_CLOSURE_IMPORT, importType.callName());
                    } else if (!declaration.isConst() && currentModule.isEs6Module()) {
                        t.report(call, LHS_OF_CLOSURE_IMPORT_MUST_BE_CONST_IN_ES_MODULE, importType.callName());
                    }
                }
                if ((lhs = declaration.getFirstChild()).isDestructuringLhs()) {
                    if (importType.allowDestructuring()) {
                        if (!this.isValidDestructuringImport(lhs)) {
                            t.report(declaration, INVALID_CLOSURE_IMPORT_DESTRUCTURING, importType.callName());
                        }
                    } else {
                        t.report(declaration, NO_CLOSURE_IMPORT_DESTRUCTURING, importType.callName());
                    }
                } else {
                    this.checkShortName(t, lhs, call.getLastChild().getString());
                }
            }
            String namespace = call.getSecondChild().getString();
            ModuleMetadataMap.ModuleMetadata requiredModule = this.moduleMetadataMap.getModulesByGoogNamespace().get(namespace);
            if (requiredModule == null) {
                if (importType == ClosureImport.FORWARD_DECLARE) {
                    if (isAliased && isModule) {
                        t.report(call, ClosurePrimitiveErrors.MISSING_MODULE_OR_PROVIDE_FOR_FORWARD_DECLARE, namespace);
                    }
                    return;
                }
                t.report(call, ClosurePrimitiveErrors.MISSING_MODULE_OR_PROVIDE, namespace);
                return;
            }
            if (importType.mustBeOrdered()) {
                CheckClosureImports.this.verifyRequireOrder(namespace, call, t, requiredModule);
            }
            if (importType == ClosureImport.REQUIRE && currentModule.isEs6Module() && requiredModule.isEs6Module()) {
                t.report(call, Es6RewriteModules.SHOULD_IMPORT_ES6_MODULE, new String[0]);
            }
        }
    }

    private static enum ClosureImport {
        REQUIRE{

            @Override
            boolean allowDestructuring() {
                return true;
            }

            @Override
            boolean aliasMustBeConstant() {
                return true;
            }

            @Override
            boolean mustBeOrdered() {
                return true;
            }

            @Override
            String callName() {
                return "goog.require";
            }
        }
        ,
        FORWARD_DECLARE{

            @Override
            boolean allowDestructuring() {
                return false;
            }

            @Override
            boolean aliasMustBeConstant() {
                return false;
            }

            @Override
            boolean mustBeOrdered() {
                return false;
            }

            @Override
            String callName() {
                return "goog.forwardDeclare";
            }
        }
        ,
        REQUIRE_TYPE{

            @Override
            boolean allowDestructuring() {
                return true;
            }

            @Override
            boolean aliasMustBeConstant() {
                return true;
            }

            @Override
            boolean mustBeOrdered() {
                return false;
            }

            @Override
            String callName() {
                return "goog.requireType";
            }
        };


        abstract boolean allowDestructuring();

        abstract boolean aliasMustBeConstant();

        abstract boolean mustBeOrdered();

        abstract String callName();
    }
}

